﻿//
//  濁点、半濁点制御文字 ver1.00
//
// author skinhead.man
//

var Imported = Imported || {};
Imported['dakuten_text'] = 1.00;
/*:
 * @plugindesc v指定した文字に濁点や半濁点を付ける制御文字を追加します。
 * @author Skinhead.man
 *
 * @param PlusRate
 * @desc 濁点の表示位置です。文字サイズに対する倍率で指定してください。
 * @default 0.75
 *
 * @help------------------------------------------------------
 * 使用方法
 * ------------------------------------------------------
 * drawTextExを通る場面(文章の表示やバトルログ)などで、
 * \VS[濁点を付けたいテキスト]
 * と記述することで、そのテキストに濁点を付けることができます。
 *
 * また、
 * \PS[半濁点を付けたいテキスト]
 * と記述することで、そのテキストに半濁点を付けることができます。
*/


(function(){
    ////////////////////////////////////////////////////////////////////////////////////

    var parameters = PluginManager.parameters('dakuten_text');
    var plusRate = Number(parameters['PlusRate']);

    ////////////////////////////////////////////////////////////////////////////////////

    var __WBase_processEscapeCharacter = Window_Base.prototype.processEscapeCharacter;
    Window_Base.prototype.processEscapeCharacter = function(code, textState) {
        switch(code) {
            case 'VS':
            case 'PS':
                var arr = /^\[(.+?)\]/.exec(textState.text.slice(textState.index));
                if (arr) {
                    textState.index += arr[0].length;
                    if (code === 'VS') {
                        this.processDrawVSound(arr[1], textState);
                    } else {
                        this.processDrawPSound(arr[1], textState);
                    }
                }
                break;
            default:
                __WBase_processEscapeCharacter.call(this, code, textState);
                break;
        }
    };

    Window_Base.prototype.processDrawVSound = function(text, textState) {
        this.processDrawSound(text, textState, '゛');
    };

    Window_Base.prototype.processDrawPSound = function(text, textState) {
        this.processDrawSound(text, textState, '゜');
    };

    Window_Base.prototype.processDrawSound = function(text, textState, mark) {
        for(var i = 0, max = text.length; i < max; i++){
            var c = text[i];
            var w = this.contents.measureTextWidth(c); 
            this.contents.drawText(c, textState.x, textState.y, w * 2, textState.height);
            this.contents.drawText(mark, textState.x + Math.floor(w * plusRate), textState.y, w * 2, textState.height);
            textState.x += w;
        }
    };

    ////////////////////////////////////////////////////////////////////////////////////
})();
