/*:
 * @target MZ
 * @plugindesc 静止中も「0→1→2→0…」で歩行アニメを継続する（MZ専用・速度調整可） - by ChatGPT
 * @author ChatGPT
 *
 * @param IdleAnimSpeed
 * @text 足踏みアニメ速度（静止時）
 * @desc キャラが立ち止まっているときのアニメ速度（フレーム数）。大きいほどゆっくり。
 * @default 24
 *
 * @help
 * ■ 概要
 * キャラが移動していない状態でも歩行アニメーション（0→1→2→0…）を
 * 続けて再生します。立ち止まっていても足踏みするようになります。
 *
 * ■ 設定
 * ・プラグインパラメータ「足踏みアニメ速度」で再生速度を調整できます。
 *
 * ■ 注意
 * ・全キャラに一律で適用されます（プレイヤー・イベント共通）
 * ・「歩行アニメ」がONになっている必要があります
 */

(() => {
    const pluginName = "AlwaysWalkAnimMZ";
    const parameters = PluginManager.parameters(pluginName);
    const idleSpeed = Number(parameters["IdleAnimSpeed"] || 24);

    // キャラベースにカウンターと初期化追加
    const _Game_CharacterBase_initMembers = Game_CharacterBase.prototype.initMembers;
    Game_CharacterBase.prototype.initMembers = function() {
        _Game_CharacterBase_initMembers.call(this);
        this._idleAnimCounter = 0;
    };

    // キャラ更新処理に足踏みパターンの進行を追加
    const _Game_CharacterBase_update = Game_CharacterBase.prototype.update;
    Game_CharacterBase.prototype.update = function() {
        _Game_CharacterBase_update.call(this);

        // 静止中かつアニメONの場合、カウンターでパターン変更
        if (!this.isMoving() && this.hasWalkAnime()) {
            this._idleAnimCounter++;
            if (this._idleAnimCounter >= idleSpeed) {
                this.setPattern((this.pattern() + 1) % 3); // 0→1→2→0…
                this._idleAnimCounter = 0;
            }
        } else {
            this._idleAnimCounter = 0;
        }
    };

    // スプライト更新で強制的にパターンを反映（静止中でも更新）
    const _Sprite_Character_updateCharacterFrame = Sprite_Character.prototype.updateCharacterFrame;
    Sprite_Character.prototype.updateCharacterFrame = function() {
        const character = this._character;
        const pw = this.patternWidth();
        const ph = this.patternHeight();
        const pattern = character.pattern();
        const sx = (character.characterIndex() % 4 * 3 + pattern) * pw;
        const sy = (Math.floor(character.characterIndex() / 4) * 4 +
                    (character.direction() / 2 - 1)) * ph;
        this.setFrame(sx, sy, pw, ph);
    };
})();
