//=============================================================================
// ClickSE_NoMarker.js
//=============================================================================
/*:
 * @target MZ
 * @plugindesc クリック時の目的地マーカーを非表示にし、代わりにSEを鳴らします。
 * @author ChatGPT
 *
 * @param ClickSE
 * @text 再生するSE名
 * @type file
 * @dir audio/se
 * @desc 画面クリック時に再生するSE（audio/se フォルダ内のファイル名）
 * @default Cursor1
 *
 * @param Volume
 * @text ボリューム
 * @type number
 * @min 0
 * @max 100
 * @desc 効果音の音量
 * @default 90
 *
 * @param Pitch
 * @text ピッチ
 * @type number
 * @min 50
 * @max 150
 * @desc 効果音のピッチ
 * @default 100
 *
 * @param Pan
 * @text 位相（左右バランス）
 * @type number
 * @min -100
 * @max 100
 * @desc -100=左 / 0=中央 / 100=右
 * @default 0
 *
 * @help
 * ■ 概要
 * このプラグインは、画面クリック時の目的地マーカー（点滅エフェクト）を無効化し、
 * 代わりに任意のSE（効果音）を再生するものです。
 * 
 * ■ 使い方
 * プラグインを有効にし、パラメータで再生したいSEを設定してください。
 * SEファイルは audio/se フォルダ内にある必要があります。
 * 
 * ■ 注意
 * ・クリックで移動する仕様（デフォルト）のままSEのみ追加されます。
 * ・マウス操作やタッチ移動を完全に無効にするものではありません。
 */

(() => {
    const parameters = PluginManager.parameters("ClickSE_NoMarker");
    const seName = String(parameters["ClickSE"] || "");
    const seVolume = Number(parameters["Volume"] || 90);
    const sePitch = Number(parameters["Pitch"] || 100);
    const sePan = Number(parameters["Pan"] || 0);

    // 目的地マーカーの点滅を無効化（空のビットマップに）
    Sprite_Destination.prototype.createBitmap = function() {
        this.bitmap = new Bitmap(1, 1);
    };

    // タッチ入力時にSEを再生する
    const _Scene_Map_processMapTouch = Scene_Map.prototype.processMapTouch;
    Scene_Map.prototype.processMapTouch = function() {
        const wasTouching = TouchInput.isTriggered();
        _Scene_Map_processMapTouch.call(this);
        if (wasTouching && $gameTemp.isDestinationValid()) {
            // 目的地が設定されたときにSEを鳴らす
            AudioManager.playSe({
                name: seName,
                volume: seVolume,
                pitch: sePitch,
                pan: sePan
            });
        }
    };
})();
