# encoding: utf8

__all__ = [
    "ENE_ONTONOTES_MAPPING",
]


ENE_ONTONOTES_MAPPING = {
    "Person": "PERSON",
    "God": "PERSON",

    "International_Organization": "NORP",
    "Ethnic_Group": "NORP",
    "Ethnic_Group_Other": "NORP",
    "Nationality": "NORP",
    "Political_Organization": "NORP",
    "Political_Organization_Other": "NORP",
    "Political_Party": "NORP",
    "Religion": "NORP",

    "Language": "LANGUAGE",
    "Language_Other": "LANGUAGE",
    "National_Language": "LANGUAGE",

    "Location_Other": "GPE",
    "GPE": "GPE",
    "GPE_Other": "GPE",
    "City": "GPE",
    "Province": "GPE",
    "Country": "GPE",
    "Spa": "GPE",
    "Address": "GPE",
    "Address_Other": "GPE",
    "Postal_Address": "GPE",
    "County": "GPE",

    "Region": "LOC",
    "Region_Other": "LOC",
    "Continental_Region": "LOC",
    "Domestic_Region": "LOC",
    "Geological_Region": "LOC",
    "Geological_Region_Other": "LOC",
    "Mountain": "LOC",
    "Island": "LOC",
    "River": "LOC",
    "Lake": "LOC",
    "Sea": "LOC",
    "Bay": "LOC",

    "Event_Other": "EVENT",
    "Occasion": "EVENT",
    "Occasion_Other": "EVENT",
    "Election": "EVENT",
    "Religious_Festival": "EVENT",
    "Competition": "EVENT",
    "Game": "EVENT",  # used in v7 ("Competition" in v8)
    "Conference": "EVENT",
    "Incident": "EVENT",
    "Incident_Other": "EVENT",
    "War": "EVENT",
    "Natural_Phenomenon": "EVENT",
    "Natural_Phenomenon_Other": "EVENT",
    "Natural_Disaster": "EVENT",
    "Earthquake": "EVENT",

    "Facility": "FAC",
    "Facility_Other": "FAC",
    "Facility_Part": "FAC",
    "Dam": "FAC",
    "Archaeological_Place": "FAC",
    "Archaeological_Place_Other": "FAC",
    "Tomb": "FAC",
    "FOE": "FAC",
    "FOE_Other": "FAC",
    "GOE_Other": "FAC",  # used in v7 ("FOE_Other" in v8)
    "Military_Base": "FAC",
    "Power_Plant": "FAC",
    "Park": "FAC",
    "Shopping_Complex": "FAC",
    "Sports_Facility": "FAC",
    "Museum": "FAC",
    "Zoo": "FAC",
    "Amusement_Park": "FAC",
    "Theater": "FAC",
    "Worship_Place": "FAC",
    "Castle": "FAC",
    "Palace": "FAC",
    "Public_Institution": "FAC",
    "Accommodation": "FAC",
    "Medical_Institution": "FAC",
    "School": "FAC",
    "Research_Institute": "FAC",
    "Market": "FAC",
    "Transport_Facility": "FAC",
    "Transport_Facility_Other": "FAC",
    "Car_Stop": "FAC",
    "Station": "FAC",
    "Airport": "FAC",
    "Port": "FAC",
    "Line": "FAC",
    "Line_Other": "FAC",
    "Railroad": "FAC",
    "Road": "FAC",
    "Canal": "FAC",
    "Water_Route": "FAC",
    "Tunnel": "FAC",
    "Bridge": "FAC",
    "Tumulus": "FAC",

    "Organization": "ORG",
    "Organization_Other": "ORG",
    "Show_Organization": "ORG",
    "Family": "ORG",
    "Sports_Organization": "ORG",
    "Sports_Organization_Other": "ORG",
    "Pro_Sports_Organization": "ORG",  # used in v7 ("Sports_Organization" in v8)
    "Sports_Federation": "ORG",
    "Sports_League": "ORG",
    "Sports_Team": "ORG",
    "Juridical_Person": "ORG",
    "Juridical_Person_Other": "ORG",
    "Channel": "ORG",
    "Corporation_Other": "ORG",  # used in v7 ("Juridical_Person_Other" in v8)
    "Nonprofit_Organization": "ORG",
    "Company": "ORG",
    "Company_Group": "ORG",
    "Government": "ORG",
    "Cabinet": "ORG",
    "Military": "ORG",

    "Product_Other": "PRODUCT",
    "Service": "PRODUCT",
    "Character": "PRODUCT",
    "ID_Number": "PRODUCT",
    "Game_Other": "PRODUCT",
    "Digital_Game": "PRODUCT",
    "Software": "PRODUCT",
    "Vehicle": "PRODUCT",
    "Vehicle_Other": "PRODUCT",
    "Car": "PRODUCT",
    "Train": "PRODUCT",
    "Aircraft": "PRODUCT",
    "Spaceship": "PRODUCT",
    "Ship": "PRODUCT",
    "Food_Other": "PRODUCT",
    "Musical_Instrument": "PRODUCT",
    "Clothing": "PRODUCT",
    "Money_Form": "PRODUCT",
    "Drug": "PRODUCT",
    "Weapon": "PRODUCT",
    "Stock": "PRODUCT",
    "Award": "PRODUCT",
    "Decoration": "PRODUCT",

    "Video_Work": "WORK_OF_ART",
    "Art": "WORK_OF_ART",
    "Art_Other": "WORK_OF_ART",
    "Painting": "WORK_OF_ART",
    "Broadcast_Program": "WORK_OF_ART",
    "Movie": "WORK_OF_ART",
    "Show": "WORK_OF_ART",
    "Music": "WORK_OF_ART",
    "Book": "WORK_OF_ART",
    "Printing": "WORK_OF_ART",
    "Printing_Other": "WORK_OF_ART",
    "Newspaper": "WORK_OF_ART",
    "Magazine": "WORK_OF_ART",
    "Picture": "WORK_OF_ART",

    "Offense": "LAW",
    "Doctrine_Method_Other": "LAW",
    "Movement": "LAW",
    "Plan": "LAW",
    "Rule": "LAW",
    "Rule_Other": "LAW",
    "Treaty": "LAW",
    "Law": "LAW",

    "Timex": "DATE",
    "Timex_Other": "DATE",
    "Timeex": "DATE",
    "Timeex_Other": "DATE",
    "Date": "DATE",
    "Day_Of_Week": "DATE",
    "Era": "DATE",
    "Periodx": "DATE",
    "Periodx_Other": "DATE",
    "Period_Day": "DATE",
    "Period_Week": "DATE",
    "Period_Month": "DATE",
    "Period_Year": "DATE",
    "Time_Top_Other": "DATE",

    "Time": "TIME",
    "Period_Time": "TIME",

    "Percent": "PERCENT",

    "Currency": "MONEY",
    "Money": "MONEY",

    "Unit_Other": "QUANTITY",
    "Latitude_Longitude": "QUANTITY",
    "Latitude_Longtitude": "QUANTITY",  # used in v7 ("Latitude_Longitude" in v8)
    "Measurement": "QUANTITY",
    "Measurement_Other": "QUANTITY",
    "Physical_Extent": "QUANTITY",
    "Seismic_Magnitude": "QUANTITY",
    "Space": "QUANTITY",
    "Volume": "QUANTITY",
    "Weight": "QUANTITY",
    "Speed": "QUANTITY",
    "Intensity": "QUANTITY",
    "Temperature": "QUANTITY",
    "Calorie": "QUANTITY",
    "Seismic_Intensity": "QUANTITY",
    "Countx": "QUANTITY",
    "Countx_Other": "QUANTITY",
    "N_Person": "QUANTITY",
    "N_Organization": "QUANTITY",
    "N_Location": "QUANTITY",
    "N_Location_Other": "QUANTITY",
    "N_Country": "QUANTITY",
    "N_Facility": "QUANTITY",
    "N_Product": "QUANTITY",
    "N_Event": "QUANTITY",
    "N_Natural_Object": "QUANTITY",
    "N_Natural_Object_Other": "QUANTITY",
    "N_Animal": "QUANTITY",
    "N_Flora": "QUANTITY",
    "Point": "QUANTITY",
    "Multiplication": "QUANTITY",
    "Frequency": "QUANTITY",
    "Age": "QUANTITY",

    "Rank": "ORDINAL",
    "School_Age": "ORDINAL",
    "Ordinal_Number": "ORDINAL",

    "Stock_Index": "CARDINAL",

    "Phone_Number": "PHONE",

    "Email": "EMAIL",

    "URL": "URL",

    "Individual_Animal": "ANIMAL",
    "Individual_Animal_Other": "ANIMAL",
    "Racehorse": "ANIMAL",

    "Name": "OTHERS",
    "Name_Other": "OTHERS",
    "Natural_Object": "OTHERS",
    "Natural_Object_Other": "OTHERS",
    "Element": "OTHERS",
    "Compound": "OTHERS",
    "Mineral": "OTHERS",
    "Living_Thing": "OTHERS",
    "Living_Thing_Other": "OTHERS",
    "Fungus": "OTHERS",
    "Mollusk_Arthropod": "OTHERS",
    "Mollusc_Arthropod": "OTHERS",  # used in v7 ("Mollusk_Arthropod" in v8)
    "Insect": "OTHERS",
    "Fish": "OTHERS",
    "Amphibia": "OTHERS",
    "Reptile": "OTHERS",
    "Bird": "OTHERS",
    "Mammal": "OTHERS",
    "Flora": "OTHERS",
    "Living_Thing_Part": "OTHERS",
    "Living_Thing_Part_Other": "OTHERS",
    "Animal_Part": "OTHERS",
    "Flora_Part": "OTHERS",
    "Disease": "OTHERS",
    "Disease_Other": "OTHERS",
    "Animal_Disease": "OTHERS",
    "Color": "OTHERS",
    "Color_Other": "OTHERS",
    "Nature_Color": "OTHERS",
    "Location": "OTHERS",
    "Astronomical_Object": "OTHERS",
    "Astronomical_Object_Other": "OTHERS",
    "Star": "OTHERS",
    "Planet": "OTHERS",
    "Constellation": "OTHERS",
    "Product": "OTHERS",
    "Class": "OTHERS",
    "Food": "OTHERS",
    "Dish": "OTHERS",
    "Doctrine_Method": "OTHERS",
    "Culture": "OTHERS",
    "Academic": "OTHERS",
    "Sport": "OTHERS",
    "Style": "OTHERS",
    "Theory": "OTHERS",
    "Title": "OTHERS",
    "Title_Other": "OTHERS",
    "Position_Vocation": "OTHERS",
    "Unit": "OTHERS",
    "Virtual_Address": "OTHERS",
    "Virtual_Address_Other": "OTHERS",
    "Event": "OTHERS",
    "Numex": "OTHERS",
    "Numex_Other": "OTHERS",
    "Astral_Body_Other": "OTHERS",
    "Material": "OTHERS",
}

ENE8_LABELS = {
    "Name": "1",
    "Name_Other": "1.0",
    "Person": "1.1",
    "God": "1.2",
    "Individual_Animal": "1.3",
    "Individual_Animal_Other": "1.3.0",
    "Racehorse": "1.3.1",
    "Organization": "1.4",
    "Organization_Other": "1.4.0",
    "International_Organization": "1.4.1",
    "Show_Organization": "1.4.2",
    "Family": "1.4.3",
    "Ethnic_Group": "1.4.4",
    "Ethnic_Group_Other": "1.4.4.0",
    "Nationality": "1.4.4.1",
    "Sports_Organization": "1.4.5",
    "Sports_Organization_Other": "1.4.5.0",
    "Sports_Federation": "1.4.5.1",
    "Sports_League": "1.4.5.2",
    "Sports_Team": "1.4.5.3",
    "Juridical_Person": "1.4.6",
    "Juridical_Person_Other": "1.4.6.0",
    "Nonprofit_Organization": "1.4.6.1",
    "Company": "1.4.6.2",
    "Company_Group": "1.4.6.3",
    "Political_Organization": "1.4.7",
    "Political_Organization_Other": "1.4.7.0",
    "Government": "1.4.7.1",
    "Political_Party": "1.4.7.2",
    "Cabinet": "1.4.7.3",
    "Military": "1.4.7.4",
    "Location": "1.5",
    "Location_Other": "1.5.0",
    "GPE": "1.5.1",
    "GPE_Other": "1.5.1.0",
    "City": "1.5.1.1",
    "Province": "1.5.1.2",
    "Country": "1.5.1.3",
    "Region": "1.5.2",
    "Region_Other": "1.5.2.0",
    "Continental_Region": "1.5.2.1",
    "Domestic_Region": "1.5.2.2",
    "Geological_Region": "1.5.3",
    "Geological_Region_Other": "1.5.3.0",
    "Spa": "1.5.3.1",
    "Mountain": "1.5.3.2",
    "Island": "1.5.3.3",
    "River": "1.5.3.4",
    "Lake": "1.5.3.5",
    "Sea": "1.5.3.6",
    "Bay": "1.5.3.7",
    "Astronomical_Object": "1.5.4",
    "Astronomical_Object_Other": "1.5.4.0",
    "Star": "1.5.4.1",
    "Planet": "1.5.4.2",
    "Constellation": "1.5.4.3",
    "Address": "1.5.5",
    "Address_Other": "1.5.5.0",
    "Postal_Address": "1.5.5.1",
    "Facility": "1.6",
    "Facility_Other": "1.6.0",
    "Facility_Part": "1.6.1",
    "Dam": "1.6.2",
    "Archaeological_Place": "1.6.3",
    "Archaeological_Place_Other": "1.6.3.0",
    "Tomb": "1.6.3.1",
    "FOE": "1.6.4",
    "FOE_Other": "1.6.4.0",
    "Military_Base": "1.6.4.1",
    "Castle": "1.6.4.2",
    "Palace": "1.6.4.3",
    "Public_Institution": "1.6.4.4",
    "Accommodation": "1.6.4.5",
    "Medical_Institution": "1.6.4.6",
    "School": "1.6.4.7",
    "Research_Institute": "1.6.4.8",
    "Market": "1.6.4.9",
    "Power_Plant": "1.6.4.10",
    "Park": "1.6.4.11",
    "Shopping_Complex": "1.6.4.12",
    "Sports_Facility": "1.6.4.13",
    "Museum": "1.6.4.14",
    "Zoo": "1.6.4.15",
    "Amusement_Park": "1.6.4.16",
    "Theater": "1.6.4.17",
    "Worship_Place": "1.6.4.18",
    "Transport_Facility": "1.6.5",
    "Transport_Facility_Other": "1.6.5.0",
    "Car_Stop": "1.6.5.1",
    "Station": "1.6.5.2",
    "Airport": "1.6.5.3",
    "Port": "1.6.5.4",
    "Line": "1.6.6",
    "Line_Other": "1.6.6.0",
    "Railroad": "1.6.6.1",
    "Road": "1.6.6.2",
    "Canal": "1.6.6.3",
    "Water_Route": "1.6.6.4",
    "Tunnel": "1.6.6.5",
    "Bridge": "1.6.6.6",
    "Product": "1.7",
    "Product_Other": "1.7.0",
    "Video_Work": "1.7.1",
    "Musical_Instrument": "1.7.2",
    "Clothing": "1.7.3",
    "Money_Form": "1.7.4",
    "Drug": "1.7.5",
    "Weapon": "1.7.6",
    "Stock": "1.7.7",
    "Award": "1.7.8",
    "Decoration": "1.7.9",
    "Offense": "1.7.10",
    "Service": "1.7.11",
    "Class": "1.7.12",
    "Character": "1.7.13",
    "ID_Number": "1.7.14",
    "Game": "1.7.15",
    "Game_Other": "1.7.15.0",
    "Digital_Game": "1.7.15.1",
    "Software": "1.7.16",
    "Vehicle": "1.7.17",
    "Vehicle_Other": "1.7.17.0",
    "Car": "1.7.17.1",
    "Train": "1.7.17.2",
    "Aircraft": "1.7.17.3",
    "Spaceship": "1.7.17.4",
    "Ship": "1.7.17.5",
    "Food": "1.7.18",
    "Food_Other": "1.7.18.0",
    "Dish": "1.7.18.1",
    "Art": "1.7.19",
    "Art_Other": "1.7.19.0",
    "Painting": "1.7.19.1",
    "Broadcast_Program": "1.7.19.2",
    "Movie": "1.7.19.3",
    "Show": "1.7.19.4",
    "Music": "1.7.19.5",
    "Book": "1.7.19.6",
    "Printing": "1.7.20",
    "Printing_Other": "1.7.20.0",
    "Newspaper": "1.7.20.1",
    "Magazine": "1.7.20.2",
    "Doctrine_Method": "1.7.21",
    "Doctrine_Method_Other": "1.7.21.0",
    "Culture": "1.7.21.1",
    "Religion": "1.7.21.2",
    "Academic": "1.7.21.3",
    "Sport": "1.7.21.4",
    "Style": "1.7.21.5",
    "Movement": "1.7.21.6",
    "Theory": "1.7.21.7",
    "Plan": "1.7.21.8",
    "Rule": "1.7.22",
    "Rule_Other": "1.7.22.0",
    "Treaty": "1.7.22.1",
    "Law": "1.7.22.2",
    "Title": "1.7.23",
    "Title_Other": "1.7.23.0",
    "Position_Vocation": "1.7.23.1",
    "Language": "1.7.24",
    "Language_Other": "1.7.24.0",
    "National_Language": "1.7.24.1",
    "Unit": "1.7.25",
    "Unit_Other": "1.7.25.0",
    "Currency": "1.7.25.1",
    "Virtual_Address": "1.8",
    "Virtual_Address_Other": "1.8.0",
    "Channel": "1.8.1",
    "Phone_Number": "1.8.2",
    "Email": "1.8.3",
    "URL": "1.8.4",
    "Event": "1.9",
    "Event_Other": "1.9.0",
    "Occasion": "1.9.1",
    "Occasion_Other": "1.9.1.0",
    "Election": "1.9.1.1",
    "Religious_Festival": "1.9.1.2",
    "Competition": "1.9.1.3",
    "Conference": "1.9.1.4",
    "Incident": "1.9.2",
    "Incident_Other": "1.9.2.0",
    "War": "1.9.2.1",
    "Natural_Phenomenon": "1.9.3",
    "Natural_Phenomenon_Other": "1.9.3.0",
    "Natural_Disaster": "1.9.3.1",
    "Earthquake": "1.9.3.2",
    "Natural_Object": "1.10",
    "Natural_Object_Other": "1.10.0",
    "Element": "1.10.1",
    "Compound": "1.10.2",
    "Mineral": "1.10.3",
    "Living_Thing": "1.10.4",
    "Living_Thing_Other": "1.10.4.0",
    "Fungus": "1.10.4.1",
    "Mollusk_Arthropod": "1.10.4.2",
    "Insect": "1.10.4.3",
    "Fish": "1.10.4.4",
    "Amphibia": "1.10.4.5",
    "Reptile": "1.10.4.6",
    "Bird": "1.10.4.7",
    "Mammal": "1.10.4.8",
    "Flora": "1.10.4.9",
    "Living_Thing_Part": "1.10.5",
    "Living_Thing_Part_Other": "1.10.5.0",
    "Animal_Part": "1.10.5.1",
    "Flora_Part": "1.10.5.2",
    "Disease": "1.11",
    "Disease_Other": "1.11.0",
    "Animal_Disease": "1.11.1",
    "Color": "1.12",
    "Color_Other": "1.12.0",
    "Nature_Color": "1.12.1",
    "Timex": "2",
    "Timex_Other": "2.0",
    "Timeex": "2.1",
    "Timeex_Other": "2.1.0",
    "Time": "2.1.1",
    "Date": "2.1.2",
    "Day_Of_Week": "2.1.3",
    "Era": "2.1.4",
    "Periodx": "2.2",
    "Periodx_Other": "2.2.0",
    "Period_Time": "2.2.1",
    "Period_Day": "2.2.2",
    "Period_Week": "2.2.3",
    "Period_Month": "2.2.4",
    "Period_Year": "2.2.5",
    "Numex": "3",
    "Numex_Other": "3.0",
    "Money": "3.1",
    "Stock_Index": "3.2",
    "Point": "3.3",
    "Percent": "3.4",
    "Multiplication": "3.5",
    "Frequency": "3.6",
    "Age": "3.7",
    "School_Age": "3.8",
    "Ordinal_Number": "3.9",
    "Rank": "3.10",
    "Latitude_Longitude": "3.11",
    "Measurement": "3.12",
    "Measurement_Other": "3.12.0",
    "Physical_Extent": "3.12.1",
    "Space": "3.12.2",
    "Volume": "3.12.3",
    "Weight": "3.12.4",
    "Speed": "3.12.5",
    "Intensity": "3.12.6",
    "Temperature": "3.12.7",
    "Calorie": "3.12.8",
    "Seismic_Intensity": "3.12.9",
    "Seismic_Magnitude": "3.12.10",
    "Countx": "3.13",
    "Countx_Other": "3.13.0",
    "N_Person": "3.13.1",
    "N_Organization": "3.13.2",
    "N_Location": "3.13.3",
    "N_Location_Other": "3.13.3.0",
    "N_Country": "3.13.3.1",
    "N_Facility": "3.13.4",
    "N_Product": "3.13.5",
    "N_Event": "3.13.6",
    "N_Natural_Object": "3.13.7",
    "N_Natural_Object_Other": "3.13.7.0",
    "N_Animal": "3.13.7.1",
    "N_Flora": "3.13.7.2",
}

"""
import json
import sys

if __name__ == "__main__":
    for ne, idx in ENE8_LABELS.items():
        if ne not in ENE_NE_MAPPING:
            print(idx, ne, "not in mapping")
    with open(sys.argv[1], "r") as f:
        meta_json = json.load(f)
    for ne in meta_json["labels"]["ner"]:
        if ne not in ENE_NE_MAPPING:
            print(ne, "not in mapping")
    for ent, idx in ENE_NE_MAPPING.items():
        if ent not in ENE8_LABELS and ent not in meta_json["labels"]["ner"]:
            print(idx, ent, "not used")

    for ne, idx, ent in sorted([
        (ne, ENE8_LABELS[ent] if ent in ENE8_LABELS else "_", ent) for ent, ne in ENT_NE_MAPPING.items()
    ]):
        print("\t"{}": "{}",".format(ent, ne))
"""
