struct VS_IN
{
    float4 pos : POSITION0;
	float4 normal : NORMAL0;
    float4 col : COLOR0;
    float2 tex : TEXCOORD0;
	float4  BlendWeights    : BLENDWEIGHT0;
    int4    BlendIndices    : BLENDINDICES0;
};
 
struct VS_OUT
{
    float4 pos  : SV_POSITION;
	float4 normal  : NORMAL0;
	float4 col  : COLOR0;
    float2 tex  : TEXCOORD0;
};
 
cbuffer ConstantBuffer : register(b0)
{
    float4x4 world;
    float4x4 view;
    float4x4 projection;
	float4x4 wvp;
	float4x4 shadowVP;
}

cbuffer BoneBuffer : register(b1)
{
    float4x4 boneMatrix[256];
}

cbuffer SystemBuffer : register(b2)
{
    float4 backBufferSize;
}
 
VS_OUT vs_simple( VS_IN input )
{
    VS_OUT output;
 
	output.pos  = mul(input.pos,  wvp);
    
	output.normal  = input.normal;
	output.col  = input.col;
    output.tex  = input.tex;
	
    return output;
}

VS_OUT vs_2D( VS_IN input )
{
    VS_OUT output;
 
    output.pos  = mul(input.pos,  world);

	float2 size = (backBufferSize / 2.0f);
	output.pos.x = ((float)output.pos.x - size.x ) / size.x;
	output.pos.y = -((float)output.pos.y - size.y ) / size.y;
	output.col  = input.col;
    output.tex  = input.tex;
 
    return output;
}