//=============================================================================
// Change_Stonize_MZ.js
//   Last update: 2024/09/22
//=============================================================================
// 更新っぽいもの
// 
// 2024/09/22 [v0.1.0]
// 初版

/*:
 * @target MZ
 * 
 * @plugindesc
 * [v0.1.0] Change!! Stonize MZ.
 * 
 * @author Diamond
 *
 * @param Stonize State ID
 * @text ????
 * @default 18
 * @type state
 * @desc
 * English is not supported.
 * Please Use Japanese!!
 * 
 * @help
 * Diamond use ruby, not use Java Script!!
 * Please use Ruby!! and RPG Tkool XP/VX/VX Ace.
 * 
 * @url https://diamond.iza-yoi.net/
 */

/*:ja
 * @target MZ
 * 
 * @plugindesc
 * [v0.1.0] 真（チェンジ！！）石化 MZ
 * 
 * @author 貪藻矢射妥←
 *
 * @param Stonize State ID
 * @text 石化のステートID
 * @default 18
 * @type state
 * @desc 「石化」のステートIDを設定
 *
 * @help
 * ステート：石化を実装します。
 * ツクールXPの場合、一番目のステート以外にHP 0とみなすステートを設定すると
 * 動作がおかしくなるという致命的なバグがありましたが、MZでは多分そんな現象は
 * おこらないと思います。（そもそも制約として「HP 0とみなす」がない）
 * ただ、パーティー全体が石化した場合、ゲームオーバーにならないため、その部分を
 * 実装します。
 * 
 * ※石化はアイテム、スキルでしか解除できないステート前提
 *
 * Java ScriptよりもRubyを使いたい！ by 貪藻矢射妥←
 * 
 * @url https://diamond.iza-yoi.net/
 */


var OuterFlg = OuterFlg || {};

(() => {

'use strict';

OuterFlg.imported = OuterFlg.imported || {};
OuterFlg.imported['Stonize'] = true;

var pluginParams         = PluginManager.parameters('Change_Stonize_MZ');
var changeStonizeStateId = Number(pluginParams['Stonize State ID'] || 18);

//var ParamsEx          = PluginManagerEx.createParameter(document.currentScript);
//var ParamsEx_hogehoge = ParamsEx['hogehogeStruct'];


//-----------------------------------------------------------------------------
// Game_BattlerBase

Game_BattlerBase.prototype.stonizeStateId = function() {
    return changeStonizeStateId;
};

Game_BattlerBase.prototype.isStonizeStateAffected = function() {
    return this.isStateAffected(this.stonizeStateId());
};

Game_BattlerBase.prototype.isStonize = function() {
    return this.isAppeared() && this.isStonizeStateAffected();
};


//-----------------------------------------------------------------------------
// Game_Unit

Game_Unit.prototype.stonizeMembers = function() {
    return this.members().filter(member => member.isStonize());
};

Game_Unit.prototype.isAllDead = function() {
    const aliveMembers   = this.aliveMembers().length;
    const stonizeMembers = this.stonizeMembers().length;
    
    if ( aliveMembers === 0 ) {
        // 生存メンバーが一人もいない場合は全滅
        return true;
    } else if ( aliveMembers - stonizeMembers <= 0 ) {
        // メンバーが全員石化している場合も全滅
        return true;
    } else {
        // それ以外の場合、生存判定
        return false;
    }
};


})();
