//=============================================================================
// SeparateDigit.js
//=============================================================================

/*:
 * @plugindesc 数値を指定の桁数ごとに区切ります。
 * @author Risato Aragami
 *
 * @help
 * 【注意】
 * ・当プラグインはRPGツクールMV環境下で利用されることを想定しています。
 * 　他の環境で動作させることは想定しておりません。
 * ・当プラグイン及び記載のコードによって発生したいかなる事象について、当方は責任を負いかねます。
 * ・予告なくプラグインの更新を停止する場合があります。
 * ・当プラグインの利用及び改変はご自由に行っていただいて結構です。
 * ・当プラグインに関する質問意見要望等は、作者ツイッターまで。(risato_aragami)
 *
 * ============================================================================
 *
 * 【プラグインコマンド】
 * SeparateDigit string 【区切りたい数値が入っている変数のID】 【処理後の値を入れたい変数ID】
 * 　→　1,234,567　のような形の文字列を返します。
 * SeparateDigit number 【区切りたい数値が入っている変数のID】 【処理後の値を入れたい変数ID（始点）】
 * 　→　変数1に567、変数2に234、変数3に1、といったような形の数字を返します。
 *
 * ============================================================================
 * 【更新履歴】
 * 2019/11/12      ver, 1.0.0          # BP版として再リリース
 *
 */

 "use strict";

(function () {

  let _Game_Interpreter_pluginCommand =
          Game_Interpreter.prototype.pluginCommand;
  Game_Interpreter.prototype.pluginCommand = function(command, args) {
      _Game_Interpreter_pluginCommand.call(this, command, args);
      if (command === 'SeparateDigit') {
          switch (args[0]) {
          case 'number':
              separater(args[1], args[2], 'number');
              break;
          case 'string':
              separater(args[1], args[2], 'string');
              break;
          }
      }
  };

  let separater = function (varId, varId2, type) {
    let str = String($gameVariables.value(varId));
    let count = Math.floor((str.length - 1) / 3);
    let newData = [];
    let max = str.length;
    for (let i = 0; i < count + 1; i++) {
      let counter = [max - 3 * i - 3, max - 3 * i];
      if (counter[0] < 0) {
        counter[0] = 0;
      }
      newData.unshift(str.slice(counter[0], counter[1]));
      if (type === 'string') {
        newData.unshift(",");
      }
    }
    if (type === 'string') {
      let number = " ";
      newData.shift();
      for (let i = 0; i < newData.length; i++) {
        number = number + newData[i];
      }
      $gameVariables.setValue(varId2, number.slice(1));
    } else {
      for (let i = 0; i < newData.length; i++) {
        $gameVariables.setValue(varId2 + i, newData[i]);
      }
    }
  };

})();
