/*:
 * @target MZ
 * @plugindesc 数値を指定の桁数ごとに区切る（MZ対応版）
 * @author Risato Aragami（改修：ChatGPT）
 * @command SeparateAsString
 * @text 区切り文字列として出力
 * @desc 1,234,567 のような文字列として変数に格納します
 *
 * @arg sourceVarId
 * @type variable
 * @text 元の変数ID
 * @desc 区切る対象の数値が入った変数ID
 *
 * @arg targetVarId
 * @type variable
 * @text 出力変数ID
 * @desc 変換後の文字列を格納する変数ID
 *
 * @command SeparateAsNumbers
 * @text 各桁を変数に格納
 * @desc 567, 234, 1 のように1000単位で分けた数値を複数の変数に格納します
 *
 * @arg sourceVarId
 * @type variable
 * @text 元の変数ID
 * @desc 区切る対象の数値が入った変数ID
 *
 * @arg startVarId
 * @type variable
 * @text 出力変数ID（始点）
 * @desc 結果を格納していく最初の変数ID（以降連番で入ります）
 */

(() => {
    const pluginName = "SeparateDigit_MZ";
  
    PluginManager.registerCommand(pluginName, "SeparateAsString", args => {
      const sourceVarId = Number(args.sourceVarId);
      const targetVarId = Number(args.targetVarId);
      const value = String($gameVariables.value(sourceVarId));
      const count = Math.floor((value.length - 1) / 3);
      let result = [];
      let max = value.length;
  
      for (let i = 0; i < count + 1; i++) {
        let start = Math.max(0, max - 3 * (i + 1));
        let end = max - 3 * i;
        result.unshift(value.slice(start, end));
      }
  
      const formatted = result.join(",");
      $gameVariables.setValue(targetVarId, formatted);
    });
  
    PluginManager.registerCommand(pluginName, "SeparateAsNumbers", args => {
      const sourceVarId = Number(args.sourceVarId);
      const startVarId = Number(args.startVarId);
      const value = String($gameVariables.value(sourceVarId));
      const count = Math.floor((value.length - 1) / 3);
      let result = [];
      let max = value.length;
  
      for (let i = 0; i < count + 1; i++) {
        let start = Math.max(0, max - 3 * (i + 1));
        let end = max - 3 * i;
        result.unshift(value.slice(start, end));
      }
  
      for (let i = 0; i < result.length; i++) {
        $gameVariables.setValue(startVarId + i, Number(result[i]));
      }
    });
  })();
  