//=============================================================================
// DispStatusWndOnMsg.js
//=============================================================================
/*:
 * @plugindesc Don't close status window when message window is opening in battle.
 * @author Sasuke KANNAZUKI
 *
 * @help
 * This plugin does not provide plugin commands.
 *
 * [License]
 * this plugin is released under MIT license.
 * http://opensource.org/licenses/mit-license.php
 */

/*:ja
 * @plugindesc 戦闘中メッセージウィンドウ表示中もステータスウィンドウを閉じません
 * @author 神無月サスケ
 *
 * @help
 * このプラグインには、プラグインコマンドはありません。
 *
 * ■概要
 * メッセージウィンドウの表示位置は上か中にしてください。
 * 下にすると、ステータスウィンドウとかぶって見えなくなります。
 *
 * ■ライセンス表記
 * このプラグインは MIT ライセンスで配布されます。
 * ご自由にお使いください。
 * http://opensource.org/licenses/mit-license.php
 */

(function() {
  // overwritten
  Scene_Battle.prototype.updateStatusWindow = function() {
    if ($gameMessage.isBusy()) {
      // this._statusWindow.close();
      this._partyCommandWindow.close();
      this._actorCommandWindow.close();
    } else if (this.isActive() && !this._messageWindow.isClosing()) {
      this._statusWindow.open();
    }
  };

})();
