﻿//
// HP回復、MP回復の乱数調整プラグイン ver.1.01
//
// author 綱秀時
//

var Imported = Imported || {};
Imported['HPRecoverRandomAdd'] = 1.00;
Imported['HPRecoverRandomRate'] = 1.00;
Imported['MPRecoverRandomAdd'] = 1.00;
Imported['MPRecoverRandomRate'] = 1.00;


/*:
 * @plugindesc 使用効果リストのHP回復、MP回復の値に
 * 乱数調整を加えられるようになります。
 * @author 綱秀時
 *
 * @param HPRecoverRandomAdd
 * @desc HP回復に最終的に追加されるランダムの値です。
 * ±の絶対値を入力してください。
 * @default 0
 *
 * @param HPRecoverRandomRate
 * @desc HP回復が変動する倍率（%）
 * この倍率がかかった後にAddの値が加算されます。
 * @default 0
 *
 * @param MPRecoverRandomAdd
 * @desc MP回復に最終的に追加されるランダムの値です。
 * ±の絶対値を入力してください。
 * @default 0
 *
 * @param MPRecoverRandomRate
 * @desc MP回復が変動する倍率（%）
 * この倍率がかかった後にAddの値が加算されます。
 * @default 0
 *
 * @help
 *-------------------------------------------------------------------------------
 * HPMP回復の乱数調整プラグイン
 *-------------------------------------------------------------------------------
 * 
 * スキル、アイテムの使用効果の値を乱数で調整するプラグインです。
 *
 * YEP_ItemCoreなどの回復効果の数値を直接表示するプラグインとの併用で
 * 表示を変えずに乱数で変化を加えることができます。
 *
 * プラグインコマンドはありません。
 *
 * ＜使い方＞
 *
 * Rateに変動倍率（%）、Addに加算する乱数の絶対値を入力すると
 * 使用効果リストのHP回復、MP回復の値に適応されます。
 *
 * ＜仕様＞
 *
 * rpg_objectsのitemEffectRecoverを直接書き換えているだけです。
 * TPを調整したい場合もコピペ＆置換でできるはずです。
 *
 * ＜計算式＞
 *
 * 使用効果リストの値 * 倍率変動（Rate）+ 加算乱数（Add） となっています。
 * 
 * ＜注意点＞
 * 
 * スキル、アイテム全てに一括で適応されます。
 * 加算乱数の値によっては回復、ダメージが逆転することもあります。
 * 
 * ＜利用規約＞
 * 
 * 商用、再配布、暴力的表現、アダルト表現、改変使用（説明文削除含む）、何でも可。
 * プラグイン単体の販売と著作表記削除改変のみ禁止です。後はご自由に。
 * クレジット表記して頂けると作者が心の中で小躍りします。
 *
 * ver1.01　回復効果率の変動が乱数調整後にかかるように修正 
 * ver1.00　初回リリース
 *
 */

(function() {
    var parameters = PluginManager.parameters('HPMPRecoverRandomizer');
    var HPRecoverRandomAdd = Number(parameters['HPRecoverRandomAdd'] || '0') + 1;
    var HPRecoverRandomRate = Number(parameters['HPRecoverRandomRate'] || '0') + 1;
    var MPRecoverRandomAdd = Number(parameters['MPRecoverRandomAdd'] || '0') + 1;
    var MPRecoverRandomRate = Number(parameters['MPRecoverRandomRate'] || '0') + 1;

Game_Action.prototype.itemEffectRecoverHp = function(target, effect) {
    var value = target.mhp * effect.value1 + effect.value2;
    if (this.isItem()) {
        value *= this.subject().pha;
    }
    value = Math.floor(value);
    var rate = Math.floor( Math.random() * HPRecoverRandomRate );
    var incdec = Math.floor( Math.random() * 2 );
    if (incdec == 1){
        rate = -rate;
    }
    incdec = Math.floor( Math.random() * 2 );
    if (incdec == 1){
        var rnd = Math.floor( Math.random() * HPRecoverRandomAdd );
    }
    else{
        var rnd = - Math.floor( Math.random() * HPRecoverRandomAdd );
    }
    value = value * ( 1 + rate * 0.01 ) + rnd;
    value = value * target.rec;
    value = Math.round(value);
    if (value !== 0) {
        target.gainHp(value);
        this.makeSuccess(target);
    }
};

Game_Action.prototype.itemEffectRecoverMp = function(target, effect) {
    var value = target.mmp * effect.value1 + effect.value2;
    if (this.isItem()) {
        value *= this.subject().pha;
    }
    value = Math.floor(value);
    var rate = Math.floor( Math.random() * MPRecoverRandomRate );
    var incdec = Math.floor( Math.random() * 2 );
    if (incdec == 1){
        rate = -rate;
    }
    incdec = Math.floor( Math.random() * 2 );
    if (incdec == 1){
        var rnd = Math.floor( Math.random() * MPRecoverRandomAdd );
    }
    else{
        var rnd = - Math.floor( Math.random() * MPRecoverRandomAdd );
    }
    value = value * ( 1 + rate * 0.01 ) + rnd;
    value = value * target.rec;
    value = Math.round(value);
    if (value !== 0) {
        target.gainMp(value);
        this.makeSuccess(target);
    }
};


})();