//=============================================================================
// RecollectionModeMZ.js
// Copyright (c) 2020 rinne_grid
// This plugin is released under the MIT license.
// http://opensource.org/licenses/mit-license.php
//
// Version
// 1.0.0 2020/11/28 公開
//=============================================================================

/*:ja
 * @target MZ
 * @plugindesc 回想モード機能を追加します。
 * @author rinne_grid
 *
 *
 *
 * @param recModeBgm
 * @text [回想モードBGM設定]
 * @desc
 *
 * @param recModeBgmName
 * @parent recModeBgm
 * @text BGMファイル名
 * @desc 回想モードで再生するBGM名を指定します。拡張子不要です
 * @type file
 * @dir audio/bgm
 * @default blank_memories
 *
 * @param recModeBgmPan
 * @parent recModeBgm
 * @text BGMの位相
 * @desc 再生するBGMの位相(左右どちら寄りで再生するか)を指定します。0の場合中央です
 * @type number
 * @min -100
 * @max 100
 * @default 0
 *
 * @param recModeBgmPitch
 * @parent recModeBgm
 * @text BGMのピッチ
 * @desc 再生するBGMのピッチ(再生速度)を指定します。0の場合は元の楽曲の速さです
 * @type number
 * @min 50
 * @max 150
 * @default 100
 *
 * @param recModeBgmVolume
 * @parent recModeBgm
 * @text BGMの音量
 * @desc 再生するBGMの音量を指定します。
 * @type number
 * @min 0
 * @max 100
 * @default 90
 *
 *
 *
 * @param recModeSelectWindow
 * @text [回想・CG選択設定]
 * @desc
 *
 * @param recModeSelectWindowX
 * @parent recModeSelectWindow
 * @text x座標
 * @desc 回想モード・CG選択ウィンドウのX座標を指定します
 * @type number
 * @default 260
 *
 * @param recModeSelectWindowY
 * @parent recModeSelectWindow
 * @text Y座標
 * @desc 回想モード・CG選択ウィンドウのY座標を指定します
 * @type number
 * @default 180
 *
 * @param recModeSelectWindowRecoTitle
 * @parent recModeSelectWindow
 * @text 回想メニュー名
 * @desc タイトル画面に追加する回想モード用の文字列を指定します
 * @type string
 * @default 回想モード
 *
 * @param recModeSelectWindowSelectReco
 * @parent recModeSelectWindow
 * @text 回想の選択肢名
 * @desc 回想・CG選択ウィンドウのうち、回想側に設定する選択肢の文字列を指定します
 * @type string
 * @default 回想を見る
 *
 * @param recModeSelectWindowSelectCg
 * @parent recModeSelectWindow
 * @text CGの選択肢名
 * @desc 回想・CG選択ウィンドウのうち、CG側に設定する選択肢の文字列を指定します
 * @type string
 * @default CGを見る
 *
 * @param recModeSelectWindowBackTitle
 * @parent recModeSelectWindow
 * @text タイトルに戻る選択肢名
 * @desc 回想・CG選択ウィンドウのうち、タイトルに戻る選択肢の文字列を指定します
 * @type string
 * @default タイトルに戻る
 *
 *
 *
 * @param recModeList
 * @text [回想リストウィンドウの設定]
 * @desc
 *
 * @param recModeListItemColumn
 * @parent recModeList
 * @text 1画面あたりの列数
 * @desc 回想リストウィンドウの1画面あたりに表示する列数を指定します
 * @type number
 * @default 2
 *
 * @param recModeListItemRow
 * @parent recModeList
 * @text 1画面あたりの行数
 * @desc 回想リストウィンドウの1画面あたりに表示する行数を指定します
 * @type number
 * @default 2
 *
 * @param recModeListIsDisplayText
 * @parent recModeList
 * @text CG説明テキストの表示有無
 * @desc 回想リストウィンドウのCGに説明テキストを表示するかどうかを選択します
 * @type boolean
 * @on する
 * @off しない
 * @default true
 *
 * @param recModeListDisplayPosition
 * @parent recModeList
 * @text CG説明テキストの表示位置
 * @desc CG説明テキストの表示位置を指定します。
 * @type select
 * @option center
 * @option right
 * @option left
 * @default center
 *
 * @param recModeListNeverWatchPictureName
 * @parent recModeList
 * @text 未開放の時に表示する画像
 * @desc 回想が未開放の時に表示する画像ファイル名を指定します(拡張子は不要です)
 * @type file
 * @dir img/pictures
 * @default never_watch_picture
 *
 * @param recModeListNeverWatchTextName
 * @parent recModeList
 * @text 未開放の時に表示するテキスト
 * @desc 回想が未開放の時に表示するテキストを指定します
 * @type string
 * @default ？？？
 *
 *
 *
 * @param sandboxMapId
 * @text 回想用一時マップID
 * @desc 回想用に一時敵に利用するマップを指定します。何もないマップを指定してください。
 * @type number
 * @default 1
 *
 * @param recoCgSettingList
 * @text 回想情報ファイル
 * @desc 回想情報を定義したファイルを指定します。
 * @type file
 * @dir img/system
 * @default RecollectionModeMZData.json
 *
 *
 * @param devParameter
 * @text [開発向けパラメータ]
 * @desc
 *
 * @param devParameterDevTools
 * @parent devParameter
 * @text 起動時の開発者ツールの表示有無
 * @desc デスクトップ版において、ゲーム起動時に開発者ツールも一緒に起動するかどうかを指定します
 * @type boolean
 * @on する
 * @off しない
 * @default false
 *
 * @command backToRecoMode
 * @text 回想に戻る
 * @desc 回想用のコモンイベントの一番最後で必ずこのコマンドを利用する必要があります。
 *
 * @help
 * このプラグインはアドベンチャーゲーム等でよく見られる
 * シーン回想及びCGモードを追加します
 *
 * [プラグインコマンド一覧]
 *
 * [回想に戻る]
 *  回想用のコモンイベントから、回想モード用の画面に戻るためのコマンドです。
 *  回想用のコモンイベントの一番最後で必ずこのコマンドを利用する必要があります。
 *  通常時(回想モード以外のゲーム中)ではこのコマンドは
 *  無視されるためご安心ください。
 */