//=============================================================================
// UT_PreserveMapScene.js  v2.2
//=============================================================================
/*:
 * @target MV MZ
 * @plugindesc Preserve map scene after going into menus and battle
 * @author utunnels
 *
 * @help This plugin is plug-and-play.
 * Use it when the game has notable lag after leaving a menu and back to the map.
 * 
 */

(function(){
const isMV = Utils.RPGMAKER_NAME == 'MV';
const isMZ = Utils.RPGMAKER_NAME == 'MZ';
const isUnknown = !isMV && !isMZ;

if(isUnknown) throw 'Unknown RPG Maker: RPGMAKER_NAME = ' + Utils.RPGMAKER_NAME;

  (function(alias){
  SceneManager.clearStack = function() {
      alias.call(this);
      this.preserveScene(null);
  };
  })(SceneManager.clearStack);

  //2025-04-19: hook createGameObjects to remove preserved scene for in game load
  (function(alias){
  DataManager.createGameObjects = function() {
      SceneManager.preserveScene(null);
      alias.call(this);
  };
  })(DataManager.createGameObjects);

  SceneManager.preserveScene = function(scene){
    if(this._preserved){
      //2025-04-19 : Remove those below because it may destroy current background.
      // TODO: Watch for possible memory leak
      //this._preserved.stop(true); //crash when return to title, so remove this, no visible side effects
      //var ts = this._scene;
      //this._scene = this._preserved;
      //this._preserved.terminate();
      //this._scene = ts;
      if(isMV) this._preserved.detachReservation();
      //else this.onSceneTerminate(); //should it? 
    }
    if(scene){
      this._preserved=scene;
      scene._isPreserved=true;
      //transition plugin compatible
      if(scene.preStopTransition){
        scene.preStopTransition();
        scene.postStopTransition();
      }
    }else delete this._preserved;
  };

  Spriteset_Map.prototype.showCharacters = function() {
      for (var i = 0; i < this._characterSprites.length; i++) {
          this._characterSprites[i].show();
      }
  };

  (function(alias){
  SceneManager.changeScene = function() {
      if((this._scene&&this._scene._isPreserved)||(this._nextScene&&this._nextScene._isPreserved)) {
        if (this.isSceneChanging() && !this.isCurrentSceneBusy()) {
            if (this._scene) {
              if(!this._scene._isPreserved){
                this._scene.terminate();
                if(isMV) this._scene.detachReservation();
                else this.onSceneTerminate();
              } else{
                SceneManager.snapForBackground();
                $gameScreen.clearZoom();
                //multitweaks zoom fix
                if($gameMap._currentZoom) $gameScreen.setZoom(Graphics.width / 2, Graphics.height / 2, $gameMap._currentZoom);
              }
              this._previousClass = this._scene.constructor;
            }
            this._scene = this._nextScene;
            if (this._scene) {
              if(!this._scene._isPreserved){
                if(isMV) this._scene.attachReservation();
                if(typeof DKTools!='undefined'){//DKTools patch
                  //NOTE: code below are copied from DKTools,
                  // I'm not sure how they exactly work,
                  // but making an exact copy fixes compatible issue
                  this._scene.startPreloading();

                  this._sceneCreated = false;
                  this._sceneStarted = false;
                  this._nextScene = null;

                  if (this._scene.isPreloaded()) {
                      this._scene.create();
                      this._sceneCreated = true;

                      this.onSceneCreate();
                  }
                }else{
                  this._scene.create();
                  this.onSceneCreate();
                  if(isMV) this._sceneStarted = false;
                }
              }else{
                this._scene._active=true;
                this._scene.menuCalling = false;
                if(isMZ) Graphics.setStage(this._scene);
                //YEP message core patch
                if(typeof Yanfly!='undefined'){
                  var mw = this._scene._messageWindow;
                  if(mw){
                    Yanfly.nameWindow = mw._nameWindow;
                  }
                }
                if(this._previousClass==Scene_Battle){
                  //MPP encounter effect patch
                  if(this._encEffSprite){
                    this._scene.destroyEncEffSprite();
                    this._scene._spriteset.visible = true; 
                  }
                  this._scene.startFadeIn(this._scene.fadeSpeed(), false);
                  this._scene._spriteset.showCharacters();
                }
                //multitweaks zoom fix
                if($gameMap._currentZoom) $gameScreen.setZoom(Graphics.width / 2, Graphics.height / 2, $gameMap._currentZoom);
                //(my) SceneTransition.js compatible patch
                if(this._scene.startTransitionEffect){
                  if(this._scene._prevSceneSprite){
                    this._scene.removeChild(this._scene._prevSceneSprite);
                    delete this._scene._prevSceneSprite;
                  }
                  this._scene.startTransitionEffect();
                }
              }
              this._nextScene = null;
              delete this._scene._isPreserved;
            }
            if (this._exiting) {
                this.terminate();
            }
        }
      }else {
        alias.call(this);
      }
  };
  })(SceneManager.changeScene);

  (function(alias){
  SceneManager.goto = function(sceneClass) {
      //preserve map scene before battle and menu
      if(this._scene && this._scene instanceof Scene_Map){
        if(sceneClass!=Scene_Map){
          this.preserveScene(this._scene);
        }
      }
      if(this._preserved){
        if (sceneClass) {
          if(this._preserved instanceof sceneClass){
            this._nextScene = this._preserved;
            delete this._preserved;
          }else{
            this._nextScene = new sceneClass();
          }
        }
        if (this._scene!=this._preserved) {
            this._scene.stop();
        }else{
            this._preserved._active=false;
            if(sceneClass==Scene_Battle) {
              this._scene.launchBattle();
            }
        }
      }else alias.call(this,sceneClass);
  };
  })(SceneManager.goto);
})();