﻿/*:
 * @target MZ MV
 * @url 
 * @plugindesc 生肉汁 自作プラグイン
 * @author  生肉汁
 *
 * @param SkipTitleSW
 * @type boolean
 * @text タイトルをSkip
 * @desc タイトルをSkipします。default true
 * @on はい
 * @off いいえ
 * @default true
 * 
 * @param SkipMovieSW
 * @type boolean
 * @text 動画をSkip
 * @desc 動画をSkipします。default true
 * @on はい
 * @off いいえ
 * @default true
 * 
 * @command 動画をSkip
 * @text 動画をSkip
 * @desc 動画をSkipします。
 * 
 * @param TryMoneySW
 * @type boolean
 * @text 金銭問題を回避
 * @desc 金銭問題を回避。default true
 * @on はい
 * @off いいえ
 * @default true
 * 
 * @command 金銭問題をSkip
 * @text 金銭問題をSkip
 * @desc 金銭問題をSkipします。
 * 
 * @param TryOnOff
 * @type boolean
 * @text 体験版の表示
 * @desc 体験版の表示です。default true
 * @on はい
 * @off いいえ
 * @default true
 *
 * @command  体験版
 * @text 体験版
 * @desc 体験版を表示。
 * 
 * @command ステータス_表示
 * @text ステータス
 * @desc ステータスを表示します。
 * 
 * @command ピクチャ_全消去
 * @text ピクチャ_全消去
 * @desc ピクチャ_全消去します。
 *
 * @param GoldWindowSW
 * @type boolean
 * @text 所持金の表示
 * @desc 所持金の表示です。default true
 * @on はい
 * @off いいえ
 * @default true
 * 
 * @command face
 * @text face
 * @desc faceをセットします。
 *
 * @arg FaceOnOff
 * @type boolean
 * @text 顔の表示をOffにする。
 * @desc 顔の表示をOffにします。default false
 * @on はい
 * @off いいえ
 * @default false
 *
 * @arg ActorImg
 * @type string
 * @text ActorImg
 * @desc ActorImgです。
 *
 * @arg FaceNumber
 * @type number
 * @default 0
 * @text FaceNumber Number
 * @desc FaceNumber Numberです。
 * 
 * @arg  Message
 * @type string
 * @text Message
 * @desc Messageです。
 *
 * @command Message
 * @text Message
 * @desc Messageをセットします。
 *
 * @arg MessageNumber
 * @type string
 * @text MessageNumber Number
 * @desc man0:男性 woman0:女性
 * 
 * @help
 * 生肉汁 自作プラグイン
 */

(() => {

    'use strict';
    var parameters = PluginManager.parameters('Erotan_Plugin');

    var SkipTitleSW = parameters['SkipTitleSW'] === 'true';
    if (SkipTitleSW) {
        Scene_Boot.prototype.startNormalGame = function () {
            this.checkPlayerLocation();
            DataManager.setupNewGame();
            SceneManager.goto(Scene_Map);
        };
    }

    var SkipMovieSW = parameters['SkipMovieSW'] === 'true';
    var TryMoneySW = parameters['TryMoneySW'] === 'true';
    
    var TryOnOff = parameters['TryOnOff'] === 'true';
    Scene_Title.prototype.createBackground = function() {
    this._backSprite1 = new Sprite(
        ImageManager.loadPicture("movies/z_cover560x420_00000")
    );

    this._backSprite2 = new Sprite(
        ImageManager.loadTitle2($dataSystem.title2Name)
    );
    this.addChild(this._backSprite1);
    this.addChild(this._backSprite2);
    };

    Scene_Title.prototype.createForeground = function() {
    this._gameTitleSprite = new Sprite(
        new Bitmap(Graphics.width, Graphics.height)
    );
    this.addChild(this._gameTitleSprite);
    if(TryOnOff){
        var sprite = new Sprite(ImageManager.loadPicture("try"));
        sprite.x = Graphics.width / 2;
        sprite.y = Graphics.height / 2;
        sprite.anchor.x = 0.5;
        sprite.anchor.y = 0.5;
        this.addChild(sprite);
    }
    if ($dataSystem.optDrawTitle) {
        this.drawGameTitle();
    }
    };

    var GoldWindowSW = parameters['GoldWindowSW'] === 'true';
    Scene_Menu.prototype.commandWindowRect = function () {
        if (GoldWindowSW) {
            const ww = this.mainCommandWidth();
            const wh = this.calcWindowHeight(3, true);
            const wx = (Graphics.boxWidth - ww) / 2;
            const wy = (Graphics.boxHeight - wh) / 2;
            return new Rectangle(wx, wy, ww, wh);
        } else {
            const ww = this.mainCommandWidth();
            const wh = this.calcWindowHeight(3, true);
            const wx = (Graphics.boxWidth - ww) / 2;
            const wy = (Graphics.boxHeight - wh) / 2;
            return new Rectangle(wx, wy, ww, wh);
        }
    };
    Scene_Menu.prototype.createGoldWindow = function () {
        if (GoldWindowSW) {
            const rect = this.goldWindowRect();
            this._goldWindow = new Window_Gold(rect);
            this.addWindow(this._goldWindow);
        } else { }
    };
    Scene_Menu.prototype.goldWindowRect = function () {
        const ww = this.mainCommandWidth();
        const wh = this.calcWindowHeight(2, true);
        const wx = (Graphics.boxWidth - ww) / 2;
        const wy = 15;
        return new Rectangle(wx, wy, ww, wh);
    };



// ******************************************************************************
    function f_Array(num) {
        var obj = num.split(",");
        var i = Math.floor(Math.random() * obj.length);
        return obj[i];
    }

    function f_RepeatWord(num) {
        var obj = num.split(",");
        var hoge2 = obj[0];
        for (var i = 1; i < obj.length; i++) { hoge2 = hoge2 + f_RepeatWord2(obj[i]); }
        return hoge2;
    }

    function f_RepeatWord2(hoge) {
        var hoge2 = hoge;
        var max = Math.floor(Math.random() * 3);
        for (var i = 0; i < max; i++) { hoge2 = hoge2 + hoge; }
        return hoge2;
    }



    const pluginName = 'Erotan_Plugin';

    PluginManager.registerCommand(pluginName, '動画をSkip', function () {
        if (SkipMovieSW) {
            $gameSwitches.setValue(19, true);
        } else {
            $gameSwitches.setValue(19, false);
        }
    });
    PluginManager.registerCommand(pluginName, '金銭問題をSkip', function () {
        if (TryMoneySW) $gameParty.gainGold(10000000000000);
    });

    PluginManager.registerCommand(pluginName, '体験版', function () {
        if (TryOnOff) {
            $gameVariables.setValue(100, 1);
        } else {
            $gameVariables.setValue(100, 0);
        }
    }); 

    PluginManager.registerCommand(pluginName, 'ステータス_表示', function () {
        window.JwinName = {};    // ★★ウィンドウ名を変更 /////////////////////////////
        JwinName.windows = 0;   // ★★ウィンドウ名を変更 /////////////////////////////
        JwinName.show = function (x, y, width, height) { // ★★ウィンドウ名を変更 ////
            let t_val = new Rectangle(x, y, width, height)
            var w = new Window_Base(t_val);
            w.openness = 255;  // 0:アニメで開く　255:瞬間で開く
            w.opacity = 255;   // 0:透明　255:透明度無し（ピクチャのアルファチャンネル分のみ）
            w.open();
            if (this.windows) this.hide();
            this.windows = w;
            SceneManager._scene.addWindow(w);
            this.refresh();
        };

        JwinName.hide = function () {  // ★★ウィンドウ名を変更 ////////////////////////
            if (!this.windows) return;
            this.windows.openness = 0;  // 0:瞬間で閉じる　255:アニメで閉じる（開くときと逆）
            this.windows.close();
            this.windows = null;
        };

        /////////////////////////////////////////////////////////////////////////
        // ここから描画部
        JwinName.refresh = function () {  // ★★ウィンドウ名を変更 /////////////////////
            if (!this.windows) return;
            this.windows.contents.clear();

            ///////////////////////////
            // 文字列の描画
            // フォントサイズ設定：デフォルトフォントサイズは「システム２」で設定
            this.windows.contents.fontSize = 26;
            // フォントカラー設定：normalColorの部分の名前を変える
            // normalColor：白　　systemColor：水色　　
            // crisisColor：黄色　 deathColor：　赤　　
            this.windows.changeTextColor(ColorManager.normalColor());
            //　描画部
            //  this.windows.drawText("文字列", x, y, 文字幅, align);
            //  alignは"left","center","right"とダブルコーテーション付きで文字で書く
            //  文字幅、alignは省略可能　("文字列", x, y,)だけでもいい
            this.windows.drawText("あいうえお", 0, 0, 320, "center");
            this.windows.drawText($gameVariables.value(1), 0, 26,);

            ///////////////////////////
            // ピクチャの描画
            var bmp = ImageManager.loadPicture("Actor1_1");
            bmp.addLoadListener(function () {
                // 最後の２つがウィンドウ内のｘ、ｙ座標
                this.windows.contents.blt(bmp, 0, 0, bmp.width, bmp.height, 90, 120);
            }.bind(this));
        };
    });
        PluginManager.registerCommand(pluginName, 'ピクチャ_全消去', function() {
            for(var i = 0; i <= 100; i++){$gameScreen.erasePicture(i)}
        });

    PluginManager.registerCommand(pluginName, 'face', function (args) {
        const FaceOnOff = args.FaceOnOff === "true";
        const ActorImg = args.ActorImg;
        const FaceNumber = args.FaceNumber;
        const Message = args.Message;
        SoundManager.playOk();
        $gameMessage.newPage();
        $gameMessage.add(f_RepeatWord(Message));
        if (FaceOnOff) {
            $gameMessage.setFaceImage(ActorImg, FaceNumber);
        } else {
            
        }
        this.setWaitMode('message');
    });

    PluginManager.registerCommand(pluginName, 'Message', function (args) {
        const num_tyou = f_Array("超, 無茶苦茶, とっても, すご～く");
        const MessageNumber = args.MessageNumber;
        SoundManager.playOk();
        $gameMessage.newPage();
        const x_woman = f_Array("プリップリの,ピッチピチの,若さ溢れる,フレッシュな,生きのいい,新鮮もぎたての,プルンプルンの") + f_Array("メス豚,売春婦,淫乱娘");
        const x_play = f_Array("マジで,無茶苦茶,思いっきり") + f_RepeatWord("セックスした,ぁ,い,～,！");
        if (MessageNumber == "man0") $gameMessage.add(`${x_woman}は${f_RepeatWord("最高,ぉ,お,う,ー,！")} ${x_play}`);
        if (MessageNumber == "man1") $gameMessage.add(`${x_woman}と売春${f_RepeatWord("して,ぇ,え,ー,！")} `);
        if (MessageNumber == "man2") $gameMessage.add(`${x_woman}は${f_RepeatWord("スゲー! ,うひょっ,っ,お,ー,！")} ${x_play}`);
        if (MessageNumber == "man3") $gameMessage.add(`${x_woman}が${f_RepeatWord("好きだ,ぁ,あ,ー,！")} ${x_play}`);
        if (MessageNumber == "man4") $gameMessage.add(`${x_woman}が${f_RepeatWord("好きだ,ぁ,あ,ー,！")} ${x_woman}は${f_RepeatWord("超最高,ぉ,お,う,ー,！")}`);
        if (MessageNumber == "man5") $gameMessage.add(`${x_woman}は${f_RepeatWord("超最高,ぉ,お,う,ー,！")} ${x_woman}が${f_RepeatWord("好きだ,ぁ,あ,ー,！")}`);
       
        const x_woman2 = "私";
        const x_play2 = `${num_tyou}気持ち良くしてあげるわ！`;
        if (MessageNumber == "woman00") {
            $gameMessage.add(`お客様っ！ 私のプロフィールよっ！`);
        }
        if (MessageNumber == "woman0") {
            $gameVariables.setValue(99, 100 + 200 * $gameVariables.value(94) * Math.pow(2, $gameVariables.value(94)));
            $gameMessage.add(`${x_woman2}の値段は${$gameVariables.value(99)}${$dataSystem.currencyUnit}なの！　買ってよっ！`);
        }
        if (MessageNumber == "woman1") $gameMessage.add(`${x_play2}`);
        if (MessageNumber == "woman2") $gameMessage.add(`お金が足りないわ・・・。 ${f_RepeatWord("話にならないから帰,っ,て,ー,！")}`);
        if (MessageNumber == "woman3") $gameMessage.add(`全然、話にならないわ・・・。　この${f_Array("どスケベ, ケチ, カッコ悪い男ね,クズ,ハゲ,デブ")}！`);

        if (MessageNumber == "SexEnd0") $gameMessage.add(`他の${f_Array("男,ペニス,オチ○ポ")}より、${num_tyou}気持ち良かったわ！`);



        if (MessageNumber == "金塊") {
            var RndGold = Math.randomInt($gameVariables.value(99));
            $gameParty.gainGold(RndGold);
            $gameMessage.add(`${RndGold}${$dataSystem.currencyUnit}を手に入れた！`);
        }
        
        this.setWaitMode('message');
    });

//Game_Messageで独自関数を使えるプラグイン ******************************************************************************
    Game_Message.prototype.showMessage = function (it, Message) {
        SoundManager.playOk();
        $gameMessage.newPage()
        $gameMessage.add(Message)
        it.setWaitMode('message')
    };

    Game_Message.prototype.f_Array = function (num) {
        var obj = num.split(",");
        var i = Math.floor(Math.random() * obj.length);
        return obj[i];
    };

    Game_Message.prototype.f_kya = function (num) {
        var str0 = f_RepeatWord("キ,ャ,ア,～,！");
        var str1 = f_RepeatWord("も,う") + "、" + f_RepeatWord("ヤ,だ,ぁ,～,！");
        var str2 = f_RepeatWord("イ,ヤ,だ,ぁ,～,！");
        var str3 = f_RepeatWord("キ,ャ,ア,ッ,！");
        var str4 = f_Array("こんなの、,えっ？,えっ？　ちょっと") + f_RepeatWord("ダメ,ェ,エ,～,！");
        var arr = [str0, str1, str2, str3, str4];
        var max = Math.floor(Math.random() * arr.length);
        var str_end = arr[max];
        return str_end;
    };

    Game_Message.prototype.f_GainGold = function (it, Number) {
        SoundManager.playOk();
        rnd = Math.randomInt(Number);
        $gameParty.gainGold(rnd);
        $gameMessage.newPage()
        $gameMessage.add(rnd + "円を手に入れた！")
        it.setWaitMode('message')
    };

})();