//=============================================================================
// Actor Stepping Animation + Speed Control (MZ Only)
//=============================================================================

/*:
 * @target MZ
 * @plugindesc [MZ専用] <stepanim>で足踏みON＋速度を割り算方式で遅延（完全動作版）します。
 * @author ChatGPT
 *
 * @param Step Animation Divider
 * @type number
 * @min 1
 * @max 60
 * @default 3
 * @desc 足踏み速度の遅延倍率（2で半分、3で1/3の速度）
 *
 * @help
 * ■使い方
 * アクター・職業・ステートのメモ欄に <stepanim> を書くと、
 * そのキャラがマップ上で足踏みするようになります。
 *
 * さらに、プラグインパラメータでその足踏みの速度を遅くできます。
 *
 * ■対応
 * - プレイヤーとフォロワーのみ
 * - RPGツクールMZ専用
 */

(() => {
  const pluginName = document.currentScript.src.match(/([^\/]+)\.js$/)[1];
  const params = PluginManager.parameters(pluginName);
  const divider = Math.max(1, Number(params['Step Animation Divider'] || 3));

  // <stepanim> 判定
  function hasStepAnimMeta(actor) {
    return actor &&
      (actor.actor().meta.stepanim ||
        actor.currentClass().meta.stepanim ||
        actor.states().some(s => s && s.meta.stepanim));
  }

  // プレイヤー
  const _Game_Player_update = Game_Player.prototype.update;
  Game_Player.prototype.update = function(sceneActive) {
    _Game_Player_update.call(this, sceneActive);
    const actor = $gameParty.leader();
    this._stepAnimSlow = hasStepAnimMeta(actor);
    this.setStepAnime(this._stepAnimSlow);
  };

  // フォロワー
  const _Game_Follower_update = Game_Follower.prototype.update;
  Game_Follower.prototype.update = function() {
    _Game_Follower_update.call(this);
    const actor = this.actor();
    this._stepAnimSlow = hasStepAnimMeta(actor);
    this.setStepAnime(this._stepAnimSlow);
  };

  // Sprite_Character アニメーション速度制御（本物）
  const _Sprite_Character_updateAnimation = Sprite_Character.prototype.updateAnimation;
  Sprite_Character.prototype.updateAnimation = function() {
    const char = this._character;
    if (char && char._stepAnimSlow && char.isStopping() && char.isStepAnime()) {
      this._animationCount += 1 / divider; // 遅延
    } else {
      this._animationCount++;
    }

    const wait = this.animationWait();
    if (this._animationCount >= wait) {
      this.updatePattern();
      this._animationCount = 0;
    }
  };
})();
