/*:
 * @target MZ
 * @plugindesc メッセージウィンドウの透明度をゲーム中に変更できるプラグイン
 * @author ChatGPT
 *
 * @command SetOpacity
 * @text 透明度を変更
 * @desc メッセージウィンドウの透明度を設定します（0～255）
 *
 * @arg opacity
 * @type number
 * @min 0
 * @max 255
 * @default 255
 * @text 透明度（0～255）
 *
 * @help
 * このプラグインを使うと、ゲーム中にメッセージウィンドウの透明度を
 * 変更できます。
 *
 * ◆ プラグインコマンド
 * ・透明度を変更（0～255）
 *   0 にすると完全に透明、255 にすると完全に不透明です。
 *
 * ◆ スクリプトから使いたい場合：
 * $gameSystem._messageOpacity = 200;
 *
 * ◆ 注意
 * この設定は以降のメッセージウィンドウに反映されます。
 */

(() => {
  PluginManager.registerCommand("ChangeMessageOpacity", "SetOpacity", args => {
    const opacity = Number(args.opacity);
    $gameSystem._messageOpacity = opacity.clamp(0, 255);
  });

  const _Window_Message_updateBackground = Window_Message.prototype.updateBackground;
  Window_Message.prototype.updateBackground = function () {
    _Window_Message_updateBackground.call(this);
    this.opacity = $gameSystem._messageOpacity ?? 255;
  };

  const _Window_Message_initialize = Window_Message.prototype.initialize;
  Window_Message.prototype.initialize = function(rect) {
    _Window_Message_initialize.call(this, rect);
    this.opacity = $gameSystem._messageOpacity ?? 255;
  };
})();
