/*:
 * @target MZ
 * @plugindesc 数値入力中にEsc/Bキーでキャンセルすると「0」にして決定（MZ完全対応） 
 * @author ChatGPT
 *
 * @help
 * EscキーやBボタンを押すと入力を「0」として即決定します。
 * 数値入力イベントそのものは通常通り続行されます。
 */

(() => {
    let _forceZero = false;

    // キャンセルキーでフラグを立てる
    const _Window_NumberInput_update = Window_NumberInput.prototype.update;
    Window_NumberInput.prototype.update = function() {
        _Window_NumberInput_update.call(this);

        if (this.active && Input.isTriggered("cancel")) {
            SoundManager.playCancel();
            _forceZero = true;
            this.processOk();
        }
    };

    // 数値が決定される瞬間にフラグをチェックして上書き
    const _Game_Message_onInputNumber = Game_Message.prototype.onInputNumber;
    Game_Message.prototype.onInputNumber = function(inputNumber) {
        const variableId = this._numInputVariableId;
        if (variableId > 0) {
            const value = _forceZero ? 0 : inputNumber;
            $gameVariables.setValue(variableId, value);
        }
        _forceZero = false;
    };
})();
