/*:
 * @target MZ
 * @plugindesc ゲームオーバー画面で動画を再生（描画後に実行・MZ1.9.0対応）するプラグインです。
 * @author トリアコンタン MarkⅡ
 *
 * @param VideoName
 * @text 動画ファイル名
 * @desc 再生する動画のファイル名（拡張子不要、movieフォルダに配置）
 * @default GameOver
 *
 * @help
 * Scene_Gameover の描画が完了してから動画を再生します。
 * それにより、セキュリティ制限や描画未完了エラーを回避します。
 */

(() => {
    const parameters = PluginManager.parameters(document.currentScript.src.match(/[^/]+\.js$/)[0]);
    const videoName = String(parameters['VideoName'] || 'GameOver');

    Scene_Gameover.prototype.start = function () {
        Scene_Base.prototype.start.call(this);
        this._playedVideo = false;
    };

    Scene_Gameover.prototype.update = function () {
        Scene_Base.prototype.update.call(this);
        if (!this._playedVideo) {
            this._playedVideo = true;
            if (videoName) {
                Video.play(videoName);
                this._waitMode = 'video';
            }
        }

        if (!Video.isPlaying() && this._waitMode === 'video') {
            SceneManager.goto(Scene_Title);
        }
    };

    Scene_Gameover.prototype.terminate = function () {
        Scene_Base.prototype.terminate.call(this);
        Video.stop();
    };
})();
