/*:
 * @target MZ
 * @plugindesc ゲームオーバー画面で動画を再生するプラグイン
 * @author トリアコンタン MarkⅡ
 *
 * @param VideoName
 * @text 動画ファイル名
 * @desc 再生する動画のファイル名（拡張子不要、movieフォルダに配置）
 * @default GameOver
 *
 * @param WaitForVideoEnd
 * @text 動画終了まで待つ
 * @type boolean
 * @desc 動画が終わるまで画面遷移しないようにするかどうか
 * @default true
 *
 * @help
 * ゲームオーバー時に指定した動画を再生します。
 *
 * ▼使い方
 * ・動画ファイルを「movie」フォルダに配置してください。
 * ・プラグインパラメータでそのファイル名を指定します（拡張子不要）。
 *
 * ▼注意点
 * 動画終了後、自動的にタイトル画面に戻ります。
 */

(() => {
    const parameters = PluginManager.parameters(document.currentScript.src.match(/[^/]+\.js$/)[0]);
    const videoName = String(parameters['VideoName'] || 'GameOver');
    const waitForVideoEnd = parameters['WaitForVideoEnd'] === 'true';

    const _Scene_Gameover_start = Scene_Gameover.prototype.start;
    Scene_Gameover.prototype.start = function () {
        _Scene_Gameover_start.call(this);
        if (videoName) {
            Video.play(videoName);
            if (waitForVideoEnd) {
                this._videoPlaying = true;
                this._videoEndHandler = () => {
                    this._videoPlaying = false;
                    SceneManager.goto(Scene_Title);
                };
                Video._element.addEventListener('ended', this._videoEndHandler);
            } else {
                this._videoTimer = 180; // 3秒後にタイトルへ（任意）
            }
        }
    };

    const _Scene_Gameover_update = Scene_Gameover.prototype.update;
    Scene_Gameover.prototype.update = function () {
        _Scene_Gameover_update.call(this);
        if (this._videoTimer !== undefined) {
            this._videoTimer--;
            if (this._videoTimer <= 0) {
                SceneManager.goto(Scene_Title);
            }
        }
    };

    const _Scene_Gameover_terminate = Scene_Gameover.prototype.terminate;
    Scene_Gameover.prototype.terminate = function () {
        _Scene_Gameover_terminate.call(this);
        if (this._videoEndHandler) {
            Video._element.removeEventListener('ended', this._videoEndHandler);
            this._videoEndHandler = null;
        }
        Video.stop();
    };
})();
