/*:
 * @target MZ
 * @plugindesc 動画をシーン遷移でシームレスに再生し、終了後にタイトル画面へ戻るプラグインです。
 * @author トリアコンタン MarkⅡ
 *
 * @command PlayGameOverVideo
 * @text ゲームオーバー動画を再生
 * @desc 動画を再生し、終了後にタイトル画面へ戻ります。
 *
 * @param VideoName
 * @text 動画ファイル名
 * @desc movieフォルダに配置された動画ファイル名（拡張子なし）
 * @default GameOver
 */

(() => {
    const pluginName = "GameOverVideoScene";
    const parameters = PluginManager.parameters(pluginName);
    const videoName = String(parameters["VideoName"] || "GameOver");

    PluginManager.registerCommand(pluginName, "PlayGameOverVideo", function () {
        SceneManager.push(Scene_GameOverVideo);
    });

    class Scene_GameOverVideo extends Scene_Base {
        create() {
            super.create();
            this._videoStarted = false;
            this._waitMode = null;
        }

        start() {
            super.start();
            this._fadeDuration = 0;
        }

        update() {
            super.update();
            if (!this._videoStarted) {
                this._videoStarted = true;
                Video.play(videoName);
                this._waitMode = "video";
                this._fadeDuration = 0;
            }

            if (!Video.isPlaying() && this._waitMode === "video") {
                SceneManager.goto(Scene_Title);
            }
        }

        stop() {
            super.stop();
            Video.stop();
        }
    }
})();
