/*:ja
 * @target MV MZ
 * @plugindesc 選択肢の機能を拡張します。
 * @author 木星ペンギン
 * @url 
 *
 * @help [version 4.2.0]
 * このプラグインはRPGツクールMVおよびMZ用です。
 * 
 * ▼ プラグインコマンド
 *  - MVでは数値を入力する項目で v[N] と記述することで変数N番を参照します。
 *  - MZでは数値を入力する項目で、テキストを選択して v[N] と記述することで
 *    変数N番を参照します。
 *  - プラグインコマンドは基本的に[選択肢の表示]の前に実行するのが好ましいです。
 *  - メッセージウィンドウを表示したままプラグインコマンドを使いたい場合、
 *    [文章の表示]の前に実行してください。
 *  
 *  〇 MV / MZ
 *  
 *  〇 ChoicePos x y row  / 選択肢位置設定
 *       x   : 選択肢ウィンドウのX座標
 *       y   : 選択肢ウィンドウのY座標
 *       row : 選択肢ウィンドウの行数。未設定の場合はすべて表示
 *   - 次に表示する選択肢の位置(x,y)と行数(row)指定します。
 * 
 *  〇 ChoiceVariableId varId  / カーソル位置設定
 *       varId : 変数番号
 *   - 次に表示する選択肢のデフォルト位置を変数の値にします。
 *   - さらに現在のカーソル位置を変数に入れます。
 *   - カーソル位置は最初の選択肢が上から0～5、次の選択肢は10～15と、
 *     選択肢毎に+10されます。
 * 
 *  〇 ChoiceRect x y width height  / 選択肢サイズ設定
 *       x      : X座標
 *       y      : Y座標
 *       width  : 幅
 *       height : 高さ
 *   - 次に表示する選択肢の座標とサイズを指定します。
 *   - 未設定もしくは-1を指定した項目は、通常の値が適用されます。
 *   
 *  〇 ChoiceInMessage  / メッセージ内表示
 *   - 次に表示する選択肢をメッセージウィンドウ内に表示させます。
 *   - この機能は[文章の表示]と併用しなければ機能しません。
 *   - [文章の表示]の前に実行してください。
 *   
 * ▼ 選択肢を増やす
 *  - イベントコマンド『選択肢の表示』を続けて配置すると
 *    一つの選択肢にまとめられます。
 *  - まとめたくない場合は、間に注釈などを入れることで
 *    通常通り分けることができます。
 *  - 『デフォルト』の処理は、なし以外を設定したものが適用されます。
 *  - 『キャンセル』の処理は、禁止以外を設定したものが適用されます。
 *  - どちらも後にある選択肢の設定が優先されます。
 *  - 『背景』と『ウィンドウ位置』は後にある選択肢の設定が適用されます。
 * 
 * ▼ 項目が表示される条件の設定
 *  - 選択肢の文章中に
 *      if(条件)
 *    と入れ、その条件が偽になると項目が表示されなくなります。
 *  - 『デフォルト』の項目が表示されない場合の動作は、
 *    プラグインパラメータの[Disabled Index]にて設定できます。
 *  - 『キャンセル』の項目が表示されない場合、禁止と同じ処理をします。
 *  - 条件内では s でスイッチ、v で変数を参照できます。
 *     例：if(s[1]) とした場合
 *          => スイッチ１番がONで表示、OFFで非表示。
 *        if(!s[2]) とした場合
 *          => スイッチ２番がOFFで表示、ONで非表示。
 *        if(v[5]>0) とした場合
 *          => 変数５番が0より大きければ表示、0以下で非表示。
 *     
 *     変数で使える不等号
 *       === : 等しい
 *       !== : 等しくない
 *       <   : より小さい
 *       <=  : より小さいまたは等しい
 *       >   : より大きい
 *       >=  : より大きいまたは等しい
 * 
 * ▼ 項目を半透明で表示する条件の設定
 *  - 選択肢の文章中に
 *      en(条件)
 *    と入れ、その条件が偽になると項目が半透明で表示されます。
 *  - 半透明となった項目は選択できなくなります。
 *  - 条件は上の『項目が表示される条件の設定』と同じです。
 *  - 『キャンセル』の項目が半透明の場合、キャンセルできなくなります。
 * 
 * ▼ ヘルプメッセージの表示
 *  - 各選択肢項目の下に注釈で
 *      選択肢ヘルプ
 *    と入れると、続きの文章をヘルプメッセージとしてカーソルを合わせたときに
 *    標示させることができます。
 *  - ヘルプメッセージは[文章の表示]と同じ機能を使っているため、
 *    制御文字が使用できます。(!と^は使用できません)
 * 
 * ================================
 * Mail : wood_penguin＠yahoo.co.jp (＠は半角)
 * Blog : http://woodpenguin.blog.fc2.com/
 * License : MIT license
 *
 *  @command choicePos
 *      @text 選択肢位置設定
 *      @desc 次に表示する選択肢の位置と行数を指定します。
 *      @arg x
 *          @desc 
 *          @type number
 *              @min 0
 *              @max 999999
 *          @default 0
 *      @arg y
 *          @desc 
 *          @type number
 *              @min 0
 *              @max 999999
 *          @default 0
 *       @arg row
 *          @text 行数
 *          @desc 0 : 全て表示
 *          @type number
 *              @min 0
 *              @max 999
 *          @default 0
 *
 *  @command choiceVariableId
 *      @text カーソル位置設定
 *      @desc 次に表示する選択肢のデフォルト位置を変数の値にします。
 *      さらに現在のカーソル位置を変数に入れます。
 *      @arg varId
 *          @text 変数
 *          @desc 
 *          @type variable
 *          @default 0
 *
 *  @command choiceRect
 *      @text 選択肢サイズ設定
 *      @desc 次に表示する選択肢の座標とサイズを指定します。
 *      未設定の項目は通常の値が適用されます。
 *      @arg x
 *          @desc 
 *          @type number
 *              @min 0
 *              @max 999999
 *          @default 
 *      @arg y
 *          @desc 
 *          @type number
 *              @min 0
 *              @max 999999
 *          @default 
 *      @arg width
 *          @text 幅
 *          @desc 
 *          @type number
 *              @min 1
 *              @max 999999
 *          @default 
 *      @arg height
 *          @text 高さ
 *          @desc 
 *          @type number
 *              @min 1
 *              @max 999999
 *          @default 
 *
 *  @command choiceInMessage
 *      @text メッセージ内表示
 *      @desc 次に表示する選択肢をメッセージウィンドウ内に表示させます。
 *      [文章の表示]と併用しなければ機能しません。
 * 
 * 
 *  @param Max Page Row
 *      @text 最大表示行数
 *      @desc 1ページに表示される最大行数
 *      @type number
 *          @min 1
 *          @min 999
 *      @default 6
 *
 *  @param Disabled Position
 *      @text 無効時のカーソル位置
 *      @desc [デフォルト]となる選択肢が表示されない場合のカーソル位置
 *      @type select
 *          @option なし
 *          @value none
 *          @option 先頭
 *          @value top
 *      @default none
 * 
 */