/*:
 * @plugindesc ノベルゲーム向けの機能を提供します
 * @author しぐれん
 * 
 * @target MZ
 * @orderAfter MOG_TitleSplashScreen
 * 
 * @url https://siguren400.booth.pm/items/3300534
 * 
 * 
 * @command Show
 * @text バックログを開く
 * 
 * @command ClearAll
 * @text 全てのログをクリアする
 * @desc 保存されているログを全て消します。
 * 
 * 
 * @command GetLogSize
 * @text 現在のログの大きさを取得
 * @arg variableId
 * @text 結果を書き込む変数
 * @type variable
 * @default 0
 * 
 * @command SetAutoMode
 * @text オートモードの設定
 * @desc イベントコマンドからオート設定のON/OFFを切り替えます。
 * @arg automode
 * @type boolean
 * @default true
 * 
 * @command GetAutoMode
 * @text オートモードの状態取得
 * @desc 現在のオート設定の状態を取得します。
 * @arg swtichId
 * @type switch
 * @default 0
 * 
 * @command HasLastVoice
 * @text 最後に再生した音声の有無を取得
 * @desc 音声再生ボタンが有効かどうかを取得します。
 * @arg switchId
 * @default 0
 * 
 * 
 * @command GetAutoWaitTime
 * @text GetAutoWaitTime/オート待ち時間取得
 * @arg variableId
 * @text 結果を書き込む変数
 * @type variable
 * @default 0
 * 
 * @command SetAutoWaitTime
 * @text SetAutoWaitTime/オート待ち時間設定
 * @arg variableId
 * @type variable
 * @default 0
 * 
 * @command SetLogLimitSizeBasic
 * @text ログの保存容量を設定
 * @arg variableId
 * @type variable
 * @default 0
 * 
 * @command GetLogLimitSizeBasic
 * @text ログの保存容量を取得
 * @arg variableId
 * @text 結果を書き込む変数
 * @type variable
 * @default 0
 * 
 * @command SetLogLimitSizeExtends
 * @text ログの予備容量を設定
 * @arg variableId
 * @type variable
 * @default 0
 * 
 * @command GetLogLimitSizeExtends
 * @text ログの予備容量を取得
 * @desc 取得するのはオプションの状態です。
 * @arg variableId
 * @text 結果を書き込む変数
 * @type variable
 * @default 0
 * 
 * @command GetKeepingAutoMode
 * @text オート保持の設定を取得
 * @type switch
 * @default 0
 * 
 * @command GetMachinakaLines
 * @text 街中モードの同時表示数を取得
 * @arg variableId
 * @text 結果を書き込む変数
 * @type variable
 * @default 0
 * 
 * @command SetMachinakaLines
 * @text 街中モードの同時表示数を設定
 * @arg variableId
 * @type variable
 * @default 0
 * 
 * 
 * @command ShowConsloeProxy
 * @text ログ表示用のデータをコンソールに表示
 * 
 * @param menuCommand
 * @text メニューコマンド
 * @type struct<MultiLangString>
 * @desc メニューにログを開くコマンドを追加します。
 * コマンド名が空欄の場合、追加しません。
 * @default {"ja_JP":"","en_US":"","zh_CN":"","ko_KR":"","de_DE":"","fr_FR":"","ru_RU":""}
 * 
 * @param voice
 * @text ボイス設定
 * @desc 「文章の表示」と「SEの再生」を関連付けます。
 * 合致したファイルを音声として、メッセージログに記録します。
 * @type struct<Voice>
 * @default {"regex":"voice","files":"[]"}
 * 
 * @param buttonSetting
 * @text ボタンの全般設定
 * @type struct<ButtonSetting>
 * @default {"offsetX":"0","offsetY":"0","windowOverlap":"outside","windowStretchY":"0"}
 * 
 * @param backlogButton
 * @text ログ表示ボタン
 * @type struct<Button>
 * @default {"x":"0","y":"0","image":"MessageButton","enabledSwitch":"0","pressedSound":"{\"name\":\"Book1\",\"volume\":\"90\",\"pitch\":\"100\",\"pan\":\"0\"}","hot":"{\"x\":\"0\",\"y\":\"256\",\"width\":\"64\",\"height\":\"64\"}","cold":"{\"x\":\"64\",\"y\":\"256\",\"width\":\"64\",\"height\":\"64\"}"}
 * @parent buttonSetting
 * 
 * @param saveButton
 * @text セーブボタン
 * @type struct<Button>
 * @default {"x":"64","y":"0","image":"MessageButton","enabledSwitch":"0","pressedSound":"{\"name\":\"Book2\",\"volume\":\"90\",\"pitch\":\"100\",\"pan\":\"0\"}","hot":"{\"x\":\"0\",\"y\":\"128\",\"width\":\"64\",\"height\":\"64\"}","cold":"{\"x\":\"64\",\"y\":\"128\",\"width\":\"64\",\"height\":\"64\"}"}
 * @parent buttonSetting
 * 
 * @param loadButton
 * @text ロードボタン
 * @type struct<Button>
 * @default {"x":"128","y":"0","image":"MessageButton","enabledSwitch":"0","pressedSound":"{\"name\":\"Book2\",\"volume\":\"90\",\"pitch\":\"100\",\"pan\":\"0\"}","hot":"{\"x\":\"0\",\"y\":\"192\",\"width\":\"64\",\"height\":\"64\"}","cold":"{\"x\":\"64\",\"y\":\"192\",\"width\":\"64\",\"height\":\"64\"}"}
 * @parent buttonSetting
 * 
 * @param autoButton
 * @text オートボタン
 * @desc オート状態の場合、
 * 解除されるまでボタンが押されている状態の表示になります。
 * @type struct<Button>
 * @default {"x":"196","y":"0","image":"MessageButton","enabledSwitch":"0","pressedSound":"{\"name\":\"Key\",\"volume\":\"90\",\"pitch\":\"100\",\"pan\":\"0\"}","hot":"{\"x\":\"0\",\"y\":\"0\",\"width\":\"64\",\"height\":\"64\"}","cold":"{\"x\":\"64\",\"y\":\"0\",\"width\":\"64\",\"height\":\"64\"}"}
 * @parent buttonSetting
 * 
 * @param autoGauge
 * @text オートゲージ
 * @type struct<AutoGauge>
 * @default {"width":"10","texture":"","color":"FF0000"}
 * @parent autoButton
 * 
 * @param voiceRepeatButton
 * @text ボイスリピートボタン
 * @desc 押した場合、最後のボイスをもう一度再生します。
 * @type struct<Button>
 * @default {"x":"256","y":"0","image":"MessageButton","enabledSwitch":"0","pressedSound":"","hot":"{\"x\":\"0\",\"y\":\"320\",\"width\":\"64\",\"height\":\"64\"}","cold":"{\"x\":\"64\",\"y\":\"320\",\"width\":\"64\",\"height\":\"64\"}"}
 * @parent buttonSetting
 * 
 * @param logWriteSwitch
 * @text ログ書き込み有効化スイッチ
 * @desc 指定したスイッチがONの場合のみ、ログを書き込みます。
 * 未指定の場合、常に書き込みます。
 * @type switch
 * @default 0
 * 
 * @param logWriteOnBattle
 * @text 戦闘中のログ書き込み
 * @desc OFFにすると、戦闘中はログの書き込みを行いません。
 * @type boolean
 * @default false
 * 
 * @param logStyle
 * @type struct<LogStyle>
 * @text ログ画面スタイル
 * @desc ログ画面の配置などを設定します。
 * @default {"windowFileName":"Window","background":"","speakerName":"【%1】","choiceFormat":"【%1】：%2","choiceText":"{\"ja_JP\":\"選択肢\",\"en_US\":\"choices\",\"zh_CN\":\"选择\",\"ko_KR\":\"선택\",\"de_DE\":\"Auswahl\",\"fr_FR\":\"Les choix\",\"ru_RU\":\"Выбор\"}","voiceIconIndex":"4"}
 * 
 * @param logSize
 * @text ログの保存個数
 * @desc ログの数が増えてきた際に、この数以下になるように古いログを削除します。
 * @type number
 * @default 30
 * 
 * 
 * @param machinakaModeSwitch
 * @text 街中モード制御スイッチ
 * @desc 指定スイッチがONの間のみ機能を有効化します。
 * @type switch
 * @default 0
 * 
 * @param macinakaModeDefault
 * @text 街中モード初期値
 * @type boolean
 * @default true
 * @parent macinakaMode
 * 
 * @param machinakaModeLines
 * @text 街中モード・表示行数
 * @type number
 * @default 3
 * 
 * @param choiceFormat
 * @text 選択肢の表示形式
 * @type string
 * @desc %1に「選択肢」、%2に項目の文字列が表示されます。
 * @default 【%1】：%2
 * @parent logStyle
 * 
 * @param choiceText
 * @text 選択肢
 * @type struct<MultiLangString>
 * @default {"ja_JP":"選択肢","en_US":"choices","zh_CN":"选择","ko_KR":"선택","de_DE":"Auswahl","fr_FR":"Les choix","ru_RU":"Выбор"}
 * @desc 選択肢の表示名。多言語対応済み。
 * @parent logStyle
 * 
 * @param choiceCancelText
 * @text 選択肢キャンセル時の文章
 * @type struct<MultiLangString>
 * @default {"ja_JP":"キャンセル","en_US":"Cancel","zh_CN":"","ko_KR":"","de_DE":"","fr_FR":"","ru_RU":""}
 * @parent logStyle
 * 
 * @help
 * 以下の機能を提供します
 * ■メッセージログの保存・表示
 * ■メッセージの途中セーブ・ロード実行
 * ■ボイス記録機能
 * 
 * 「文章の表示」によって表示された文章をログとして記録します。
 * 
 * ■ボタンの割り当てについて
 * メッセージの表示中、
 * 以下のシンボルの入力が行われた場合にシーン切り替えを実行します。
 * 内部判定はlongPressedを使用しているので、長押しが必要です。
 * ・セーブ:pageup
 * ・ロード:pagedown
 * ・ログ　:shift
 * 
 * ■ボタン配置について
 * ボタン配置は相対位置で決められています。
 * ボタン領域の四角形は、全てのボタンを収めることができる四角形となります。
 * この四角形の右側がウィンドウの右側と合わさるような位置を基準とします。
 * offsetX,offsetYは、この位置を基準に動かします。
 * 
 * ■途中セーブ機能について
 * メッセージ表示中にセーブ画面を開き、セーブを行えます。
 * トリガーが並列実行のイベントを実行中にセーブを行うと、
 * 不具合が発生することがあります。
 * 
 * ■途中セーブをロードした場合の挙動
 * メッセージを正しく復元するために、イベントの実行状態を巻き戻します。
 * メッセージの文章によって変数などを操作するプラグインと併用すると、
 * 不具合が発生する可能性があります。
 * 
 * ■ログデータが消えている場合
 * プラグインのバージョンが異なる場合、ログデータを初期化します。
 * この場合でもログ以外のセーブデータは読み込み可能です。
 * 
 * ■ボイス記録機能
 * 文章の表示前に「SEの再生」が実行されていると、それをボイスとして記録します。
 * 
 * 効果音が巻き込まれないように、判別方法が用意されています。
 * 効果音はaudio/se/の内部に配置されますが、
 * その中のサブフォルダで登録するかを判定します。
 * ※サブフォルダはツクールMZ ver1.3.1以降の機能です。
 * 対応するのは以下のファイルです。
 * ※以下の設定はパラメータ「ボイスファイル正規表現」が
 * 「voice」の場合の設定方法です。
 * ・フォルダ「audio/se/」内のサブフォルダ「voice」に含まれるファイル
 * ・ファイル名の先頭に「voice」と付くファイル
 * ・専用に登録したファイル(プラグインパラメータ:ボイスファイルリスト参照)
 * 
 * ■メッセージ自動送り
 * 文章の表示が完了した後、一定時間の経過で自動的に次のメッセージを表示します。
 * ボイスがある場合、ボイスの再生完了まで待ちます。
 * 手動でメッセージ送りした場合、ボイスを停止します。
 * 
 * メッセージ自動送りの速度を変更する場合、付属のオプションプラグインを入れてください。
 * 
 * ■ログ画面の開き方
 * ログ画面はメッセージ表示中に以下の操作を押すと開きます。
 * ・shiftキーを押し続ける
 * ・マウスホイール上
 * ・画面内のボタンを押す
 * これ以外にも、プラグインコマンドで呼び出す方法があります。
 * マップ上で自由に呼び出せるようにしたい場合、
 * コモンイベントを利用してプラグインコマンドを呼び出してください。
 * 
 * ■街中モード
 * マップ内を移動して複数のイベントに話しかけた場合を想定した機能です。
 * 同じイベントのイベントのメッセージを記録する場合、
 * 最新の1回分で上書きします。
 * 
 * 街中モードによる表示はスイッチ制御で一時的に無効化できます。
 * 無効化中はログ画面を開いても街中モードの選択ウィンドウが非表示になります。
 * 
 * ■既知の不具合
 * 
 * ・ゲームデータが更新されていても、読み込んだセーブデータに反映されない
 * ツクールの仕様に起因する問題。
 * 対処方法はありますが、とても複雑なので先送りです。
 * 
 * 
 * ■利用規約
 * 1.利用可能なプロジェクト
 * ・ゲームの内容(配布および販売方法・年齢制限の有無など)を問わず、どのようなゲームにでもご利用いただけます。
 * 
 * 2.利用条件
 * ・ゲームの配布(販売を含む)の際に、同梱のテキストなどに本プラグインを利用したことを記載してください。
 * ・複数人のチームによるゲーム作成の場合、参加者の内１名以上が本プラグインを購入している必要があります。
 * ・本プラグインを利用するに際し、利用者は自己の責任に基づいて使用するものとします。
 * ・本プラグインを改変しての利用は可能ですが、その場合は(5)で示すサポートの範囲外とします。
 * 
 * 3.禁止事項
 * ・改変の有無に関わらず本プラグインをゲームの配布(販売を含む)以外の方法で、公開・配布・販売する行為。
 * ・配布(販売含む)されたゲームの中から本プラグイン抜き出して使用する行為。
 * ・このプラグインに記載された利用規約を削除・改変する行為。
 * 
 * 4.免責事項
 * 当方は以下の内容についてその責任を負わないものとします。
 * ・本プラグインの更新によるセーブデータの互換性消失
 * ・セーブデータの破損
 * ・ゲームデータの破損
 * ・他のプラグインとの併用による誤作動・不具合
 * ・その他プラグインの使用によって生じた損害
 * 
 * 5.不具合対応(サポート)
 * ・本プラグインの不具合について可能な限り対応しますが、修正を行うことを保証するものではありません。
 * 
 * 9.利用規約の変更について
 * ・この利用規約は予告なく変更されることがあります。
 * 
*/

 /*~struct~PlaySE:
 * @param name
 * @type file
 * @dir audio/se/
 * 
 * @param volume
 * @text 音量
 * @desc ボイスファイルの音量
 * @default 90
 * @min 0
 * @max 100
 * @type number
 *
 * @param pitch
 * @text ピッチ
 * @desc ボイスファイルのピッチ
 * @default 100
 * @type number
 *
 * @param pan
 * @text 左右バランス
 * @desc ボイスファイルの左右バランス
 * @default 0
 * @min -100
 * @max 100
 * @type number
  */
/*~struct~Button:
 * 
 * @param x
 * @text X座標(相対位置)
 * @desc 基準位置はボタングループで設定。
 * 状況により基準位置は移動します。
 * @type number
 * @default 0
 * 
 * @param y
 * @text Y座標(相対位置)
 * @desc 基準位置はボタングループで設定。
 * 状況により基準位置は移動します。
 * @type number
 * @default 0
 * 
 * @param image
 * @text ボタン画像
 * @desc 空欄にするとボタンと対応した機能が無効になります。
 * @type file
 * @dir img/system/
 * 
 * @param hot
 * @text 押されている時の画像
 * @type struct<Rect>
 * @desc ボタンがクリックされている間に表示する画像。
 * ボタン画像の一部から、指定範囲を切り出して使います。
 * @default {"x":"0","y":"0","width":"64","height":"64"}
 * 
 * @param cold
 * @text 通常時の画像
 * @type struct<Rect>
 * @desc ボタンがクリックされていない間に表示する画像。
 * ボタン画像の一部から、指定範囲を切り出して使います。
 * @default {"x":"0","y":"0","width":"64","height":"64"}
 * 
 * @param enabledSwitch
 * @text 有効化スイッチ
 * @desc 指定したスイッチがONの場合のみボタンを表示します。
 * ニューゲーム時にONになります。未指定の場合、常に有効化。
 * @type switch
 * @default 0
 * 
 * @param pressedSound
 * @text 押された時の音声
 * @type struct<PlaySE>
 * 
 */
/*~struct~AutoGauge:
 * 
 * @param width
 * @type number
 * @default 10
 * 
 * @param texture
 * @type file
 * @dir img/system/
 * 
 * @param color
 * @type string
 * @default FF0000
*/
/*~struct~Rect:
 * @param x
 * @type number
 * @min -123456
 * 
 * @param y
 * @type number
 * @min -123456
 * 
 * @param width
 * @type number
 * 
 * @param height
 * @type number
*/
/*~struct~ButtonSetting:
 * @param offsetX
 * @desc ボタンを横方向に移動します。
 * @type number
 * @min -123456
 * @default 0
 * 
 * @param offsetY
 * @desc ボタンを縦方向に移動します。
 * @type number
 * @min -123456
 * @default 0
 * 
 * @param windowOverlap
 * @text ウィンドウとの重なり
 * @type select
 * @option 内側(ウィンドウが少し大きくなります)
 * @value inside
 * @option 外側(必要に応じて選択肢が移動します)
 * @value outside
 * @option 絶対指定(ほぼ左上原点・メッセージが下側の場合のみ表示)
 * @value absolute
 * @default outside
 * 
 * @param windowStretchY
 * @text ウィンドウの伸縮(Y)
 * @desc ボタン設置用のスペースを確保するときに使います。
 * @type number
 * @min -123456
 * @default 0
 * 
 * @param disableSwitch
 * @text 強制ボタン非表示
 * @desc 指定したスイッチがONの間、全てのボタンを無効化します。
 * @type switch
 * @default 0
 * */
/*~struct~LogStyle:
 * 
 * 
 * @param windowRect
 * @text ウィンドウ配置
 * @type struct<Rect>
 * 
 *
 * @param windowFileName
 * @type file
 * @text ウィンドウ画像
 * @dir img/system
 * @default Window
 * 
 * @param background
 * @text 背景画像
 * @type file
 * @dir img/system
 * @desc ログシーンの背景に使う画像を設定します。
 * 
 * @param freamColor
 * @text 枠線の色(空欄の場合非表示)
 * @desc 文章の間に入れる区切り線の色を指定します。#00FFFF表記
 * @type string
 * @default #00FFFF
 * 
 * @param speakerName
 * @text 名前表示フォーマット
 * @desc 名前を変換して表示します(%1→名前,%2→ボイスアイコン)
 * @type string
 * @default 【%1】%2
 * 
 * 
 * @param voiceIconIndex
 * @text アイコン番号
 * @desc ログ表示の際に、ボイスがあるログにアイコンを表示します。
 * @type number
 * @default 4
 * 
 * 
 * @param lineSpacing
 * @text 行間スペース
 * @type number
 * @default 2
 * 
*/
//通常効果音をボイス扱いするための機能
/*~struct~Voice:
 * @param regex
 * @text ボイスファイル正規表現
 * @desc  正規表現で合致したファイル名を音声として扱います。
 * 内部的には「"^"+"この文字列"+".+"」で処理しています。
 * @type string
 * @default voice
 * 
 * @param files
 * @text ボイスファイルリスト
 * @type file[]
 * @dir audio/se/
 * @desc 指定したファイルをボイスファイルとして扱います。
 * 正規表現で対応できないファイルを対応させる場合に使います。
 * @default []
 * 
 * 
*/
/*~struct~Auto:
 * @param autoSpeed
 * @type sturct<AutoSpeed>[]
 * @desc メッセージ送りの速度です。
 * ここで設定したリストの中から選びます。
 * 
 * @param optionName
 * @desc コンフィグ画面での表示名です。
 * @type struct<MultiLangString>
 * 
 * @param button
 * @type struct<Button>
 * 
 * 
 * 
*/
/*~struct~AutoSpeed:
 * @param text
 * @text 表示する文字
 * @desc 設定画面に表示するテキスト 
 * @type struct<MultiLangString>
 * 
 * @param speed
 * @text オート速度
 * @desc テキストがすべて描画された後、
 * メッセージ送りをするまでの時間(フレーム数)
 * @type number
 * @default 600
*/
 /*~struct~MultiLangString:
  * @param ja_JP
    @text 日本語

    @param en_US
    @text English

    @param zh_CN
    @text 中文(簡体)
    @desc 我不知道繁體中文，所以目​​前不支持。
    繁体については私が知らないので非対応です。

    @param ko_KR
    @text 한국

    @param de_DE
    @text Deutsche(ドイツ語)

    @param fr_FR
    @text français(フランス語)

    @param ru_RU
    @text русский(ロシア語)
 */

const _0x25a81d=_0x4588;(function(_0x1dd34b,_0x21da3c){const _0x1c751e=_0x4588,_0x4d4848=_0x1dd34b();while(!![]){try{const _0x5a9bd2=-parseInt(_0x1c751e(0x2db))/0x1+-parseInt(_0x1c751e(0x307))/0x2*(-parseInt(_0x1c751e(0x369))/0x3)+parseInt(_0x1c751e(0x2bc))/0x4+-parseInt(_0x1c751e(0x33b))/0x5+parseInt(_0x1c751e(0x229))/0x6*(-parseInt(_0x1c751e(0x2b6))/0x7)+parseInt(_0x1c751e(0x2d7))/0x8*(parseInt(_0x1c751e(0x22e))/0x9)+parseInt(_0x1c751e(0x3f0))/0xa*(-parseInt(_0x1c751e(0x2b7))/0xb);if(_0x5a9bd2===_0x21da3c)break;else _0x4d4848['push'](_0x4d4848['shift']());}catch(_0x2dfcb6){_0x4d4848['push'](_0x4d4848['shift']());}}}(_0x48cb,0xe0db2));class LogManager_Export{constructor(_0x32a6d3){const _0x1ef186=_0x4588;this[_0x1ef186(0x2c9)]=_0x32a6d3,this[_0x1ef186(0x363)](null);}['getStyle'](){return this['_logManager']['getLogItemStyle']();}['setPlayVoiceFunction'](_0x5097ee){const _0x5b5a36=_0x4588;this[_0x5b5a36(0x326)]=_0x5097ee;}[_0x25a81d(0x3eb)](_0x279a00,_0x17d818){const _0x89a95=_0x25a81d;this[_0x89a95(0x326)]&&!!_0x17d818?this[_0x89a95(0x326)](_0x279a00,_0x17d818):AudioManager[_0x89a95(0x41b)](_0x279a00);}[_0x25a81d(0x3a8)](){const _0x38f147=_0x25a81d;return this['_logManager'][_0x38f147(0x379)]()[_0x38f147(0x3d6)];}[_0x25a81d(0x2e4)](_0x2af744){const _0x484829=_0x25a81d;return this['_logManager'][_0x484829(0x2e4)](_0x2af744);}[_0x25a81d(0x26c)](_0x19cdc4,_0x409a6d){const _0x4e0e03=_0x25a81d;this[_0x4e0e03(0x2c9)][_0x4e0e03(0x26c)](_0x19cdc4,_0x409a6d);}[_0x25a81d(0x29c)](_0x351c19){const _0x24ccd7=_0x25a81d;this[_0x24ccd7(0x2c9)]['setOptionValue'](_0x351c19);}['cloneOptionValue'](){const _0x3d6df0=_0x25a81d;return this[_0x3d6df0(0x2c9)]['cloneOptionValue']();}}function _0x4588(_0x29e842,_0x15ecd2){const _0x48cb2e=_0x48cb();return _0x4588=function(_0x4588da,_0x1d7f4e){_0x4588da=_0x4588da-0x1e6;let _0x4b8458=_0x48cb2e[_0x4588da];return _0x4b8458;},_0x4588(_0x29e842,_0x15ecd2);}class I_EventUniqueId{[_0x25a81d(0x32c)](){return null;}}class UZLOG_EventUniqueID extends I_EventUniqueId{constructor(_0x4905fd,_0x51619d,_0x26934f){const _0x5e9c79=_0x25a81d;super(),this['_mapId']=_0x4905fd,this[_0x5e9c79(0x37d)]=_0x51619d,this[_0x5e9c79(0x2aa)]=_0x26934f;}[_0x25a81d(0x32c)](){const _0x1a5740=_0x25a81d;return'M'+this[_0x1a5740(0x434)]+'E'+this[_0x1a5740(0x37d)]+'P'+this[_0x1a5740(0x2aa)];}}class I_Multiline_Porxy{[_0x25a81d(0x2b0)](){return'';}[_0x25a81d(0x3dd)](){return 0x1;}[_0x25a81d(0x2f8)](){return null;}[_0x25a81d(0x3ee)](){const _0x3a0315=_0x25a81d;return!!this[_0x3a0315(0x2f8)]();}[_0x25a81d(0x3c9)](){return!![];}['faceName'](){return null;}[_0x25a81d(0x412)](){return 0x0;}[_0x25a81d(0x1fb)](){return!![];}[_0x25a81d(0x306)](){return![];}['lineIndex'](){return 0x0;}}class Multiline_PorxyBase extends I_Multiline_Porxy{constructor(_0x54f2b2){const _0x30a54d=_0x25a81d;super(),this[_0x30a54d(0x28d)]=_0x54f2b2;}['isTopItem'](){return![];}['item'](){return null;}[_0x25a81d(0x1fa)](){return![];}['numItemLines'](){const _0x49a5ef=_0x25a81d;return this[_0x49a5ef(0x28d)][_0x49a5ef(0x31b)]();}['voiceParam'](){const _0x2ee1fa=_0x25a81d;return this[_0x2ee1fa(0x28d)][_0x2ee1fa(0x2f8)]();}[_0x25a81d(0x3ee)](){const _0x2bc8ab=_0x25a81d;return this[_0x2bc8ab(0x1fb)]()&&this[_0x2bc8ab(0x28d)][_0x2bc8ab(0x40a)]();}[_0x25a81d(0x2b5)](){return![];}['faceName'](){const _0x3ab26c=_0x25a81d;return this[_0x3ab26c(0x28d)][_0x3ab26c(0x226)]();}[_0x25a81d(0x412)](){const _0xcb8b10=_0x25a81d;return this[_0xcb8b10(0x28d)][_0xcb8b10(0x412)]();}['isIconLeft'](){return![];}['needsDrawBackground'](){return![];}}class MultilineItemProxy_Choice extends I_Multiline_Porxy{constructor(_0x5306ff){const _0x35da37=_0x25a81d;super(),this[_0x35da37(0x244)]=_0x5306ff;}[_0x25a81d(0x2b0)](){return this['_choice']['text']();}[_0x25a81d(0x3c9)](){return!![];}}class MultilineItemProxy_Name extends Multiline_PorxyBase{constructor(_0xe94fd3){super(_0xe94fd3);}[_0x25a81d(0x306)](){return!![];}[_0x25a81d(0x1fb)](){return!![];}[_0x25a81d(0x2b0)](){const _0x2a3fa2=_0x25a81d;return this['_item'][_0x2a3fa2(0x410)]();}[_0x25a81d(0x405)](){return 0x0;}[_0x25a81d(0x3c9)](){return!![];}}class MultiLineItemProxy_Message extends Multiline_PorxyBase{constructor(_0x3ad995,_0x4a1cd6){const _0x1ba698=_0x25a81d;super(_0x3ad995),this[_0x1ba698(0x329)]=_0x4a1cd6;}[_0x25a81d(0x405)](){return this['_lineIndex'];}[_0x25a81d(0x306)](){return![];}[_0x25a81d(0x1fb)](){const _0x2b64b6=_0x25a81d;return!this[_0x2b64b6(0x28d)]['speakerName']();}['text'](){const _0xd205f=_0x25a81d;return this[_0xd205f(0x28d)][_0xd205f(0x2b0)]();}[_0x25a81d(0x2b5)](){return!![];}['needsDrawBackground'](){const _0xe67b25=_0x25a81d;return this[_0xe67b25(0x1fb)]();}}class MultiLineItemProxy_Empty extends Multiline_PorxyBase{constructor(_0x4e4445,_0x188574){super(_0x4e4445),this['_lineIndex']=_0x188574;}['text'](){return'';}[_0x25a81d(0x1fb)](){return![];}[_0x25a81d(0x405)](){const _0x2335c3=_0x25a81d;return this[_0x2335c3(0x329)];}[_0x25a81d(0x3c9)](){return![];}}class I_LogItem{[_0x25a81d(0x2af)](){}[_0x25a81d(0x34f)](){return[];}['voiceParam'](){return null;}['hasVoice'](){const _0x1ac1fb=_0x25a81d;return!!this[_0x1ac1fb(0x2f8)]();}[_0x25a81d(0x435)](){}[_0x25a81d(0x2f2)](){return null;}}class MultiLine_Message extends I_LogItem{constructor(){const _0x2993c4=_0x25a81d;super(),this[_0x2993c4(0x2a0)]='',this[_0x2993c4(0x2c0)]=0x0,this['_facename']=null,this['_se']=null,this['_numLines']=0x0;}['startMessage'](_0x5225bb,_0x16fcea,_0x5cb8bc){const _0x4fcac4=_0x25a81d;this[_0x4fcac4(0x2c0)]=_0x5cb8bc,this[_0x4fcac4(0x346)]=_0x16fcea,this[_0x4fcac4(0x2a0)]='',this['_speakerName']=_0x5225bb;}[_0x25a81d(0x2f2)](){const _0x4e42b1=_0x25a81d;if(!this[_0x4e42b1(0x2a0)])return null;const _0x3ab6b3=this[_0x4e42b1(0x2a0)][_0x4e42b1(0x439)](/([^\r\n]\s*\S.*)/);if(_0x3ab6b3)return _0x3ab6b3[0x0];return null;}[_0x25a81d(0x1fc)](_0x50df7e){}[_0x25a81d(0x43a)](_0x3a44de,_0x58aa3b,_0x4662ee,_0x5117b6,_0x3f8130){
    const _0x17d58f=_0x25a81d;this['_speakerName']=_0x3a44de,this[_0x17d58f(0x2a0)]=_0x58aa3b,this[_0x17d58f(0x346)]=_0x4662ee,this[_0x17d58f(0x2c0)]=_0x5117b6,this[_0x17d58f(0x32f)]=_0x3f8130;}[_0x25a81d(0x3f4)](_0x337e9e){this['_numLines']+=_0x337e9e;}[_0x25a81d(0x2b0)](){const _0x42a834=_0x25a81d;return this[_0x42a834(0x2a0)];}[_0x25a81d(0x36c)](){const _0x7dbbd=_0x25a81d;return this[_0x7dbbd(0x235)];}['numLines'](){const _0x1d2fa9=_0x25a81d,_0x505a4c=this[_0x1d2fa9(0x1fa)]()?0x1:0x0,_0x21eace=!!this[_0x1d2fa9(0x226)]()?0x4:0x0;return Math['max'](_0x21eace,_0x505a4c+this[_0x1d2fa9(0x36c)]());}[_0x25a81d(0x226)](){const _0x2f9df0=_0x25a81d;return this[_0x2f9df0(0x346)];}[_0x25a81d(0x412)](){return this['_faceindex'];}[_0x25a81d(0x1fa)](){const _0x263e47=_0x25a81d;return!!this[_0x263e47(0x35e)];}[_0x25a81d(0x410)](){const _0x202ac2=_0x25a81d;return this[_0x202ac2(0x35e)];}['voiceParam'](){return this['_se'];}['needsVoiceIconRender'](){const _0x2c1062=_0x25a81d;return!!this[_0x2c1062(0x32f)];}['createProxy'](){const _0x3045c8=_0x25a81d,_0x51d4c7=this[_0x3045c8(0x1fa)](),_0x90f4d9=_0x51d4c7?0x1:0x0,_0xf28a5c=new MultiLineItemProxy_Message(this,_0x90f4d9),_0x2cf25a=[_0xf28a5c];if(_0x51d4c7){const _0x5c6297=new MultilineItemProxy_Name(this);_0x2cf25a[_0x3045c8(0x273)](_0x5c6297);}const _0x322669=this['numLines']();for(let _0x1fe71e=_0x90f4d9+0x1;_0x1fe71e<_0x322669;++_0x1fe71e){const _0x529a07=new MultiLineItemProxy_Empty(this,_0x1fe71e);_0x2cf25a['push'](_0x529a07);}return _0x2cf25a;}}function _0x48cb(){const _0x511c4c=['cold','maxValue','getLogItemStyle','callUpdateHelp','version','some','_eventId','round','_frameColor','isItemChoice','itemRectWithPadding','getAutoWaitTime','ru_RU','setValue','isRepeated','setList','saveButton','SetJumpTarget','_background','_commandName','command101','isInputEnabled','ko_KR','refreshLang','_disableSwitch','onEndOfText','onChoiceOk','isPlaying','resetTemporaly','terminateMessage','endFill','filter','choice','isAutoMode','choiceCancelText','label','_auto','_errorFiles','top','_autoSpeedList','readSaveContents','cursorDown','_cancelText','getAutoMode','_machinakaList','createMachinakaWindow','readSwitch','SetAutoWaitTime','refreshAutoKeeping','voiceIconIndex','setHelpWindow','machinakaModeSwitch','_machinakaMode','createGameObjects','bottomItemIndex','onBoot','create','isButtonOn','_logList','inside','_paramNames','getGaugeColor','needsHelpWindow','start','outputHeight','isNaN','isLocal','initSwitchs','setupNewGame','lineStyle','_battleMode','speakerNameFormat','_defaultOption','variableId','voice','autoButton','_itemstyle','offsetY','clearTextItem','_voice','iconWidth','setShowFast','needsDrawBackground','pan','windowSkinBitmap','windowFileName','index:','callCancelHandler','symbol','correctDataErrors','max','Texture','makeData','_autoXXX','_logWindow','voiceIcon','topItemIndex','_buttons','logWriteSwitch','prototype','needsDrawFace','isNwjs','numItemLines','parentId','isPressed','clear','setLocal','isBusy','needsShowFast','forceSelect','ManoUZ_MessageLog','_pluginName','machinakaRect','_choiceText','_contents','_layout','playVoice','maxPageRows','_needsShowFast','needsVoiceIconRender','keepingAutoMode','43850CVtNpa','goto','nextTopIndex','texture','addLines','add','enabledSwitch','isAbsolute','mapId','parent','updateInput','setWorkaround','select','_logWrite','lineText','_title','forceCleanup','_coldFrame','onMachinakaCancel','registerCommandMV','isClickEnabled','lineIndex','background','readOnryData','isNumberInput','onMachnakaOk','hasVoice','_backgroundSprite','itemRect','_machinakaWindow','clearLog','mainAreaTop','speakerName','_parallelMode','faceIndex','SetLogLimitSizeBasic','applyData','pos','updatePlacement','playClickSound','saveCurrentLog','_radius','windowskin','playSe','_logStyle','findIndex','onAudioLoadError','createBackground','baseTexture','createTitle','_gauge','registerCommandMZ','makeSaveContents','cloneValue','_style','machinakeModeEnabled',
'canSave','onBacklogCancel','_nameBoxWindow','currentValue','mainAreaHeight','switchId','checkLogSize','hasLastVoice','createAutoGauge','loadObject','_pitch','topIndex','_mapId','isChoiceMatch','itemStyle','_voiceList','commandName','match','write','_behaviorList','GetLogSize','faceWidth','update','currentScript','quickLoad','logLimitBasic','setColdFrame','setLocation','Container','color','logWriteOnBattle','ClearAll','_windowRect','convertEscapeCharacters','topLineIndex','cancelText','isMacinakaMode','boxWidth','<br>','lineSpacing','_parallelInputLock','isLogWriteEnabled','addOriginalCommands','現在のファイル名:\x20','lastCodeIndex','callMV','abs','drawTextEx','length','lineTextureStyle','setLastCodeIndex','GetLogLimitSizeExtends','_height','bind','_scrollY','hasName','isTopItem','writeTextV8','backgroundBitmap','clearOldData','setBattleMode','callDrawIcon','deselect','mainAreaLeft','otherLocationMatch','option','isButtonHot','getLogLimitSizeExtends','en_US','_overlapType','drawItem','autoWaitTime','createAllWindows','onMapEventStarted','initSwitch','_windowStretchY','lastItemIndex','swtichId','isEventRunning','isAnyButtonOverlaped','convertCall','isSceneChanging','logManager','volume','play','pluginVersion','logLimitExtends','radius','setContents','cloneOptionValue','Original\x20file\x20name:\x20','isLongPressed','createMachinakaList','_msg','logSizeRed','logWindowRect','saveObject','src','choiceFormat','faceName','colSpacing','bottomLineIndex','42PwVgcQ','repeatLastVoice','baseRect','stopVoice','changeAutoMode','900QMZBgh','_speed','call','rowSpacing','setLogLimitBasic','isValid','clearLastCodeIndex','_numLines','map','autoGaugeRate','_logItem','redraw','time','updateInterpreter','onTerminateMessage','mode','then','callMZ','_list','_table','itemFrameColor','inBattle','_choice','addWindow','ja_JP','locale','createCommandWindow','cloneDefaultOption','tryReadingSaveContents','GetAutoWaitTime','selectlLastItem','setRootMap','_textState','startAutoTimer','UZMSGLOG_CONFIG','setAutoWaitTime','pitch','startMessage','jumpTo','UZMSGLOG','Show','flipAutoMode','windowMessageInit','zh_CN','left','value','registerCommand','contentsHeight','_defaultState','logButtonAreaHeight','resetTimer','pageup','_showFast','getLogSize','_func','true','newPage','refresh','createMinimize','_index','_swicthId','setLogListWindow','setLastVoiceParam','Do\x20not\x20rename\x20the\x20plugin\x20file.<br>','loadSystem','linkWindow','_buttonsSprites','writeSaveContents','endMessage','unshift','lastItem','calcRectHeight','_messageWindow','setAutoGauge','SetLogLimitSizeExtends','loadButton','CleanupOldData','_option','windowStretchY','_texture','isInside','removeChild','writeMessage','min','right','addItem','files','getKeepingAutoMode','setHandler','setTitle','_switchId','name','calcWindowHeight','setTextV8','machinakaWindowHeight','_item','itemHeight','stop','_onOff','_logButtonGroop','onNewGame','SetTitle','machinakaLines','height','onBacklogOk','getCurrentText','onAutosaveFailure','_voiceReg','_width','updateAutoTimer','setOptionValue','isBattleMode','isVoiceStoped','_value','_text','_name','pressedSound','machinakaModeLines','_workaround','_messageStream','beginFill','getContents','addChild','setTextTerminate','_pageIndex','setAutoMode','index','event','openness','onSaveLoaded','text','setMachinakaTitle','arc','_currentTime','maxItems','needsDrawItem','920479WFdbIu','1034UhxFUK','setupStartingMapEvent','createButtonSprite','isEmpty','calcSize','6824228JgnhCN','quickSaveFileName','needsAutoModeStop','_positionType','_faceindex','notitle','createOutside','Current\x20file\x20name:\x20','smoothSelect','width','setHotFrame','_temporaly','macinakaModeDefault','_logManager','_cache','createLogButtonSprites','_childInterpreter','itemAt','_behavior','wheelY','offsetX','_windowFileName','isVoiceFile','callDrawFace','openOptionScene','clone','isTriggered','119848gQjGIR','setFrame','setLastVoice','updateHelp','1051849rKxEaB','_logListWindow','_interpreter','_helpWindow','setLastVoiceBuffer','_machinakaRect','createOnOffButtonSprite','absolute','isButtonDisabled','createChoiceItemText','obj','_localBoundsRect','_lastIndex','eventId','loadBitmap','_commandWindow','list','本来のファイル名:\x20','onEndEvent','setScrollIndex','defaultQuickSaveFileName','_readOnlyData','_autoGaugeFunc','titleText','open','onVoiceStop','_volume','onClick','isTextAutoMode','voiceParam','faceHeight','_machinakaFocus','logquicksave','logStyle','makeNewLog','push','faceRect','_seBuffer','windowRect','command250','helpAreaHeight','_offsetX','multiLineItems','isIconLeft','1491080UZCNVW','has','error','_macinakaMode','saveContents','activate','cancel','_hotFrame','GetAutoSpeed','_textuerName','coldFrame','setText','addCommand','set','_rootMapId','logSizeYellow','getLogItem','close','optionNormalize','menuCommand','numLines','makeStateText','setGaugeFunction','createLogWindow','currentLocal','logSize','_pan','layout','lineHeight','setupBitmapStyle','windowOverlap','_channelFunc','pause','choicePositionType','_lineIndex','GetLogLimitSizeBasic','isLogButtonEnabled','uniqueId','_enabled','_currnet','_se','HasLastVoice','updateFrame','lastVoice',
'makeItemList','_choiceStyle','drawItemBackground','regex','setJumpTarget','isItemEnalbled','pushScene','bottom','3220845emBwiu','_symbol','_logSwitch','callOkHandler','_scrollIndex','_menuCommand','parse','makeCache','test','createSpriteList','isOpen','_facename','onMapTransfer','shift','extractSaveContents','_version','_map','cursorUp','isMachinakaModeEnabled','_offsetY','createProxy','needsTextTerminate','messageLog','bitmap','hotFrame','Unknow\x20RPG\x20MAKER:','itemPadding','addLoadListener','_pressed','visible','auto','itemFrameThickness','setParallelMode','updateAutoTime','isEnabled','_speakerName','isSaveEnabled','popScene','itemRectForText','currentItem','setPlayVoiceFunction','needsNextMessage','setLogLimitExtends','isMVcommandEnabeled','disableSwitch','getWorkaround','3ctYptE','initialize','makeMZ_arg','textLines','RPGMAKER_NAME','createDisplayObjects','machinakaWindowRect','image','endAutoTimer','loadWindowskin','gaugeColor','pagedown','createSprite','de_DE'];_0x48cb=function(){return _0x511c4c;};return _0x48cb();}class Log_ContentsObject{constructor(_0x24bdb5){const _0x4cfc1b=_0x25a81d;this['_version']=_0x24bdb5,this[_0x4cfc1b(0x3a3)]=[],this['_logList']=new LogList(),this[_0x4cfc1b(0x2fa)]=0x0,this[_0x4cfc1b(0x234)]();}[_0x25a81d(0x42e)](_0x39f4cf,_0x37ec89){const _0x4ca3d8=_0x25a81d,_0x3310aa=Math[_0x4ca3d8(0x3d1)](_0x39f4cf,_0x37ec89);if(this[_0x4ca3d8(0x3a3)][_0x4ca3d8(0x1f3)]>_0x3310aa){const _0x226425=Math[_0x4ca3d8(0x1f1)](_0x37ec89-_0x39f4cf),_0x4a0f11=this[_0x4ca3d8(0x3a3)]['slice'](_0x226425);this['_machinakaList']=_0x4a0f11;}}[_0x25a81d(0x283)](_0x55638b){const _0x1819de=_0x25a81d;this['_logList']&&this['_logList'][_0x1819de(0x3f5)](_0x55638b);}[_0x25a81d(0x37b)](){const _0x4f9484=_0x25a81d;return this[_0x4f9484(0x34a)];}[_0x25a81d(0x1ef)](){const _0xc8efd=_0x25a81d;return this[_0xc8efd(0x2e7)];}[_0x25a81d(0x1f5)](_0x42af42){const _0xd8c6b5=_0x25a81d;this[_0xd8c6b5(0x2e7)]=_0x42af42;}[_0x25a81d(0x234)](){const _0x483157=_0x25a81d;this[_0x483157(0x1f5)](NaN);}['createMachinakaList'](){const _0x38e6fc=_0x25a81d,_0x16f7a4=this[_0x38e6fc(0x3a3)][_0x38e6fc(0x396)](_0x118add=>{const _0x5c6f0b=_0x38e6fc;if(this[_0x5c6f0b(0x3b1)])return!this[_0x5c6f0b(0x3b1)]['isLocationMatch'](_0x118add['mapId'](),_0x118add['eventId']());return!![];});return this[_0x38e6fc(0x3b1)]&&!this[_0x38e6fc(0x3b1)][_0x38e6fc(0x2ba)]()&&_0x16f7a4[_0x38e6fc(0x2fe)](this[_0x38e6fc(0x3b1)]),_0x16f7a4;}[_0x25a81d(0x418)](){const _0x3f93b5=_0x25a81d;if(!this[_0x3f93b5(0x3b1)]||this['_logList'][_0x3f93b5(0x2ba)]())return;const _0x17d399=this[_0x3f93b5(0x3a3)][_0x3f93b5(0x41d)](_0x2491e9=>{return this['_logList']['otherLocationMatch'](_0x2491e9);});_0x17d399>=0x0?this[_0x3f93b5(0x3a3)][_0x17d399]=this[_0x3f93b5(0x3b1)]:this['_machinakaList'][_0x3f93b5(0x2fe)](this['_logList']),this['_logList']=null;}[_0x25a81d(0x2fd)](_0x2f6dc7,_0xb4b6a5){const _0x50b570=_0x25a81d,_0x3855a0=new LogList();_0x3855a0[_0x50b570(0x443)](_0x2f6dc7,_0xb4b6a5),this[_0x50b570(0x3b1)]=_0x3855a0;}['createProxy'](){const _0x2814db=_0x25a81d;if(this['_logList'])return this[_0x2814db(0x3b1)]['createProxy']();return[];}['lastVoice'](){const _0x4c93c8=_0x25a81d,_0x4ee9f0=this[_0x4c93c8(0x3b1)][_0x4c93c8(0x274)]();if(_0x4ee9f0)return _0x4ee9f0[_0x4c93c8(0x2f8)]();return null;}[_0x25a81d(0x2bb)](){}[_0x25a81d(0x400)](){}['createMinimize'](){const _0x39eb66=_0x25a81d,_0x5d4c6a=new Log_ContentsObject(this[_0x39eb66(0x34a)]);return _0x5d4c6a['_machinakaList']=[],_0x5d4c6a;}[_0x25a81d(0x320)](){return 0x0;}}class LogItem_Choice extends I_LogItem{constructor(_0x356ea1,_0x4595a9){const _0x2aa6db=_0x25a81d;super(),this['_text']=_0x356ea1,this[_0x2aa6db(0x269)]=_0x4595a9;}[_0x25a81d(0x34f)](){return[new MultilineItemProxy_Choice(this)];
}[_0x25a81d(0x2b0)](){return this['_text'];}['titleText'](){return this['_text'];}}class ReadOnlyLogList{[_0x25a81d(0x2eb)](){return[];}[_0x25a81d(0x20f)](){const _0x451f88=_0x25a81d;return this[_0x451f88(0x320)]()-0x1;}[_0x25a81d(0x3f8)](){return NaN;}[_0x25a81d(0x2e8)](){return NaN;}['logSize'](){const _0x533522=_0x25a81d;return this[_0x533522(0x2eb)]()[_0x533522(0x1f3)];}['isLocationMatch'](_0x2ab7a9,_0xb64424){const _0x4f2e23=_0x25a81d;return this['mapId']()===_0x2ab7a9&&this[_0x4f2e23(0x2e8)]()===_0xb64424;}[_0x25a81d(0x203)](_0x201bdf){const _0x2170a8=_0x25a81d,_0x1d562c=this['mapId'](),_0x5d25c6=this[_0x2170a8(0x2e8)]();if(isNaN(_0x1d562c)||isNaN(_0x5d25c6))return![];return this[_0x2170a8(0x3f8)]()===_0x201bdf['mapId']()&&this[_0x2170a8(0x2e8)]()===_0x201bdf[_0x2170a8(0x2e8)]();}[_0x25a81d(0x34f)](){const _0x4cc3cf=_0x25a81d,_0x356ddd=[],_0x37649f=this[_0x4cc3cf(0x2eb)]();for(const _0xbaaf1e of _0x37649f){const _0x3f521a=_0xbaaf1e['createProxy']();_0x356ddd['push'](..._0x3f521a);}return _0x356ddd;}}class LogList extends ReadOnlyLogList{constructor(){super(),this['clear']();}['list'](){return this['_list'];}[_0x25a81d(0x3e0)](){const _0x3adb63=_0x25a81d;this[_0x3adb63(0x240)]=[],this['setTitle'](''),this[_0x3adb63(0x443)](NaN,NaN);}['createTitle'](){const _0x58d73e=_0x25a81d;if(this[_0x58d73e(0x3ff)])return this[_0x58d73e(0x3ff)];for(const _0x595690 of this['_list']){const _0x2a136e=_0x595690[_0x58d73e(0x2f2)]();if(_0x2a136e)return _0x2a136e;}return _0x58d73e(0x2c1);}[_0x25a81d(0x287)](_0x137ede){this['_title']=_0x137ede;}[_0x25a81d(0x443)](_0x31b5b6,_0x3fb836){
    const _0x3dd8c4=_0x25a81d;this[_0x3dd8c4(0x434)]=_0x31b5b6,this['_eventId']=_0x3fb836;}[_0x25a81d(0x3f8)](){const _0x36fae8=_0x25a81d;return this[_0x36fae8(0x434)];}[_0x25a81d(0x2e8)](){const _0x142ec9=_0x25a81d;return this[_0x142ec9(0x37d)];}['isEmpty'](){const _0x44ceda=_0x25a81d;return this['_list'][_0x44ceda(0x1f3)]<=0x0;}['onSaveLoaded'](){}[_0x25a81d(0x268)](){const _0x94f6a5=_0x25a81d,_0x40c60b=this[_0x94f6a5(0x274)](),_0x3da5f1=new LogList();return _0x3da5f1[_0x94f6a5(0x3f5)](_0x40c60b),_0x3da5f1;}[_0x25a81d(0x274)](){const _0x224039=_0x25a81d;;const _0x1dbd4a=this[_0x224039(0x20f)](),_0x5efe45=this[_0x224039(0x240)][_0x1dbd4a];return _0x5efe45?_0x5efe45:null;}[_0x25a81d(0x3f5)](_0x29485c){const _0x2b00de=_0x25a81d;this[_0x2b00de(0x240)][_0x2b00de(0x2fe)](_0x29485c);}}class I_LogButtonLayout{[_0x25a81d(0x233)](){return![];}[_0x25a81d(0x417)](){}['x'](){return 0x0;}['y'](){return 0x0;}[_0x25a81d(0x2c5)](){return 0x0;}[_0x25a81d(0x295)](){return 0x0;}[_0x25a81d(0x42d)](){return 0x0;}[_0x25a81d(0x353)](){return null;}['coldFrame'](){return null;}[_0x25a81d(0x352)](){return null;}}class I_ButtonBehavior{[_0x25a81d(0x322)](){return null;}[_0x25a81d(0x35d)](){return![];}[_0x25a81d(0x2f6)](){}}var ManoUZ_MessageLog=(function(){'use strict';const _0x1c233b=_0x25a81d;const _0x556c6a=0x1348b28;class _0x500c54 extends Sprite_Clickable{constructor(_0x4306d2){const _0x1704f7=_0x4588;super();const _0x1f7282=_0x4306d2[_0x1704f7(0x322)]();this['_behavior']=_0x4306d2,this[_0x1704f7(0x352)]=_0x1f7282[_0x1704f7(0x352)]();const _0x4dab5f=_0x1f7282['hotFrame']();this[_0x1704f7(0x2c6)](_0x4dab5f['x'],_0x4dab5f['y'],_0x4dab5f[_0x1704f7(0x2c5)],_0x4dab5f[_0x1704f7(0x295)]);const _0x303986=_0x1f7282[_0x1704f7(0x311)]();this[_0x1704f7(0x442)](_0x303986['x'],_0x303986['y'],_0x303986[_0x1704f7(0x2c5)],_0x303986['height']),this['updateFrame'](),this['x']=_0x1f7282['x'](),this['y']=_0x1f7282['y'](),this[_0x1704f7(0x357)]=![],this['_hovered']=![];}['setBehavior'](_0x30774a){}get['height'](){const _0x40f0d2=_0x4588;return Math[_0x40f0d2(0x3d1)](this['_hotFrame'][_0x40f0d2(0x295)],this[_0x40f0d2(0x401)][_0x40f0d2(0x295)]);}get['width'](){const _0x193a64=_0x4588;return Math[_0x193a64(0x3d1)](this[_0x193a64(0x30e)][_0x193a64(0x2c5)],this[_0x193a64(0x401)][_0x193a64(0x2c5)]);}[_0x1c233b(0x43e)](){const _0xa1f847=_0x1c233b;super[_0xa1f847(0x43e)](),this['processTouch'](),this['updateFrame']();}[_0x1c233b(0x2c6)](_0x25434d,_0x40d7a1,_0x4b58e0,_0x5713a6){const _0x14f373=_0x1c233b;this[_0x14f373(0x30e)]=new Rectangle(_0x25434d,_0x40d7a1,_0x4b58e0,_0x5713a6);}['setColdFrame'](_0x589a03,_0x202968,_0x4cd3ba,_0x4fb1b6){const _0x7eb82c=_0x1c233b;this[_0x7eb82c(0x401)]=new Rectangle(_0x589a03,_0x202968,_0x4cd3ba,_0x4fb1b6);}['isButtonHot'](){const _0x3393b3=_0x1c233b;return this[_0x3393b3(0x3df)]();}[_0x1c233b(0x331)](){const _0x27daa3=_0x1c233b,_0x57b669=this[_0x27daa3(0x205)]()?this[_0x27daa3(0x30e)]:this['_coldFrame'];_0x57b669&&this[_0x27daa3(0x2d8)](_0x57b669['x'],_0x57b669['y'],_0x57b669[_0x27daa3(0x2c5)],_0x57b669[_0x27daa3(0x295)]);}[_0x1c233b(0x404)](){const _0x530f5b=_0x1c233b;if(this[_0x530f5b(0x3f9)]){if(!this['parent'][_0x530f5b(0x358)])return![];}return this[_0x530f5b(0x358)]&&this[_0x530f5b(0x2ce)][_0x530f5b(0x35d)]();}[_0x1c233b(0x2f6)](){const _0x460790=_0x1c233b;this[_0x460790(0x404)]()&&this[_0x460790(0x2ce)][_0x460790(0x2f6)]();}['startMessage'](){const _0x2e2e95=_0x1c233b;this[_0x2e2e95(0x358)]=this[_0x2e2e95(0x2ce)][_0x2e2e95(0x35d)]();}}class _0x4253ea{[_0x1c233b(0x3e4)](_0x184e67,_0x521f40){}['createButtonSprite'](_0x357191){return null;}[_0x1c233b(0x2e1)](_0x23c805){return null;}[_0x1c233b(0x258)](_0x342251){}['quickSave'](){}[_0x1c233b(0x440)](){}}const _0x1a1516=_0x1c233b(0x3e5);function _0x34e0f6(){const _0x9541c4=_0x1c233b,_0x205b17=decodeURIComponent(document[_0x9541c4(0x43f)][_0x9541c4(0x224)])[_0x9541c4(0x439)](/([^/]+)\.js$/);if(_0x205b17)return _0x205b17[0x1];return'';}function _0x2abebf(_0x3e9eb5){const _0x3f6080=_0x1c233b,_0x1af608=_0x34e0f6();if(_0x3e9eb5===_0x1af608)return;const _0x262695=_0x3f6080(0x26d)+(_0x3f6080(0x2c3)+_0x1af608+_0x3f6080(0x1e9))+(_0x3f6080(0x21d)+_0x3e9eb5+'<br>')+'プラグインファイルの名前を変更してはいけません<br>'+(_0x3f6080(0x1ee)+_0x1af608+_0x3f6080(0x1e9))+(_0x3f6080(0x2ec)+_0x3e9eb5);throw new Error(_0x262695);}_0x2abebf(_0x1a1516);class _0x50551a extends _0x4253ea{[_0x1c233b(0x3e4)](_0x56d01e,_0x17edb9){const _0x41bc3a=_0x1c233b;_0x56d01e[_0x41bc3a(0x3e4)](_0x17edb9);}[_0x1c233b(0x2b9)](_0x3590ea){return new _0x500c54(_0x3590ea);}[_0x1c233b(0x2e1)](_0xf58f4f){return new _0x35e1f3(_0xf58f4f);}['quickSave'](){const _0x56192a=_0x1c233b,_0x160a90=_0x3430dd[_0x56192a(0x204)]()[_0x56192a(0x2bd)](),_0x1f0b5f=DataManager[_0x56192a(0x424)]();return StorageManager[_0x56192a(0x223)](_0x160a90,_0x1f0b5f);}['quickLoad'](){const _0x232872=_0x1c233b,_0x269da9=_0x3430dd[_0x232872(0x204)]()[_0x232872(0x2bd)]();return StorageManager[_0x232872(0x431)](_0x269da9)[_0x232872(0x23e)](_0x167a32=>{const _0x773ce=_0x232872;return DataManager['createGameObjects'](),DataManager[_0x773ce(0x349)](_0x167a32),DataManager[_0x773ce(0x3d0)](),0x0;});}}function _0x258ec8(_0x343fc2,_0x3eb45b,_0x3daed7){
        const _0xd95def=_0x1c233b;if(Utils[_0xd95def(0x36d)]==='MZ'){_0x3daed7['call'](_0x343fc2,_0x3eb45b);return;}if(Utils['RPGMAKER_NAME']==='MV'){_0x3daed7[_0xd95def(0x230)](_0x343fc2,_0x3eb45b['x'],_0x3eb45b['y'],_0x3eb45b[_0xd95def(0x2c5)],_0x3eb45b[_0xd95def(0x295)]);return;}throw new Error(_0xd95def(0x354)+Utils['RPGMAKER_NAME']);}class _0x379cff{constructor(_0x344926,_0x3d1ed7,_0x31e05f,_0x3592af){const _0x142b26=_0x1c233b;this[_0x142b26(0x2a1)]=_0x344926,this[_0x142b26(0x2f5)]=_0x3d1ed7,this[_0x142b26(0x432)]=_0x31e05f,this[_0x142b26(0x321)]=_0x3592af;}static[_0x1c233b(0x3af)](_0xd26798){const _0x4f56de=_0x1c233b;if(!_0xd26798)return null;const _0x211dd7=JSON[_0x4f56de(0x341)](_0xd26798),_0x4d64a7=_0x211dd7['name'],_0xa7e5ff=Number(_0x211dd7[_0x4f56de(0x216)]),_0x401776=Number(_0x211dd7[_0x4f56de(0x252)]),_0x446a40=Number(_0x211dd7[_0x4f56de(0x3ca)]);return new _0x379cff(_0x4d64a7,_0xa7e5ff,_0x401776,_0x446a40);}[_0x1c233b(0x217)](){const _0x1ad5b1=_0x1c233b;if(this[_0x1ad5b1(0x2a1)]){const _0x28af04={'pos':0x0,'name':this['_name'],'volume':this[_0x1ad5b1(0x2f5)],'pitch':this[_0x1ad5b1(0x432)],'pan':this[_0x1ad5b1(0x321)]};AudioManager[_0x1ad5b1(0x41b)](_0x28af04);}}}function _0x14f903(_0x38e0cb){const _0x4e34e2=_0x1c233b,_0x1122f1=JSON[_0x4e34e2(0x341)](_0x38e0cb);return new Rectangle(Number(_0x1122f1['x']),Number(_0x1122f1['y']),Number(_0x1122f1[_0x4e34e2(0x2c5)]),Number(_0x1122f1[_0x4e34e2(0x295)]));}class _0x7b9ba1 extends I_LogButtonLayout{constructor(_0x12af8e,_0x21868d,_0x59adad,_0x17b873,_0x2f2bd1,_0x1f97ab,_0x4f2743){const _0x42c7c2=_0x1c233b;super(),this['_name']=_0x12af8e,this[_0x42c7c2(0x30e)]=_0x17b873,this[_0x42c7c2(0x401)]=_0x2f2bd1,this['_x']=_0x21868d,this['_y']=_0x59adad,this[_0x42c7c2(0x288)]=_0x1f97ab,this[_0x42c7c2(0x32f)]=_0x4f2743;}static[_0x1c233b(0x3af)](_0x59d9dd){const _0x17df58=_0x1c233b,_0x486889=JSON[_0x17df58(0x341)](_0x59d9dd),_0x23545d=_0x379cff['create'](_0x486889[_0x17df58(0x2a2)]),_0x4d058d=_0x14f903(_0x486889['hot']),_0x282854=_0x14f903(_0x486889[_0x17df58(0x377)]),_0x1e8e97=Number(_0x486889['x']),_0x4ff02a=Number(_0x486889['y']),_0x5085ec=Number(_0x486889[_0x17df58(0x3f6)]||0x0);return new _0x7b9ba1(_0x486889[_0x17df58(0x370)],_0x1e8e97,_0x4ff02a,_0x4d058d,_0x282854,_0x5085ec,_0x23545d);}[_0x1c233b(0x233)](){const _0x568bf8=_0x1c233b;return!!this[_0x568bf8(0x2a1)];}['switchId'](){const _0x230f74=_0x1c233b;return this[_0x230f74(0x288)];}['bitmap'](){const _0x2a69c1=_0x1c233b;return ImageManager[_0x2a69c1(0x26e)](this[_0x2a69c1(0x2a1)]);}[_0x1c233b(0x417)](){const _0x3e0475=_0x1c233b;this[_0x3e0475(0x32f)]&&this[_0x3e0475(0x32f)][_0x3e0475(0x217)]();}[_0x1c233b(0x311)](){const _0x118dc5=_0x1c233b;return this[_0x118dc5(0x401)][_0x118dc5(0x2d5)]();}[_0x1c233b(0x353)](){const _0x38b096=_0x1c233b;return this[_0x38b096(0x30e)][_0x38b096(0x2d5)]();}['x'](){return this['_x'];}['y'](){return this['_y'];}['width'](){const _0x28a097=_0x1c233b;return Math['max'](this[_0x28a097(0x30e)][_0x28a097(0x2c5)],this[_0x28a097(0x401)]['width']);}['height'](){const _0x3b6eef=_0x1c233b;return Math[_0x3b6eef(0x3d1)](this[_0x3b6eef(0x30e)]['height'],this[_0x3b6eef(0x401)][_0x3b6eef(0x295)]);}}class _0x548dd9 extends I_ButtonBehavior{constructor(_0x12b952,_0x3390d6){const _0xd662b2=_0x1c233b;super(),this[_0xd662b2(0x3ea)]=_0x12b952,this['_symbol']=_0x3390d6;}[_0x1c233b(0x233)](){const _0x244e20=_0x1c233b;return this[_0x244e20(0x3ea)]&&this['_layout'][_0x244e20(0x233)]();}[_0x1c233b(0x322)](){const _0x13fd0e=_0x1c233b;return this[_0x13fd0e(0x3ea)];}[_0x1c233b(0x35d)](){const _0x51381e=_0x1c233b,_0x24bb89=this[_0x51381e(0x3ea)][_0x51381e(0x42d)]();if(_0x24bb89)return $gameSwitches[_0x51381e(0x25b)](_0x24bb89);return!![];}[_0x1c233b(0x3cf)](){const _0x5c1802=_0x1c233b;return this[_0x5c1802(0x33c)];}[_0x1c233b(0x3fa)](){const _0x512e1f=_0x1c233b;this[_0x512e1f(0x33c)]&&this[_0x512e1f(0x2d6)]()&&this[_0x512e1f(0x2f6)]();}['isTriggered'](){const _0x162ac0=_0x1c233b;return Input[_0x162ac0(0x21e)](this[_0x162ac0(0x33c)]);}[_0x1c233b(0x33e)](){}[_0x1c233b(0x2f6)](){const _0x55a900=_0x1c233b;this['_layout'][_0x55a900(0x417)](),this['callOkHandler']();}[_0x1c233b(0x375)](){const _0x477423=_0x1c233b;return this['logManager']()[_0x477423(0x368)]()['createButtonSprite'](this);}[_0x1c233b(0x215)](){return _0x3430dd;}[_0x1c233b(0x339)](_0x4e249e){const _0x36e3a=_0x1c233b;this[_0x36e3a(0x215)]()[_0x36e3a(0x339)](_0x4e249e);}}class _0x332892 extends _0x548dd9{[_0x1c233b(0x33e)](){const _0x53bbd0=_0x1c233b;this[_0x53bbd0(0x339)](_0x753851);}[_0x1c233b(0x2d6)](){const _0x4e6a63=_0x1c233b;return super['isTriggered']()||TouchInput[_0x4e6a63(0x2cf)]<0x0;}}class _0x5a898e extends _0x548dd9{[_0x1c233b(0x33e)](){const _0x42b219=_0x1c233b;this[_0x42b219(0x339)](Scene_Load);}}class _0x58b818 extends _0x548dd9{[_0x1c233b(0x35d)](){const _0x3e6a0c=_0x1c233b;return super[_0x3e6a0c(0x35d)]()&&this[_0x3e6a0c(0x215)]()[_0x3e6a0c(0x428)]();}[_0x1c233b(0x33e)](){const _0x35b867=_0x1c233b;this[_0x35b867(0x339)](Scene_Save);}
    }class _0x18470d extends _0x548dd9{[_0x1c233b(0x35d)](){const _0x2762f7=_0x1c233b;return super[_0x2762f7(0x35d)]()&&this['logManager']()['canSave']();}[_0x1c233b(0x33e)](){const _0x52227e=_0x1c233b;this['logManager']()[_0x52227e(0x368)]()['quickSave']();}['onAutoSaveSuccess'](){}[_0x1c233b(0x298)](){}}class _0x198b98 extends _0x548dd9{['callOkHandler'](){const _0x1070db=_0x1c233b,_0x395c63=DataManager['loadGame'](0x0);_0x395c63&&SceneManager[_0x1070db(0x3f1)](Scene_Map);}}class _0x2342af extends _0x548dd9{['createSprite'](){const _0x58cd39=_0x1c233b;return this[_0x58cd39(0x215)]()['getWorkaround']()[_0x58cd39(0x2e1)](this);}[_0x1c233b(0x3b0)](){return![];}}class _0x35e1f3 extends _0x500c54{constructor(_0x2cb95e){const _0xd00037=_0x1c233b;super(_0x2cb95e),this[_0xd00037(0x290)]=_0x2cb95e;}[_0x1c233b(0x2f6)](){const _0x1b15e4=_0x1c233b;super['onClick'](),this[_0x1b15e4(0x331)]();}[_0x1c233b(0x205)](){const _0x523ca9=_0x1c233b;return this[_0x523ca9(0x290)]&&this[_0x523ca9(0x290)]['isButtonOn']();}}class _0x3d8710 extends _0x35e1f3{constructor(_0x1b8db4){const _0x2d9be8=_0x1c233b;super(_0x1b8db4),this[_0x2d9be8(0x422)]=null;}[_0x1c233b(0x253)](){const _0xb5e9d4=_0x1c233b;super['startMessage'](),this['updateFrame'](),this[_0xb5e9d4(0x422)]&&this[_0xb5e9d4(0x422)][_0xb5e9d4(0x384)](0x0);}['setAutoGauge'](_0x5150fe){const _0x289ca3=_0x1c233b;this[_0x289ca3(0x422)]&&this[_0x289ca3(0x27f)](this[_0x289ca3(0x422)]),this[_0x289ca3(0x422)]=_0x5150fe,this[_0x289ca3(0x2a8)](_0x5150fe);}['update'](){const _0x59895b=_0x1c233b;super[_0x59895b(0x43e)](),this[_0x59895b(0x422)]&&!this[_0x59895b(0x422)][_0x59895b(0x43e)]&&this['_gauge'][_0x59895b(0x384)](_0x3430dd[_0x59895b(0x237)]());}}class _0x10dc10 extends _0x2342af{constructor(_0x201071,_0x1b70b1,_0x58634a){super(_0x1b70b1,_0x58634a),this['_gauge']=_0x201071;}[_0x1c233b(0x33e)](){const _0x40442b=_0x1c233b;this[_0x40442b(0x215)]()[_0x40442b(0x22d)]();}[_0x1c233b(0x3b0)](){const _0x3ed592=_0x1c233b;return this[_0x3ed592(0x215)]()[_0x3ed592(0x2f7)]();}[_0x1c233b(0x375)](){const _0x272a78=_0x1c233b,_0x39849f=new _0x3d8710(this),_0xec54ea=this[_0x272a78(0x422)][_0x272a78(0x375)](this[_0x272a78(0x3ea)]['width']()/0x2);return _0x39849f[_0x272a78(0x277)](_0xec54ea),_0x39849f;}}function _0x51e601(_0x337853){const _0x5b45c1=Number('0x'+_0x337853);if(isNaN(_0x5b45c1))return 0xffffff;return _0x5b45c1;}class _0x26708e{constructor(_0x523d8f,_0x3b8a3b,_0x1341de){const _0x384008=_0x1c233b;this[_0x384008(0x29a)]=_0x523d8f,this[_0x384008(0x310)]=_0x3b8a3b;}static['create'](_0x44a801){const _0x37e11e=_0x1c233b,_0x5827bb=JSON[_0x37e11e(0x341)](_0x44a801),_0x276589=Number(_0x5827bb[_0x37e11e(0x2c5)]),_0x3cb7e6=_0x51e601(_0x5827bb[_0x37e11e(0x445)]),_0x124439=String(_0x5827bb[_0x37e11e(0x3f3)]||'');return new _0x26708e(_0x276589,_0x124439,_0x3cb7e6);}[_0x1c233b(0x2e9)](){const _0x2984f9=_0x1c233b;return ImageManager[_0x2984f9(0x26e)](this[_0x2984f9(0x310)]);}[_0x1c233b(0x2c5)](){const _0x56c89d=_0x1c233b;return this[_0x56c89d(0x29a)];}['color'](){const _0x21a221=_0x1c233b;return _0x3430dd[_0x21a221(0x204)]()[_0x21a221(0x3b4)]();}[_0x1c233b(0x375)](_0x1eb4ed){const _0x29b0be=_0x1c233b,_0x3db26e=new _0x58c1cc(_0x1eb4ed);if(this[_0x29b0be(0x310)]){const _0x3df382=this[_0x29b0be(0x2e9)]();_0x3db26e[_0x29b0be(0x324)](_0x3df382,this[_0x29b0be(0x29a)],this[_0x29b0be(0x445)]());}else _0x3db26e[_0x29b0be(0x3bc)](this[_0x29b0be(0x29a)],this['color']());return _0x3db26e;}}class _0x1e238c extends _0x548dd9{[_0x1c233b(0x33e)](){const _0x1d72b2=_0x1c233b;this[_0x1d72b2(0x215)]()[_0x1d72b2(0x22a)]();}['isEnabled'](){const _0x58bfdb=_0x1c233b;return this[_0x58bfdb(0x215)]()[_0x58bfdb(0x42f)]();}[_0x1c233b(0x2d6)](){const _0x534f98=_0x1c233b,_0x58cece=this['symbol']();return _0x58cece&&Input[_0x534f98(0x2d6)](_0x58cece);}}class _0x1b42e6 extends _0x548dd9{[_0x1c233b(0x33e)](){const _0x414ec1=_0x1c233b;this[_0x414ec1(0x215)]()[_0x414ec1(0x2d4)]();}}class _0x3c43e3{constructor(_0x32ac49,_0x4b8f36,_0x2b3910,_0x3d14d1,_0x374387,_0x47fcd1){const _0x339200=_0x1c233b;this[_0x339200(0x240)]=_0x32ac49,this[_0x339200(0x304)]=_0x4b8f36,this[_0x339200(0x34e)]=_0x2b3910,this[_0x339200(0x208)]=_0x3d14d1,this[_0x339200(0x20e)]=_0x47fcd1,this[_0x339200(0x38f)]=_0x374387;}static[_0x1c233b(0x3af)](_0x102ed9,_0x51853f){const _0xbcba28=_0x1c233b;if(_0x102ed9){const _0x16fa11=JSON[_0xbcba28(0x341)](_0x102ed9),_0x5e9f22=Number(_0x16fa11[_0xbcba28(0x2d0)]),_0x38899f=Number(_0x16fa11['offsetY']),_0x54906c=_0x16fa11[_0xbcba28(0x325)],_0x45211b=Number(_0x16fa11[_0xbcba28(0x27c)]),_0x437c1a=Number(_0x16fa11[_0xbcba28(0x367)]||0x0);return new _0x3c43e3(_0x51853f,_0x5e9f22,_0x38899f,_0x54906c,_0x437c1a,_0x45211b);}return new _0x3c43e3(_0x51853f,0x0,0x0,_0xbcba28(0x3b2),0x0,0x0);}[_0x1c233b(0x2e3)](){const _0x530385=_0x1c233b;return $gameSwitches['value'](this[_0x530385(0x38f)]);}[_0x1c233b(0x344)](){const _0x17310a=_0x1c233b;return this[_0x17310a(0x240)][_0x17310a(0x236)](_0x46058c=>{const _0x47d788=_0x17310a;return _0x46058c[_0x47d788(0x375)]();});}[_0x1c233b(0x3ba)](){const _0x54022c=_0x1c233b;for(const _0x4d8bb6 of this['_list']){$gameSwitches['setValue'](_0x4d8bb6[_0x54022c(0x322)]()[_0x54022c(0x42d)](),!![]);}}[_0x1c233b(0x3fa)](){const _0x3cd721=_0x1c233b;for(const _0x3ad103 of this[_0x3cd721(0x240)]){if(SceneManager[_0x3cd721(0x214)]())return;_0x3ad103['updateInput']();}}[_0x1c233b(0x2d0)](){const _0x211dee=_0x1c233b;return this[_0x211dee(0x304)];}['offsetY'](){const _0x34e584=_0x1c233b;return this[_0x34e584(0x34e)];}[_0x1c233b(0x27e)](){const _0x5cb2be=_0x1c233b;return this[_0x5cb2be(0x208)]===_0x5cb2be(0x3b2);}['isAbsolute'](){const _0x2b9d44=_0x1c233b;return this[_0x2b9d44(0x208)]===_0x2b9d44(0x2e2);}[_0x1c233b(0x2c2)](){return new _0x269d2d(this);}}class _0x1b4030{constructor(_0x12df12,_0x48be56){const _0x23cd69=_0x1c233b;this['_voiceReg']=new RegExp('^'+_0x12df12+'.+'),this[_0x23cd69(0x437)]=new Set(_0x48be56);}static[_0x1c233b(0x3af)](_0x6f0bd){const _0x50a26c=_0x1c233b,_0xed1a6=JSON['parse'](_0x6f0bd),_0x43ffc1=_0xed1a6[_0x50a26c(0x336)],_0x404851=JSON['parse'](_0xed1a6[_0x50a26c(0x284)]);return new _0x1b4030(_0x43ffc1,_0x404851);}[_0x1c233b(0x2d2)](_0x36fe2c){const _0x3f49b1=_0x1c233b;if(this[_0x3f49b1(0x299)][_0x3f49b1(0x343)](_0x36fe2c))return!![];return this[_0x3f49b1(0x437)][_0x3f49b1(0x308)](_0x36fe2c);}}class _0x167e19{constructor(_0x1a76e5){const _0x4bf843=_0x1c233b;this[_0x4bf843(0x240)]=_0x1a76e5,this['_title']=_0x1a76e5[_0x4bf843(0x421)](),this[_0x4bf843(0x2ca)]=null;}[_0x1c233b(0x342)](){const _0x18428e=_0x1c233b;!this['_cache']&&(this[_0x18428e(0x2ca)]=this['_list'][_0x18428e(0x34f)]());}['title'](){const _0x1089e2=_0x1c233b;return this[_0x1089e2(0x3ff)];}['multiLineItems'](){if(this['_cache'])return this['_cache'];return[];}[_0x1c233b(0x338)](){const _0x550e02=_0x1c233b;return!this[_0x550e02(0x240)][_0x550e02(0x2ba)]();}}class _0x542885 extends Window_Selectable{constructor(_0xbf105a){const _0x55261a=_0x1c233b;super(_0xbf105a),this[_0x55261a(0x26b)](null),this['setList']([]);}[_0x1c233b(0x386)](_0x422dcd){const _0x45c43f=_0x1c233b;this[_0x45c43f(0x240)]=_0x422dcd[_0x45c43f(0x236)](_0xce6651=>new _0x167e19(_0xce6651)),this[_0x45c43f(0x267)]();}['maxItems'](){const _0x175157=_0x1c233b;return this[_0x175157(0x240)][_0x175157(0x1f3)];}[_0x1c233b(0x209)](_0x1ff134){const _0x590124=_0x1c233b,_0x5227a0=this['itemAt'](_0x1ff134);if(_0x5227a0){const _0x16f4e5=this[_0x590124(0x381)](_0x1ff134);this['drawTextEx'](_0x5227a0['title'](),_0x16f4e5['x'],_0x16f4e5['y'],_0x16f4e5[_0x590124(0x2c5)]);}}['callUpdateHelp'](){const _0x5d702e=_0x1c233b;super[_0x5d702e(0x37a)]();if(this[_0x5d702e(0x2dc)]){const _0x1cfe83=this[_0x5d702e(0x362)]();_0x1cfe83?(_0x1cfe83[_0x5d702e(0x342)](),this[_0x5d702e(0x2dc)][_0x5d702e(0x386)](_0x1cfe83[_0x5d702e(0x305)]())):this[_0x5d702e(0x2dc)]['setList']([]);}}[_0x1c233b(0x26b)](_0x876901){const _0x588c01=_0x1c233b;this[_0x588c01(0x2dc)]=_0x876901;}[_0x1c233b(0x2cd)](_0x4a589b){const _0x32abf8=_0x1c233b;return this[_0x32abf8(0x240)][_0x4a589b];}[_0x1c233b(0x362)](){const _0x36cfc3=_0x1c233b;return this[_0x36cfc3(0x2cd)](this[_0x36cfc3(0x2ac)]());}['isCurrentItemEnabled'](){const _0x59c8ad=_0x1c233b,_0x1391e7=this[_0x59c8ad(0x362)]();if(_0x1391e7&&_0x1391e7[_0x59c8ad(0x338)]())return!![];return![];}['selectLastItem'](){const _0x51a876=_0x1c233b,_0x14ef50=this[_0x51a876(0x2b4)]();_0x3430dd[_0x51a876(0x368)]()['forceSelect'](this,_0x14ef50-0x1);}}class _0x291b9f extends Window_Selectable{[_0x1c233b(0x36a)](_0x53543b){const _0x1b863b=_0x1c233b;_0x258ec8(this,_0x53543b,super[_0x1b863b(0x36a)]);
    }['numItemLines'](_0x470019){return 0x1;}[_0x1c233b(0x3fe)](_0x138032){return'';}[_0x1c233b(0x3d7)](_0xd9a99d){return _0xd9a99d;}[_0x1c233b(0x3ad)](_0x1a178a){const _0x4864e6=_0x1c233b,_0x579785=this[_0x4864e6(0x3d7)](_0x1a178a),_0x213901=this[_0x4864e6(0x3dd)](_0x1a178a);return _0x579785+_0x213901-0x1;}[_0x1c233b(0x31c)](){const _0x483f61=_0x1c233b;return _0x483f61(0x3cd)+this[_0x483f61(0x2ac)]()+'\x0ascroll:'+this[_0x483f61(0x1f9)];}[_0x1c233b(0x2da)](){const _0x554667=_0x1c233b;this['_helpWindow'][_0x554667(0x312)](this['makeStateText']());}[_0x1c233b(0x22b)](_0x4a0ae3){const _0x4c32bf=_0x1c233b;return super[_0x4c32bf(0x40c)](_0x4a0ae3);}[_0x1c233b(0x3f2)](){const _0x52a63c=_0x1c233b,_0x2242c4=Math[_0x52a63c(0x3d1)](0x0,this[_0x52a63c(0x2ac)]()),_0x789379=this[_0x52a63c(0x3d7)](_0x2242c4),_0x3d61fd=this[_0x52a63c(0x2b4)](),_0x288323=(_0x789379+_0x3d61fd-0x1)%_0x3d61fd,_0x1076a8=this[_0x52a63c(0x3d7)](_0x288323);if(_0x1076a8>_0x2242c4)return this[_0x52a63c(0x3ad)](_0x1076a8);return _0x1076a8;}[_0x1c233b(0x34c)](_0x5d9032){const _0x304f64=this['nextTopIndex']();this['smoothSelect'](_0x304f64);}['nextBottomIndex'](){const _0x2e6565=_0x1c233b,_0x263d26=Math[_0x2e6565(0x3d1)](0x0,this[_0x2e6565(0x2ac)]()),_0xd9ed27=this[_0x2e6565(0x3ad)](_0x263d26),_0xcabb59=this[_0x2e6565(0x2b4)](),_0x371e47=(_0xd9ed27+_0xcabb59+0x1)%_0xcabb59,_0x2c516e=this['bottomItemIndex'](_0x371e47);if(_0x2c516e>_0x263d26)return _0x2c516e;return this['topItemIndex'](_0x2c516e);}[_0x1c233b(0x3a0)](_0x1362c1){const _0x1ed506=_0x1c233b,_0x2318e1=this['nextBottomIndex']();this[_0x1ed506(0x2c4)](_0x2318e1);}[_0x1c233b(0x44a)](){const _0x3ab105=_0x1c233b;return this[_0x3ab105(0x433)]();}[_0x1c233b(0x228)](){const _0x51fbee=_0x1c233b,_0x5293ff=this[_0x51fbee(0x433)](),_0x133dca=this[_0x51fbee(0x3ec)]();return _0x5293ff+_0x133dca;}[_0x1c233b(0x275)](_0x1930c3){const _0x354412=_0x1c233b,_0x41b17d=this[_0x354412(0x323)](),_0x86fdc6=this[_0x354412(0x231)]()*0x2;return(_0x41b17d+_0x86fdc6)*_0x1930c3;}[_0x1c233b(0x40c)](_0x98451e){const _0x5057c5=_0x1c233b,_0x5c04a1=this[_0x5057c5(0x3d7)](_0x98451e),_0xdaff6c=this['baseRect'](_0x5c04a1),_0xef79e5=this[_0x5057c5(0x3dd)](_0x5c04a1),_0x2a2ce8=this[_0x5057c5(0x275)](_0xef79e5-0x1);return _0xdaff6c['height']+=_0x2a2ce8,_0xdaff6c;}[_0x1c233b(0x361)](_0x14a4ab){const _0x198109=_0x1c233b,_0x2799f2=this['baseRect'](_0x14a4ab),_0x517747=this[_0x198109(0x355)]();return _0x2799f2['x']+=_0x517747,_0x2799f2[_0x198109(0x2c5)]-=_0x517747*0x2,_0x2799f2;}['needsDrawBackground'](_0x37ddec){const _0x4879fa=this['topItemIndex'](_0x37ddec);return _0x4879fa===_0x37ddec;}['drawItemBackground'](_0x33d533){const _0x1e48e8=_0x1c233b;this['needsDrawBackground'](_0x33d533)&&super[_0x1e48e8(0x335)](_0x33d533);}[_0x1c233b(0x209)](_0x4f716c){const _0xacad74=_0x1c233b,_0x2afff3=this['lineText'](_0x4f716c);if(_0x2afff3){const _0xb7b00e=this[_0xacad74(0x361)](_0x4f716c);this[_0xacad74(0x1f2)](_0x2afff3,_0xb7b00e['x'],_0xb7b00e['y'],_0xb7b00e[_0xacad74(0x2c5)]);}}}class _0x28e1e4 extends _0x291b9f{[_0x1c233b(0x386)](_0x1f0106){this['_list']=_0x1f0106;}[_0x1c233b(0x3e0)](){const _0x2aa390=_0x1c233b;this[_0x2aa390(0x386)]([]);}[_0x1c233b(0x2b4)](){const _0xd9f264=_0x1c233b;return this['_list'][_0xd9f264(0x1f3)];}[_0x1c233b(0x2cd)](_0x447606){const _0x46763f=_0x1c233b;return this[_0x46763f(0x240)][_0x447606];}[_0x1c233b(0x362)](){const _0x2b156a=_0x1c233b;return this[_0x2b156a(0x2cd)](this[_0x2b156a(0x2ac)]());}['topItemIndex'](_0x1c63f3){const _0x370d4c=_0x1c233b,_0x4158ac=this[_0x370d4c(0x2cd)](_0x1c63f3);if(_0x4158ac)return _0x1c63f3-_0x4158ac['lineIndex']();return _0x1c63f3;}[_0x1c233b(0x3c9)](_0x13d26f){const _0x355b74=_0x1c233b,_0x2cd061=this[_0x355b74(0x2cd)](_0x13d26f);if(_0x2cd061)return _0x2cd061[_0x355b74(0x3c9)]();return![];}[_0x1c233b(0x3fe)](_0x573844){const _0x14b87=_0x1c233b,_0x26267b=this[_0x14b87(0x2cd)](_0x573844);if(_0x26267b)return _0x26267b[_0x14b87(0x2b0)]();return'';}[_0x1c233b(0x3dd)](_0x541a6c){const _0x19aa6b=_0x1c233b,_0x493317=this[_0x19aa6b(0x2cd)](_0x541a6c);if(_0x493317)return _0x493317[_0x19aa6b(0x3dd)]();return 0x1;}[_0x1c233b(0x231)](){return 0x0;}[_0x1c233b(0x1ea)](){return 0x4;}[_0x1c233b(0x323)](){const _0x5da0dc=_0x1c233b;return super[_0x5da0dc(0x323)]()+this[_0x5da0dc(0x1ea)]();}[_0x1c233b(0x28e)](){const _0x18ccc7=_0x1c233b;return this[_0x18ccc7(0x323)]();}}class _0x45f793 extends _0x28e1e4{[_0x1c233b(0x36a)](_0x41e7e3){const _0x53e59e=_0x1c233b;this[_0x53e59e(0x426)]=_0x3430dd[_0x53e59e(0x407)]()[_0x53e59e(0x2fc)](),super[_0x53e59e(0x36a)](_0x41e7e3),this[_0x53e59e(0x333)]();}[_0x1c233b(0x372)](){const _0x34ce56=_0x1c233b,_0x10d926=_0x3430dd[_0x34ce56(0x407)]()[_0x34ce56(0x2fc)](),_0x5ae290=_0x10d926[_0x34ce56(0x3cb)]();_0x5ae290?this[_0x34ce56(0x41a)]=_0x5ae290:super['loadWindowskin']();}[_0x1c233b(0x1ea)](){const _0x2613d0=_0x1c233b;return this[_0x2613d0(0x426)][_0x2613d0(0x436)]()[_0x2613d0(0x1ea)];}['makeItemList'](){
        const _0x3b3f8a=_0x1c233b,_0x1cdf1a=_0x3430dd[_0x3b3f8a(0x34f)]();this[_0x3b3f8a(0x386)](_0x1cdf1a);}[_0x1c233b(0x386)](_0x4c44cd){const _0x5a3f69=_0x1c233b;super[_0x5a3f69(0x386)](_0x4c44cd);for(const _0x5a7d16 of _0x4c44cd){_0x5a7d16&&ImageManager['loadFace'](_0x5a7d16[_0x5a3f69(0x226)]());}this[_0x5a3f69(0x267)]();}['playBuzzerSound'](){}['playOkSound'](){}[_0x1c233b(0x24c)](){const _0x20de13=_0x1c233b,_0x333f70=this[_0x20de13(0x2b4)]()-0x1;_0x3430dd[_0x20de13(0x368)]()['forceSelect'](this,_0x333f70);}['faceWidth'](){const _0x31d989=_0x1c233b;return ImageManager[_0x31d989(0x43d)];}[_0x1c233b(0x2f9)](){const _0x3c2075=_0x1c233b;return ImageManager[_0x3c2075(0x2f9)];}[_0x1c233b(0x2ff)](_0x2770f2){const _0x4fb450=_0x1c233b,_0x1108fe=this[_0x4fb450(0x2cd)](_0x2770f2),_0x1650a6=_0x1108fe?_0x1108fe[_0x4fb450(0x405)]():0x0,_0x38c14f=this[_0x4fb450(0x22b)](_0x2770f2-_0x1650a6),_0x1967b5=this[_0x4fb450(0x2f9)](),_0x14cde0=this[_0x4fb450(0x1ea)](),_0x845627=Math[_0x4fb450(0x281)](_0x14cde0*0x2,0x4);return _0x38c14f[_0x4fb450(0x2c5)]=this[_0x4fb450(0x43d)](),_0x38c14f['height']=_0x1967b5,_0x38c14f['x']+=this[_0x4fb450(0x227)](),_0x38c14f['y']+=_0x845627,_0x38c14f;}[_0x1c233b(0x3db)](_0xd3efe){const _0x3739d3=_0x1c233b,_0x4c6b94=this[_0x3739d3(0x2cd)](_0xd3efe);if(!_0x4c6b94[_0x3739d3(0x226)]())return![];if(_0x4c6b94['isTopItem']())return!![];const _0x14f561=this[_0x3739d3(0x433)]();if(_0xd3efe===_0x14f561)return!![];return![];}[_0x1c233b(0x2d3)](_0x22cb32){const _0x23343d=_0x1c233b;if(this[_0x23343d(0x3db)](_0x22cb32)){const _0x4ac112=this['faceRect'](_0x22cb32),_0x449428=this[_0x23343d(0x2cd)](_0x22cb32);this['drawFace'](_0x449428[_0x23343d(0x226)](),_0x449428[_0x23343d(0x412)](),_0x4ac112['x'],_0x4ac112['y'],_0x4ac112[_0x23343d(0x2c5)],_0x4ac112['height']);}}[_0x1c233b(0x3c7)](){const _0x5ed9d4=_0x1c233b;return ImageManager[_0x5ed9d4(0x3c7)];}[_0x1c233b(0x200)](_0x40c170,_0x588bb0){const _0x18c631=_0x1c233b,_0x42627b=_0x40c170['isIconLeft']()?_0x588bb0['x']:_0x588bb0['x']+_0x588bb0[_0x18c631(0x2c5)]-this['iconWidth']();this['drawIcon'](this[_0x18c631(0x426)][_0x18c631(0x3d6)](),_0x42627b,_0x588bb0['y']);}[_0x1c233b(0x209)](_0xa1b10c){const _0x4e1aee=_0x1c233b;this['callDrawFace'](_0xa1b10c);const _0x377709=this[_0x4e1aee(0x2cd)](_0xa1b10c);if(!_0x377709)return;const _0x4f26a6=this['itemRectForText'](_0xa1b10c);if(_0x377709[_0x4e1aee(0x3ee)]()){this[_0x4e1aee(0x200)](_0x377709,_0x4f26a6);if(_0x377709[_0x4e1aee(0x306)]()){const _0x49da60=this[_0x4e1aee(0x3c7)]();this[_0x4e1aee(0x1f2)](_0x377709[_0x4e1aee(0x2b0)](),_0x4f26a6['x']+_0x49da60,_0x4f26a6['y'],_0x4f26a6[_0x4e1aee(0x2c5)]-_0x49da60);return;}}super['drawItem'](_0xa1b10c);}['itemRectForText'](_0x370f3d){const _0x44be89=_0x1c233b,_0x34ea16=super[_0x44be89(0x361)](_0x370f3d),_0x53ce17=this[_0x44be89(0x2cd)](_0x370f3d);if(!!_0x53ce17[_0x44be89(0x226)]()){const _0x53c023=this[_0x44be89(0x43d)]();_0x34ea16[_0x44be89(0x2c5)]-=_0x53c023,_0x34ea16['x']+=_0x53c023+this[_0x44be89(0x227)]();}return _0x34ea16;}}class _0x40f8f2{constructor(_0xca3db2,_0xccbf7f,_0x2f8de7,_0x30d01e,_0x3326c1,_0x10c656){const _0x599bfc=_0x1c233b;this[_0x599bfc(0x241)]={'ja':_0xca3db2,'en':_0xccbf7f,'zh':_0x2f8de7,'ko':_0x30d01e,'de':_0x3326c1,'ru':_0x10c656},this[_0x599bfc(0x38e)](_0x599bfc(0x207)),_0x3a3085[_0x599bfc(0x3f5)](this);}static[_0x1c233b(0x3af)](_0x32ee56){const _0x4c6c8e=_0x1c233b,_0x10485c=JSON[_0x4c6c8e(0x341)](_0x32ee56);return new _0x40f8f2(_0x10485c[_0x4c6c8e(0x246)],_0x10485c[_0x4c6c8e(0x207)],_0x10485c[_0x4c6c8e(0x259)],_0x10485c[_0x4c6c8e(0x38d)],_0x10485c[_0x4c6c8e(0x376)],_0x10485c[_0x4c6c8e(0x383)]);}['text'](){const _0x248eba=_0x1c233b;return this[_0x248eba(0x32e)];}[_0x1c233b(0x297)](_0x7d7f0d){const _0x437448=_0x1c233b;if(_0x7d7f0d[_0x437448(0x439)](/^ja/))return this['_table']['ja'];if(_0x7d7f0d[_0x437448(0x439)](/^en/))return this['_table']['en'];if(_0x7d7f0d[_0x437448(0x439)](/^de/))return this[_0x437448(0x241)]['de'];if(_0x7d7f0d['match'](/^zh/))return this['_table']['zh'];return this[_0x437448(0x241)]['en'];}[_0x1c233b(0x38e)](_0x4d80bc){const _0x36a161=_0x1c233b;this[_0x36a161(0x32e)]=this['getCurrentText'](_0x4d80bc);}}class _0x5a96c8{constructor(){const _0x5d5b65=_0x1c233b;this[_0x5d5b65(0x240)]=[];}[_0x1c233b(0x31f)](){const _0x295f80=_0x1c233b;return $dataSystem[_0x295f80(0x247)];}[_0x1c233b(0x3f5)](_0x10dcdf){const _0x545b89=_0x1c233b;this[_0x545b89(0x240)][_0x545b89(0x2fe)](_0x10dcdf);}[_0x1c233b(0x267)](){const _0x5862f6=_0x1c233b,_0x5dfc4f=this['currentLocal']();for(const _0x528cdb of this[_0x5862f6(0x240)]){_0x528cdb[_0x5862f6(0x38e)](_0x5dfc4f);}}[_0x1c233b(0x3e1)](_0x2c8929){return;}}const _0x3a3085=new _0x5a96c8();class _0x5f2814{constructor(_0x41a904,_0x56730a){const _0x509e90=_0x1c233b;this[_0x509e90(0x22f)]=_0x41a904,this['_text']=_0x56730a;}[_0x1c233b(0x2b0)](){const _0x38e376=_0x1c233b;return this['_text'][_0x38e376(0x2b0)]();}}class _0x90ccf7{constructor(_0x22b3ec,_0x107d0a){const _0x16194e=_0x1c233b;this[_0x16194e(0x39e)]=_0x22b3ec;}[_0x1c233b(0x23a)](){return 0x140;}}class _0x629e52{constructor(){const _0x1b8d1f=_0x1c233b;this[_0x1b8d1f(0x3e0)](),this[_0x1b8d1f(0x32d)]=![];}[_0x1c233b(0x2ab)](_0x4ab6c2){this['_enabled']=_0x4ab6c2;}[_0x1c233b(0x3a2)](){const _0x4afafb=_0x1c233b;return this[_0x4afafb(0x32d)];}[_0x1c233b(0x257)](){const _0xeed418=_0x1c233b;this[_0xeed418(0x2ab)](!this['_enabled']);}['clear'](){const _0x34e600=_0x1c233b;this[_0x34e600(0x2df)](null),this[_0x34e600(0x260)]();}[_0x1c233b(0x260)](){this['_currentTime']=0x0;}['timerValue'](){const _0x28b27b=_0x1c233b;return this[_0x28b27b(0x2b3)];}[_0x1c233b(0x398)](){return this['_enabled'];}[_0x1c233b(0x35c)](_0x34f3a9){const _0x5d2949=_0x1c233b;this[_0x5d2949(0x32d)]&&(this['_currentTime']+=_0x34f3a9);}['onStartMessage'](){const _0xb296ea=_0x1c233b;this[_0xb296ea(0x260)]();}[_0x1c233b(0x22c)](){const _0x2bc564=_0x1c233b;this['_seBuffer']&&this[_0x2bc564(0x300)][_0x2bc564(0x392)]()&&(this[_0x2bc564(0x300)][_0x2bc564(0x28f)](),this['_seBuffer']=null);}[_0x1c233b(0x23c)](){const _0x354d37=_0x1c233b;this[_0x354d37(0x22c)](),this['resetTimer']();}[_0x1c233b(0x2f4)](){const _0x14be35=_0x1c233b;this[_0x14be35(0x300)]=null;}['setLastVoiceBuffer'](_0x25e8d1){const _0x4f3599=_0x1c233b;this[_0x4f3599(0x300)]=_0x25e8d1,_0x25e8d1&&_0x25e8d1['addStopListener'](this[_0x4f3599(0x2f4)][_0x4f3599(0x1f8)](this));}[_0x1c233b(0x29e)](){const _0x68c524=_0x1c233b;return!this[_0x68c524(0x300)];}['timeRate'](_0x140779){const _0x3114c7=_0x1c233b,_0x1e9071=this[_0x3114c7(0x2b3)]/_0x140779;return Math[_0x3114c7(0x281)](0x1,_0x1e9071);}[_0x1c233b(0x364)](_0x2fd1f3){const _0x3fac1f=_0x1c233b;if(this[_0x3fac1f(0x29e)]()){const _0x2aab64=this['timeRate'](_0x2fd1f3);if(_0x2aab64>=0x1)return!![];}return![];}}class _0x22ecb1{constructor(_0x1a46e0,_0x4006be,_0xa1199b){const _0x1774a3=_0x1c233b;this['_format']=_0x1a46e0,this[_0x1774a3(0x3e8)]=_0x4006be,this[_0x1774a3(0x3a1)]=_0xa1199b;}[_0x1c233b(0x2e4)](_0x44adab){const _0x256406=_0x1c233b,_0x28b492=this['_choiceText'][_0x256406(0x2b0)]();return this['_format']['format'](_0x28b492,_0x44adab);}['cancelText'](){const _0x53cad8=_0x1c233b;return this['_cancelText'][_0x53cad8(0x2b0)]();}}class _0x4f3505{constructor(_0x40000e,_0x358b81,_0x449cb0,_0x581d13,_0x2a3eaa,_0x26b1cd,_0x954436){const _0xda5e70=_0x1c233b;this[_0xda5e70(0x3c3)]=_0x40000e,this[_0xda5e70(0x2d1)]=_0x358b81||null,this[_0xda5e70(0x389)]=_0x581d13||null,this[_0xda5e70(0x37f)]=_0x2a3eaa||null,this[_0xda5e70(0x448)]=_0x449cb0,this[_0xda5e70(0x2e0)]=_0x26b1cd,this[_0xda5e70(0x334)]=_0x954436;}static[_0x1c233b(0x3af)](_0x2f2727,_0x45d5fb){const _0x43588=_0x1c233b,_0x20229e=JSON[_0x43588(0x341)](_0x2f2727),_0x42271e=_0x20229e[_0x43588(0x3cc)],_0x1b7567=_0x20229e[_0x43588(0x410)],_0x1a8605=_0x20229e[_0x43588(0x406)],_0xdcac6b=Number(_0x20229e[_0x43588(0x3a8)]),_0xa4fbba=_0x20229e[_0x43588(0x3e7)]?_0x14f903(_0x20229e[_0x43588(0x2e5)][_0x43588(0x3e7)]):null,_0x2afa83=_0x20229e[_0x43588(0x301)]?_0x14f903(_0x20229e[_0x43588(0x301)]):null,_0x3d48c5=_0x20229e['freamColor']||null,_0x5e9e10=Number(_0x20229e[_0x43588(0x1ea)]||0x2),_0xfd7cd8={'voiceIcon':_0xdcac6b,'numFaceLines':0x4,'lineSpacing':_0x5e9e10,'speakerNameFormat':_0x1b7567};return new _0x4f3505(_0xfd7cd8,_0x42271e,_0x2afa83,_0x1a8605,_0x3d48c5,_0xa4fbba,_0x45d5fb[_0x43588(0x397)]);}[_0x1c233b(0x3d6)](){const _0x4318aa=_0x1c233b;return this[_0x4318aa(0x3c3)][_0x4318aa(0x3d6)];}[_0x1c233b(0x436)](){const _0x1f242d=_0x1c233b;return this[_0x1f242d(0x3c3)];}[_0x1c233b(0x222)](){const _0x26fa3f=_0x1c233b;if(this[_0x26fa3f(0x448)])return this[_0x26fa3f(0x448)][_0x26fa3f(0x2d5)]();return null;}[_0x1c233b(0x1fd)](){const _0x330bdb=_0x1c233b;if(this[_0x330bdb(0x389)])return ImageManager[_0x330bdb(0x26e)](this[_0x330bdb(0x389)]);return null;}[_0x1c233b(0x3cb)](){const _0x29f39d=_0x1c233b;if(this['_windowFileName'])return ImageManager['loadSystem'](this[_0x29f39d(0x2d1)]);return null;}[_0x1c233b(0x355)](){return 0x8;}[_0x1c233b(0x3be)](){const _0x30f1f9=_0x1c233b;return this['_itemstyle'][_0x30f1f9(0x3be)];}[_0x1c233b(0x2e4)](_0x3c1b8f){const _0x32aea6=_0x1c233b;return this['_choiceStyle'][_0x32aea6(0x2e4)](_0x3c1b8f);}['cancelText'](){const _0x50c606=_0x1c233b,_0x418b92=this[_0x50c606(0x334)][_0x50c606(0x1e6)]();return this[_0x50c606(0x2e4)](_0x418b92);}[_0x1c233b(0x35a)](){return 0x4;}[_0x1c233b(0x242)](){const _0x533708=_0x1c233b;return this[_0x533708(0x37f)];}}class _0x5f2fe2{constructor(_0xd7ce30,_0xf630b9){const _0xa5d6a0=_0x1c233b;this['_logWrite']=_0xd7ce30,this[_0xa5d6a0(0x30a)]=_0xf630b9;}[_0x1c233b(0x3ba)](){const _0x3a637f=_0x1c233b;for(const _0x3e1948 of[this[_0x3a637f(0x3fd)],this['_macinakaMode']]){$gameSwitches['setValue'](_0x3e1948,!![]);}}[_0x1c233b(0x1e7)](){const _0x4bf654=_0x1c233b;return this[_0x4bf654(0x3a5)](this[_0x4bf654(0x30a)]);}[_0x1c233b(0x1ec)](){const _0x4e34dd=_0x1c233b;return this[_0x4e34dd(0x3a5)](this['_logWrite']);}[_0x1c233b(0x3a5)](_0x4834c8){
            const _0x411f27=_0x1c233b;if(_0x4834c8<=0x0)return!![];return $gameSwitches[_0x411f27(0x25b)](_0x4834c8);}}class _0x44a8ef{constructor(_0x39dcb2,_0x38ee1d,_0x19cdd4){const _0x238373=_0x1c233b;this[_0x238373(0x26a)]=_0x39dcb2,this[_0x238373(0x25e)]=_0x38ee1d,this['_numLines']=_0x19cdd4;}[_0x1c233b(0x20d)](){const _0x55633a=_0x1c233b;$gameSwitches[_0x55633a(0x384)](this[_0x55633a(0x26a)],this[_0x55633a(0x25e)]);}[_0x1c233b(0x35d)](){const _0x513c5b=_0x1c233b;if(this[_0x513c5b(0x26a)]>0x0)return $gameSwitches['value'](this[_0x513c5b(0x26a)]);return this[_0x513c5b(0x25e)];}}class _0x35f8c0{constructor(_0x4f9766,_0x2a0dc6,_0x55c681,_0x1c6872,_0x675c2b,_0xc29105,_0x28119c,_0x398b0c){const _0x38b964=_0x1c233b;this['_logSwitch']=_0x1c6872,this[_0x38b964(0x3c6)]=_0x4f9766,this['_logWriteOnBattle']=_0x675c2b,this['_logStyle']=_0x2a0dc6,this[_0x38b964(0x39b)]=_0x55c681,this[_0x38b964(0x3bf)]=_0xc29105,this[_0x38b964(0x340)]=_0x28119c,this[_0x38b964(0x3ab)]=_0x398b0c;}[_0x1c233b(0x3ba)](){const _0x2f9fcf=_0x1c233b;this[_0x2f9fcf(0x33d)][_0x2f9fcf(0x3ba)](),this[_0x2f9fcf(0x3ab)][_0x2f9fcf(0x20d)]();}[_0x1c233b(0x2fc)](){const _0x388157=_0x1c233b;return this[_0x388157(0x41c)];}[_0x1c233b(0x2e4)](_0x5d6a6a){const _0x24b75b=_0x1c233b;return this[_0x24b75b(0x41c)][_0x24b75b(0x2e4)](_0x5d6a6a);}['autoTime'](){const _0x3ae3e2=_0x1c233b;return this[_0x3ae3e2(0x39b)][_0x3ae3e2(0x23a)]();}[_0x1c233b(0x1ec)](){const _0x552569=_0x1c233b;if(!this['_logWriteOnBattle']){if($gameParty['inBattle']())return![];}return this[_0x552569(0x33d)][_0x552569(0x1ec)]();}[_0x1c233b(0x34d)](){const _0x17e19e=_0x1c233b;return this['_machinakaMode'][_0x17e19e(0x35d)]();}[_0x1c233b(0x428)](){return!![];}[_0x1c233b(0x2d2)](_0xbf048f){const _0x5e88cc=_0x1c233b;if(_0xbf048f)return this[_0x5e88cc(0x3c6)]['isVoiceFile'](_0xbf048f[_0x5e88cc(0x289)]);return![];}['optionNormalize'](_0x3448e2){const _0x2e0bf2=_0x1c233b,_0x30a951={'keepingAutoMode':!!_0x3448e2[_0x2e0bf2(0x3ef)],'autoWaitTime':_0x5adfd9(_0x3448e2[_0x2e0bf2(0x20a)],this[_0x2e0bf2(0x3bf)]['autoWaitTime']),'logLimitBasic':_0x5adfd9(_0x3448e2[_0x2e0bf2(0x441)],this[_0x2e0bf2(0x3bf)][_0x2e0bf2(0x441)]),'logLimitExtends':_0x5adfd9(_0x3448e2[_0x2e0bf2(0x219)],this[_0x2e0bf2(0x3bf)][_0x2e0bf2(0x219)]),'gaugeColor':_0x5adfd9(_0x3448e2['gaugeColor'],this['_defaultOption'][_0x2e0bf2(0x373)]),'machinakaLines':_0x5adfd9(_0x3448e2[_0x2e0bf2(0x294)],this['_defaultOption']['machinakaLines'])};return _0x30a951;}['cloneDefaultOption'](){const _0x4c3058=_0x1c233b;return this[_0x4c3058(0x319)](this[_0x4c3058(0x3bf)]);}[_0x1c233b(0x31a)](){const _0x4e3e03=_0x1c233b;return this[_0x4e3e03(0x340)];}}function _0x5adfd9(_0x3cbdef,_0x143e82){return isNaN(_0x3cbdef)?_0x143e82:Number(_0x3cbdef);}class _0x65ecfd{constructor(){const _0x5cf1e7=_0x1c233b;this[_0x5cf1e7(0x3e0)]();}['clear'](){const _0x5d9c44=_0x1c233b;this[_0x5d9c44(0x24e)]=null,this['_logItem']=null,this['_se']=null;}[_0x1c233b(0x3f4)](_0x132fff){const _0x248e6b=_0x1c233b;this[_0x248e6b(0x238)]&&this[_0x248e6b(0x238)][_0x248e6b(0x3f4)](_0x132fff);}[_0x1c233b(0x253)](_0x22e260,_0x225e21,_0x28ccd3){const _0xf0f21b=_0x1c233b;this[_0xf0f21b(0x238)]&&this['_logItem']['startMessage'](_0x22e260,_0x225e21,_0x28ccd3);}['setTextV8'](_0x43aefb){const _0x38db4b=_0x1c233b;this[_0x38db4b(0x238)]&&this[_0x38db4b(0x238)]['writeTextV8'](_0x43aefb);}[_0x1c233b(0x312)](_0x5e5ee1,_0x5da2ec,_0xa8ba0,_0x38af59){const _0x429f9b=_0x1c233b;this[_0x429f9b(0x238)]&&this['_logItem'][_0x429f9b(0x43a)](_0x5e5ee1,_0x5da2ec,_0xa8ba0,_0x38af59,this[_0x429f9b(0x32f)]);}[_0x1c233b(0x317)](){const _0xdad355=_0x1c233b;return this[_0xdad355(0x238)];}[_0x1c233b(0x2d9)](_0x583fd8){const _0x4d7efd=_0x1c233b;if(!_0x583fd8){this[_0x4d7efd(0x32f)]=null;return;}const _0x1d1ab6={'name':_0x583fd8['name'],'pan':_0x583fd8[_0x4d7efd(0x3ca)],'pitch':_0x583fd8[_0x4d7efd(0x252)],'pos':_0x583fd8[_0x4d7efd(0x415)]||0x0,'volume':_0x583fd8[_0x4d7efd(0x216)]};this['_se']=_0x1d1ab6;}[_0x1c233b(0x40a)](){const _0x4e1b80=_0x1c233b;return!!this[_0x4e1b80(0x32f)];}[_0x1c233b(0x3c5)](){}[_0x1c233b(0x345)](){return!!this['_logItem'];}[_0x1c233b(0x318)](){const _0x3755e7=_0x1c233b;this[_0x3755e7(0x3e0)]();}['open'](){const _0x5dd8fa=_0x1c233b;this[_0x5dd8fa(0x238)]=new MultiLine_Message();}}class _0x12bab4{constructor(){const _0x416fd5=_0x1c233b;this[_0x416fd5(0x220)]=new _0x65ecfd();}}class _0x1a784c{constructor(){const _0x22f01a=_0x1c233b;this['setBattleMode'](![]),this[_0x22f01a(0x3c8)](![]),this[_0x22f01a(0x35b)](![]),this[_0x22f01a(0x2a9)](![]),this[_0x22f01a(0x2ee)](NaN);}[_0x1c233b(0x2ee)](_0x2ef6cc){const _0x568fa1=_0x1c233b;this[_0x568fa1(0x33f)]=_0x2ef6cc;}[_0x1c233b(0x2a9)](_0x18d7e9){this['_textTerminate']=!!_0x18d7e9;}['setParallelMode'](_0x6d1929){const _0x3cc7f4=_0x1c233b;this[_0x3cc7f4(0x411)]=_0x6d1929,this[_0x3cc7f4(0x1eb)]=!![];}[_0x1c233b(0x428)](){const _0x1a7383=_0x1c233b;return!this[_0x1a7383(0x411)];}[_0x1c233b(0x3c8)](_0x2ed84b){const _0x1b3bfa=_0x1c233b;this[_0x1b3bfa(0x3ed)]=!!_0x2ed84b;}[_0x1c233b(0x3e3)](){const _0x31ff08=_0x1c233b;return this[_0x31ff08(0x3ed)];}[_0x1c233b(0x1ff)](_0x3c831f){this['_battleMode']=_0x3c831f;}[_0x1c233b(0x29d)](){const _0x3a6869=_0x1c233b;return this[_0x3a6869(0x3bd)];}}class _0x5aebae{constructor(_0x2d2e38){const _0x5b58d1=_0x1c233b;this[_0x5b58d1(0x29c)](_0x2d2e38);}[_0x1c233b(0x221)](){const _0x158e3b=_0x1c233b;return this[_0x158e3b(0x29f)]['logLimitExtends'];}[_0x1c233b(0x316)](){const _0x4b91f7=_0x1c233b;return this[_0x4b91f7(0x29f)][_0x4b91f7(0x441)];}[_0x1c233b(0x2bd)](){const _0x142475=_0x1c233b;return this[_0x142475(0x2ef)]();}['defaultQuickSaveFileName'](){const _0x26a844=_0x1c233b;return _0x26a844(0x2fb);}[_0x1c233b(0x29c)](_0x6c3980){const _0x42ad00=_0x1c233b;this[_0x42ad00(0x29f)]=_0x6c3980;}[_0x1c233b(0x232)](_0x44c0a4){const _0x1883d9=_0x1c233b;!isNaN(_0x44c0a4)&&(this[_0x1883d9(0x29f)][_0x1883d9(0x219)]=Math[_0x1883d9(0x3d1)](0xa,_0x44c0a4));}['getLogLimitSizeBasic'](){const _0x47746c=_0x1c233b;return this['_value'][_0x47746c(0x441)];}[_0x1c233b(0x365)](_0x3e3a0d){const _0x5e1471=_0x1c233b;!isNaN(_0x3e3a0d)&&(this[_0x5e1471(0x29f)][_0x5e1471(0x219)]=Math['max'](0x4,_0x3e3a0d));}[_0x1c233b(0x206)](){const _0x47007f=_0x1c233b;return this[_0x47007f(0x29f)][_0x47007f(0x219)];}['getAutoWaitTime'](){const _0x356c6e=_0x1c233b;return this['_value'][_0x356c6e(0x20a)];}['setAutoWaitTime'](_0xd8610f){const _0x47940e=_0x1c233b;!Number[_0x47940e(0x3b8)](_0xd8610f)&&(this[_0x47940e(0x29f)]['autoWaitTime']=Math[_0x47940e(0x3d1)](0xa,_0xd8610f));}['getKeepingAutoMode'](){const _0x4ccb91=_0x1c233b;return!!this['_value'][_0x4ccb91(0x3ef)];}[_0x1c233b(0x3b4)](){const _0x3cffb5=_0x1c233b;return this[_0x3cffb5(0x29f)][_0x3cffb5(0x373)];}[_0x1c233b(0x294)](){const _0x105cc0=_0x1c233b;return this[_0x105cc0(0x29f)][_0x105cc0(0x294)];}['cloneValue'](){const _0x538dbf=_0x1c233b;return{'keepingAutoMode':this[_0x538dbf(0x29f)][_0x538dbf(0x3ef)],'logLimitBasic':this[_0x538dbf(0x29f)][_0x538dbf(0x441)],'logLimitExtends':this['_value'][_0x538dbf(0x219)],'autoWaitTime':this[_0x538dbf(0x29f)][_0x538dbf(0x20a)],'gaugeColor':this[_0x538dbf(0x29f)][_0x538dbf(0x373)],'machinakaLines':this['_value'][_0x538dbf(0x294)]};}}class _0x216055{constructor(){const _0x31a497=_0x1c233b;this[_0x31a497(0x39c)]=new Set();}[_0x1c233b(0x2d2)](_0xd0bd38){}}class _0x22e8c6{constructor(){const _0x3b0a69=_0x1c233b;this[_0x3b0a69(0x31d)](_0x5eaa6b=>{const _0x1e79d1=_0x3b0a69,_0xdb036=new _0x58c1cc(_0x5eaa6b[_0x1e79d1(0x21a)]),_0x2445fa=ImageManager[_0x1e79d1(0x26e)](_0x5eaa6b['fileName']);return _0xdb036[_0x1e79d1(0x324)](_0x2445fa,_0x5eaa6b['lineWidth'],_0x5eaa6b[_0x1e79d1(0x445)]),_0xdb036;});}[_0x1c233b(0x31d)](_0xb1eb29){const _0x58d9be=_0x1c233b;this[_0x58d9be(0x2f1)]=_0xb1eb29;}[_0x1c233b(0x430)](_0x5553de){const _0xa8e167=_0x1c233b;if(this[_0xa8e167(0x2f1)]){const _0x4c4561=this[_0xa8e167(0x2f1)](_0x5553de);return _0x4c4561[_0xa8e167(0x384)](0x0),_0x4c4561;}return null;}}function _0x27ddcc(_0x34ffc2){const _0x5521da=_0x1c233b;let _0x54f928=_0x34ffc2;for(let _0xb8335b=0x0;_0xb8335b<0x64;++_0xb8335b){const _0x53ca10=$dataMapInfos[_0x54f928];if(!_0x53ca10)return _0x54f928;_0x54f928=_0x53ca10[_0x5521da(0x3de)];}return 0x0;}class _0x4c0e1a{constructor(){const _0x3aedf4=_0x1c233b;this[_0x3aedf4(0x24d)](0x0);}['setRootMap'](_0x325315){const _0x1b3132=_0x1c233b;this[_0x1b3132(0x315)]=_0x325315;}[_0x1c233b(0x347)](){}}function _0x4b9bdf(){const _0x57112c=_0x1c233b;let _0x582460=$gameMap[_0x57112c(0x2dd)];for(let _0x162b87=0x0;_0x162b87<0x3f2;++_0x162b87){if(!_0x582460[_0x57112c(0x2cc)])return _0x582460;_0x582460=_0x582460[_0x57112c(0x2cc)];}return null;}class _0x5f7514{[_0x1c233b(0x218)](){return _0x556c6a;}constructor(_0x58882d,_0x19d3ea,_0x3e7ce0){const _0x429681=_0x1c233b;this[_0x429681(0x3fb)](_0x58882d),this['_contents']=null,this[_0x429681(0x3d4)]=new _0x629e52(),this[_0x429681(0x393)](),this['_readOnlyData']=_0x19d3ea,this['_option']=new _0x5aebae(_0x19d3ea[_0x429681(0x249)]()),this[_0x429681(0x3d8)]=_0x3e7ce0;}[_0x1c233b(0x41e)](_0x3aca5d){}['setOptionValue'](_0x1d5ea6){const _0x146c1b=_0x1c233b;if(_0x1d5ea6){const _0x2b247f=this[_0x146c1b(0x2f0)][_0x146c1b(0x319)](_0x1d5ea6);this['_option'][_0x146c1b(0x29c)](_0x2b247f);}else this[_0x146c1b(0x27b)]['setOptionValue'](this[_0x146c1b(0x2f0)][_0x146c1b(0x249)]());}['cloneOptionValue'](){const _0x5701f4=_0x1c233b,_0xa3f622=this[_0x5701f4(0x27b)][_0x5701f4(0x425)]();return this[_0x5701f4(0x2f0)][_0x5701f4(0x319)](_0xa3f622);}['option'](){return this['_option'];}['openOptionScene'](){}['getLogItemStyle'](){const _0x15e11b=_0x1c233b;return this[_0x15e11b(0x407)]()[_0x15e11b(0x2fc)]()[_0x15e11b(0x436)]();}[_0x1c233b(0x3fb)](_0x4722b5){const _0x395e2c=_0x1c233b;this[_0x395e2c(0x2a4)]=_0x4722b5;}['getWorkaround'](){return this['_workaround'];}['setEventUniqueId'](_0x1596d8){this['_eventUniqueId']=_0x1596d8;}[_0x1c233b(0x20c)](_0x18052c,_0x410dfa){
                const _0x146283=_0x1c233b;this[_0x146283(0x3e9)][_0x146283(0x2fd)](_0x410dfa,_0x18052c[_0x146283(0x2e8)]());}[_0x1c233b(0x21f)](){const _0xc0b73d=_0x1c233b;return this[_0xc0b73d(0x2a7)]()[_0xc0b73d(0x21f)]();}[_0x1c233b(0x2b1)](_0x13ae84){const _0x297744=_0x1c233b,_0x500dc7=this[_0x297744(0x2a7)]();}['nameIsMeetsTitle'](_0xef523){const _0x342bb7=_0x1c233b,_0xf9e4f1=_0xef523[_0x342bb7(0x2ad)]()['name'];if(!_0xf9e4f1)return![];if(_0xf9e4f1['match'](/^EV\d{1,3}/))return![];return!![];}['createEmptySaveContents'](){const _0x388bfe=_0x1c233b;return new Log_ContentsObject(this[_0x388bfe(0x218)]());}[_0x1c233b(0x40e)](){const _0x280a03=_0x1c233b;this[_0x280a03(0x21b)](this['createEmptySaveContents']());}[_0x1c233b(0x1fe)](){const _0x5d9807=_0x1c233b,_0x3828b0=this[_0x5d9807(0x204)]();this[_0x5d9807(0x3e9)]['checkLogSize'](_0x3828b0[_0x5d9807(0x316)](),_0x3828b0[_0x5d9807(0x221)]());}[_0x1c233b(0x21b)](_0x4224d9){const _0x3be97c=_0x1c233b;this[_0x3be97c(0x3e9)]=_0x4224d9,this['makeSaveContents']();}[_0x1c233b(0x263)](){const _0x2c5232=_0x1c233b;return this[_0x2c5232(0x3e9)][_0x2c5232(0x320)]();}[_0x1c233b(0x2a7)](){const _0x5d26ff=_0x1c233b;return this[_0x5d26ff(0x3e9)];}['makeSaveContents'](){const _0xfb965=_0x1c233b;!this[_0xfb965(0x3e9)]&&(this[_0xfb965(0x3e9)]=this['createEmptySaveContents']());}[_0x1c233b(0x24a)](_0x588c41){const _0x1edbc8=_0x1c233b;if(!_0x588c41)return!![];try{const _0x1708c8=_0x588c41['version']();if(_0x1708c8!==this[_0x1edbc8(0x218)]())return![];this[_0x1edbc8(0x21b)](_0x588c41);}catch(_0x1c183d){return console[_0x1edbc8(0x309)](_0x1c183d),console[_0x1edbc8(0x309)](_0x588c41),![];}const _0x19ef85=_0x588c41[_0x1edbc8(0x1ef)](),_0x320b43=_0x4b9bdf();return!isNaN(_0x19ef85)&&_0x320b43&&_0x320b43['isRunning']()&&_0x320b43[_0x1edbc8(0x254)](_0x19ef85),!![];}[_0x1c233b(0x39f)](_0x4281a3){const _0x2e33f5=_0x1c233b;this[_0x2e33f5(0x393)](),this[_0x2e33f5(0x3e9)]=null;const _0x9e2c2=_0x4281a3[_0x2e33f5(0x351)],_0x5e23ed=this['tryReadingSaveContents'](_0x9e2c2);this[_0x2e33f5(0x424)]();if(!_0x5e23ed){}}[_0x1c233b(0x393)](){const _0x5d5e4b=_0x1c233b;this[_0x5d5e4b(0x3d4)][_0x5d5e4b(0x2df)](null),this[_0x5d5e4b(0x2c7)]=new _0x1a784c(),this[_0x5d5e4b(0x2a5)]=new _0x65ecfd();}['onNewGame'](){const _0x385d33=_0x1c233b;this[_0x385d33(0x3d8)][_0x385d33(0x3ba)](),this[_0x385d33(0x2f0)][_0x385d33(0x3ba)](),this['resetTemporaly'](),this[_0x385d33(0x40e)]();}[_0x1c233b(0x3ae)](){}[_0x1c233b(0x407)](){const _0x2eebcb=_0x1c233b;return this[_0x2eebcb(0x2f0)];}[_0x1c233b(0x294)](){const _0x4a2ef2=_0x1c233b;return this['_option'][_0x4a2ef2(0x294)]();}[_0x1c233b(0x2cb)](){const _0x221927=_0x1c233b,_0x604162=this[_0x221927(0x3d8)];if(_0x604162['isInside']())return new _0x20a9bc(_0x604162);if(_0x604162[_0x221927(0x3f7)]())return new _0x4d361f(_0x604162);return new _0x269d2d(_0x604162);}[_0x1c233b(0x3be)](){const _0x5dc6a6=_0x1c233b;return this[_0x5dc6a6(0x2f0)][_0x5dc6a6(0x2fc)]()[_0x5dc6a6(0x3be)]();}[_0x1c233b(0x2e4)](_0x4bd7ec){const _0x2944b0=_0x1c233b;return this[_0x2944b0(0x2f0)]['createChoiceItemText'](_0x4bd7ec);}[_0x1c233b(0x35b)](_0xfcd539){const _0x22a50f=_0x1c233b;this[_0x22a50f(0x2c7)][_0x22a50f(0x35b)](_0xfcd539);}[_0x1c233b(0x428)](){const _0x6d4864=_0x1c233b;return $gameSystem[_0x6d4864(0x35f)]()&&this['_temporaly']['canSave']()&&this[_0x6d4864(0x2f0)][_0x6d4864(0x428)]();}[_0x1c233b(0x271)](_0x4c1b93){const _0x51c550=_0x1c233b;_0x4c1b93['messageLog']=this[_0x51c550(0x30b)]();}[_0x1c233b(0x339)](_0x215df8){const _0x45bd9e=_0x1c233b;SceneManager[_0x45bd9e(0x2fe)](_0x215df8),this[_0x45bd9e(0x2c7)][_0x45bd9e(0x3c8)](!![]);}[_0x1c233b(0x3e3)](){const _0x4ec510=_0x1c233b;return this[_0x4ec510(0x2c7)]['needsShowFast']();}[_0x1c233b(0x38c)](){const _0x211890=_0x1c233b;if($gameMessage[_0x211890(0x380)]()||$gameMessage[_0x211890(0x408)]())return![];return!![];}['updateInput'](){const _0x21b677=_0x1c233b;this['isInputEnabled']()&&this['_buttons'][_0x21b677(0x3fa)]();}[_0x1c233b(0x30f)](){return 0x1;}[_0x1c233b(0x24f)](){}[_0x1c233b(0x371)](){const _0x8cae39=_0x1c233b;this['_autoXXX'][_0x8cae39(0x3e0)]();}[_0x1c233b(0x237)](){const _0x849b20=_0x1c233b;return this[_0x849b20(0x3d4)]['timeRate'](this[_0x849b20(0x27b)][_0x849b20(0x382)]());}[_0x1c233b(0x29b)](){const _0xbe6dbb=_0x1c233b;this[_0xbe6dbb(0x3d4)][_0xbe6dbb(0x35c)](0x1);}[_0x1c233b(0x29e)](){const _0x4799dd=_0x1c233b;return this[_0x4799dd(0x3d4)][_0x4799dd(0x29e)]();}['needsTextTerminate'](){const _0x5dd683=_0x1c233b,_0x4bbb13=this[_0x5dd683(0x27b)][_0x5dd683(0x382)]();return this[_0x5dd683(0x3d4)][_0x5dd683(0x364)](_0x4bbb13+0x14);}[_0x1c233b(0x3f4)](_0x58c48c){const _0x34467b=_0x1c233b;this[_0x34467b(0x2a5)][_0x34467b(0x3f4)](_0x58c48c);}['onEnedOfText'](){const _0xd59cbe=_0x1c233b,_0xa87383=this[_0xd59cbe(0x2a5)]['getLogItem']();_0xa87383&&this[_0xd59cbe(0x283)](_0xa87383),this[_0xd59cbe(0x2a5)][_0xd59cbe(0x318)]();}[_0x1c233b(0x253)](_0x31ba4a,_0x27299b){const _0x2a7065=_0x1c233b,_0x1597c9=$gameMessage['faceName'](),_0x78a16d=$gameMessage[_0x2a7065(0x412)]();this[_0x2a7065(0x2a5)][_0x2a7065(0x312)](_0x31ba4a,_0x27299b,_0x1597c9,_0x78a16d),this[_0x2a7065(0x3d4)]['onStartMessage'](),this[_0x2a7065(0x2c7)][_0x2a7065(0x3c8)](![]);}[_0x1c233b(0x280)](_0x14ecb2){const _0x545dbe=_0x1c233b;this[_0x545dbe(0x2a5)][_0x545dbe(0x28b)](_0x14ecb2);}['onTerminateMessage'](){this['_autoXXX']['onTerminateMessage']();}[_0x1c233b(0x1f5)](_0x252249){const _0x535645=_0x1c233b,_0x212576=this[_0x535645(0x2a7)]();_0x212576['lastCodeIndex']()===_0x252249?(this['repeatLastVoice'](),this[_0x535645(0x2a5)]['close']()):(_0x212576[_0x535645(0x1f5)](_0x252249),this['isLogWriteEnabled']()&&this[_0x535645(0x2a5)][_0x535645(0x2f3)]());}['createProxy'](){const _0x3438c5=_0x1c233b;return this[_0x3438c5(0x2a7)]()['createProxy']();}[_0x1c233b(0x1ff)](_0x215481){const _0x1b87ad=_0x1c233b;this[_0x1b87ad(0x2c7)][_0x1b87ad(0x1ff)](_0x215481);}[_0x1c233b(0x32b)](){const _0xa9070a=_0x1c233b;return!this['_temporaly'][_0xa9070a(0x29d)]();}[_0x1c233b(0x1ec)](){const _0x2f70cf=_0x1c233b;return this['_readOnlyData'][_0x2f70cf(0x1ec)]();}['isLogSaveEnabled'](){const _0x191a8e=_0x1c233b;if(Utils[_0x191a8e(0x3dc)]())return!![];if(Utils[_0x191a8e(0x3b9)]())return!![];return![];}[_0x1c233b(0x30b)](){const _0x160c15=_0x1c233b;if(this['isLogSaveEnabled']())return this[_0x160c15(0x3e9)];return this['_contents'][_0x160c15(0x268)]();}[_0x1c233b(0x22a)](){const _0xd534ea=_0x1c233b;if(this[_0xd534ea(0x29e)]()){const _0x5633ac=this['getContents']()[_0xd534ea(0x332)]();_0x5633ac&&ManoUZ_MessageLog[_0xd534ea(0x3eb)](_0x5633ac,{});}}[_0x1c233b(0x42f)](){const _0xe34c07=_0x1c233b;if(this[_0xe34c07(0x2a5)][_0xe34c07(0x40a)]())return!![];const _0x2872ee=this['getContents'](),_0x35b690=_0x2872ee[_0xe34c07(0x332)]();return!!_0x35b690;}['onChoiceOk'](_0x1667cb,_0x4b4f55){const _0x528779=_0x1c233b;if(_0x1667cb===-0x2){const _0x4b9f41=this[_0x528779(0x407)]()['logStyle']()[_0x528779(0x1e6)](),_0x3a634f=new LogItem_Choice(_0x4b9f41,_0x1667cb);this[_0x528779(0x283)](_0x3a634f);return;}if(0x0<=_0x1667cb&&_0x1667cb<_0x4b4f55[_0x528779(0x2b4)]()){const _0x436993=_0x4b4f55['commandName'](_0x1667cb),_0x2dfaec=_0x4b4f55[_0x528779(0x449)](_0x436993),_0x504d63=this['readOnryData']()[_0x528779(0x2fc)]()[_0x528779(0x2e4)](_0x2dfaec),_0x4fe8f1=new LogItem_Choice(_0x504d63,_0x1667cb);this['addItem'](_0x4fe8f1);}}[_0x1c233b(0x283)](_0x5ed7f7){const _0x14c065=_0x1c233b;if(!this['isLogWriteEnabled']())return;const _0x52e08d=this['getContents']();_0x52e08d[_0x14c065(0x283)](_0x5ed7f7);}[_0x1c233b(0x211)](){const _0x2f29c5=_0x1c233b;return!isNaN(this[_0x2f29c5(0x3e9)][_0x2f29c5(0x1ef)]());}[_0x1c233b(0x2ed)](){const _0x46ab2a=_0x1c233b;this['_contents'][_0x46ab2a(0x234)](),this[_0x46ab2a(0x3e9)]['saveCurrentLog'](),this[_0x46ab2a(0x1fe)](),this[_0x46ab2a(0x2a5)][_0x46ab2a(0x3e0)](),this[_0x46ab2a(0x3a7)]();}[_0x1c233b(0x26c)](_0x192d15,_0x296c7f){const _0xcf74e3=_0x1c233b,_0x5b2230=this[_0xcf74e3(0x2f0)][_0xcf74e3(0x2d2)](_0x192d15);return _0x5b2230&&this[_0xcf74e3(0x2a5)][_0xcf74e3(0x2d9)](_0x192d15),_0x5b2230;}[_0x1c233b(0x2df)](_0x2bfb5e){const _0x3311ab=_0x1c233b;this[_0x3311ab(0x3d4)][_0x3311ab(0x2df)](_0x2bfb5e);}[_0x1c233b(0x2ab)](_0x49b683){const _0x4f8cfe=_0x1c233b;this[_0x4f8cfe(0x3d4)][_0x4f8cfe(0x2ab)](!!_0x49b683);}[_0x1c233b(0x3a2)](){const _0x463556=_0x1c233b;return this[_0x463556(0x3d4)][_0x463556(0x3a2)]();}[_0x1c233b(0x22d)](){const _0x37c43d=_0x1c233b;this[_0x37c43d(0x3d4)]['flipAutoMode']();}['needsAutoModeStop'](){const _0x2a74ba=_0x1c233b;if(this[_0x2a74ba(0x27b)]['getKeepingAutoMode']())return![];const _0x4c9615=$gameMap[_0x2a74ba(0x211)](),_0xf9e142=$gameMessage[_0x2a74ba(0x3e2)]();if(_0x4c9615)return![];if(_0xf9e142)return![];return!![];}['refreshAutoKeeping'](){const _0x11540f=_0x1c233b;this[_0x11540f(0x2be)]()&&this['_autoXXX'][_0x11540f(0x2ab)](![]);}[_0x1c233b(0x2f7)](){return this['_autoXXX']['isAutoMode']();}}function _0x207fa5(){return PluginManager['parameters'](_0x1a1516);}function _0x38100d(_0x5b0ae7){const _0x2cf5df=_0x1c233b,_0x99ed15=_0x26708e[_0x2cf5df(0x3af)](_0x5b0ae7['autoGauge']),_0x4c1c6b=new _0x10dc10(_0x99ed15,_0x7b9ba1[_0x2cf5df(0x3af)](_0x5b0ae7[_0x2cf5df(0x3c2)]),_0x2cf5df(0x359)),_0x32ad82=new _0x332892(_0x7b9ba1['create'](_0x5b0ae7['backlogButton']),_0x2cf5df(0x348)),_0x534eb5=new _0x58b818(_0x7b9ba1['create'](_0x5b0ae7[_0x2cf5df(0x387)]),_0x2cf5df(0x261)),_0x16ed52=new _0x5a898e(_0x7b9ba1[_0x2cf5df(0x3af)](_0x5b0ae7[_0x2cf5df(0x279)]),_0x2cf5df(0x374)),_0x14cbeb=new _0x1e238c(_0x7b9ba1[_0x2cf5df(0x3af)](_0x5b0ae7['voiceRepeatButton']),null),_0x2ca958=[_0x32ad82,_0x534eb5,_0x16ed52,_0x14cbeb,_0x4c1c6b][_0x2cf5df(0x396)](_0x57aac3=>{const _0x598a4f=_0x2cf5df;return _0x57aac3[_0x598a4f(0x233)]();}),_0x2c74fb=_0x3c43e3[_0x2cf5df(0x3af)](_0x5b0ae7['buttonSetting'],_0x2ca958);return _0x2c74fb;}function _0x728354(_0x53c555,_0x2879d1){
                    return{'logLimitBasic':_0x53c555||0x1e,'logLimitExtends':_0x53c555+0x4,'autoWaitTime':0x168,'keepingAutoMode':![],'gaugeColor':0xff0000,'machinakaLines':_0x2879d1||0x3};}const _0x3430dd=(function(){const _0x1bcd1b=_0x1c233b,_0x121a02=_0x207fa5(),_0x269e62=Number(_0x121a02[_0x1bcd1b(0x2a3)]||0x3),_0x367e59=Number(_0x121a02[_0x1bcd1b(0x3aa)]||0x0),_0x19c0dd=_0x1bcd1b(0x265)===_0x121a02[_0x1bcd1b(0x2c8)],_0x4dee84=new _0x44a8ef(_0x367e59,_0x19c0dd,_0x269e62),_0x4e6482=_0x728354(Number(_0x121a02[_0x1bcd1b(0x320)]||0x1e),_0x269e62),_0x259f9=_0x40f8f2['create'](_0x121a02['choiceText']),_0x5d62a1=String(_0x121a02[_0x1bcd1b(0x225)]),_0xa10fa2=_0x40f8f2[_0x1bcd1b(0x3af)](_0x121a02[_0x1bcd1b(0x399)]),_0x299d47=_0x4f3505[_0x1bcd1b(0x3af)](_0x121a02[_0x1bcd1b(0x2fc)],{'choice':new _0x22ecb1(_0x5d62a1,_0x259f9,_0xa10fa2)}),_0x52f056=_0x38100d(_0x121a02),_0x184faf=new _0x90ccf7([],null),_0x1c276c=_0x1b4030['create'](_0x121a02[_0x1bcd1b(0x3c1)]),_0x28e1df=Number(_0x121a02[_0x1bcd1b(0x3d9)]),_0x5b1d59=_0x121a02[_0x1bcd1b(0x446)]===_0x1bcd1b(0x265),_0x3093a6={'commandName':_0x40f8f2[_0x1bcd1b(0x3af)](_0x121a02[_0x1bcd1b(0x31a)]||'{}'),'symbol':_0x1bcd1b(0x255)},_0x470966=new _0x5f2fe2(_0x28e1df,0x0),_0x52f5a8=new _0x35f8c0(_0x1c276c,_0x299d47,_0x184faf,_0x470966,_0x5b1d59,_0x4e6482,_0x3093a6,_0x4dee84),_0x48b615=Utils[_0x1bcd1b(0x36d)]==='MZ'?new _0x50551a():null,_0x84e0b1=new _0x5f7514(_0x48b615,_0x52f5a8,_0x52f056);return _0x84e0b1;}()),_0xecb349=Game_Interpreter[_0x1c233b(0x3da)][_0x1c233b(0x38b)];Game_Interpreter['prototype']['command101']=function(_0x58585f){const _0xe6b81c=_0x1c233b,_0x2dd9fc=this[_0xe6b81c(0x269)],_0x421648=_0xecb349[_0xe6b81c(0x230)](this,_0x58585f);return _0x421648&&_0x3430dd[_0xe6b81c(0x1f5)](_0x2dd9fc),_0x421648;};const _0x1b131e=Game_Interpreter[_0x1c233b(0x3da)][_0x1c233b(0x302)];Game_Interpreter[_0x1c233b(0x3da)][_0x1c233b(0x302)]=function(_0x4366c5){const _0x252ab3=_0x1c233b,_0x2ca817=_0x1b131e['call'](this,_0x4366c5);if(!_0x3430dd['isLogWriteEnabled']())return _0x2ca817;const _0x1a6c2c=_0x3430dd['setLastVoiceParam'](_0x4366c5[0x0],null);if(_0x1a6c2c){const _0x529b97=_0x238bcf();_0x3430dd[_0x252ab3(0x2df)](_0x529b97);}return _0x2ca817;};function _0x238bcf(){const _0x17f454=_0x1c233b,_0x2bca86=AudioManager['_seBuffers'][_0x17f454(0x1f3)],_0x194dc7=AudioManager['_seBuffers'][_0x2bca86-0x1];if(_0x194dc7)return _0x194dc7;return null;}const _0x5e1f2f=Window_ChoiceList[_0x1c233b(0x3da)][_0x1c233b(0x33e)];Window_ChoiceList['prototype'][_0x1c233b(0x33e)]=function(){const _0x1f5a7f=_0x1c233b;if(_0x3430dd[_0x1f5a7f(0x1ec)]()){const _0x160919=this[_0x1f5a7f(0x2ac)]();_0x3430dd[_0x1f5a7f(0x391)](_0x160919,this);}_0x5e1f2f[_0x1f5a7f(0x230)](this);};const _0x19157f=Window_ChoiceList[_0x1c233b(0x3da)][_0x1c233b(0x3ce)];Window_ChoiceList[_0x1c233b(0x3da)][_0x1c233b(0x3ce)]=function(){const _0x7429e2=_0x1c233b;if(_0x3430dd['isLogWriteEnabled']()){const _0x486ec8=$gameMessage['choiceCancelType']();_0x3430dd[_0x7429e2(0x391)](_0x486ec8,this);}_0x19157f[_0x7429e2(0x230)](this);};class _0x753851 extends Scene_MenuBase{[_0x1c233b(0x3af)](){const _0x796845=_0x1c233b;super[_0x796845(0x3af)](),this[_0x796845(0x20b)]();}['logManager'](){return _0x3430dd;}[_0x1c233b(0x41f)](){const _0x27b96c=_0x1c233b,_0x50dc2f=this[_0x27b96c(0x215)]()[_0x27b96c(0x407)]()[_0x27b96c(0x2fc)]()[_0x27b96c(0x1fd)]();_0x50dc2f?(this[_0x27b96c(0x40b)]=new Sprite(_0x50dc2f),this[_0x27b96c(0x2a8)](this[_0x27b96c(0x40b)])):super[_0x27b96c(0x41f)]();}[_0x1c233b(0x20b)](){const _0x33bffb=_0x1c233b;this['createHelpWindow'](),this[_0x33bffb(0x3a4)](),this[_0x33bffb(0x31e)](),this[_0x33bffb(0x26f)]();}[_0x1c233b(0x427)](){const _0x1ce298=_0x1c233b;return _0x3430dd[_0x1ce298(0x407)]()[_0x1ce298(0x34d)]();}[_0x1c233b(0x26f)](){const _0x503299=_0x1c233b;this[_0x503299(0x40d)][_0x503299(0x26b)](this[_0x503299(0x3d5)]),this['_machinakaWindow']['selectLastItem']();if(this[_0x503299(0x427)]()){this['_machinakaWindow'][_0x503299(0x30c)]();return;}this['_logWindow'][_0x503299(0x24c)](),this[_0x503299(0x3d5)][_0x503299(0x30c)]();}['start'](){const _0x5906a6=_0x1c233b;super[_0x5906a6(0x3b6)](),this['_logWindow'][_0x5906a6(0x267)]();}[_0x1c233b(0x202)](){return 0x0;}[_0x1c233b(0x3b5)](){return![];}['helpAreaHeight'](){const _0xf814e4=_0x1c233b;if(this[_0xf814e4(0x3b5)]())return super[_0xf814e4(0x303)]();return 0x0;}['isBottomHelpMode'](){return![];}[_0x1c233b(0x222)](){const _0x4121f5=_0x1c233b,_0x853d22=_0x3430dd[_0x4121f5(0x407)]()[_0x4121f5(0x2fc)]()[_0x4121f5(0x222)]();if(_0x853d22)return _0x853d22;const _0x1e2074=this[_0x4121f5(0x28c)](),_0x1c9f5a=this['mainAreaLeft'](),_0x4129e4=this[_0x4121f5(0x40f)]()+_0x1e2074,_0x17772e=this[_0x4121f5(0x42c)]()-_0x1e2074;return new Rectangle(_0x1c9f5a,_0x4129e4,Graphics[_0x4121f5(0x1e8)],_0x17772e);}[_0x1c233b(0x31e)](){const _0x50988b=_0x1c233b,_0xbbb41a=this[_0x50988b(0x222)](),_0x2a6fe8=new _0x45f793(_0xbbb41a);this['needsHelpWindow']()&&_0x2a6fe8[_0x50988b(0x3a9)](this[_0x50988b(0x2de)]),_0x2a6fe8[_0x50988b(0x286)]('ok',this[_0x50988b(0x296)][_0x50988b(0x1f8)](this)),_0x2a6fe8[_0x50988b(0x286)](_0x50988b(0x30d),this['onBacklogCancel'][_0x50988b(0x1f8)](this)),this[_0x50988b(0x3d5)]=_0x2a6fe8,this['addWindow'](_0x2a6fe8);}[_0x1c233b(0x296)](){const _0x10b4d0=_0x1c233b,_0x40ba8f=this[_0x10b4d0(0x3d5)][_0x10b4d0(0x362)]();if(_0x40ba8f){const _0x467eaf=_0x40ba8f[_0x10b4d0(0x2f8)]();_0x467eaf&&ManoUZ_MessageLog[_0x10b4d0(0x3eb)](_0x467eaf,{});}this[_0x10b4d0(0x3d5)][_0x10b4d0(0x30c)]();}[_0x1c233b(0x429)](){const _0x23d423=_0x1c233b;this[_0x23d423(0x40d)][_0x23d423(0x358)]&&this[_0x23d423(0x427)]()?(this[_0x23d423(0x3d5)][_0x23d423(0x201)](),this['_machinakaWindow'][_0x23d423(0x30c)]()):this['popScene']();}[_0x1c233b(0x28c)](){const _0x313ac5=_0x1c233b;if(this[_0x313ac5(0x427)]()){const _0x1c5594=_0x3430dd[_0x313ac5(0x294)](),_0x59b97e=this[_0x313ac5(0x28a)](_0x1c5594,!![]);return _0x59b97e;}return 0x0;}[_0x1c233b(0x36f)](){const _0x51d9b9=_0x1c233b,_0x2eb045=this[_0x51d9b9(0x202)](),_0x50a933=this[_0x51d9b9(0x40f)](),_0x35a4f5=this[_0x51d9b9(0x28c)]();return new Rectangle(_0x2eb045,_0x50a933,Graphics[_0x51d9b9(0x1e8)],_0x35a4f5);}['createMachinakaWindow'](){const _0x57ba0c=_0x1c233b,_0x140b9c=this[_0x57ba0c(0x36f)](),_0x3f9522=new _0x542885(_0x140b9c);_0x3f9522[_0x57ba0c(0x358)]=this['machinakeModeEnabled'](),_0x3f9522[_0x57ba0c(0x286)]('ok',this['onMachnakaOk'][_0x57ba0c(0x1f8)](this)),_0x3f9522['setHandler']('cancel',this[_0x57ba0c(0x402)]['bind'](this));const _0x278a31=_0x3430dd['createMachinakaList']();_0x3f9522[_0x57ba0c(0x386)](_0x278a31),this[_0x57ba0c(0x40d)]=_0x3f9522,this[_0x57ba0c(0x245)](_0x3f9522);}[_0x1c233b(0x409)](){const _0x429859=_0x1c233b,_0x4d6304=this['_machinakaWindow']['currentItem']();this[_0x429859(0x3d5)][_0x429859(0x386)](_0x4d6304[_0x429859(0x305)]()),this[_0x429859(0x3d5)][_0x429859(0x3fc)](0x0),this[_0x429859(0x3d5)]['activate']();}[_0x1c233b(0x402)](){const _0x3c9660=_0x1c233b;this[_0x3c9660(0x360)]();}}class _0x5585a0{[_0x1c233b(0x378)](){return 0x1;}[_0x1c233b(0x42b)](){return 0x1;}['valueRate'](){const _0x1fad1f=_0x1c233b,_0xb360a2=Math[_0x1fad1f(0x3d1)](0x1,this[_0x1fad1f(0x378)]());return this[_0x1fad1f(0x42b)]()/_0xb360a2;}}class _0x5690bc extends PIXI['Graphics']{[_0x1c233b(0x239)](_0xb22419,_0xb84d7a){const _0x1028fa=_0x1c233b;this['geometry'][_0x1028fa(0x3e0)]();const _0x3f95b7=-Math['PI']/0x2;this[_0x1028fa(0x2a6)](0x0,0x0),this[_0x1028fa(0x2b2)](_0xb84d7a,_0xb84d7a,_0xb84d7a,_0x3f95b7,Math['PI']*_0xb22419*0x2+_0x3f95b7),this[_0x1028fa(0x395)]();}}class _0x58c1cc extends _0x5690bc{constructor(_0x4d0345){const _0x1542d4=_0x1c233b;super(),this[_0x1542d4(0x419)]=_0x4d0345;}[_0x1c233b(0x324)](_0x59c8cc,_0x62299b,_0x21330b){const _0x35fe1d=_0x1c233b;_0x59c8cc[_0x35fe1d(0x356)](_0x52076d=>{const _0x53ed07=_0x35fe1d,_0x5f2fe0=new PIXI[(_0x53ed07(0x3d2))](_0x52076d[_0x53ed07(0x420)]);this[_0x53ed07(0x27d)]=_0x5f2fe0,this[_0x53ed07(0x1f4)]({'texture':_0x5f2fe0,'width':_0x62299b,'color':_0x21330b});});}[_0x1c233b(0x384)](_0xb31280){const _0xca725f=_0x1c233b;this[_0xca725f(0x239)](_0xb31280,this[_0xca725f(0x419)]);}}function _0x4ac434(_0x286062){const _0x42c9e3=_0x1c233b;return{'left':_0x286062['x'],'top':_0x286062['y'],'right':_0x286062['x']+_0x286062[_0x42c9e3(0x2c5)],'bottom':_0x286062['y']+_0x286062[_0x42c9e3(0x295)]};
                }class _0x3fd481 extends PIXI[_0x1c233b(0x444)]{constructor(_0x14efa3){const _0x56e6e5=_0x1c233b;super(),this[_0x56e6e5(0x2e6)]=new Rectangle(0x0,0x0,0x0,0x0),this['y']=-0x1e240,this['_behaviorList']=_0x14efa3,this['_buttonsSprites']=_0x14efa3[_0x56e6e5(0x344)](),this['calcSize'](),this[_0x56e6e5(0x2a8)](...this[_0x56e6e5(0x270)]);}get[_0x1c233b(0x2c5)](){const _0x4c0d7f=_0x1c233b;return this[_0x4c0d7f(0x29a)];}get[_0x1c233b(0x295)](){const _0xce1734=_0x1c233b;return this[_0xce1734(0x1f7)];}[_0x1c233b(0x2bb)](){const _0x23c52c=_0x1c233b;if(this[_0x23c52c(0x270)][_0x23c52c(0x1f3)]<=0x0){this[_0x23c52c(0x29a)]=0x0,this[_0x23c52c(0x1f7)]=0x0;return;}const _0x395c58=this[_0x23c52c(0x270)][0x0],_0xf67e38=_0x4ac434(_0x395c58);for(let _0x1781bd=0x1;_0x1781bd<this[_0x23c52c(0x270)][_0x23c52c(0x1f3)];_0x1781bd++){const _0x2abb9c=_0x4ac434(this['_buttonsSprites'][_0x1781bd]);_0xf67e38[_0x23c52c(0x25a)]=Math[_0x23c52c(0x281)](_0xf67e38[_0x23c52c(0x25a)],_0x2abb9c[_0x23c52c(0x25a)]),_0xf67e38[_0x23c52c(0x282)]=Math[_0x23c52c(0x3d1)](_0xf67e38[_0x23c52c(0x282)],_0x2abb9c[_0x23c52c(0x282)]),_0xf67e38[_0x23c52c(0x39d)]=Math[_0x23c52c(0x281)](_0xf67e38[_0x23c52c(0x39d)],_0x2abb9c['top']),_0xf67e38['bottom']=Math[_0x23c52c(0x3d1)](_0xf67e38[_0x23c52c(0x33a)],_0x2abb9c[_0x23c52c(0x33a)]);}this[_0x23c52c(0x29a)]=Math['abs'](_0xf67e38[_0x23c52c(0x25a)]-_0xf67e38[_0x23c52c(0x282)]),this[_0x23c52c(0x1f7)]=Math[_0x23c52c(0x1f1)](_0xf67e38[_0x23c52c(0x39d)]-_0xf67e38[_0x23c52c(0x33a)]);}[_0x1c233b(0x212)](){const _0x53fe32=_0x1c233b;return this[_0x53fe32(0x270)][_0x53fe32(0x37c)](_0x3b5e12=>{return _0x3b5e12['isBeingTouched']();});}['updateInput'](){const _0x3665fd=_0x1c233b;for(const _0xcc957 of this[_0x3665fd(0x270)]){_0xcc957['update']();}}[_0x1c233b(0x253)](){const _0x2437f7=_0x1c233b;this[_0x2437f7(0x358)]=!this[_0x2437f7(0x43b)][_0x2437f7(0x2e3)]();for(const _0x3babc1 of this['_buttonsSprites']){_0x3babc1['startMessage']();}}[_0x1c233b(0x272)](){}['movementAmountOfChoice'](_0x4bdb39){return 0x0;}[_0x1c233b(0x416)](_0x40dbd4){}[_0x1c233b(0x27c)](){return 0x0;}}class _0x20a9bc extends _0x3fd481{[_0x1c233b(0x27c)](){const _0xaab38b=_0x1c233b;return this[_0xaab38b(0x295)]-0x10;}[_0x1c233b(0x416)](_0x177321){const _0x266edd=_0x1c233b,_0x5b3fc1=this['parent'][_0x266edd(0x2c5)]-this[_0x266edd(0x2c5)],_0x111486=this[_0x266edd(0x3f9)][_0x266edd(0x295)]-this[_0x266edd(0x295)];this['x']=_0x5b3fc1+this[_0x266edd(0x43b)][_0x266edd(0x2d0)](),this['y']=_0x111486+this['_behaviorList'][_0x266edd(0x3c4)]();}}class _0x269d2d extends _0x3fd481{[_0x1c233b(0x416)](_0x56f023){const _0x17fe16=_0x1c233b,_0xa0532f=this[_0x17fe16(0x3f9)][_0x17fe16(0x2c5)]-this[_0x17fe16(0x2c5)],_0x50c3d3=_0x56f023===0x0?this[_0x17fe16(0x3f9)][_0x17fe16(0x295)]:-this['height'];this['x']=_0xa0532f+this[_0x17fe16(0x43b)]['offsetX'](),this['y']=_0x50c3d3+this[_0x17fe16(0x43b)][_0x17fe16(0x3c4)]();}['movementAmountOfChoice'](_0x3b0252){const _0x3b7a0b=_0x1c233b;if(_0x3b0252===0x1)return 0x0;if(_0x3b0252===0x2)return-this['height'];return this[_0x3b7a0b(0x295)];}}class _0x4d361f extends _0x3fd481{constructor(_0x2c3133){super(_0x2c3133);}[_0x1c233b(0x416)](_0x387d00){const _0x2b8dd4=_0x1c233b;this[_0x2b8dd4(0x358)]=_0x387d00===0x2,this['x']=this[_0x2b8dd4(0x43b)][_0x2b8dd4(0x2d0)]()-this['parent']['x'],this['y']=this[_0x2b8dd4(0x43b)][_0x2b8dd4(0x3c4)]()-this[_0x2b8dd4(0x3f9)]['y'];}}const _0x164ca6=Window_ChoiceList[_0x1c233b(0x3da)][_0x1c233b(0x416)];Window_ChoiceList['prototype'][_0x1c233b(0x416)]=function(){const _0x46af4b=_0x1c233b;_0x164ca6[_0x46af4b(0x230)](this);if($gameMessage[_0x46af4b(0x328)]()===0x2){const _0x2bbf64=this[_0x46af4b(0x276)][_0x46af4b(0x25f)]();this['y']+=_0x2bbf64;}};const _0x171e35=Window_Message[_0x1c233b(0x3da)][_0x1c233b(0x36a)];Window_Message[_0x1c233b(0x3da)]['initialize']=function(_0x355fdc){const _0xf63dbb=_0x1c233b;this[_0xf63dbb(0x291)]=null;if(!_0x3430dd['isLogButtonEnabled']()){_0x171e35[_0xf63dbb(0x230)](this,_0x355fdc);return;}const _0x5bded8=_0x355fdc[_0xf63dbb(0x2d5)](),_0x3fdb00=_0x3430dd[_0xf63dbb(0x2cb)]();this['_logButtonGroop']=_0x3fdb00,_0x5bded8[_0xf63dbb(0x295)]+=_0x3fdb00[_0xf63dbb(0x27c)](),_0x171e35['call'](this,_0x5bded8),this[_0xf63dbb(0x2a8)](_0x3fdb00);};function _0x424f5c(_0x3c70a0){const _0x294b45=_0x1c233b;return _0x3c70a0[_0x294b45(0x291)];}Window_Message[_0x1c233b(0x3da)][_0x1c233b(0x25f)]=function(){const _0x3da919=_0x424f5c(this);if(_0x3da919)return _0x3da919['movementAmountOfChoice'](this['_positionType']);return 0x0;};const _0x50f2f4=Window_Message[_0x1c233b(0x3da)][_0x1c233b(0x25d)];Window_Message['prototype'][_0x1c233b(0x25d)]=function(){const _0xe8dd3e=_0x1c233b,_0x53e442=_0x50f2f4[_0xe8dd3e(0x230)](this),_0x586171=_0x424f5c(this);if(_0x586171)return _0x53e442-_0x586171['windowStretchY']();return _0x53e442;};const _0x587c90=Window_Message['prototype'][_0x1c233b(0x266)];Window_Message['prototype'][_0x1c233b(0x266)]=function(_0x2d8982){const _0x523554=_0x1c233b,_0x2d4023=this[_0x523554(0x323)](),_0x950b32=Math[_0x523554(0x37e)](this['_textState']['outputHeight']/_0x2d4023);_0x3430dd[_0x523554(0x3f4)](Math[_0x523554(0x281)](_0x950b32,0x4)),_0x587c90['call'](this,_0x2d8982);};const _0x292a8e=Window_Message[_0x1c233b(0x3da)][_0x1c233b(0x390)];Window_Message[_0x1c233b(0x3da)][_0x1c233b(0x390)]=function(){const _0x59bd8a=_0x1c233b,_0x54b8f5=this[_0x59bd8a(0x323)](),_0x5ecf29=Math['round'](this[_0x59bd8a(0x24e)][_0x59bd8a(0x3b7)]/_0x54b8f5);_0x3430dd[_0x59bd8a(0x3f4)](Math[_0x59bd8a(0x281)](_0x5ecf29,0x4)),_0x3430dd['onEnedOfText'](),_0x292a8e[_0x59bd8a(0x230)](this);};const _0x3fcf2b=Window_Message[_0x1c233b(0x3da)][_0x1c233b(0x253)];Window_Message[_0x1c233b(0x3da)]['startMessage']=function(){const _0x819e19=_0x1c233b;_0x3fcf2b[_0x819e19(0x230)](this);const _0x17cb8f=_0x424f5c(this);if(_0x17cb8f){_0x3430dd['needsShowFast']()&&(this[_0x819e19(0x262)]=!![]);const _0x201051=this[_0x819e19(0x42a)][_0x819e19(0x449)]($gameMessage['speakerName']());_0x3430dd[_0x819e19(0x253)](_0x201051,this[_0x819e19(0x24e)][_0x819e19(0x2b0)]),_0x17cb8f[_0x819e19(0x253)]();}};const _0x34a86b=Window_Message[_0x1c233b(0x3da)]['terminateMessage'];Window_Message[_0x1c233b(0x3da)][_0x1c233b(0x394)]=function(){const _0xafd7f9=_0x1c233b;_0x3430dd['onTerminateMessage'](),_0x34a86b[_0xafd7f9(0x230)](this),_0x3430dd[_0xafd7f9(0x3a7)]();};const _0x4af388=Window_Message[_0x1c233b(0x3da)][_0x1c233b(0x416)];Window_Message[_0x1c233b(0x3da)][_0x1c233b(0x416)]=function(){const _0x58e679=_0x1c233b;_0x4af388[_0x58e679(0x230)](this);const _0x4e53e5=_0x424f5c(this);_0x4e53e5&&_0x4e53e5[_0x58e679(0x416)](this[_0x58e679(0x2bf)]);};function _0x3ce27c(_0x25426){const _0x2712d4=_0x1c233b;return _0x25426[_0x2712d4(0x345)]()&&!_0x25426['isClosing']();}function _0x46fca5(_0x4787bc){const _0x4d75d5=_0x1c233b;if($gameParty[_0x4d75d5(0x243)]())return;_0x3430dd[_0x4d75d5(0x3fa)](),_0x4787bc&&_0x4787bc[_0x4d75d5(0x3fa)]();}const _0x74dc67=Window_Message['prototype'][_0x1c233b(0x3fa)];Window_Message[_0x1c233b(0x3da)][_0x1c233b(0x3fa)]=function(){const _0x59bb6a=_0x1c233b;!this[_0x59bb6a(0x24e)]&&_0x3ce27c(this)&&_0x46fca5(_0x424f5c(this));const _0x41879d=this['pause'],_0x555e77=_0x74dc67[_0x59bb6a(0x230)](this);if(!this[_0x59bb6a(0x327)])return _0x555e77;if(!_0x3430dd[_0x59bb6a(0x2f7)]())return _0x555e77;!_0x41879d&&_0x3430dd[_0x59bb6a(0x24f)]();_0x3430dd['updateAutoTimer']();if(_0x3430dd[_0x59bb6a(0x350)]())return _0x3430dd[_0x59bb6a(0x371)](),this[_0x59bb6a(0x327)]=![],this[_0x59bb6a(0x24e)]=null,this[_0x59bb6a(0x394)](),![];return!![];};const _0x5670e2=Window_Message[_0x1c233b(0x3da)][_0x1c233b(0x2d6)];Window_Message[_0x1c233b(0x3da)][_0x1c233b(0x2d6)]=function(){const _0x28c40f=_0x1c233b,_0x60dffb=_0x424f5c(this);if(_0x60dffb&&TouchInput[_0x28c40f(0x385)]()&&_0x60dffb[_0x28c40f(0x212)]())return![];return _0x5670e2['call'](this);};const _0x3bfed6=Scene_Map[_0x1c233b(0x3da)][_0x1c233b(0x36e)];Scene_Map[_0x1c233b(0x3da)]['createDisplayObjects']=function(){const _0x56b288=_0x1c233b;_0x3430dd['setBattleMode'](![]),_0x3bfed6[_0x56b288(0x230)](this),_0x3430dd[_0x56b288(0x3e3)]()&&(this['_messageWindow'][_0x56b288(0x2ae)]=0xff);};const _0x29779e=Scene_Battle[_0x1c233b(0x3da)][_0x1c233b(0x36e)];Scene_Battle[_0x1c233b(0x3da)][_0x1c233b(0x36e)]=function(){_0x3430dd['setBattleMode'](!![]),_0x29779e['call'](this);};
                const _0x52f3aa=Game_Map[_0x1c233b(0x3da)][_0x1c233b(0x2b8)];Game_Map[_0x1c233b(0x3da)]['setupStartingMapEvent']=function(){const _0x323e47=_0x1c233b,_0x56e4e2=_0x52f3aa[_0x323e47(0x230)](this);if(_0x56e4e2){const _0xe72126=this[_0x323e47(0x2dd)][_0x323e47(0x2e8)](),_0x47e75d=this[_0x323e47(0x2ad)](_0xe72126);_0x47e75d&&_0x3430dd[_0x323e47(0x20c)](_0x47e75d,this['_mapId']);}return _0x56e4e2;};const _0x44aa93=Game_Map[_0x1c233b(0x3da)][_0x1c233b(0x23b)];Game_Map[_0x1c233b(0x3da)][_0x1c233b(0x23b)]=function(){const _0x177274=_0x1c233b,_0x42d6e9=this[_0x177274(0x2dd)]['isRunning']();_0x44aa93['call'](this),_0x42d6e9&&!this[_0x177274(0x2dd)]['isRunning']()&&_0x3430dd['onEndEvent']();};const _0x1095de=Window_MenuCommand[_0x1c233b(0x3da)][_0x1c233b(0x1ed)];Window_MenuCommand['prototype'][_0x1c233b(0x1ed)]=function(){const _0x5e247b=_0x1c233b;_0x1095de[_0x5e247b(0x230)](this);const _0x57b484=_0x3430dd['readOnryData']()[_0x5e247b(0x31a)](),_0x113f9f=_0x57b484[_0x5e247b(0x438)][_0x5e247b(0x2b0)]();_0x113f9f&&this[_0x5e247b(0x313)](_0x113f9f,_0x57b484[_0x5e247b(0x3cf)]);};const _0x52518f=Scene_Menu[_0x1c233b(0x3da)][_0x1c233b(0x248)];Scene_Menu[_0x1c233b(0x3da)][_0x1c233b(0x248)]=function(){const _0x246d67=_0x1c233b;_0x52518f[_0x246d67(0x230)](this);const _0x575541=_0x3430dd[_0x246d67(0x407)]()['menuCommand']();this[_0x246d67(0x2ea)][_0x246d67(0x286)](_0x575541[_0x246d67(0x3cf)],()=>{SceneManager['push'](_0x753851);});};class _0x3d5342{constructor(_0x36fe4a,_0x395a25,_0x2855c6){const _0x27fba4=_0x1c233b;this[_0x27fba4(0x38a)]=_0x36fe4a,this[_0x27fba4(0x3b3)]=_0x395a25,this[_0x27fba4(0x264)]=_0x2855c6;}['makeMZ_arg'](_0x56fc66){const _0x47c41f=_0x1c233b,_0x171244={},_0x57ef46=Math['min'](_0x56fc66[_0x47c41f(0x1f3)],this[_0x47c41f(0x3b3)][_0x47c41f(0x1f3)]);for(let _0x46cb42=0x0;_0x46cb42<_0x57ef46;++_0x46cb42){const _0x499868=this['_paramNames'][_0x46cb42];_0x171244[_0x499868]=_0x56fc66[_0x46cb42];}return _0x171244;}[_0x1c233b(0x213)](_0x5135c0){const _0x138862=_0x1c233b,_0x23c3d4=this[_0x138862(0x36b)](_0x5135c0);this[_0x138862(0x23f)](_0x23c3d4);}[_0x1c233b(0x23f)](_0x448de4){this['_func'](_0x448de4);}}class _0x46c16c{constructor(_0x2553e4){const _0x38cd21=_0x1c233b;this[_0x38cd21(0x34b)]=new Map(),this[_0x38cd21(0x3e6)]=_0x2553e4;}[_0x1c233b(0x25c)](_0x12db0d,_0x1bc663,_0x2a660b){const _0x24677c=_0x1c233b;Utils[_0x24677c(0x36d)]==='MZ'&&this[_0x24677c(0x423)](_0x12db0d,_0x2a660b),this['isMVcommandEnabeled']()&&this[_0x24677c(0x403)](_0x12db0d,_0x1bc663,_0x2a660b);}[_0x1c233b(0x366)](){const _0x19c77b=_0x1c233b;return Utils[_0x19c77b(0x36d)]==='MV';}['registerCommandMZ'](_0x126ad2,_0x246256){const _0x45e4e5=_0x1c233b;PluginManager[_0x45e4e5(0x25c)](this['_pluginName'],_0x126ad2,_0x246256);}[_0x1c233b(0x403)](_0x35fa8a,_0x5d69f2,_0x1a876d){const _0x536ef5=_0x1c233b,_0x110ca2=new _0x3d5342(_0x35fa8a,_0x5d69f2,_0x1a876d);this[_0x536ef5(0x34b)][_0x536ef5(0x314)](_0x35fa8a,_0x110ca2);}[_0x1c233b(0x1f0)](_0x78e2bd,_0x2338bb,_0x1e15e0){const _0x4bef0e=_0x1c233b,_0x5ac603=this[_0x4bef0e(0x34b)]['get'](_0x2338bb);if(_0x5ac603){const _0x1fa05f=_0x5ac603[_0x4bef0e(0x36b)](_0x1e15e0);return _0x5ac603[_0x4bef0e(0x23f)](_0x1fa05f),!![];}return![];}}const _0x492284=new _0x46c16c(_0x1a1516);_0x492284[_0x1c233b(0x25c)](_0x1c233b(0x256),[],()=>{const _0x4c8f0e=_0x1c233b;SceneManager[_0x4c8f0e(0x2fe)](_0x753851);}),_0x492284[_0x1c233b(0x25c)](_0x1c233b(0x293),[],_0x43f2a8=>{const _0x3a3edf=_0x1c233b,_0x132630=String(_0x43f2a8['title']);_0x3430dd[_0x3a3edf(0x2b1)](_0x132630);}),_0x492284[_0x1c233b(0x25c)](_0x1c233b(0x447),[],()=>{const _0x45e9dc=_0x1c233b;_0x3430dd[_0x45e9dc(0x40e)]();}),_0x492284[_0x1c233b(0x25c)](_0x1c233b(0x27a),[],_0x50772b=>{const _0x41fc63=_0x1c233b;_0x3430dd[_0x41fc63(0x1fe)]();}),_0x492284[_0x1c233b(0x25c)](_0x1c233b(0x43c),[],_0x46e823=>{
                    const _0x857c81=_0x1c233b,_0xaa4e2a=Number(_0x46e823[_0x857c81(0x3c0)]),_0x44a616=_0x3430dd[_0x857c81(0x263)]();$gameVariables['setValue'](_0xaa4e2a,_0x44a616);}),_0x492284[_0x1c233b(0x25c)]('SetAutoMode',[_0x1c233b(0x23d)],_0x39ffd9=>{const _0x4079f4=_0x1c233b;_0x3430dd[_0x4079f4(0x2ab)](_0x39ffd9['automode']==='true');}),_0x492284['registerCommand']('GetAutoMode',[_0x1c233b(0x23d)],_0x188453=>{const _0x2cad42=_0x1c233b,_0x5c176a=Number(_0x188453[_0x2cad42(0x210)]),_0x448cf7=_0x3430dd[_0x2cad42(0x3a2)]();$gameSwitches[_0x2cad42(0x384)](_0x5c176a,_0x448cf7);}),_0x492284[_0x1c233b(0x25c)](_0x1c233b(0x388),[_0x1c233b(0x39a)],function(_0x87f7e){const _0x3b2f45=_0x1c233b;this[_0x3b2f45(0x337)](_0x87f7e[_0x3b2f45(0x39a)]);}),_0x492284[_0x1c233b(0x25c)](_0x1c233b(0x330),[_0x1c233b(0x42d)],_0xc6d450=>{const _0x7e66e=_0x1c233b,_0x4fdb35=Number(_0xc6d450[_0x7e66e(0x42d)]);$gameSwitches[_0x7e66e(0x384)](_0x4fdb35,_0x3430dd[_0x7e66e(0x42f)]());}),_0x492284[_0x1c233b(0x25c)]('ShowConsloeProxy',[],()=>{const _0x569487=_0x1c233b,_0x5bace0=_0x3430dd['getContents']()[_0x569487(0x34f)]();for(const _0x4b0e55 of _0x5bace0){console['table'](_0x4b0e55);}}),_0x492284[_0x1c233b(0x25c)](_0x1c233b(0x24b),[],_0x28e1e2=>{const _0x1df111=_0x1c233b,_0x4a90fc=_0x3430dd[_0x1df111(0x204)]()['getAutoWaitTime'](),_0x162e67=Number(_0x28e1e2[_0x1df111(0x3c0)]);$gameVariables[_0x1df111(0x384)](_0x162e67,_0x4a90fc);}),_0x492284[_0x1c233b(0x25c)](_0x1c233b(0x3a6),[],_0x1e88a1=>{const _0x371c41=_0x1c233b,_0x33bdec=Number(_0x1e88a1[_0x371c41(0x3c0)]),_0x20e42d=$gameVariables[_0x371c41(0x25b)](_0x33bdec);!isNaN(_0x20e42d)&&_0x3430dd[_0x371c41(0x204)]()[_0x371c41(0x251)](_0x20e42d);}),_0x492284['registerCommand'](_0x1c233b(0x413),[],_0x21904b=>{const _0x50238d=_0x1c233b,_0x4b7e24=Number(_0x21904b[_0x50238d(0x3c0)]),_0x2fa302=$gameVariables[_0x50238d(0x25b)](_0x4b7e24);_0x3430dd['option']()[_0x50238d(0x232)](_0x2fa302);}),_0x492284[_0x1c233b(0x25c)](_0x1c233b(0x32a),[],_0x247ee4=>{const _0x3c10bb=_0x1c233b,_0x2861c9=Number(_0x247ee4[_0x3c10bb(0x3c0)]),_0x51d6fa=_0x3430dd[_0x3c10bb(0x204)]()['getLogLimitSizeBasic']();$gameVariables['setValue'](_0x2861c9,_0x51d6fa);}),_0x492284[_0x1c233b(0x25c)](_0x1c233b(0x278),[],_0x4ca7ca=>{const _0x8216c8=_0x1c233b,_0xfcfd36=Number(_0x4ca7ca[_0x8216c8(0x3c0)]),_0x1877e1=$gameVariables['value'](_0xfcfd36);_0x3430dd[_0x8216c8(0x204)]()[_0x8216c8(0x365)](_0x1877e1);}),_0x492284[_0x1c233b(0x25c)](_0x1c233b(0x1f6),[],_0x2d1249=>{const _0x1765d2=_0x1c233b,_0x5ca9ca=Number(_0x2d1249['variableId']),_0x4846a0=_0x3430dd[_0x1765d2(0x204)]()[_0x1765d2(0x206)]();$gameVariables[_0x1765d2(0x384)](_0x5ca9ca,_0x4846a0);}),_0x492284['registerCommand']('GetKeepingAutoMode',[],_0x3ea062=>{const _0x412578=_0x1c233b,_0x2fba71=_0x3430dd[_0x412578(0x204)]()[_0x412578(0x285)](),_0x45210f=Number(_0x3ea062[_0x412578(0x42d)]);$gameSwitches[_0x412578(0x384)](_0x45210f,_0x2fba71);});const _0x4dd698=_0x1c233b(0x250),_0xfa254e=ConfigManager[_0x1c233b(0x3d3)];ConfigManager['makeData']=function(){const _0x330588=_0x1c233b,_0x5738ef=_0xfa254e['call'](this),_0x53971f=_0x3430dd[_0x330588(0x21c)]();return _0x5738ef[_0x4dd698]=_0x53971f,_0x5738ef;};const _0x1ecf75=ConfigManager['applyData'];ConfigManager[_0x1c233b(0x414)]=function(_0x454c1c){const _0x2d7b8a=_0x1c233b;_0x1ecf75['call'](this,_0x454c1c);const _0xd7c8c0=_0x454c1c[_0x4dd698];_0x3430dd[_0x2d7b8a(0x29c)](_0xd7c8c0);};const _0x420668=DataManager['makeSaveContents'];DataManager['makeSaveContents']=function(){const _0x27b38f=_0x1c233b,_0x5539c2=_0x420668['call'](this);return _0x3430dd[_0x27b38f(0x271)](_0x5539c2),_0x5539c2;};const _0x103254=DataManager['extractSaveContents'];DataManager['extractSaveContents']=function(_0x49fb59){const _0x1dc933=_0x1c233b;_0x103254['call'](this,_0x49fb59),_0x3430dd[_0x1dc933(0x39f)](_0x49fb59);};const _0x39bc94=DataManager[_0x1c233b(0x3bb)];DataManager['setupNewGame']=function(){const _0x34ab3d=_0x1c233b;_0x39bc94['call'](this),_0x3430dd[_0x34ab3d(0x292)]();};const _0x328aee=DataManager[_0x1c233b(0x3ac)];DataManager[_0x1c233b(0x3ac)]=function(){const _0x733e27=_0x1c233b;_0x328aee[_0x733e27(0x230)](this),_0x3430dd[_0x733e27(0x424)]();};const _0x202b57=Scene_Boot['prototype']['start'];Scene_Boot[_0x1c233b(0x3da)][_0x1c233b(0x3b6)]=function(){
                    const _0x1106c9=_0x1c233b;_0x202b57[_0x1106c9(0x230)](this),_0x3a3085[_0x1106c9(0x267)](),_0x3430dd[_0x1106c9(0x3ae)]();};function _0x43bf66(_0x562614,_0x46d73f){window[_0x46d73f]=_0x562614;}
                    const _0x51ef4a=[LogList,MultiLine_Message,LogItem_Choice,Log_ContentsObject];
                    for(const _0x18e7f3 of _0x51ef4a){_0x43bf66(_0x18e7f3,_0x18e7f3[_0x1c233b(0x289)]);}return new LogManager_Export(_0x3430dd);}());
                    