/*:
 * @target MZ
 * @plugindesc ゲームオーバーを無効化して全滅後も処理を継続できるようにします。
 * @author トリアコンタン MarkⅡ
 * @help
 * パーティが全滅しても Scene_Gameover に遷移しなくなります。
 * イベント処理で独自の演出（動画再生など）を行いたい場合に使用します。
 */
(() => {
    Game_Battler.prototype.performCollapse = function () {
        if (this.isEnemy()) {
            SoundManager.playEnemyCollapse();
        } else {
            SoundManager.playActorCollapse();
        }
    };

    Scene_Battle.prototype.checkBattleEnd = function () {
        if (this._battleManager.isBattleTest()) {
            SceneManager.exit();
        } else if (BattleManager.checkAbort()) {
            this.processAbort();
        } else if ($gameParty.isAllDead()) {
            // デフォルトのゲームオーバー処理を無効化
            BattleManager.processDefeat();
            return true;
        } else if ($gameTroop.isAllDead()) {
            BattleManager.processVictory();
            return true;
        }
        return false;
    };
})();
