//=============================================================================
// Tatsu_EightLineSlot.js
// 内容：8ラインスロットを実装するためのプラグインです
// 製作者：タツノコ
// バージョン：Ver1.2.0
//=============================================================================
/*:
 * @target MZ
 * @plugindesc 8ラインスロットのプラグイン
 * @author タツノコ
 * 
 * @help Tatsu_EightLineSlot.js
 * @command start
 * @text 8ラインスロットの開始。
 * @desc 8ラインスロットを開始します。
 * 
 * @arg arg1
 * @text 使用するリールのID（必須項目）
 * @desc 使用するリールのID（必須項目）
 * 
 * @param coinVariable
 * @text コイン枚数保持用変数番号
 * @desc コイン枚数保持用変数番号
 * @type variable
 * 
 * @param realManVariable
 * @text リールID管理用格納変数番号
 * @desc ゲームごとで利用するリールの管理するIDを管理する変数番号
 * @type variable
 * @default 0
 * 
 * @param oneBetCoinVariable
 * @text 1回のBETを行う枚数を管理する変数
 * @desc 1回のBETを行う枚数を管理する変数(設定しない場合は1が設定されます。)
 * @type variable
 * @default 0
 * 
 * @param initPositionVariable
 * @text スロット開始時の場所を指定する変数
 * @desc スロット開始時の場所を指定する変数(位置の番号を入れてください)
 *       設定しない場合は、一番下がデフォルトになります
 * @type variable
 * @default 0
 * 
 * @param maxBetCoinVariable
 * @text maxBetを行う枚数を管理する変数
 * @desc maxBetを行う枚数を管理する変数
 * @type variable
 * @default 0
 * 
 * @param realNumVariable
 * @text 実行するリールの図柄の数を管理する変数
 * @desc 実行するリールの図柄の数を管理する変数
 * @type variable
 * @default 0
 * 
 * @param backgroundImage
 * @text 背景画像ファイル設定
 * @desc 利用したい背景画像を設定してください。
 * @type String
 * @default background
 * 
 * @param frameImg
 * @text リールの周りを装飾するフレーム画像のファイル名
 * @desc リールの周りを装飾するフレーム画像のファイル名を設定してください。
 * @type String
 * @default frame
 * 
 * @param helpImg
 * @text helpボタン画像のファイル名
 * @desc 利用したいhelpボタンの画像のファイル名を設定してください。
 * @type String
 * @default help
 * 
 * @param onebetImg
 * @text 1枚BET(ONBET)ボタン画像のファイル名
 * @desc 利用したい1枚BET(ONBET)ボタンの画像のファイル名を設定してください。
 * @type String
 * @default onebet
 * 
 * @param maxbetImg
 * @text MAXBETボタン画像のファイル名
 * @desc 利用したいMAXBETボタンの画像のファイル名を設定してください。
 * @type String
 * @default maxBet
 * 
 * @param startRepeatImg
 * @text START/REPEATボタン画像のファイル名
 * @desc 利用したいSTART/REPEATボタンの画像のファイル名を設定してください。
 * @type String
 * @default startRepeat
 * 
 * @param exitImg
 * @text EXITボタン画像のファイル名
 * @desc EXITボタンの画像のファイル名を設定してください。
 * @type String
 * @default exit
 * 
 * @param buttonFrameImg
 * @text ボタンのカーソル画像のファイル名
 * @desc ボタンを選ぶカーソルのフレーム画像のファイル名を設定してください。
 * @type String
 * @default buttonFrame
 * 
 * @param betWindowFrameImg
 * @text BETコインのフレーム画像のファイル名
 * @desc BETコインのフレーム画像のファイル名を設定してください。
 * @type String
 * @default betWindowFrame
 * 
 * @param nowWindowFrameImg
 * @text 現在の所持コインのフレーム画像のファイル名
 * @desc 現在の所持コインのフレーム画像のファイル名を設定してください。
 * @type String
 * @default nowWindowFrame
 * 
 * @param helpModeList
 * @text HELPを使う場合の画像ファイル名リスト
 * @desc 紙芝居で表示したい画像のファイル名のリストを設定してください。
 * @type String[]
 * 
 * @param helpExitImg
 * @text HELPを閉じるボタンの画像のファイル名
 * @desc マウスクリックで操作可能なHELPを閉じるボタンの画像のファイル名を設定してください。
 * @type String
 * @default helpExit
 * 
 * @param useBGM
 * @text ゲームBGM鳴動設定
 * @desc ゲームプレイ中に設定した専用のBGMを流すかを設定することができます。
 * @type Boolean
 * @on 専用BGMを流す
 * @off 専用BGMを流さない
 * @default false
 * 
 * @param backBGM
 * @text ゲームBGM設定
 * @desc ゲームプレイ中に流したい専用のBGMのファイル名を入力してください。
 * @type String
 * @default bgm_kajino
 * 
 * @param startReal
 * @text リール回転START音設定
 * @desc リールスタート時に流したいSEのファイル名を入力してください。
 * @type String
 * @default onepoint
 * 
 * @param lineCompSE
 * @text ラインが揃った時の音設定
 * @desc ラインが揃った時に流したいSEのファイル名を入力してください。
 * @type String
 * @default seWin
 * 
 * @param lineNotCompSE
 * @text ラインが揃わなかった時の音設定
 * @desc ラインが揃わなかった時に流したいSEのファイル名を入力してください。
 * @type String
 * @default seLose
 * 
 * @param allLineCompSE
 * @text 全ラインが同じ図柄で揃った時の音設定
 * @desc 全ラインが同じ図柄で揃った時に流したいSEのファイル名を入力してください。
 * @type String
 * @default seAllLine
 * 
 * @param useHelp
 * @text help機能利用有無設定
 * @desc helpボタンを表示するかしないかの設定をすることができます
 * @type Boolean
 * @on helpボタンを表示する
 * @off helpボタンを表示しない
 * @default false
 * 
 * @param useHelpExit
 * @text helpを閉じるボタン利用有無設定
 * @desc helpを閉じるボタンを利用するかしないかの設定をすることができます。
 * @type Boolean
 * @on helpを閉じるボタンを表示する
 * @off helpを閉じるボタンを表示しない
 * @default false
 * 
 * @param realInfomang
 * @text リール情報
 * @desc リール情報
 * @type struct<RealIds>[]
 * @default ["{\"realId\":\"1\",\"realImgName\":\"real\",\"realScoreName\":\"score\",\"realGroupInfoList\":\"[\\\"{\\\\\\\"realGroup\\\\\\\":\\\\\\\"[1,3,5,6]\\\\\\\",\\\\\\\"realgroupScore\\\\\\\":\\\\\\\"1\\\\\\\"}\\\",\\\"{\\\\\\\"realGroup\\\\\\\":\\\\\\\"[2,9]\\\\\\\",\\\\\\\"realgroupScore\\\\\\\":\\\\\\\"3\\\\\\\"}\\\",\\\"{\\\\\\\"realGroup\\\\\\\":\\\\\\\"[4,8]\\\\\\\",\\\\\\\"realgroupScore\\\\\\\":\\\\\\\"4\\\\\\\"}\\\",\\\"{\\\\\\\"realGroup\\\\\\\":\\\\\\\"[7]\\\\\\\",\\\\\\\"realgroupScore\\\\\\\":\\\\\\\"30\\\\\\\"}\\\"]\"}","{\"realId\":\"2\",\"realImgName\":\"real2\",\"realScoreName\":\"score2\",\"realGroupInfoList\":\"[\\\"{\\\\\\\"realGroup\\\\\\\":\\\\\\\"[1,3,5,7]\\\\\\\",\\\\\\\"realgroupScore\\\\\\\":\\\\\\\"1\\\\\\\"}\\\",\\\"{\\\\\\\"realGroup\\\\\\\":\\\\\\\"[2,4]\\\\\\\",\\\\\\\"realgroupScore\\\\\\\":\\\\\\\"10\\\\\\\"}\\\",\\\"{\\\\\\\"realGroup\\\\\\\":\\\\\\\"[6,8,9]\\\\\\\",\\\\\\\"realgroupScore\\\\\\\":\\\\\\\"3\\\\\\\"}\\\"]\"}"]
 * 
 * 
 * @param realImgSize
 * @text -> リールの画像サイズ情報 <<<<<<<<<<<<<<<<<<<<<<<
 * @desc
 * 
 * @param realImgWidht
 * @text リールで使われる画像の幅サイズ(1つのサイズ)
 * @desc リールで使われる画像の幅サイズ(1つのサイズ)
 * @type number
 * @default 150
 * @parent realImgSize
 * 
 * @param realImgHeight
 * @text リールで使われる画像の縦サイズ(1つのサイズ)
 * @desc リールで使われる画像の縦サイズ(1つのサイズ)
 * @type number
 * @default 155
 * @parent realImgSize
 * 
 * @param realImgSpan
 * @text リール同士の間のスペースのサイズ
 * @desc 画面に表示するリール同士の間のスペース
 * @type number
 * @default 10
 * @parent realImgSize
 * 
 * @param imgPosition
 * @text -> 各種画像の位置情報 <<<<<<<<<<<<<<<<<<<<<<<
 * @desc
 * 
 * @param slotFrameXpos
 * @text リールの周りを装飾するフレーム画像のX座標
 * @desc リールの周りを装飾するフレーム画像のX座標
 * @type number
 * @default 10
 * @parent imgPosition
 * 
 * @param slotFrameYpos
 * @text リールの周りを装飾するフレーム画像のY座標
 * @desc リールの周りを装飾するフレーム画像のY座標
 * @type number
 * @default 10
 * @parent imgPosition
 * 
 * @param scoreImgXPos
 * @text 配当コインを表示する画像エリアのX座標
 * @desc 配当コインを表示する画像エリアのX座標
 * @type number
 * @default 530
 * @parent imgPosition
 * 
 * @param scoreImgYPos
 * @text 配当コインを表示する画像エリアのY座標
 * @desc 配当コインを表示する画像エリアのY座標
 * @type number
 * @default 10
 * @parent imgPosition
 * 
 * @param helpXpos
 * @text helpボタンの画像のX座標
 * @desc helpボタンの画像のX座標
 * @type number
 * @default 5
 * @parent imgPosition
 *  
 * @param helpYpos
 * @text helpボタンの画像のY座標
 * @desc helpボタンの画像のY座標
 * @type number
 * @default 530
 * @parent imgPosition
 * 
 * @param oneBetXpos
 * @text 1枚BET(ONBET)ボタンの画像のX座標
 * @desc 1枚BET(ONBET)ボタンの画像のX座標
 * @type number
 * @default 165
 * @parent imgPosition
 * 
 * @param oneBetYpos
 * @text 1枚BET(ONBET)ボタンの画像のY座標
 * @desc 1枚BET(ONBET)ボタンの画像のY座標
 * @type number
 * @default 530
 * @parent imgPosition
 * 
 * @param maxBetXpos
 * @text MAXBETボタンの画像のX座標
 * @desc MAXBETボタンの画像のX座標
 * @type number
 * @default 325
 * @parent imgPosition
 * 
 * @param maxBetYpos
 * @text MAXBETボタンの画像のY座標
 * @desc MAXBETボタンの画像のY座標
 * @type number
 * @default 530
 * @parent imgPosition
 * 
 * @param startRepeatXpos
 * @text START/REPEATボタンの画像のX座標
 * @desc START/REPEATボタンの画像のX座標
 * @type number
 * @default 485
 * @parent imgPosition
 *  
 * @param startRepeatYpos
 * @text START/REPEATボタンの画像のY座標
 * @desc START/REPEATボタンの画像のY座標
 * @type number
 * @default 530
 * @parent imgPosition
 * 
 * @param exitXpos
 * @text EXITボタンの画像のX座標
 * @desc EXITボタンの画像のX座標
 * @type number
 * @default 645
 * @parent imgPosition
 *  
 * @param exitYpos
 * @text EXITボタンの画像のY座標
 * @desc EXITボタンの画像のY座標
 * @type number
 * @default 530
 * @parent imgPosition
 * 
 * @param helpExitImgXpos
 * @text helpを閉じるボタン画像のX座標
 * @desc helpを閉じるボタン画像のX座標（閉じるボタンを使う場合のみ有効）
 * @type number
 * @default 650
 * @parent imgPosition
 *  
 * @param helpExitImgYpos
 * @text helpを閉じるボタン画像のY座標
 * @desc helpを閉じるボタン画像のY座標（閉じるボタンを使う場合のみ有効）
 * @type number
 * @default 10
 * @parent imgPosition
 * 
 * @param windowPosition
 * @text -> 各種ウィンドウの位置情報 <<<<<<<<<<<<<<<<<<<<<<<
 * @desc
 * 
 * @param nowCoinPosX
 * @text 現在の所持コインの表示ウィンドウのX座標
 * @desc 現在の所持コインの表示ウィンドウのX座標
 * @type number
 * @default 550
 * @parent windowPosition
 * 
 * @param nowCoinPosY
 * @text 現在の所持コインの表示ウィンドウのY座標
 * @desc 現在の所持コインの表示ウィンドウのY座標
 * @type number
 * @default 350
 * @parent windowPosition
 * 
 * @param nowCoinWindowWidth
 * @text 現在の所持コインの表示ウィンドウの幅
 * @desc 現在の所持コインの表示ウィンドウの幅
 * @type number
 * @default 235
 * @parent windowPosition
 * 
 * @param nowCoinWindowHeight
 * @text 現在の所持コインの表示ウィンドウの高さ
 * @desc 現在の所持コインの表示ウィンドウの高さ
 * @type number
 * @default 70
 * @parent windowPosition
 * 
 * @param betCoinPosX
 * @text BETコインの表示ウィンドウのX座標
 * @desc BETコインの表示ウィンドウのX座標
 * @type number
 * @default 550
 * @parent windowPosition
 * 
 * @param betCoinPosY
 * @text BETコインの表示ウィンドウのY座標
 * @desc BETコインの表示ウィンドウのY座標
 * @type number
 * @default 420
 * @parent windowPosition
 * 
 * @param betCoinWindowWidth
 * @text BETコインの表示ウィンドウの幅
 * @desc BETコインの表示ウィンドウの幅
 * @type number
 * @default 235
 * @parent windowPosition
 * 
 * @param betCoinWindowHeight
 * @text BETコインの表示ウィンドウの高さ
 * @desc BETコインの表示ウィンドウの高さ
 * @type number
 * @default 70
 * @parent windowPosition
 * 
 * @param yesNoWindowWidth
 * @text はい/いいえ選択ウィンドウの幅
 * @desc はい/いいえ選択ウィンドウの幅
 * @type number
 * @default 120
 * @parent windowPosition
 * 
 * @param yesNoWindowHeight
 * @text はい/いいえ選択ウィンドウの高さ
 * @desc はい/いいえ選択ウィンドウの高さ
 * @type number
 * @default 110
 * @parent windowPosition
 * 
 * @param languageInfo
 * @text -> メッセージ関連の情報（他言語化向け） <<<<<<<<<<<<<<<<<<<<<<<
 * @desc
 * 
 * @param winMessage1
 * @text ラインが揃った時に表示するメッセージ
 * @desc ラインが揃った時に表示するメッセージです。
 * @type String
 * @default YOU WIN!!%d枚獲得です!
 * @parent languageInfo
 * 
 * @param notCoinMessage
 * @text コインが足りない時用のメッセージ
 * @desc コインが足りない時用のメッセージです。
 * @type String
 * @default コインが足りません
 * @parent languageInfo
 * 
 * @param limitCoinMessage
 * @text BETするコインが上限に達した時のメッセージ
 * @desc BETするコインが上限に達した時のメッセージです。
 * @type String
 * @default これ以上BETできません。
 * @parent languageInfo
 * 
 * @param existsBetMessage
 * @text 初回のBETをせずにSTARTを押した時のメッセージ
 * @desc 初回のBETをせずにSTARTを押した時のメッセージです。
 * @type String
 * @default BETをしてください
 * @parent languageInfo
 * 
 * @param repeatNotCoinMessage
 * @text リピート時のコインが足りない時用のメッセージ
 * @desc リピート時のコインが足りない時用のメッセージです。
 * @type String
 * @default リピート分のコインが足りません
 * @parent languageInfo
 * 
 * @param exitMessage
 * @text 終了確認を行うメッセージ
 * @desc 終了確認を行うメッセージ
 * @type String
 * @default スロットを終了しますか？
 * @parent languageInfo
 * 
 * @param yesLanguage
 * @text はい/いいえ選択肢の「はい」の文言
 * @desc はい/いいえ選択肢の「はい」の文言
 * @type String
 * @default はい
 * @parent languageInfo
 * 
 * @param noLanguage
 * @text はい/いいえ選択肢の「いいえ」の文言
 * @desc はい/いいえ選択肢の「いいえ」の文言
 * @type String
 * @default いいえ
 * @parent languageInfo
 * 
 * @help
 *-----------------------------------------------------------------------------
 * 概要
 *-----------------------------------------------------------------------------
 * 本プラグインは、ゲーム内にて8ラインスロットゲームを実装するプラグインです。
 * 
 * 【プラグインインストール方法】
 *   1.解凍後、出来上がった以下のフォルダを所定の位置に配置してください
 *     1-1.audio/bgm/bgm_kajino.ogg
 *     配置場所※1：RPGツクールのプロジェクト/audio/bgm/
 *
 *     1-2.audio/se/seWin.ogg
 *         audio/se/seLose.ogg
 *         audio/se/seAllLine.ogg
 * 
 *     配置場所※1：RPGツクールのプロジェクト/audio/se/
 *     ※slide.oggのみプラグインパラメータからの変更は不可能です（カードを引く時のSE）
 *      
 * 
 *
 *     1-3.jsファイルの配置場所
 *     配置場所：js/plugins
 *
 *     1-4.画像ファイルの配置場所
 *     配置場所：img/tSlot
 *     配置場所※1：RPGツクールのプロジェクト/img/の直下に「tSlot」フォルダごと配置してください
 * 
 * 【プラグイン設定方法】
 *    1.RPGツクールMV(RPGツクールMZ)を起動
 *    2.メニュー画面より、「プラグイン管理」を選択
 *    3.プラグイン管理画面にて「tSlot」を追加後、「有効」に設定
 *    4.プラグインパラメータのコイン枚数保持用変数の設定をしてください
 * 
 * 【プラグイン呼び出し方法】
 *    ・イベントの「プラグインコマンド」に以下を入力
 *      RPGツクールMVの場合
 *        Tatsu_EightLineSlot start 使用するスロットのID(プラグインパラメータのリール情報「リールのID」に指定した項目)
 *
 *      RPGツクールMZの場合
 *        プラグイン名：Tatsu_EightLineSlot
 *        コマンド名：スロットの開始
 *        引数：「・引数の説明」にて記述
 *
 *    ・引数の説明
 *     ・使用するスロットのID(プラグインパラメータのリール情報「リールのID」に指定した項目)
 * 
 * 【プラグインパラメータの説明】
 *   1.コイン枚数保持用変数番号
 *     所持コインを保持する変数
 *     必ず設定をしてください。
 * 
 *   2.リールID管理用格納変数番号
 *     必須項目
 *     ゲームプレイ時に指定するIDを管理する変数番号
 * 
 *   3.maxBetを行う枚数を管理する変数
 *     必須項目
 *     maxBetを行う枚数を管理する変数
 *
 *   4.1回のBETを行う枚数を管理する変数
 *     1回のBETを行う枚数を管理する変数
 *     設定しない場合は1が設定されます。
 * 
 *   5.スロット開始時の場所を指定する変数
 *     スロット開始時の場所を指定する変数(位置の番号を入れてください)
 *     設定しない場合は、一番下がデフォルトになります
 * 
 *   6.実行するリールの図柄の数を管理する変数
 *     実行するリールの図柄の数を管理する変数になります。
 *     スロット実行前に、変数に値を設定してください。
 *　　　変数の中身に設定する値は「図柄の数-1」にしてください。
 *　　　（コマ数-1）。指定しない場合はデフォルト値の「9」が設定されます。
 * 
 *   7.背景画像ファイル設定
 *     必須項目
 *     背景画像ファイル名
 *     背景にしたいファイル名を設定してください。
 *
 *   8.リールの周りを装飾するフレーム画像のファイル名
 *     必須項目
 *     リールの周りを装飾するフレーム画像のファイル名を設定してください。
 *
 *   9.helpボタン画像のファイル名
 *     必須項目
 *     利用したいhelpボタンの画像のファイル名を設定してください。
 *
 *   10.1枚BETボタン画像のファイル名
 *     必須項目
 *     利用したい1枚BETボタンの画像のファイル名を設定してください。
 *
 *   11.MAXBETボタン画像のファイル名
 *     必須項目
 *     利用したいMAXBETボタンの画像のファイル名を設定してください。
 *
 *   12.START/REPEATボタン画像のファイル名
 *     必須項目
 *     利用したいSTART/REPEATボタンの画像のファイル名を設定してください。
 *
 *   13.EXITボタン画像のファイル名
 *     必須項目
 *     利用したいEXITボタンの画像のファイル名を設定してください。
 * 
 *   14.ボタンのカーソル画像のファイル名
 *     必須項目
 *     ボタンを選ぶカーソルのフレーム画像のファイル名を設定してください。
 * 
 *   15.BETコインのフレーム画像のファイル名
 *     必須項目
 *     BETコインのフレーム画像のファイル名を設定してください。
 *
 *   16.現在の所持コインのフレーム画像のファイル名
 *     必須項目
 *     現在の所持コインのフレーム画像のファイル名を設定してください。
 *
 *   17.HELPを使う場合の画像ファイル名リスト
 *     紙芝居で表示したい画像のファイル名のリストを設定してください。
 *
 *   18.HELPを閉じるボタンの画像
 *     マウスクリックで操作可能なHELPを閉じるボタンの画像のファイル名を設定してください。
 *
 *   19.ゲームBGM鳴動設定
 *     ゲームプレイ中に設定した専用のBGMを流すかを設定することができます。
 *     true:流す
 *     false:流さない
 *
 *   20.ゲームBGM設定
 *     ゲームプレイ中に流したい専用のBGMのファイル名を設定してください。
 * 
 *   21.リール回転START音設定
 *     リールスタート時に流したいSEのファイル名を入力してください。
 * 
 *   22.ラインが揃った時の音設定
 *     ラインが揃った時に流したいSEのファイル名を入力してください。
 * 
 *   23.ラインが揃わなかった時の音設定
 *     ラインが揃わなかった時に流したいSEのファイル名を入力してください。
 * 
 *   24.全ラインが同じ図柄で揃った時の音設定
 *     全ラインが同じ図柄で揃った時に流したいSEのファイル名を入力してください。
 * 
 *   25.help画像利用有無設定
 *     helpボタンを表示するかしないかの設定をすることができます。
 *     true:利用する
 *     false:利用しない
 * 
 *   26.helpを閉じるボタン利用有無設定
 *     helpを閉じるボタンを利用するかしないかの設定をすることができます。
 *     true:利用する
 *     false:利用しない
 * 
 *   27.リール情報
 *     リール情報
 *      以下の情報の塊
 *        リールのID：使用するリールを特定するためのID
 *                  ゲーム開始時の引数(「使用するスロットのID」)ではこのIDを指定する
 *        ID対応させたいリールの画像のファイル名：IDに紐付けたい、リールの画像ファイル名
 *                                          引数で指定したIDに紐づくリールの画像ファイル名が表示されます
 *        ID対応させたい配当コインの画像のファイル名：IDに紐付けたい、スコアの画像ファイル名
 *                                          引数で指定したIDに紐づくスコアの画像ファイル名が表示されます
 * 
 *        リールのグループ情報：リールのグループ情報の設定については以下の通り
 *                           同じ図柄として認識させたい図柄の番号：同じ図柄として認識させたい図柄の位置を指定してください。
 *                                                            複数同じ図柄がある場合は[数字,数字]の形式で、 
 *                                                            複数同じ図柄がないものに関しては[数字]の形式で入力してください。
 *                                                            数字の位置の番号は、画像下から数えて1,2,3...となります。
 *                           倍率：図柄が揃った時の、払い戻しの倍率を設定してください。
 * 
 * 〜〜〜〜〜〜〜〜〜〜「同じ図柄として認識させたい図柄の番号」の設定例〜〜〜〜〜〜〜
 *      リールの1番下の図柄と、下から3番目、4番目の図柄が同じ図柄の場合
 *      [1,3,4]
 * 〜〜〜〜〜〜〜〜〜〜〜〜〜〜〜〜〜〜〜〜〜〜〜〜〜〜〜〜〜〜〜〜〜〜〜〜〜〜〜〜
 * 
 *   28.リールで使われる画像の幅サイズ(1つのサイズ)
 *     リールの図柄一つあたりの幅の画像サイズ
 *     リールの画像サイズを変更する際にご変更ください
 * 
 *   29.リールで使われる画像の縦サイズ(1つのサイズ)
 *     リールの図柄一つあたりの幅の画像サイズ
 *     リールの画像サイズを変更する際にご変更ください
 * 
 *   30.リール同士の間のスペースのサイズ
 *     リールの図柄同士の間に入れるスペースのサイズ
 *     リール同士がくっつきすぎたりする場合にお使いください
 * 
 *   31.スロットを表示しているフレームの画像のX座標
 *     スロットを表示しているフレームの画像のX座標
 * 
 *   32.スロットを表示しているフレームの画像Y座標
 *     スロットを表示しているフレームの画像Y座標
 * 
 *   33.スコアを表示する画像エリアのX座標
 *     スコアを表示する画像エリアのX座標
 * 
 *   34.スコアを表示する画像エリアのY座標
 *     スコアを表示する画像エリアのY座標
 * 
 *   35.helpボタンの画像のX座標
 *     helpボタンの画像のX座標
 * 
 *   36.helpボタンの画像のY座標
 *     helpボタンの画像のY座標
 * 
 *   37.1枚BET(ONBET)ボタンの画像のX座標
 *     1枚BET(ONBET)ボタンの画像のX座標
 * 
 *   38.1枚BET(ONBET)ボタンの画像のY座標
 *     1枚BET(ONBET)ボタンの画像のY座標
 * 
 *   39.MAXBETボタンの画像のX座標
 *     MAXBETボタンの画像のX座標
 * 
 *   40.MAXBETボタンの画像のY座標
 *     MAXBETボタンの画像のY座標
 * 
 *   41.START/REPEATボタンの画像のX座標
 *     START/REPEATボタンの画像のX座標
 * 
 *   42.START/REPEATボタンの画像のY座標
 *     START/REPEATボタンの画像のY座標
 * 
 *   43.EXITボタンの画像のX座標
 *     EXITボタンの画像のX座標
 * 
 *   44.EXITボタンの画像のY座標
 *     EXITボタンの画像のY座標
 * 
 *   45.helpを閉じるボタン画像のX座標
 *    helpを閉じるボタン画像のX座標(閉じるボタンを使う場合のみ有効)
 * 
 *   46.helpを閉じるボタン画像のY座標
 *    helpを閉じるボタン画像のY座標(閉じるボタンを使う場合のみ有効)
 * 
 *   47.手持ちコインの表示ウィンドウのX座標
 *     手持ちコインの表示ウィンドウのX座標
 * 
 *   48.手持ちコインの表示ウィンドウのY座標
 *     手持ちコインの表示ウィンドウのY座標
 *
 *   49.手持ちコインの表示ウィンドウの幅
 *     手持ちコインの表示ウィンドウの幅
 *
 *   50.手持ちコインの表示ウィンドウの高さ
 *     手持ちコインの表示ウィンドウの高さ
 * 
 *   51.BETコインの表示ウィンドウのX座標
 *     BETコインの表示ウィンドウのX座標
 *
 *   52.BETコインの表示ウィンドウのY座標
 *     BETコインの表示ウィンドウのY座標
 * 
 *   53.BETコインの表示ウィンドウの幅
 *     BETコインの表示ウィンドウの幅
 *
 *   54.BETコインの表示ウィンドウの高さ
 *     BETコインの表示ウィンドウの高さ
 *
 *   55.はい/いいえ選択ウィンドウの幅
 *     はい/いいえ選択ウィンドウの幅
 * 
 *   56.はい/いいえ選択ウィンドウの高さ
 *     はい/いいえ選択ウィンドウの高さ
 * 
 * ----ここからは言語関連の設定になります。表示されている言語を別言語にしたい場合
 * 
 *   57.勝利時メッセージ1
 *     勝利時に表示するメッセージです。
 * 
 *   58.コインが足りない時用のメッセージ
 *     コインが足りない時用のメッセージです。
 *
 *   59.BETするコインが上限に達した時のメッセージ
 *      BETするコインが上限に達した時のメッセージです。
 * 
 *   60.初回のBETをせずにSTARTを押した時のメッセージ
 *      初回のBETをせずにSTARTを押した時のメッセージです。
 * 
 *   61.リピート時のコインが足りない時用のメッセージ
 *     リピート時のコインが足りない時用のメッセージです。
 * 
 *   62.BETコインがMAXのBETコインより多い場合に表示するメッセージ
 *     BETコインがMAXのBETコインより多い場合に表示するメッセージ
 * 　　関係値としては「BETコイン>MAXBETコイン」が成立している場合に表示されます。
 * 
 *   63.終了確認を行うメッセージ
 *     終了確認を行うメッセージです。
 * 
 *   64.はい/いいえ選択肢の「はい」の文言
 *     はい/いいえ選択肢の「はい」の文言
 * 
 *   65.はい/いいえ選択肢の「いいえ」の文言
 *     はい/いいえ選択肢の「いいえ」の文言
 * 
 * 【ルール】
 *   ・8ラインスロット
 *    1.最初にBET枚数を選択してください。BET枚数は、BETボタンを繰り返し押せば、設定した単位でBETできます。
 *      MAXBETボタンを押せば、設定した最大のBET数でBETできます。
 *    2.START/REPEATボタンを押してください。
 *    3.リールが回転したら1秒待つか、ENTERキー(またはクリック)を押して止めてください。
 *    4.止まるリールの位置、タイミングはランダムで決まります。(目押し不可)
 *    5.ラインが揃ったら、揃ったラインの倍率分払い戻しが行われます。
 *    6.START/REPEATボタンを再度押せば、直前にBETした分再度BETしてスロットが再開されます。
 *    7.START/REPEATボタンを押した際、所持コインが足りない場合は、全BETされた上でスロットが開始します。
 * 
 * 【操作方法】
 *    ・十字キーを使う場合
 *      →キー : カーソルの移動
 *      ←キー : カーソルの移動
 *      決定キー : 選択肢の決定
 *      ESCキー :  終了の確認ウィンドウを表示する
 * 
 *    ・マウスを使う場合
 *      左クリック : ボタンの選択
 *      右クリック : 終了の確認ウィンドウを表示する
 * 
 *-----------------------------------------------------------------------------
 * 変更履歴
 *-----------------------------------------------------------------------------
 * 
 * Ver 1.0.0 初版
 * Ver 1.1.0 リールの画像サイズ変更に対応
 * Ver 1.1.1 BETを行った後にEXITを押した場合、コインが戻らないため、BETしたあとはEXITが押せないように修正
 * Ver 1.1.2 Ver1.1.1 の対応漏れ（右クリックの終了ウインドウ無効化）対応
 * Ver 1.2.0 リールの図柄のコマ数を動的に変更できるように修正
 *-----------------------------------------------------------------------------
 *-----------------------------------------------------------------------------
 * 素材著作権
 *-----------------------------------------------------------------------------
 * 
 * 【デフォルトで使用している音楽、および効果音】
 * 　->魔王魂樣
 * 【URL】
 * 　->https://maoudamashii.jokersounds.com/
 * 
 *
 * 【画像素材】
 * 　->aya
 * 
 *-----------------------------------------------------------------------------
 * その他利用規約
 *-----------------------------------------------------------------------------
 * アダルトゲームにて利用する場合、リールの素材が使えない規約となっております。
 * その場合、リールの図柄自体を別画像に差し替えをお願いいたします。
 * その他利用規約については添付の「readme.txt」をご覧ください。
 *
 */

/*~struct~RealPos:
 * @param realPosX
 * @text X座標
 * @desc X座標
 * @type Number
 * 
 * @param realPosY
 * @text Y座標
 * @desc Y座標
 * @type Number
*/

/*~struct~RealIds:
 * @param realId
 * @text リールのID
 * @desc リールのID
 * @type Number
 * 
 * @param realImgName
 * @text IDに対応させたいリールの画像のファイル名
 * @desc IDに対応させたいリールの画像のファイル名
 * @type String
 * @default real
 * 
 * @param realScoreName
 * @text IDに対応させたい配当コインの画像のファイル名
 * @desc IDに対応させたい配当コインの画像のファイル名
 * @type String
 * @default score
 * 
 * @param realGroupInfoList
 * @text リールのグループ情報
 * @desc リールのグループ情報
 * @type struct<RealGroupInfo>[]
 * 
*/

/*~struct~RealGroupInfo:
 * @param realGroup
 * @text 同じ図柄と認識させたい図柄の位置の番号
 * @desc 同じ図柄と認識させたい図柄をグループで記載してください。
 * 例：[1,2]や[3]など
 * @type String
 * @default real
 * 
 * @param realgroupScore
 * @text 倍率
 * @desc この図柄が揃ったときの倍率
 * @type Number
 * 
*/

(function(){

    'use strict';

    // プラグインパラメータ-start-
    const TATSU_EIGHTSLOT_PLUGIN_NAME = "Tatsu_EightLineSlot";
    let isRpgMakerMV = function(){
        return (Utils.RPGMAKER_NAME == "MV");
    };

    var parameterNotNull = function(){
        var para = null;
        if (isRpgMakerMV()) {
            para = PluginManager.parameters(TATSU_EIGHTSLOT_PLUGIN_NAME);
        } else {
            var para = PluginManager.parameters(decodeURIComponent(document.currentScript.src).match(/^.*\/js\/plugins\/(.+)\.js$/)[1]);
            if (!para["nowCoinPosX"]) {
                para = PluginManager.parameters(TATSU_EIGHTSLOT_PLUGIN_NAME);
            }
        }
        return para;
    };
    var TatsuEightLineSlotP = TatsuEightLineSlotP || {};
    var parameters = parameterNotNull();
    TatsuEightLineSlotP.realImgWidht = Number(parameters['realImgWidht'] || 150);
    TatsuEightLineSlotP.realImgHeight = Number(parameters['realImgHeight'] || 155);
    TatsuEightLineSlotP.realImgSpan = Number(parameters['realImgSpan'] || 10);

    // ==CONST周り-start==================================================
    const FILE_NAME_CORRECT_FRAME = "correctFrame";
    const REAL_IMG_WIDTH = TatsuEightLineSlotP.realImgWidht;//リールの図柄の幅
    const REAL_IMG_HEIGHT = TatsuEightLineSlotP.realImgHeight;//リールの図柄の一個あたりの高さ
    const REAL_CHANGE_POINT = 50;
    const TURN_WAIT = "twait";
    const TURN_INIT = "tinit";
    const TURN_START = "start";
    const TURN_RUNNING = "runnning";
    const TURN_STOPPING = "stopping";
    const TURN_ROLECHECK = "rolecheck";
    const TURN_ROLEANIMATION= "roleanimation";
    const TURN_OKANIMATION= "okanimation";
    const TURN_NGANIMATION= "nganimation";
    const TURN_CALC_COIN = "calcCoin";
    const REAL_RUN_STATUS_WAIT = "wait";
    const REAL_RUN_STATUS_START = "start";
    const REAL_RUN_STATUS_RUNNING = "running";
    const REAL_RUN_STATUS_STOPPING = "stopping";
    const REAL_RUN_STATUS_ADJUST = "adjust";

    const MODE_GAME_PLAY = "gamePlay";
    const MODE_HELP = "help";
    const REAL_CHECK_KEY_BESIDE = "beside";
    const REAL_CHECK_KEY_VERTICAL = "vertical";
    const REAL_CHECK_KEY_DIAGNOAL = "diagonal";
    const BUTTON_HELP_POS = 0;
    const BUTTON_ONEBET_POS = 1;
    const BUTTON_MAXBET_POS = 2;
    const BUTTON_START_POS = 3;
    const BUTTON_EXIT_POS = 4;
    // ==CONST周り-end==================================================

    // データクラス周り-start==================================================
    function RealInfo (){
        this.initialize.apply(this,arguments);
    };

    RealInfo.prototype.initialize = function(sprite, lineNo, lineX, lineY,rSprite,initAnimationPoint) {
        this._sprite = sprite;
        this._lineNo = lineNo;
        this._lineX = lineX;
        this._lineY = lineY;
        this._spriteRfernceY = 0;
        this._nowPos = 0;
        this._correctSprite = rSprite;
        if (initAnimationPoint > 0) {
            this.setNowPosAndReferenceY(initAnimationPoint);
            this._sprite.setFrame(0,this._spriteRfernceY,REAL_IMG_WIDTH,REAL_IMG_HEIGHT);
        } else {
            this._sprite.setFrame(0,TatsuEightLineSlotP.realImgheightAll,REAL_IMG_WIDTH,REAL_IMG_HEIGHT);
        }
    };


    RealInfo.prototype.getSprite = function(){
        return this._sprite;
    };

    RealInfo.prototype.getlineNo = function(){
        return this._lineNo;
    };

    RealInfo.prototype.setlineNo = function(lineNo){
        this._lineNo = lineNo;
    };

    RealInfo.prototype.getlineX = function(){
        return this._lineX;
    };

    RealInfo.prototype.setlineX = function(lineX){
        this._lineX = lineX;
    };

    RealInfo.prototype.getlineY = function(){
        return this._lineY;
    };

    RealInfo.prototype.setlineY = function(lineY){
        this._lineY = lineY;
    };

    RealInfo.prototype.getNowPos = function(){
        return this._nowPos;
    };

    RealInfo.prototype.setNowPos = function(nowPos){
        this._nowPos = nowPos;
    };

    RealInfo.prototype.setSpriteReferenceY = function(spriteRfernceY){
        this._spriteRfernceY = spriteRfernceY;
    };

    RealInfo.prototype.getRealIndex = function(){
        let index = 0;
        for (let i = TatsuEightLineSlotP.realNum ; i >=0 ; i--) {
            if ((REAL_IMG_HEIGHT*i) == this._spriteRfernceY) {
                break;
            }
            index++;
        }
        return index;
    };

    RealInfo.prototype.setNowPosAndReferenceY = function(pos){
        this._nowPos = pos;
        let index = 0;
        for (let i = TatsuEightLineSlotP.realNum ; i >=0 ; i--) {
            if (index == (pos-1)) {
                this.setSpriteReferenceY(REAL_IMG_HEIGHT*i);
                break;
            }
            index++;
        }
    };

    RealInfo.prototype.getRealNumber = function(){
        return this.getRealIndex()+1;
    };

    RealInfo.prototype.getCorrectSprite = function(){
        return this._correctSprite;
    };

    // データクラス周り-end==================================================

    // ==各種共通関数まわり-start==================================================
    let getArgJson = function(arg, defaultValue) {
        try {
            arg = JSON.parse(arg || null);
            if (arg === null) {
                arg = defaultValue;
            }
        } catch (e) {
            alert(`!!!Plugin param is wrong.!!!\nPlugin:${TATSU_EIGHTSLOT_PLUGIN_NAME}.js\nValue:${arg}`);
            arg = defaultValue;
        }
        return arg;
    };

    let listObjectGetJson = function(parameter){
        if (parameter == undefined || parameter == null) {
            return null;
        }

        var paramReplacer = function(key, value) {
            try {
                return JSON.parse(value);
            } catch (e) {
                return value;
            }
        };
        let parse1 = JSON.parse(parameter);
        let parse2 = JSON.stringify(parse1,paramReplacer);
        let parse3 = JSON.parse(parse2);
        return parse3;
    };

    function getWindowMessage(){
        let wm = null;
        if (isRpgMakerMV()) {
            wm = new Window_Message();
        } else {
            wm = new Window_Message(getWindowMessageRect());
            wm.setGoldWindow(new Window_Gold(getdummyWindowRect()));
            wm.setNameBoxWindow(new Window_NameBox());
            wm.setChoiceListWindow(new Window_ChoiceList());
            wm.setNumberInputWindow(new Window_NumberInput());
            wm.setEventItemWindow(new Window_EventItem(getdummyWindowRect()));
        }

        return wm;
    };
    
    function getWindowMessageRect(){
        var rect = new Rectangle();
        var width = Graphics.boxWidth;
        var height = 4*36+18;
        var x = (Graphics.boxWidth - width) / 2;
        rect.x = x;
        rect.y = Graphics.boxHeight - height;
        rect.width = width;
        rect.height = height;
        return rect;
    };
    
    function getWindowBaseRect(x,y,width,height){
        if (isRpgMakerMV()) {
            return new Window_Base(x,y,width,height);
        } else {
            return new Window_Base(getdummyWindowRectParameter(x,y,width,height));
        }
    };
    
    function getdummyWindowRectParameter(x,y,width,height){
        var rect = new Rectangle();
        rect.x = x;
        rect.y = y;
        rect.width = width;
        rect.height = height;
        return rect;
    };

    function getdummyWindowRect(){
        var rect = new Rectangle();
        var width = 1;
        var height = 1;
        rect.x = 0;
        rect.y = 0;
        rect.width = width;
        rect.height = height;
        return rect;
    };

    function getCenterPos(arg1width,arg2width){
        return (arg1width/2) - (arg2width/2)
    };

    function playBGM(){
        $gameSystem.saveBgm();
        AudioManager.fadeOutBgm(1);
        if (TatsuEightLineSlotP.backBGM != "") {
            AudioManager.playBgm({"name":TatsuEightLineSlotP.backBGM,"volume":80,"pitch":100,"pan":0});
        }
    };

    function playStartSE(){
        globalPlaySe(TatsuEightLineSlotP.startRealSE);
    };

    function globalPlaySe(seName){
        AudioManager.playSe({"name":seName,"volume":80,"pitch":100,"pan":0});
    };

    function globalInputOkAndClick(){
        return (Input.isTriggered('ok') || Input.isRepeated('ok') || TouchInput.isTriggered());
    };

    function globalInputClick(){
        return (TouchInput.isTriggered());
    };

    function globalInputOk(){
        return (Input.isTriggered('ok') || Input.isRepeated('ok'));
    };

    function globalInputLeft(){
        return (Input.isTriggered('left') || Input.isRepeated('left'));
    };

    function globalInputRight(){
        return (Input.isTriggered('right') || Input.isRepeated('right'));
    };

    function globalInputCancel(){
        return (Input.isTriggered('cancel') || Input.isRepeated('cancel') || TouchInput.isCancelled());
    };


    TatsuEightLineSlotP.useHelpStr = String(parameters['useHelp'] || "true");
    TatsuEightLineSlotP.useHelp = false;
    TatsuEightLineSlotP.useBGMStr = String(parameters['useBGM'] || "true");
    TatsuEightLineSlotP.useBGM = true;
    TatsuEightLineSlotP.backBGM = String(parameters['backBGM'] || "");


    TatsuEightLineSlotP.lineCompSE = String(parameters['lineCompSE'] || "seWin");
    TatsuEightLineSlotP.lineNotCompSE = String(parameters['lineNotCompSE'] || "seLose");
    TatsuEightLineSlotP.allLineCompSE = String(parameters['allLineCompSE'] || "seAllLine");


    TatsuEightLineSlotP.startRealSE = String(parameters['startReal'] || "onepoint");
    TatsuEightLineSlotP.useHelpExitStr = String(parameters['useHelpExit'] || "false");
    TatsuEightLineSlotP.useHelpExit = false;
    TatsuEightLineSlotP.backgroundImage = String(parameters['backgroundImage'] || null);
    TatsuEightLineSlotP.realInfomang = listObjectGetJson(parameters['realInfomang'] || null);
    TatsuEightLineSlotP.frameImg = String(parameters['frameImg'] || "frame");
    TatsuEightLineSlotP.helpImg = String(parameters['helpImg'] || "help");
    TatsuEightLineSlotP.helpModeList = getArgJson(parameters['helpModeList']);
    TatsuEightLineSlotP.onebetImg = String(parameters['onebetImg'] || "onebet");
    TatsuEightLineSlotP.maxbetImg = String(parameters['maxbetImg'] || "maxbet");
    TatsuEightLineSlotP.buttonFrameImg = String(parameters['buttonFrameImg'] || "buttonFrame");
    TatsuEightLineSlotP.betWindowFrameImg = String(parameters['betWindowFrameImg'] || "betWindowFrame");
    TatsuEightLineSlotP.nowWindowFrameImg = String(parameters['nowWindowFrameImg'] || "nowWindowFrame");
    TatsuEightLineSlotP.startRepeatImg = String(parameters['startRepeatImg'] || "startRepeat");
    TatsuEightLineSlotP.exitImg = String(parameters['exitImg'] || "exit");

    TatsuEightLineSlotP.helpExitImg = String(parameters['helpExitImg'] || "helpExit");
    TatsuEightLineSlotP.coinVariable = Number(parameters['coinVariable'] || 0);

    TatsuEightLineSlotP.maxBetCoinVariable = Number(parameters['maxBetCoinVariable'] || 0);
    TatsuEightLineSlotP.oneBetCoinVariable = Number(parameters['oneBetCoinVariable'] || 0);
    TatsuEightLineSlotP.initPositionVariable = Number(parameters['initPositionVariable'] || 0);


    TatsuEightLineSlotP.helpXpos = Number(parameters['helpXpos'] || 5);
    TatsuEightLineSlotP.helpYpos = Number(parameters['helpYpos'] || 530);
    TatsuEightLineSlotP.oneBetXpos = Number(parameters['oneBetXpos'] || 165);
    TatsuEightLineSlotP.oneBetYpos = Number(parameters['oneBetYpos'] || 530);
    TatsuEightLineSlotP.maxBetXpos = Number(parameters['maxBetXpos'] || 325);
    TatsuEightLineSlotP.maxBetYpos = Number(parameters['maxBetYpos'] || 530);
    TatsuEightLineSlotP.startRepeatXpos = Number(parameters['startRepeatXpos'] || 485);
    TatsuEightLineSlotP.startRepeatYpos = Number(parameters['startRepeatYpos'] || 530);
    TatsuEightLineSlotP.exitXpos = Number(parameters['exitXpos'] || 645);
    TatsuEightLineSlotP.exitYpos = Number(parameters['exitYpos'] || 530);
    
    TatsuEightLineSlotP.helpExitImgXpos = Number(parameters['helpExitImgXpos'] || 650);
    TatsuEightLineSlotP.helpExitImgYpos = Number(parameters['helpExitImgYpos'] || 10);
    TatsuEightLineSlotP.slotFrameXpos = Number(parameters['slotFrameXpos'] || 10);
    TatsuEightLineSlotP.slotFrameYpos = Number(parameters['slotFrameYpos'] || 10);

    
    TatsuEightLineSlotP.scoreImgXPos = Number(parameters['scoreImgXPos'] || 531);
    TatsuEightLineSlotP.scoreImgYPos = Number(parameters['scoreImgYPos'] || 0);

    TatsuEightLineSlotP.nowCoinPosX = Number(parameters['nowCoinPosX'] || 0);
    TatsuEightLineSlotP.nowCoinPosY = Number(parameters['nowCoinPosY'] || 0);
    TatsuEightLineSlotP.nowCoinWindowWidth = Number(parameters['nowCoinWindowWidth'] || 0);
    TatsuEightLineSlotP.nowCoinWindowHeight = Number(parameters['nowCoinWindowHeight'] || 0);
    TatsuEightLineSlotP.betCoinPosX = Number(parameters['betCoinPosX'] || 0);
    TatsuEightLineSlotP.betCoinPosY = Number(parameters['betCoinPosY'] || 0);
    
    TatsuEightLineSlotP.betCoinWindowWidth = Number(parameters['betCoinWindowWidth'] || 0);
    TatsuEightLineSlotP.betCoinWindowHeight = Number(parameters['betCoinWindowHeight'] || 0);
    TatsuEightLineSlotP.yesNoWindowWidth = Number(parameters['yesNoWindowWidth'] || 0);
    TatsuEightLineSlotP.yesNoWindowHeight = Number(parameters['yesNoWindowHeight'] || 0);

    TatsuEightLineSlotP.notCoinMessage = String(parameters['notCoinMessage'] || "コインが足りません");
    TatsuEightLineSlotP.limitCoinMessage = String(parameters['limitCoinMessage'] || "これ以上BETできません");
    TatsuEightLineSlotP.repeatNotCoinMessage = String(parameters['repeatNotCoinMessage'] || "リピート分のコインが足りません");
    TatsuEightLineSlotP.existsBetMessage = String(parameters['existsBetMessage'] || "BETをしてください");

    TatsuEightLineSlotP.winMessage1 = String(parameters['winMessage1'] || "YOU WIN!!%d枚獲得です!");
    TatsuEightLineSlotP.exitMessage = String(parameters['exitMessage'] || "スロットを終了しますか？");
    TatsuEightLineSlotP.yesLanguage = String(parameters['yesLanguage'] || "はい");
    TatsuEightLineSlotP.noLanguage = String(parameters['noLanguage'] || "いいえ");
    TatsuEightLineSlotP.realNumVariable = String(parameters['realNumVariable'] || 0);
    TatsuEightLineSlotP.realNum = 9;
    TatsuEightLineSlotP.realImgheightAll = 0;
    // プラグインパラメータ-end-

    let loadBitmapByTSlotPluginFolder = function(fileName){
        return ImageManager.loadBitmap('img/tSlot/',fileName);
    };

    let globalPlayRealId = 1;
    let pluginName = TATSU_EIGHTSLOT_PLUGIN_NAME;
    if (isRpgMakerMV()) {
        let _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
        Game_Interpreter.prototype.pluginCommand = function(command, args){
            _Game_Interpreter_pluginCommand.call(this, command, args);
            if(command === pluginName){
                switch(args[0]){
                case 'start':
                    if (args.length != 1) {
                        globalPlayRealId = Number(args[1]);
                    } else {
                        globalPlayRealId = 1;
                    }
                    TatsuEightLineSlotP.realNum = 9;
                    if (TatsuEightLineSlotP.realNumVariable && TatsuEightLineSlotP.realNumVariable > 0) {
                        let tmpRealNum = $gameVariables.value(TatsuEightLineSlotP.realNumVariable);
                        if (tmpRealNum > 0) {
                            TatsuEightLineSlotP.realNum = tmpRealNum;
                        }
                    }
                    TatsuEightLineSlotP.realImgheightAll = REAL_IMG_HEIGHT * TatsuEightLineSlotP.realNum;
                    SceneManager.push(Scene_NineLineSlotScene);
                    break;
                }
            }
        };
    } else {
        PluginManager.registerCommand(pluginName, "start", args => {
            if (args.length == 1) {
                globalPlayRealId = Number(args[1]);
            } else {
                globalPlayRealId = 1;
            }
            TatsuEightLineSlotP.realNum = 9;
            if (TatsuEightLineSlotP.realNumVariable && TatsuEightLineSlotP.realNumVariable > 0) {
                let tmpRealNum = $gameVariables.value(TatsuEightLineSlotP.realNumVariable);
                if (tmpRealNum > 0) {
                    TatsuEightLineSlotP.realNum = tmpRealNum;
                }
            }
            TatsuEightLineSlotP.realImgheightAll = REAL_IMG_HEIGHT * TatsuEightLineSlotP.realNum;

            SceneManager.push(Scene_NineLineSlotScene);
        });
    }
    // ==各種共通関数まわり-end==================================================

    class Scene_NineLineSlotScene extends Scene_Base{
        constructor(){
            super();
        };

        initialize(){
           super.initialize();
           TatsuEightLineSlotP.useHelp = TatsuEightLineSlotP.useHelpStr == "true" ?  true : false;
           TatsuEightLineSlotP.useBGM = TatsuEightLineSlotP.useBGMStr == "true" ?  true : false;
           TatsuEightLineSlotP.useHelpExit = TatsuEightLineSlotP.useHelpExitStr == "true" ?  true : false;
           this._realInfoList = new Array();
           this._startRealList = null;
           this._stoppingRealList = null;
           this._turn = TURN_INIT;
           this._realWaitCnt = 0;
           this._targetPlayRealInfo = null;
           this._okList = new Array();
           this._changeColorOkList = new Array();
           this._nowButtonPos = 0;
           if (!Array.isArray(TatsuEightLineSlotP.realInfomang)) {
            this._targetPlayRealInfo = TatsuEightLineSlotP.realInfomang;
           } else {
            this._targetPlayRealInfo = TatsuEightLineSlotP.realInfomang.filter(function(realInfo){
                return realInfo.realId === globalPlayRealId;
            })[0];
           }
           
           let groupList = {};
           groupList[REAL_CHECK_KEY_BESIDE] = new Array();
           let besideList = new Array();
           for (let i = 1 ; i <= 9 ;i++) {
             besideList.push(i-1);
             if (i%3 == 0) {
                 groupList[REAL_CHECK_KEY_BESIDE].push(besideList);
                 besideList = new Array();
             }
           }

           groupList[REAL_CHECK_KEY_VERTICAL] = new Array();
           let verticalList1 = new Array();
           verticalList1.push(0);
           verticalList1.push(3);
           verticalList1.push(6);
           groupList[REAL_CHECK_KEY_VERTICAL].push(verticalList1);
           let verticalList2 = new Array();
           verticalList2.push(1);
           verticalList2.push(4);
           verticalList2.push(7);
           groupList[REAL_CHECK_KEY_VERTICAL].push(verticalList2);
           let verticalList3 = new Array();
           verticalList3.push(2);
           verticalList3.push(5);
           verticalList3.push(8);
           groupList[REAL_CHECK_KEY_VERTICAL].push(verticalList3);

           groupList[REAL_CHECK_KEY_DIAGNOAL] = new Array();
           let diagonalList1 = new Array();
           diagonalList1.push(0);
           diagonalList1.push(4);
           diagonalList1.push(8);
           groupList[REAL_CHECK_KEY_DIAGNOAL].push(diagonalList1);
           let diagonalList2= new Array();
           diagonalList2.push(2);
           diagonalList2.push(4);
           diagonalList2.push(6);
           groupList[REAL_CHECK_KEY_DIAGNOAL].push(diagonalList2);
           this._groupCheckList = groupList;
           this._animationCnt = 0;
           this._betCoin = 0;
           this._nowCoint = 0;
           this._repeatBetCoin = 0;
           this._nowSelectButton = BUTTON_START_POS;
           this._mode = MODE_GAME_PLAY;
           this._startCount = 0;
           this._winAnimationCnt = 90;
           this._betPlayCoin = 1;
           if (TatsuEightLineSlotP.oneBetCoinVariable && TatsuEightLineSlotP.oneBetCoinVariable > 0) {
              let betPlayCoinTmp = $gameVariables.value(TatsuEightLineSlotP.oneBetCoinVariable);
              if (betPlayCoinTmp > 0) {
                 this._betPlayCoin = betPlayCoinTmp;
              }
           }
        };

        create(){
            super.create();
            this.createBackground();
            this.createImgBord();
            this.createImg();
            this.createWindowLayer();
            let xpos = 0;
            let ypos = 0;
            let i = 0;
            const realImgName = this._targetPlayRealInfo.realImgName;
            for (let ypos = 0 ; ypos < 3 ; ypos++) {
                for (let xpos = 0 ; xpos < 3 ; xpos++) {
                    let tmp = new Window_RealWindow(0,0,0,0,realImgName);
                    tmp.initsettingRealInfo(i,xpos,ypos);
                    this._realInfoList.push(tmp);
                    this.addWindow(this._realInfoList[i]);
                    this._realBord.addChild(this._realInfoList[i].getRealSprite());
                    this._frameBord.addChild(this._realInfoList[i].getCorrectFrameSprite());
                    i++;
                }
            }

            this.createWindow();
        };

        createBackground(){
            this._backGroundImg = new Sprite(loadBitmapByTSlotPluginFolder(TatsuEightLineSlotP.backgroundImage));
            this.addChild(this._backGroundImg);
        };

        createImgBord(){
            this._imgBaseBord = new Sprite();
            this.addChild(this._imgBaseBord);
            this._partsBaseBord = new Sprite();
            this._imgBaseBord.addChild(this._partsBaseBord);
            this._slotBase = new Sprite();
            this._partsBaseBord.addChild(this._slotBase);
            this._slotBase.x = TatsuEightLineSlotP.slotFrameXpos;
            this._slotBase.y = TatsuEightLineSlotP.slotFrameYpos;
            this._realBord = new Sprite();
            this._slotBase.addChild(this._realBord);
            this._frameBord = new Sprite();
            this._slotBase.addChild(this._frameBord);

            
            this._scoreBord = new Sprite();
            this._partsBaseBord.addChild(this._scoreBord);
            this._buttonBord = new Sprite();
            this._partsBaseBord.addChild(this._buttonBord);
            this._coinBord = new Sprite();
            this._partsBaseBord.addChild(this._coinBord);
            this._helpViewImgList = new Array();
            this._helpExitImg = undefined;
            if (TatsuEightLineSlotP.useHelp) {
                if (TatsuEightLineSlotP.helpModeList && TatsuEightLineSlotP.helpModeList.length > 0) {
                    for (let i = 0 ; i < TatsuEightLineSlotP.helpModeList.length ;i++) {
                        this._helpViewImgList.push(new Sprite(loadBitmapByTSlotPluginFolder(TatsuEightLineSlotP.helpModeList[i])));
                    }
                }
            }

            if (TatsuEightLineSlotP.useHelpExit) {
                this._helpExitImg = new Sprite(loadBitmapByTSlotPluginFolder(TatsuEightLineSlotP.helpExitImg));
                this._helpExitImg.x = TatsuEightLineSlotP.helpExitImgXpos;
                this._helpExitImg.y = TatsuEightLineSlotP.helpExitImgYpos;
            }
        };

        createImg(){
            this._frameImg = new Sprite(loadBitmapByTSlotPluginFolder(TatsuEightLineSlotP.frameImg));
            this._frameBord.addChild(this._frameImg);

            this._scoreImg = new Sprite(loadBitmapByTSlotPluginFolder(this._targetPlayRealInfo.realScoreName));
            this._scoreBord.addChild(this._scoreImg);
            this._scoreImg.x = TatsuEightLineSlotP.scoreImgXPos
            this._scoreImg.y = TatsuEightLineSlotP.scoreImgYPos;

            this._helpButtonImg = new Sprite(loadBitmapByTSlotPluginFolder(TatsuEightLineSlotP.helpImg));
            this._buttonBord.addChild(this._helpButtonImg);
            this._helpButtonImg.x = TatsuEightLineSlotP.helpXpos;
            this._helpButtonImg.y = TatsuEightLineSlotP.helpYpos;
            if (!TatsuEightLineSlotP.useHelp) {
                this._helpButtonImg.opacity = 0;
            }
            this._oneBetButtonImg = new Sprite(loadBitmapByTSlotPluginFolder(TatsuEightLineSlotP.onebetImg));
            this._buttonBord.addChild(this._oneBetButtonImg);
            this._oneBetButtonImg.x = TatsuEightLineSlotP.oneBetXpos;
            this._oneBetButtonImg.y = TatsuEightLineSlotP.oneBetYpos;

            this._maxBetButtonImg = new Sprite(loadBitmapByTSlotPluginFolder(TatsuEightLineSlotP.maxbetImg));
            this._buttonBord.addChild(this._maxBetButtonImg);
            this._maxBetButtonImg.x = TatsuEightLineSlotP.maxBetXpos;
            this._maxBetButtonImg.y = TatsuEightLineSlotP.maxBetYpos;

            this._startRepeatButtonImg = new Sprite(loadBitmapByTSlotPluginFolder(TatsuEightLineSlotP.startRepeatImg));
            this._buttonBord.addChild(this._startRepeatButtonImg);
            this._startRepeatButtonImg.x = TatsuEightLineSlotP.startRepeatXpos;
            this._startRepeatButtonImg.y = TatsuEightLineSlotP.startRepeatYpos;


            this._exitButtonImg = new Sprite(loadBitmapByTSlotPluginFolder(TatsuEightLineSlotP.exitImg));
            this._buttonBord.addChild(this._exitButtonImg);
            this._exitButtonImg.x = TatsuEightLineSlotP.exitXpos;
            this._exitButtonImg.y = TatsuEightLineSlotP.exitYpos;

            this._buttonFrameImg = new Sprite(loadBitmapByTSlotPluginFolder(TatsuEightLineSlotP.buttonFrameImg));
            this._buttonBord.addChild(this._buttonFrameImg);
            this._imgList = {};
            this._imgList[BUTTON_HELP_POS] = this._helpButtonImg;
            this._imgList[BUTTON_ONEBET_POS] = this._oneBetButtonImg;
            this._imgList[BUTTON_MAXBET_POS] = this._maxBetButtonImg;
            this._imgList[BUTTON_START_POS] = this._startRepeatButtonImg;
            this._imgList[BUTTON_EXIT_POS] = this._exitButtonImg;
            this.setButtonSelect();
        };


        createFadeImg(){
        };
    
        createWindow(){
            this._betCoinWindow = new Window_BetCoinWindow(
                TatsuEightLineSlotP.betCoinPosX,
                TatsuEightLineSlotP.betCoinPosY,
                TatsuEightLineSlotP.betCoinWindowWidth,
                TatsuEightLineSlotP.betCoinWindowHeight
                );

            this._nowCoinWindow = new Window_NowCoinWindow(
                TatsuEightLineSlotP.nowCoinPosX,
                TatsuEightLineSlotP.nowCoinPosY,
                TatsuEightLineSlotP.nowCoinWindowWidth,
                TatsuEightLineSlotP.nowCoinWindowHeight
            );

            this.addWindow(this._betCoinWindow);
            this.addWindow(this._nowCoinWindow);
            this._betCoinWindow.initializeCoin();
            this._nowCoinWindow.reDrawCoinByVariable();
            this._betCoinWindow.reDrawCoin(this._betCoin);
            this._betCoinWindow.opacity = 0;
            this._nowCoinWindow.opacity = 0;
            this._betWindowFrameImg = new Sprite(loadBitmapByTSlotPluginFolder(TatsuEightLineSlotP.betWindowFrameImg));
            this._nowWindowFrameImg = new Sprite(loadBitmapByTSlotPluginFolder(TatsuEightLineSlotP.nowWindowFrameImg));
            this._coinBord.addChild(this._betWindowFrameImg);
            this._coinBord.addChild(this._nowWindowFrameImg);
            this._nowWindowFrameImg.x = TatsuEightLineSlotP.nowCoinPosX;
            this._nowWindowFrameImg.y = TatsuEightLineSlotP.nowCoinPosY;
            this._betWindowFrameImg.x = TatsuEightLineSlotP.betCoinPosX;
            this._betWindowFrameImg.y = TatsuEightLineSlotP.betCoinPosY;

            let messageWindowWidth = 1024;
            let messageCneterXPos = getCenterPos(Graphics.boxWidth,messageWindowWidth);
            this._WindowExitMsg = new Window_MessageInfo_Window(messageCneterXPos,230, messageWindowWidth,145);
            this._WindowExitMsg.drawMessage(TatsuEightLineSlotP.exitMessage);
            this.addWindow(this._WindowExitMsg);
    
            this._yesNoWindow = new Window_continue_Select();
            this._yesNoWindow.setHandler('ok',this.confirmExit.bind(this));
            this.addWindow(this._yesNoWindow);
            this._WindowExitMsg.close();
            this._WindowExitMsg.deactivate();
            this._yesNoWindow.close();
            this._yesNoWindow.deactivate();
        };

        isReady(){
            if (this._helpViewImgList && this._helpViewImgList.length > 0) {
                for (let i = 0 ; i < this._helpViewImgList.length ; i++) {
                    if (this._helpViewImgList[i].width < 1) {
                        return false;
                    }
                }
            }

            if (this._scoreImg.width <= 0) {
                return false;
            }
            return (super.isReady() && this._realInfoList[0].getRealSprite().width > 0);    
        };

        start(){
            super.start();
            if (TatsuEightLineSlotP.useBGM) {
                if (TatsuEightLineSlotP.backBGM != "" && TatsuEightLineSlotP.backBGM != null) {
                    playBGM();
                } else {
                    alert("警告：BGMが設定されていません。\nBGMを使わない場合は、プラグインパラメータ「 専用BGMを使うかどうか」を「false」にしてください。");
                    return;
                }
            }
            for (let i = 0 ; i < this._helpViewImgList.length ;i++) {
                this._helpViewImgList[i].opacity = 0;
            }

            if (TatsuEightLineSlotP.useHelp) {
                if (!TatsuEightLineSlotP.helpModeList || (TatsuEightLineSlotP.helpModeList && TatsuEightLineSlotP.helpModeList.length == 0)) {
                    alert("HELPを使用する設定になっているため、プラグインパラメータよりHELP画像を設定して下さい。");
                    this.popScene();
                    return;
                }
            }
 
            if (TatsuEightLineSlotP.useHelpExit) {
                if (!TatsuEightLineSlotP.helpExitImg || (TatsuEightLineSlotP.helpExitImg == "")) {
                    alert("HELPを閉じる画像を使用する設定になっているため、プラグインパラメータよりHELPを閉じる画像を設定して下さい。");
                    this.popScene();
                    return;
                }
            }

            for (let i = 0 ; i < TatsuEightLineSlotP.realNum ;i++) {
                let realIndex = i + 1;
                let parameterCheckList = this._targetPlayRealInfo.realGroupInfoList.filter(function(group){
                    return group.realGroup.indexOf(realIndex) != -1;
                })[0];

                if (!parameterCheckList) {
                    alert("プラグインパラメータのリール情報-リールグループ情報が入力されていません。確認をしてください。\n「不正なrealGroupの情報："+realIndex+"」");
                    this.popScene();
                    return;
                }
            }

            let maxBetCoin = 10;
            if (TatsuEightLineSlotP.maxBetCoinVariable && TatsuEightLineSlotP.maxBetCoinVariable > 0) {
                maxBetCoin = $gameVariables.value(TatsuEightLineSlotP.maxBetCoinVariable);
            }

            if (this._betPlayCoin > maxBetCoin) {
                alert("一回BETを行うコインの枚数がMAXBETの値を超えています。確認をしてください。\n「一回のBET数："+this._betPlayCoin+"」\n「MAXBET数："+maxBetCoin+"」");
                this.popScene();
                return;
            }
        };

        update(){
            super.update();
            switch (this._turn) {
                case TURN_INIT:
                    this.turnInit();
                    break;
                case TURN_WAIT:
                    this.waitSelect();
                    break;
                case TURN_START:
                    this.startReal();
                    break;
                case TURN_RUNNING:
                    if (this._realWaitCnt > 60) {
                        if (globalInputOkAndClick() || this._startCount >= 90){
                            this._realWaitCnt = 0;
                            this._startCount = 0;
                            this._turn = TURN_STOPPING;
                        }
                        if (this._startCount < 90 && this._turn == TURN_RUNNING) {
                            this._startCount++;
                        }

                    } else {
                        this._realWaitCnt++;
                    }

                    break;
                case TURN_STOPPING:
                    this.realStop();
                    break;
                case TURN_ROLECHECK:
                    this.roleCheck();
                    break;
                case TURN_ROLEANIMATION:
                    this.roleAnimation();
                    break;
                case TURN_OKANIMATION:
                    this.okAnimation();
                    break;
                case TURN_NGANIMATION:
                    this.ngAnimation();
                    break;
                case TURN_CALC_COIN:
                    this.calcCoin();
                    break;
            }

        };

        confirmExit(){
            if (this._yesNoWindow.index() < 0) {
                this._yesNoWindow.activate();
                return;
            }

            if (this._yesNoWindow.isOpen()) {
                if (this._turn == TURN_WAIT) {
                    if (this._yesNoWindow.isNowSelectYes()) {
                        this.popScene();
                    } else {
                        this._WindowExitMsg.close();
                        this._yesNoWindow.close();
                    }
                }
            }        
        };

        fadeIn(){
        };

        turnInit(){
            this._betCoin = 0;
            //this._betCoinWindow.reDrawCoin(this._betCoin);
            this._nowCoinWindow.reDrawCoinByVariable();
            for (let i = 0 ; i < this._realInfoList.length ;i++) {
                this._realInfoList[i].getCorrectFrameSprite().opacity = 0;
            }
            this._turn = TURN_WAIT;
        };
        waitSelect(){
            if (this._mode == MODE_GAME_PLAY) {
                if (!this._yesNoWindow.isOpen()) {
                    if (globalInputClick()){
                        if (this.isTouhButton(BUTTON_HELP_POS,TouchInput.x,TouchInput.y) && TatsuEightLineSlotP.useHelp) {
                            this._nowSelectButton = BUTTON_HELP_POS;
                            this.setHintPosition();
                            this.clickHelp();
                            SoundManager.playOk();
                        } else if (this.isTouhButton(BUTTON_ONEBET_POS,TouchInput.x,TouchInput.y)){
                            this._nowSelectButton = BUTTON_ONEBET_POS;
                            this.setButtonSelect();
                            this.clickOneBet();
                            SoundManager.playCursor();
                        } else if (this.isTouhButton(BUTTON_MAXBET_POS,TouchInput.x,TouchInput.y)) {
                            this._nowSelectButton = BUTTON_MAXBET_POS;
                            this.setButtonSelect();
                            this.clickMaxBet();
                            SoundManager.playCursor();
                        } else if (this.isTouhButton(BUTTON_EXIT_POS,TouchInput.x,TouchInput.y)) {
                            this._nowSelectButton = BUTTON_EXIT_POS;
                            this.setButtonSelect();
                            if (this._betCoin < 1) {
                                this._WindowExitMsg.drawMessage(TatsuEightLineSlotP.exitMessage);
                                this._WindowExitMsg.open();
                                this._yesNoWindow.open();
                            } else {
                                SoundManager.playBuzzer();
                            }

                        } else if (this.isTouhButton(BUTTON_START_POS,TouchInput.x,TouchInput.y)) {
                            this._nowSelectButton = BUTTON_START_POS;
                            this.setButtonSelect();
                            if (this.clickStart()) {
                                playStartSE();
                            }
                        }

                    } else if (globalInputLeft()) {
                        if (this._nowSelectButton == BUTTON_ONEBET_POS) {
                            if (TatsuEightLineSlotP.useHelp) {
                                this._nowSelectButton = BUTTON_HELP_POS;
                            } else {
                                this._nowSelectButton = BUTTON_EXIT_POS;
                            }
                        } else if (this._nowSelectButton == BUTTON_HELP_POS){
                            this._nowSelectButton = BUTTON_EXIT_POS;
                        } else {
                            this._nowSelectButton--;
                        }
                        SoundManager.playCursor();
                        this.setButtonSelect();
                    } else if (globalInputRight()) {
                        if (this._nowSelectButton == BUTTON_EXIT_POS) {
                            if (TatsuEightLineSlotP.useHelp) {
                                this._nowSelectButton = BUTTON_HELP_POS;
                            } else {
                                this._nowSelectButton = BUTTON_ONEBET_POS;
                            }
                        } else {
                            this._nowSelectButton++;
                        }
                        SoundManager.playCursor();
                        this.setButtonSelect();
                    } else if (globalInputOk()) {
                        switch(this._nowSelectButton){
                            case BUTTON_HELP_POS:
                                this.clickHelp();
                                SoundManager.playOk();
                                break;
                            case BUTTON_ONEBET_POS:
                                this.clickOneBet();
                                SoundManager.playOk();
                                break;
                            case BUTTON_MAXBET_POS:
                                this.clickMaxBet();
                                SoundManager.playOk();
                                break;
                            case BUTTON_EXIT_POS:
                                if (this._betCoin < 1) {
                                    this._WindowExitMsg.drawMessage(TatsuEightLineSlotP.exitMessage);
                                    this._WindowExitMsg.open();
                                    this._yesNoWindow.open();
                                    SoundManager.playOk();
                                } else {
                                    SoundManager.playBuzzer();
                                }
                                break;
                            case BUTTON_START_POS:
                                if (this.clickStart()) {
                                    playStartSE();
                                }
                                
                                break;
                        }
                    } else if (globalInputCancel()) {
                        if (this._betCoin < 1) {
                            this._WindowExitMsg.drawMessage(TatsuEightLineSlotP.exitMessage);
                            this._WindowExitMsg.open();
                            this._yesNoWindow.open();
                        } else {
                            SoundManager.playBuzzer();
                        }

                    }
                }
            } else {
                this.helpView();
            }
 
        };


        clickHelp(){
            for (let i = 0 ; i < this._helpViewImgList.length ;i++) {
                this.addChild(this._helpViewImgList[i]);
            }
            if (TatsuEightLineSlotP.useHelpExit && this._helpExitImg) {
                this.addChild(this._helpExitImg);   
            }
            this._helpViewImgList[0].opacity = 255;
            this._mode = MODE_HELP;
        };

        helpView(){
            if ((globalInputOkAndClick() && !this.checkClickHelpImg()) || globalInputRight()) {
                let nowIndex = 0;
                for (let i = 0 ; i < this._helpViewImgList.length ;i++) {
                    if (this._helpViewImgList[i].opacity == 255) {
                        nowIndex = i;
                        break;
                    }
                }
    
                if (this._helpViewImgList[this._helpViewImgList.length-1].opacity == 255) {
                    this._helpViewImgList[0].opacity = 255;
                    for (let i = 1 ; i < this._helpViewImgList.length ;i++) {
                        this._helpViewImgList[i].opacity = 0;
                    }
                } else {
    
                    this._helpViewImgList[nowIndex+1].opacity = 255;
                    for (let i = 0 ; i < this._helpViewImgList.length ;i++) {
                        if (i != (nowIndex+1)) {
                            this._helpViewImgList[i].opacity = 0;
                        }
                    }
                }
                SoundManager.playCursor();
            } else if (globalInputLeft()) {
                let nowIndex = 0;
                for (let i = 0 ; i < this._helpViewImgList.length ;i++) {
                    if (this._helpViewImgList[i].opacity == 255) {
                        nowIndex = i;
                        break;
                    }
                }

                if (this._helpViewImgList[0].opacity == 255) {
                    this._helpViewImgList[this._helpViewImgList.length-1].opacity = 255;

                    for (let i = 0 ; i < this._helpViewImgList.length-1 ;i++) {
                        this._helpViewImgList[i].opacity = 0;
                    }
                } else {
                    this._helpViewImgList[nowIndex-1].opacity = 255;
                    for (let i = 0 ; i < this._helpViewImgList.length ;i++) {
                        if (i != (nowIndex-1)) {
                            this._helpViewImgList[i].opacity = 0;
                        }
                    }
                }
                SoundManager.playCursor();
            } else if (globalInputCancel() || (globalInputOkAndClick() && this.checkClickHelpImg())){
                this.exitHelp();
                SoundManager.playOk();
            }
        };

        checkClickHelpImg(){
            if (TatsuEightLineSlotP.useHelpExit) {
                return this.isTouchImg(this._helpExitImg,TouchInput.x,TouchInput.y)
            }

            return false;
        }

        exitHelp(){
            for (let i = 0 ; i < this._helpViewImgList.length ;i++) {
                this._helpViewImgList[i].opacity = 0;
                this.removeChild(this._helpViewImgList[i]);
            }
            if (TatsuEightLineSlotP.useHelpExit) {
                this.removeChild(this._helpExitImg);
            }
            this._mode = MODE_GAME_PLAY;
        };

        clickOneBet(){
            let maxBetCoin = 10;
            if (TatsuEightLineSlotP.maxBetCoinVariable && TatsuEightLineSlotP.maxBetCoinVariable > 0) {
                maxBetCoin = $gameVariables.value(TatsuEightLineSlotP.maxBetCoinVariable);
            }

            let nowCoin = $gameVariables.value(TatsuEightLineSlotP.coinVariable);
            if (this._betCoin < maxBetCoin &&
                nowCoin > 0 && 
                this._betPlayCoin <= nowCoin && 
                maxBetCoin >= (this._betCoin + this._betPlayCoin)) {
                this._betCoin = this._betCoin + this._betPlayCoin;
                $gameVariables.setValue(TatsuEightLineSlotP.coinVariable,nowCoin-this._betPlayCoin);
                this._betCoinWindow.reDrawCoin(this._betCoin);
                this._nowCoinWindow.reDrawCoinByVariable();
                this._repeatBetCoin = this._betCoin;
            } else {
                if (!this._WindowExitMsg.isOpen()) {
                    if (nowCoin<=0) {
                        this._WindowExitMsg.drawMessage(TatsuEightLineSlotP.notCoinMessage);
                        this._WindowExitMsg.opentWithTimeoutClose();
                    } else if (this._betCoin >= maxBetCoin) {
                        this._WindowExitMsg.drawMessage(TatsuEightLineSlotP.limitCoinMessage);
                        this._WindowExitMsg.opentWithTimeoutClose();
                    } else if (maxBetCoin < (this._betCoin + this._betPlayCoin)) {
                        this._WindowExitMsg.drawMessage(TatsuEightLineSlotP.limitCoinMessage);
                        this._WindowExitMsg.opentWithTimeoutClose();
                    }
                }
            }
        };

        clickMaxBet(){
            let maxBetCoin = 10;
            if (TatsuEightLineSlotP.maxBetCoinVariable && TatsuEightLineSlotP.maxBetCoinVariable > 0) {
                maxBetCoin = $gameVariables.value(TatsuEightLineSlotP.maxBetCoinVariable);
            }
            let nowCoin = $gameVariables.value(TatsuEightLineSlotP.coinVariable);
            if (this._betCoin < maxBetCoin &&
                nowCoin > 0) {
                let nowBetCoin = this._betCoin;
                let zanBetCoin = $gameVariables.value(TatsuEightLineSlotP.maxBetCoinVariable) - nowBetCoin;
                if (zanBetCoin > 0) {
                    if (zanBetCoin < nowCoin) {
                        $gameVariables.setValue(TatsuEightLineSlotP.coinVariable,nowCoin-zanBetCoin);
                        this._betCoin += zanBetCoin;
                    } else {
                        $gameVariables.setValue(TatsuEightLineSlotP.coinVariable,0);
                        this._betCoin += nowCoin;
                    }
                    this._betCoinWindow.reDrawCoin(this._betCoin);
                    this._nowCoinWindow.reDrawCoinByVariable();
                    this._repeatBetCoin = this._betCoin;
                }
            } else {
                if (!this._WindowExitMsg.isOpen()) {
                    if (nowCoin<=0) {
                        this._WindowExitMsg.drawMessage(TatsuEightLineSlotP.notCoinMessage);
                        this._WindowExitMsg.opentWithTimeoutClose();
                    } else if (this._betCoin >= maxBetCoin) {
                        this._WindowExitMsg.drawMessage(TatsuEightLineSlotP.limitCoinMessage);
                        this._WindowExitMsg.opentWithTimeoutClose();
                    }
                }
            }
        };

        clickStart(){
            let coinCheckFlag = false;
            let isStart = false;
            if (this._betCoin > 0) {
                coinCheckFlag = true;
            } else if (this._repeatBetCoin > 0 ){
                let maxBetCoin = $gameVariables.value(TatsuEightLineSlotP.maxBetCoinVariable);
                let nowCoin = $gameVariables.value(TatsuEightLineSlotP.coinVariable);
                if (this._repeatBetCoin <= nowCoin) {
                    this._betCoin = this._repeatBetCoin;
                    $gameVariables.setValue(TatsuEightLineSlotP.coinVariable,nowCoin-this._repeatBetCoin);
                    this._betCoinWindow.reDrawCoin(this._betCoin);
                    this._nowCoinWindow.reDrawCoinByVariable();
                    this._repeatBetCoin = this._betCoin;
                    coinCheckFlag = true;
                } else {
                    if (!this._WindowExitMsg.isOpen()) {
                        this._WindowExitMsg.drawMessage(TatsuEightLineSlotP.repeatNotCoinMessage);
                        this._WindowExitMsg.opentWithTimeoutClose();
                    }
                }
            } else {
                let tmpNowCoin = $gameVariables.value(TatsuEightLineSlotP.coinVariable);
                if (tmpNowCoin == 0) {
                    if (!this._WindowExitMsg.isOpen()) {
                        this._WindowExitMsg.drawMessage(TatsuEightLineSlotP.notCoinMessage);
                        this._WindowExitMsg.opentWithTimeoutClose();
                    }
                } else if (this._betCoin == 0) {
                    if (!this._WindowExitMsg.isOpen()) {
                        this._WindowExitMsg.drawMessage(TatsuEightLineSlotP.existsBetMessage);
                        this._WindowExitMsg.opentWithTimeoutClose();
                    }
                } else if (this._repeatBetCoin == 0) {
                    if (!this._WindowExitMsg.isOpen()) {
                        this._WindowExitMsg.drawMessage(TatsuEightLineSlotP.existsBetMessage);
                        this._WindowExitMsg.opentWithTimeoutClose();
                    }
                }

            }


            if (coinCheckFlag) {
                let targetedWindowIndexList = new Array();
                let stoppingTargetWindowIndexList = new Array();
                this._stoppingRealList = new Array();
                this._startRealList = new Array();
                for (let i = 0 ; i < this._realInfoList.length ; i++) {
                    targetedWindowIndexList.push(i);
                    stoppingTargetWindowIndexList.push(i);
                }

                let targetCnt = targetedWindowIndexList.length;
                while(targetCnt > 0){
                    let targetWindowIndex = Math.floor(Math.random()*targetedWindowIndexList.length);   
                    let index = targetedWindowIndexList[targetWindowIndex];
                    this._startRealList.push(index);
                    targetedWindowIndexList = targetedWindowIndexList.filter(n => n != index);
                    targetCnt = targetedWindowIndexList.length;
                }


                let stoppingtargetCnt = stoppingTargetWindowIndexList.length;
                while(stoppingtargetCnt > 0){
                    let stoptargetWindowIndex = Math.floor(Math.random()*stoppingTargetWindowIndexList.length);   
                    let sindex = stoppingTargetWindowIndexList[stoptargetWindowIndex];
                    this._stoppingRealList.push(sindex);
                    stoppingTargetWindowIndexList = stoppingTargetWindowIndexList.filter(n => n != sindex);
                    stoppingtargetCnt = stoppingTargetWindowIndexList.length;
                }
                this._startCount = 0;
                this._turn = TURN_START;
                isStart = true;
            }

            return isStart;
        };

        setButtonSelect(){
            switch(this._nowSelectButton){
                case BUTTON_HELP_POS:
                    this._buttonFrameImg.x = this._helpButtonImg.x;
                    this._buttonFrameImg.y = this._helpButtonImg.y;
                    break;
                case BUTTON_ONEBET_POS:
                    this._buttonFrameImg.x = this._oneBetButtonImg.x
                    this._buttonFrameImg.y = this._oneBetButtonImg.y;
                    break;
                case BUTTON_MAXBET_POS:
                    this._buttonFrameImg.x = this._maxBetButtonImg.x;
                    this._buttonFrameImg.y = this._maxBetButtonImg.y;
                    break;
                case BUTTON_START_POS:
                    this._buttonFrameImg.x = this._startRepeatButtonImg.x;
                    this._buttonFrameImg.y = this._startRepeatButtonImg.y;
                    break;
                case BUTTON_EXIT_POS:
                    this._buttonFrameImg.x = this._exitButtonImg.x;
                    this._buttonFrameImg.y = this._exitButtonImg.y;
                    break;
            }
        };

        startReal(){
            switch (this._realWaitCnt) {
                case 0:
                    this._realInfoList[this._startRealList[0]].realStart();
                    break;
                case 10:
                    this._realInfoList[this._startRealList[1]].realStart();
                    break;
                case 15:
                    this._realInfoList[this._startRealList[2]].realStart();
                    break;
                case 20:
                    this._realInfoList[this._startRealList[3]].realStart();
                    break;
                case 25:
                    this._realInfoList[this._startRealList[4]].realStart();
                    break;
                case 30:
                    this._realInfoList[this._startRealList[5]].realStart();
                    break;
                case 35:
                    this._realInfoList[this._startRealList[6]].realStart();
                    break;
                case 40:
                    this._realInfoList[this._startRealList[7]].realStart();
                    break;
                case 45:
                    this._realInfoList[this._startRealList[8]].realStart();
                    break;
            }

            this._realWaitCnt++;

            if (this._realWaitCnt > 50) {
                let cnt = 0;
                for (let i  = 0 ; i < this._realInfoList.length ; i++) {
                    if (!this._realInfoList[i].isRunnning()) {
                        break;
                    }
                    cnt++;
                }
                if (cnt == this._realInfoList.length) {
                    this._turn = TURN_RUNNING;
                    this._realWaitCnt = 0;
                }
            }
        };

        realStop(){
            switch (this._realWaitCnt) {
                case 0:
                    this._realInfoList[this._stoppingRealList[0]].realStop();
                    break;
                case 10:
                    this._realInfoList[this._stoppingRealList[1]].realStop();
                    break;
                case 15:
                    this._realInfoList[this._stoppingRealList[2]].realStop();
                    break;
                case 20:
                    this._realInfoList[this._stoppingRealList[3]].realStop();
                    break;
                case 25:
                    this._realInfoList[this._stoppingRealList[4]].realStop();
                    break;
                case 30:
                    this._realInfoList[this._stoppingRealList[5]].realStop();
                    break;
                case 35:
                    this._realInfoList[this._stoppingRealList[6]].realStop();
                    break;
                case 40:
                    this._realInfoList[this._stoppingRealList[7]].realStop();
                    break;
                case 45:
                    this._realInfoList[this._stoppingRealList[8]].realStop();
                    break;
            }

            if (this._realWaitCnt > 45) {
                let cnt = 0;
                for (let i  = 0 ; i < this._realInfoList.length ; i++) {
                    if (!this._realInfoList[i].isWait()) {
                        break;
                    }
                    cnt++;
                }
                if (cnt == this._realInfoList.length) {
                    this._turn = TURN_ROLECHECK;
                    this._realWaitCnt = 0;
                }
            } else {
                this._realWaitCnt++;
            }
        };

        roleCheck(){
            let besidecheckList = this.getGroupList(this._groupCheckList[REAL_CHECK_KEY_BESIDE]);
            let verticalcheckList = this.getGroupList(this._groupCheckList[REAL_CHECK_KEY_VERTICAL]);
            let diagnoalcheckList = this.getGroupList(this._groupCheckList[REAL_CHECK_KEY_DIAGNOAL]);
            //縦単位のリールのチェック
            this._okList = new Array();
            this._okBesideOkNumList = new Array();
            this._okVerticalOkNumList = new Array();
            this._okDiagnoalOkNumList = new Array();
            let rtnOkInfoBesideList = this.getOkInfo(besidecheckList);
            if (Object.keys(rtnOkInfoBesideList).length > 0) {
                this._okList = this._okList.concat(rtnOkInfoBesideList['rtnScoreList']);
                this._okBesideOkNumList = rtnOkInfoBesideList['rtnRealNumberList'];
            }

            //横単位のリールのチェック
            let rtnOkInfoVerticalList = this.getOkInfo(verticalcheckList);
            if (Object.keys(rtnOkInfoVerticalList).length > 0) {
                this._okList = this._okList.concat(rtnOkInfoVerticalList['rtnScoreList']);
                this._okVerticalOkNumList = rtnOkInfoVerticalList['rtnRealNumberList'];
            }

            //斜め単位のリールチェック
            let rtnOkInfoDiagnoalList = this.getOkInfo(diagnoalcheckList);
            if (Object.keys(rtnOkInfoDiagnoalList).length > 0) {
                this._okList = this._okList.concat(rtnOkInfoDiagnoalList['rtnScoreList']);
                this._okDiagnoalOkNumList = rtnOkInfoDiagnoalList['rtnRealNumberList'];
            }
            
            this._turn = TURN_ROLEANIMATION;
        };

        getGroupList(groupList){
            let rtncheckList = new Array();
            for (let i = 0 ; i < groupList.length ; i++) {
                let checkList = groupList[i];
                let checkGroupList = new Array();
                for (let j = 0 ; j < checkList.length ; j++) {
                    checkGroupList.push(this._realInfoList[checkList[j]]);
                }
                rtncheckList.push(checkGroupList);
            }

            return rtncheckList;
        };

        getOkInfo(checkLine){
            let inCheckInfoGroupList = this._targetPlayRealInfo.realGroupInfoList;
            let rtnCheckList = new Array();
            let rtnNumList = new Array();
            let rtnParam = {};
            for (let i = 0 ; i < checkLine.length ; i++) {
                let checkList = checkLine[i];
                let realIndexNumbr = checkList[0].getRealInfo().getRealNumber();
                let parametercheckTargetRealGroup = inCheckInfoGroupList.filter(function(group){
                    return group.realGroup.indexOf(realIndexNumbr) != -1;
                })[0];
                
                let trueLine = true;
                for (let j = 1 ; j < checkList.length ; j++) {
                    let realInfo = checkList[j];
                    if (parametercheckTargetRealGroup.realGroup.indexOf(realInfo.getRealInfo().getRealNumber()) == -1) {
                        trueLine = false;
                        break;
                    }
                }

                if (trueLine){
                    for (let j = 0 ; j < checkList.length ; j++) {
                        rtnNumList.push(checkList[j].getRealNo());
                    }
                    rtnCheckList.push(parametercheckTargetRealGroup);
                }
            }

            if (rtnCheckList.length > 0) {
                rtnParam['rtnScoreList'] = rtnCheckList;
                rtnParam['rtnRealNumberList'] = rtnNumList;
            }

            return rtnParam;
        };

        roleAnimation(){
            // アニメーション前に何か処理を入れたい場合を考慮
            this._turn = this._okList.length == 0 ? TURN_NGANIMATION : TURN_OKANIMATION;
            this._animationCnt = 0;
        };

        ngAnimation(){
            if (this._animationCnt == 0) {
                // 揃わなかった時のSE
                globalPlaySe(TatsuEightLineSlotP.lineNotCompSE);
            }

            if (this._animationCnt >= 30) {
                this._turn = TURN_INIT;
                this._animationCnt = 0;
                AudioManager.stopSe();
            }

            if (this._animationCnt < 30) {
                this._animationCnt++;
            }
        };

        okAnimation(){
            if (this._animationCnt == 0) {
                let okIndexList = new Array();
                let isAllLine = false;
                for (let i = 0 ; i < this._realInfoList.length ;i++) {
                    let isInclueds = false;
                    let realNum = this._realInfoList[i].getRealNo();
                    if (this._okBesideOkNumList.includes(realNum)) {
                        isInclueds = true;
                    }

                    if (!isInclueds && this._okVerticalOkNumList.includes(realNum)) {
                        isInclueds = true;
                    }

                    if (!isInclueds && this._okDiagnoalOkNumList.includes(realNum)) {
                        isInclueds = true;
                    }

                    if (isInclueds) {
                        this._realInfoList[i].getCorrectFrameSprite().opacity = 255;
                    }
                    okIndexList.push(this._realInfoList[i].getRealInfo().getRealNumber());
                }

                let newArray = okIndexList.filter((element,index) => okIndexList.indexOf(element) === index);
                if (newArray && newArray.length == 1) {
                    // 揃った時のSE
                    this._winAnimationCnt = 120
                    globalPlaySe(TatsuEightLineSlotP.allLineCompSE);
                } else {
                    // 揃った時のSE
                    this._winAnimationCnt = 90;
                    globalPlaySe(TatsuEightLineSlotP.lineCompSE);
                }
                const baseBetCoin = this._betCoin;
                let tmpOkCoin = 0;
                this._okList.forEach(function(okElement){
                    let tmpCoin = baseBetCoin * okElement.realgroupScore;
                    tmpOkCoin += tmpCoin;
                });
                let tmpNowCoin = $gameVariables.value(TatsuEightLineSlotP.coinVariable);
                let message1 = TatsuEightLineSlotP.winMessage1.replace("%d",tmpOkCoin);
                this._WindowExitMsg.drawMessage(message1);
                this._WindowExitMsg.open();
                $gameVariables.setValue(TatsuEightLineSlotP.coinVariable,tmpNowCoin+tmpOkCoin);
                this._nowCoinWindow.reDrawCoinByVariable();
            }

            if (this._animationCnt >= this._winAnimationCnt || globalInputClick()) {
                this._turn = TURN_CALC_COIN;
                this._animationCnt = 0;
            }

            if (this._animationCnt < this._winAnimationCnt && this._turn == TURN_OKANIMATION) {
                this._animationCnt++;
            }
        };

        calcCoin(){
            if (this._animationCnt == 0) {
            }

            if (this._animationCnt >= 1) {
                this._turn = TURN_INIT;
                this._WindowExitMsg.close();
                AudioManager.stopSe();
            }
            if (this._animationCnt < 10 && this._turn == TURN_CALC_COIN) {
                this._animationCnt++;
            }
        };


        popScene(){
            stopBGM();
            super.popScene();
        };

        setHintPosition(){
            this._nowButtonPos = BUTTON_HELP_POS;
            this._buttonFrameImg.x = this._helpButtonImg.x;
            this._buttonFrameImg.y = this._helpButtonImg.y;
        };

        setOneBetPosition(){
            this._nowButtonPos = BUTTON_ONEBET_POS;
            this._buttonFrameImg.x = this._oneBetButtonImg.x;
            this._buttonFrameImg.y = this._oneBetButtonImg.y;
        };

        setMaxBetPosition(){
            this._nowButtonPos = BUTTON_MAXBET_POS;
            this._buttonFrameImg.x = this._maxBetButtonImg.x;
            this._buttonFrameImg.y = this._maxBetButtonImg.y;
        };
        
        setStartRepeatBetPosition(){
            this._nowButtonPos = BUTTON_START_POS;
            this._buttonFrameImg.x = this._startRepeatButtonImg.x;
            this._buttonFrameImg.y = this._startRepeatButtonImg.y;
        };
        
        setExitPosition(){
            this._nowButtonPos = BUTTON_EXIT_POS;
            this._buttonFrameImg.x = this._exitButtonImg.x;
            this._buttonFrameImg.y = this._exitButtonImg.y;
        };

        isTouhButton(buttonPos,x,y){
            let buttonImgObj = this._imgList[buttonPos];
            return this.isTouchImg(buttonImgObj,x,y);
        };

        isTouchImg(buttonImgObj,x,y){
            return (buttonImgObj.x <= x && (buttonImgObj.x + buttonImgObj.width) >= x &&
                buttonImgObj.y <= y && (buttonImgObj.y + buttonImgObj.height) >= y);
        };

        setNowButtonPos(num){
            this._nowButtonPos = num;
        };
    
        getNowButtonPos(){
            return this._nowButtonPos;
        };

        popScene(){
            if (TatsuEightLineSlotP.useBGM) {
                AudioManager.fadeOutBgm(1);
                $gameSystem.replayBgm();
            }
            super.popScene();
        };
    };

    class Window_RealWindow extends Window_Base{
        constructor(ix,iy,iwidth,iheigt,realImgName){
            super(ix,iy,iwidth,iheigt,realImgName);
        };

        initialize(ix,iy,iwidth,iheigt,realImgName){
            if (isRpgMakerMV()) {
                Window_Base.prototype.initialize.call(this,
                    ix,
                    iy,
                    iwidth,
                    iheigt);
            }  else {
                Window_Base.prototype.initialize.call(this,
                    getdummyWindowRectParameter(
                        ix,
                        iy,
                        iwidth,
                        iheigt)
                    ); 
            }
            this.opacity = 0;
            this._realInfoStatus = REAL_RUN_STATUS_WAIT;
            this._animationSpeed = 0;
            this._adjustStartPoint = 0;
            this._lastAdjustPoint = 0;
            this._animationPoint = TatsuEightLineSlotP.realImgheightAll;
            this._realInitPosition = 0;
            if (TatsuEightLineSlotP.initPositionVariable && TatsuEightLineSlotP.initPositionVariable > 0) {
                let initPositionTmp = $gameVariables.value(TatsuEightLineSlotP.initPositionVariable);
                if (initPositionTmp > 0) {
                    this._realInitPosition = initPositionTmp;
                    let tmpIndex = 0;
                    for (let i = TatsuEightLineSlotP.realNum ; i >=0 ; i--) {
                        if (tmpIndex == (initPositionTmp-1)) {
                             this._animationPoint = REAL_IMG_HEIGHT * i;
                             break;
                        }
                        tmpIndex++;
                    }
                }
            }


            this._realInfo = new RealInfo(
                new Sprite(loadBitmapByTSlotPluginFolder(realImgName)),
                0, 
                0, 
                0,
                new Sprite(loadBitmapByTSlotPluginFolder(FILE_NAME_CORRECT_FRAME)),
                this._realInitPosition);
        };

        initsettingRealInfo(realNo,xpos,ypos){
            this.setRealNo(realNo);
            this.setLineX(xpos);
            this.setLineY(ypos);
            // postion
            let imgPosX = (xpos * REAL_IMG_WIDTH) + (TatsuEightLineSlotP.realImgSpan * (xpos + 1));
            let imgPosY = (ypos * REAL_IMG_HEIGHT) + (TatsuEightLineSlotP.realImgSpan * (ypos + 1));
            let correctImgPosX = imgPosX - TatsuEightLineSlotP.realImgSpan;
            let correctImgPosY = imgPosY - TatsuEightLineSlotP.realImgSpan;
            this.getRealSprite().x = imgPosX;
            this.getRealSprite().y = imgPosY;
            this.getCorrectFrameSprite().x = correctImgPosX;
            this.getCorrectFrameSprite().y = correctImgPosY;
            this.getCorrectFrameSprite().opacity = 0;
        };
        
        getRealInfo () {
            return this._realInfo;
        };

        getRealSprite () {
            return this._realInfo.getSprite();
        };

        getCorrectFrameSprite () {
            return this._realInfo.getCorrectSprite();
        };

        setRealNo (lineNo) {
            this._realInfo.setlineNo(lineNo);
        };
        
        getRealNo () {
            return this._realInfo.getlineNo();
        };

        setLineX (lineX) {
            this._realInfo.setlineX(lineX);
        };

        setLineY (lineY) {
            this._realInfo.setlineY(lineY);
        };

        isWait() {
            return this._realInfoStatus == REAL_RUN_STATUS_WAIT;
        };

        realStart () {
            this._realInfoStatus = REAL_RUN_STATUS_START;
        };

        isRunnning() {
            return this._realInfoStatus == REAL_RUN_STATUS_RUNNING;
        };

        realStop () {
            this._realInfoStatus = REAL_RUN_STATUS_STOPPING;
        };

        setInitPostion (pos) {
            this._realInfo.setNowPosAndReferenceY(pos);
        };

        update(){
            super.update();
            switch (this._realInfoStatus) {
                case REAL_RUN_STATUS_WAIT:
                    break;
                case REAL_RUN_STATUS_START:
                    if (this._animationSpeed < 30) {
                        this._animationSpeed++;
                    } else {
                        this._animationSpeed = 30;
                        this._realInfoStatus = REAL_RUN_STATUS_RUNNING;
                    }
                    this.animationRealSprite();
                    break;
                case REAL_RUN_STATUS_RUNNING:
                    this.animationRealSprite();
                    break;
                case REAL_RUN_STATUS_STOPPING:
                    if (this._animationSpeed > 0) {
                        this._animationSpeed--;
                        this.animationRealSprite();
                    } else {
                        this._animationSpeed = 0;
                        this._realInfoStatus = REAL_RUN_STATUS_ADJUST;
                        this._lastAdjustPoint = this.adjustYpos();
                    }
                    break;
                case REAL_RUN_STATUS_ADJUST:
                    this.animationAdjustRealSprite();
                    break;
            }

        };

        animationRealSprite(){
            this._realInfo.getSprite().setFrame(0,this._animationPoint,REAL_IMG_WIDTH,REAL_IMG_HEIGHT);
            this._animationPoint -= this._animationSpeed;
            if (this._animationPoint <= REAL_CHANGE_POINT) {
                let imgreferenceY = TatsuEightLineSlotP.realImgheightAll - this._animationPoint;
                this._realInfo.getSprite().setFrame(0,imgreferenceY,REAL_IMG_WIDTH,REAL_IMG_HEIGHT);
                this._animationPoint = imgreferenceY;
            }
        };

        animationAdjustRealSprite(){// 最後にゆっくりになって該当の行で止まる
            if (this._lastAdjustPoint != this._animationPoint) {
                this._realInfo.getSprite().setFrame(0,this._animationPoint,REAL_IMG_WIDTH,REAL_IMG_HEIGHT);
                this._animationPoint -= 1;
                if (this._animationPoint <= 0) {
                    let imgreferenceY = TatsuEightLineSlotP.realImgheightAll;
                    this._realInfo.getSprite().setFrame(0,imgreferenceY,REAL_IMG_WIDTH,REAL_IMG_HEIGHT);
                    this._animationPoint = imgreferenceY;
                }
            } else {
                this._realInfo.setSpriteReferenceY(this._animationPoint);
                this._realInfoStatus = REAL_RUN_STATUS_WAIT;
            }
        };


        adjustYpos(){
            let lastYpos = this._animationPoint;
            for (let i = 0 ; i < TatsuEightLineSlotP.realNum+1 ;i++) {
                let yposMin = (i * REAL_IMG_HEIGHT);
                let yposMax = ((i+1) * REAL_IMG_HEIGHT);
                if (lastYpos > yposMin && lastYpos < yposMax) {
                    switch(i){
                        case 0:
                            lastYpos = TatsuEightLineSlotP.realImgheightAll;
                            break;
                        case TatsuEightLineSlotP.realNum:
                            lastYpos = 0;
                            break;
                        default:
                            lastYpos = yposMin;
                            break;
                    }
                    break;
                }
            }
            return lastYpos;
        };
    };


    class Window_CoinViewWindow extends Window_Base {
        constructor(ix,iy,iwidth,iheigt){
            super(ix,iy,iwidth,iheigt);
        };

        initialize(ix,iy,iwidth,iheigt){
            if (isRpgMakerMV()) {
                Window_Base.prototype.initialize.call(this,
                    ix,
                    iy,
                    iwidth,
                    iheigt);
            }  else {
                Window_Base.prototype.initialize.call(this,
                    getdummyWindowRectParameter(
                        ix,
                        iy,
                        iwidth,
                        iheigt)
                    ); 
            }

            this._coin = 0;
        };

        reDrawCoin(coin){
            if (this.contents) {
                this.contents.clear();
            }
            if (coin) {
                this.drawText(coin,0,0,190,"right");
            } else {
                this.drawText(this._coin,0,0,190,"right");
            }
        };

        initializeCoin(){
            this.reDrawCoin(0);
        };

        setCoin (coin) {
            this._coin = coin;
            this.reDrawCoin(coin);
        };

        getCoin() {
            return this._coin;
        };
    };

    class Window_BetCoinWindow extends Window_CoinViewWindow {
        constructor(ix,iy,iwidth,iheigt){
            super(ix,iy,iwidth,iheigt);
        };

        initialize(ix,iy,iwidth,iheigt){
            super.initialize(ix,iy,iwidth,iheigt);
        };
    };

    class Window_NowCoinWindow extends Window_CoinViewWindow {
        constructor(ix,iy,iwidth,iheigt){
            super(ix,iy,iwidth,iheigt);
        };

        initialize(ix,iy,iwidth,iheigt){
            super.initialize(ix,iy,iwidth,iheigt);
        };

        reDrawCoinByVariable(){
            if (this.contents) {
                this.contents.clear();
            }
            this.drawText($gameVariables.value(TatsuEightLineSlotP.coinVariable),0,0,190,"right");
        };
    };

    // ===========================================
    // プレイヤーが選択する「続行/やめる」の選択肢を表示させるウィンドウ
    // ===========================================
    class Window_continue_Select extends Window_Selectable {
        constructor(ix,iy,iwidth,iheigt){
            super(ix,iy,iwidth,iheigt);
        };

        initialize(){
            let thisWindowWidth = 100;
            let xPos = getCenterPos(Graphics.boxWidth,thisWindowWidth);
            let yPos = 350;
            let width = TatsuEightLineSlotP.yesNoWindowWidth;
            let height = TatsuEightLineSlotP.yesNoWindowHeight;
            if (isRpgMakerMV()) {
                Window_Selectable.prototype.initialize.call(this,
                    xPos,
                    yPos,
                    width,
                    height);
            }  else {
                Window_Selectable.prototype.initialize.call(this,
                    getdummyWindowRectParameter(xPos,yPos,width,height)
                    ); 
            }
            this._initXPos = xPos;
            this._initYPos = yPos;
    
            this._data = new Array();
            this._data.push(TatsuEightLineSlotP.yesLanguage);
            this._data.push(TatsuEightLineSlotP.noLanguage);
            this.refresh();
        };
    
        maxItems(){
            return 2;
        };
    
        isNowSelectYes(){
            return (this.index() == 0);
        };
    
        isNowSelectNo(){
            return (this.index() != 0);
        };
    
        maxCols(){
            return 1;
        };
    
        
        drawItem(index){
            if (this._data) {
                let item = this._data[index];
                let rect = this.itemRect(index);
                this.drawText(item,rect.x,rect.y,this.width);
            }
        };

        open(){
            this.opacity = 255;
            super.open();
            this.activate();
        };

        close(){
            this.opacity = 0;
            super.close();
            this.deactivate();
        };
    };

    // ===========================================
    // メッセージ用window_base
    // ===========================================
    class Window_MessageInfo_Window extends Window_Base {
        constructor(ix,iy,iwidth,iheigt){
            super(ix,iy,iwidth,iheigt);
        };

        initialize(x,y,width,height){
            if (isRpgMakerMV()) {
                Window_Base.prototype.initialize.call(this,x,y,width,height+300);
            } else {
                Window_Base.prototype.initialize.call(this,
                    getdummyWindowRectParameter(x,y,width,height+300));
            }
            this._baseHeight = height/2;
            this._baseY = y;
            this._timeOutCnt = 0;
            this._timeOutFlag = false;
        };
    
        drawMessage(text){
            if (this.contents) {
                this.contents.clear();
            }
            let messageList = text.split("\n");
            let messageSizeList = new Array();
            for (let i = 0 ; i < messageList.length ;i++) {
                messageSizeList.push(this.textWidth(messageList[i]));
            }
            const arMax = function(a,b){ return Math.max(a,b)}
            let maxSize = messageSizeList.reduce(arMax);
            let tmpWindowWidth = maxSize+50;
            let tmpWindowHeight = (messageSizeList.length == 1 ) ? this._baseHeight : messageSizeList.length*(this._baseHeight-5);
    
            let tmpOldX = this.x;
            let tmpOldY = this._baseY;
    
            let tmpNewY = (messageSizeList.length == 1 ) ? tmpOldY : tmpOldY - (this._baseHeight-60);
            let tmpNewX = getCenterPos(Graphics.boxWidth,tmpWindowWidth);
            let heightLine = this.fittingHeight(messageList.length);
            this.move(tmpNewX,tmpNewY,tmpWindowWidth,heightLine+10);
            for (let i = 0 ; i < messageList.length ;i++) {
                this.drawText(messageList[i],0,i*40,tmpWindowWidth-30,"center");
            }
        };

        update() {
            super.update();
            if (this._timeOutFlag && this.isOpen()) {
                if (this._timeOutCnt > 60) {
                    this.close();
                }
                this._timeOutCnt++;
            }
        }
        opentWithTimeoutClose(){
            this._timeOutFlag = true;
            this._timeOutCnt = 0;
            super.open();
        };

        close(){
            this._timeOutFlag = false;
            this._timeOutCnt = 0;
            super.close();
        };

        open(){
            this._timeOutFlag = false;
            this._timeOutCnt = 0;
            super.open();
        };
    };
    

})();