/*:
 * @target MZ
 * @plugindesc メモ欄で指定した変数を変更するプラグイン
 * @help
 * 例: <AddVariable:1,10>  // 変数1に+10
 */

(() => {
    const _Game_Actor_setup = Game_Actor.prototype.setup;
    Game_Actor.prototype.setup = function(actorId) {
        _Game_Actor_setup.call(this, actorId);

        const actor = $dataActors[actorId];
        if (actor && actor.meta.AddVariable) {
            const args = actor.meta.AddVariable.split(",");
            const varId = Number(args[0]);
            const addValue = Number(args[1]);
            if (!isNaN(varId) && !isNaN(addValue)) {
                $gameVariables.setValue(varId, $gameVariables.value(varId) + addValue);
            }
        }
    };
})();
