/*:
 * @plugindesc 自動で♥を\C[27]の色に変換するプラグイン ver1.0
 * @author  ユイナ
 *
 * @help
 * このプラグインを導入すると、文章内の ♥ が自動的に
 * \C[27]（ピンクなど任意設定の色）に着色されるようになります。
 *
 * 他の制御文字とは競合しにくい設計になっています。
 * 特別な使い方は不要です。普通に ♥ を書くだけでOK！
 */

(function() {
  const _Window_Base_convertEscapeCharacters =
    Window_Base.prototype.convertEscapeCharacters;

  Window_Base.prototype.convertEscapeCharacters = function(text) {
    text = _Window_Base_convertEscapeCharacters.call(this, text);
    text = text.replace(/♥/g, '\x1bC[27]♥\x1bC[0]');
    return text;
  };
})();
