﻿/*
 * ----------------------------------------------------
 * Copyright (c) 有栖かずみ / Arisu Kazumi
 * This software is released under the MIT license.
 * http://opensource.org/licenses/mit-license.php
 * ----------------------------------------------------
 */

/*:
 * @plugindesc フキダシアイコン非表示
 * @target MZ
 * @author 有栖かずみ / Arisu Kazumi
 * @url https://a-kazumi.com/plugins
 * @help 特定のスイッチがオンのときに、フキダシアイコン表示の処理をスキップします。
 *
 * 2024/02/18 ver1.0.1 URL表記を変更。文字コードをUTF-8のBOM付きに変更。プログラムは変更なし
 * 2024/02/06 ver1.0.0 作成
 *
 * @param switchId
 * @text スイッチID
 * @desc ここで指定するスイッチがオンのとき、フキダシアイコンが表示されなくなります。
 * @default 1
 * @type switch
 * @min 1
 */

(() => {
    "use strict";

    const pluginName = document.currentScript.src.match(/^.*\/(.*).js$/)[1];
    const params = PluginManager.parameters(pluginName);

    const _Sprite_Balloon_setup = Sprite_Balloon.prototype.setup;
    Sprite_Balloon.prototype.setup = function (targetSprite, balloonId) {
        if ($gameSwitches.value(params.switchId)) {
            //処理なし
        } else {
            _Sprite_Balloon_setup.apply(this, arguments);
        }
    };
})();
