// 連番画像のファイル名と総フレーム数
const baseName = "ani_";   // 画像ファイルの共通前置き
const frameCount = 6;      // フレーム数
const interval = 6;        // フレーム切替の間隔（ゲームフレーム数）

// 変数（閉じ込めるための即時関数内で管理）
(() => {
  let currentFrame = 1;
  let wait = 0;

  // ピクチャID（好きな番号に）
  const picId = 1;

  // 毎フレーム呼び出す処理
  const update = () => {
    wait++;
    if (wait >= interval) {
      wait = 0;
      // ピクチャを消す
      $gameScreen.erasePicture(picId);

      // ファイル名作成（ゼロ埋め2桁想定: ani_01.png）
      let frameStr = currentFrame.toString().padStart(2, '0');
      let filename = baseName + frameStr;

      // ピクチャ表示（画面中央）
      $gameScreen.showPicture(
        picId,
        filename,
        0,               // origin(0=左上,1=中央)
        Graphics.width/2 - 48,  // X座標（例：画面中央-48px）
        Graphics.height/2 - 48, // Y座標（例：画面中央-48px）
        100, 100,        // 拡大率（100%）
        255,             // 不透明度
        0                // 合成方法（0=通常）
      );

      // 次フレームへ
      currentFrame++;
      if (currentFrame > frameCount) currentFrame = 1;
    }

    // 次フレームも実行
    requestAnimationFrame(update);
  };

  // 最初に起動
  update();
})();