/*:
 * @target MZ
 * @plugindesc メニューから不要な項目を削除（オプション・セーブ・終了のみ）v1.1
 * @author 
 */

(() => {
  // アイテム・スキル・装備・ステータスの追加を無効化
  Window_MenuCommand.prototype.addMainCommands = function() {
    // 何も追加しない
  };

  // 並び替えを無効化
  Window_MenuCommand.prototype.addFormationCommand = function() {
    // 何も追加しない
  };

  // オリジナルコマンド（カスタム項目）も何もしない
  Window_MenuCommand.prototype.addOriginalCommands = function() {
    // 何も追加しない
  };

  // オプション
  Window_MenuCommand.prototype.addOptionsCommand = function() {
    this.addCommand(TextManager.options, 'options');
  };

  // セーブ
  Window_MenuCommand.prototype.addSaveCommand = function() {
    if (this.needsCommand('save')) {
      const enabled = this.isSaveEnabled();
      this.addCommand(TextManager.save, 'save', enabled);
    }
  };

  // ゲーム終了
  Window_MenuCommand.prototype.addGameEndCommand = function() {
    this.addCommand(TextManager.gameEnd, 'gameEnd');
  };
})();