/*:
 * @target MZ
 * @plugindesc タイトル画面に「回想部屋」コマンドを追加して指定マップへ移動します（常に3番目）。
 * @author 
 *
 * @param RecallMapId
 * @text 回想部屋マップID
 * @type number
 * @min 1
 * @default 41
 *
 * @param RecallMapX
 * @text 開始位置X
 * @type number
 * @min 0
 * @default 8
 *
 * @param RecallMapY
 * @text 開始位置Y
 * @type number
 * @min 0
 * @default 7
 */

(() => {
    const parameters = PluginManager.parameters(document.currentScript.src.match(/([^\/]+)\.js$/)[1]);
    const mapId = Number(parameters['RecallMapId'] || 5);
    const mapX  = Number(parameters['RecallMapX'] || 10);
    const mapY  = Number(parameters['RecallMapY'] || 10);

    // コマンド生成
    const _Window_TitleCommand_makeCommandList = Window_TitleCommand.prototype.makeCommandList;
    Window_TitleCommand.prototype.makeCommandList = function () {
        _Window_TitleCommand_makeCommandList.call(this);

        // 既存リストを保存
        const originalList = this._list.slice();

        // 3番目に挿入
        this._list = [
            originalList[0], // ニューゲーム
            originalList[1], // コンティニュー
            { name: "回想部屋", symbol: "recallRoom", enabled: true, ext: null },
            ...originalList.slice(2) // 残りのコマンド
        ];
    };

    // ハンドラー設定
    const _Scene_Title_createCommandWindow = Scene_Title.prototype.createCommandWindow;
    Scene_Title.prototype.createCommandWindow = function () {
        _Scene_Title_createCommandWindow.call(this);
        this._commandWindow.setHandler("recallRoom", this.commandRecallRoom.bind(this));
    };

    // 回想部屋へ移動処理
    Scene_Title.prototype.commandRecallRoom = function () {
        DataManager.setupNewGame();
        $gamePlayer.reserveTransfer(mapId, mapX, mapY, 2, 0);
        SceneManager.goto(Scene_Map);
    };
})();