
/*:

@target MZ
@plugindesc スタート、コンティニューの際に最初の処理を指定できます
@author 紫鳥＠メロウ紙芝居
@url https://meroukamisibai.com/

@param commonEvent
@text コモンイベント
@desc 最初に処理させたいコモンイベントです。
@type common_event
@default 0

@help MK_FirstProcessing.js
ver1.0

スタート、コンティニューの際に最初の処理を指定できます。
テストプレイや更新の確認などにどうぞ。

パラメーターで最初に処理させたい
コモンイベントを指定できます。

*/

(() => {
    
    /////////////////プラグイン関係/////////////////
    
    const pluginName = "MK_FirstProcessing";
    
    //----------プラグインパラメーター----------
    
    const parameters = PluginManager.parameters(pluginName);
    const p_commonEvent = Number(parameters["commonEvent"]);
    
    
    /////////////////元々オブジェクト/////////////////
    
    //----------ゲームテンポラリ----------
    
    const _Game_Temp_initialize = Game_Temp.prototype.initialize;
    Game_Temp.prototype.initialize = function() {
        _Game_Temp_initialize.apply(this, arguments);
        if(p_commonEvent > 0){
            this.reserveCommonEvent(p_commonEvent);
        }
    };
    
})();
