
/*:

@target MZ
@plugindesc グローバル変数が使えるプラグインです
@author 紫鳥＠メロウ紙芝居
@url https://meroukamisibai.com/

@help MK_GlobalVariable.js

グローバル変数が使えるプラグインです。

グローバル変数が自動で記録されるタイミングは、
セーブされる時とメニューからゲーム終了でタイトルに
戻る時や、イベントコマンドの「ゲームオーバー」、
「タイトル画面に戻す」が処理される時に自動で記録されます。


スクリプト :

$gameSystem.MK_GlobalVariable_Value("<変数名>") :
グローバル変数を取得します。


@command set
@text グローバル変数代入
@desc グローバル変数を代入します。

@arg name
@text 変数名
@desc グローバル変数の名前です。半角で入力してください。
@type string

@arg value
@text 値
@desc グローバル変数に代入する値です。スクリプトで入力してください。
@type multiline_string

@command erase
@text グローバル変数削除
@desc グローバル変数を削除します。

@arg name
@text 変数名
@desc 削除するグローバル変数の名前です。
@type string

@command eraseAll
@text グローバル変数全削除
@desc グローバル変数を全て削除します。

@command save
@text グローバル変数記録
@desc グローバル変数を記録します。

*/

/////////////////グローバルデータ/////////////////

var $game_mk_globalVariable = null;

(() => {
    
    /////////////////プラグイン関係/////////////////
    
    const pluginName = "MK_GlobalVariable";
    
    //----------プラグインコマンド----------

    //グローバル変数代入
    PluginManager.registerCommand(pluginName, "set", args => {
        $gameSystem.MK_GlobalVariable_Set(args.name, eval(args.value));
    });
    
    //グローバル変数削除
    PluginManager.registerCommand(pluginName, "erase", args => {
        $gameSystem.MK_GlobalVariable_Erase(args.name);
    });
    
    //グローバル変数全削除
    PluginManager.registerCommand(pluginName, "eraseAll", args => {
        $gameSystem.MK_GlobalVariable_EraseAll();
    });
    
    //グローバル変数記録
    PluginManager.registerCommand(pluginName, "save", args => {
        DataManager.MK_GlobalVariable_Save();
    });
    
    
    /////////////////元々オブジェクト/////////////////
    
    //----------データマネージャー----------
    
    DataManager.MK_GlobalVariable_Load = function() {
        StorageManager.loadObject("mk_globalVariable")
            .then(globalVariable => $game_mk_globalVariable = globalVariable).catch(() => $game_mk_globalVariable = {});
    };
    
    const _DataManager_saveGame = DataManager.saveGame;
    DataManager.saveGame = function(savefileId) {
        this.MK_GlobalVariable_Save();
        return _DataManager_saveGame.apply(this, arguments);
    };
    
    DataManager.MK_GlobalVariable_Save = function() {
        StorageManager.saveObject("mk_globalVariable", $game_mk_globalVariable);
    };
    
    
    //----------ゲームシステム----------
    
    Game_System.prototype.MK_GlobalVariable_Value = function(name) {
        return $game_mk_globalVariable[name];
    };
    
    Game_System.prototype.MK_GlobalVariable_Set = function(name, value) {
        $game_mk_globalVariable[name] = value;
    };
    
    Game_System.prototype.MK_GlobalVariable_Erase = function(name) {
        delete $game_mk_globalVariable[name];
    };
    
    Game_System.prototype.MK_GlobalVariable_EraseAll = function() {
        $game_mk_globalVariable = {};
    };
    
    
    //----------インタプリター----------
    
    // Game Over
    const _Game_Interpreter_command353 = Game_Interpreter.prototype.command353;
    Game_Interpreter.prototype.command353 = function() {
        DataManager.MK_GlobalVariable_Save();
        return _Game_Interpreter_command353.apply(this, arguments);
    };
    
    // Return to Title Screen
    const _Game_Interpreter_command354 = Game_Interpreter.prototype.command354;
    Game_Interpreter.prototype.command354 = function() {
        DataManager.MK_GlobalVariable_Save();
        return _Game_Interpreter_command354.apply(this, arguments);
    };
    
    
    //----------ブートシーン----------
    
    const _Scene_Boot_loadPlayerData = Scene_Boot.prototype.loadPlayerData;
    Scene_Boot.prototype.loadPlayerData = function() {
        _Scene_Boot_loadPlayerData.apply(this, arguments);
        DataManager.MK_GlobalVariable_Load();
    };
    
    
    //----------ゲーム終了するかシーン----------
    
    const _Scene_GameEnd_commandToTitle = Scene_GameEnd.prototype.commandToTitle;
    Scene_GameEnd.prototype.commandToTitle = function() {
        DataManager.MK_GlobalVariable_Save();
        _Scene_GameEnd_commandToTitle.apply(this, arguments);
    };
    
    
})();
