
/*:

@target MZ
@plugindesc 特定のキーが押されている間、メッセージウィンドウを透明にします。
@author 紫鳥＠メロウ紙芝居
@url https://meroukamisibai.com/

@param keyCode
@text キーコード
@desc メッセージウィンドウを透明にするキーのキーコード 。（例（デフォルト）:83 = Sキー）
@type number
@default 83

@help MK_MessageWindowHide.js
ver1.01

特定のキーが押されている間、メッセージウィンドウを透明にします。
透明になるだけなので、透明にした状態で決定キーなどを押すと話が進みます。

動作確認コアスクリプト: v1.4.4

*/

(() => {
    
    const pluginName = "MK_MessageWindowHide";
    
    //キー操作追加
    const parameters = PluginManager.parameters(pluginName);
    const p_keyCode = Number(parameters["keyCode"]);
    
    //----------インプット---------
    
    const _Input_initialize = Input.initialize;
    Input.initialize = function() {
        _Input_initialize.apply(this, arguments);
        this.mk_messageWindowHide = {
            key : "mk_messageWindowHide"
        };
        this.MK_MessageWindowHide_SetKey();
    };
    
    Input.MK_MessageWindowHide_SetKey = function() {
        if(!Input.keyMapper[p_keyCode]){
            Input.keyMapper[p_keyCode] = "mk_messageWindowHide";
        }else{
            this.mk_messageWindowHide.key = Input.keyMapper[p_keyCode];
        }
    };
    
    Input.MK_MessageWindowHide_Key = function() {
        return this.mk_messageWindowHide.key;     
    };
    
    
    //----------メッセージウィンドウ----------
    
    //特定のキー押されてると透明化
    Window_Message.prototype.MK_MessageWindowHide_Hide = function() {
        if(Input.isPressed(Input.MK_MessageWindowHide_Key())){
            this.contentsOpacity = 0;
            this.opacity = 0;
            this.hideBackgroundDimmer();
            this._nameBoxWindow.contentsOpacity = 0;
            this._nameBoxWindow.opacity = 0;
            this._nameBoxWindow.hideBackgroundDimmer();
        }else{
            this.setBackgroundType(this._background);
            this.contentsOpacity = 255;
            this._nameBoxWindow.setBackgroundType(this._background);
            this._nameBoxWindow.contentsOpacity = 255;
        }
    };
    
    //メッセージウィンドウ更新
    const _Window_Message_update = Window_Message.prototype.update;
    Window_Message.prototype.update = function() {
        this.MK_MessageWindowHide_Hide();
        _Window_Message_update.apply(this, arguments);
    };
    
    //メッセージウィンドウ出す
    const _Window_Message_startMessage = Window_Message.prototype.startMessage;
    Window_Message.prototype.startMessage = function() {
        _Window_Message_startMessage.apply(this, arguments);
        this.MK_MessageWindowHide_Hide();
    };
    
})();
