
/*:

@target MZ
@plugindesc オプション項目を追加できます
@author 紫鳥＠メロウ紙芝居
@url https://meroukamisibai.com/

@param option
@text 追加オプション項目
@desc 追加するオプション項目の設定ができます。
@type struct<item>[]
@default []

@help MK_OptionItemAdd.js

オプション項目を追加できます。


条件分岐:

ConfigManager.MK_OptionItemAdd("「変数名」") :
変数名のオプション項目を判定します。

*/

/*~struct~item:

@param name
@text 名前
@desc このオプション項目の名前です。
@type string

@param variableName
@text 変数名
@desc このオプション項目の変数名です。必ず入力して、半角で他のオプション項目と重複しない名前を入力してください。
@type string
@default option1

@param default
@text デフォルト
@desc このオプションの元々はONかOFFか設定します。
@type boolean
@on ON
@off OFF
@default true

@param position
@text 表示位置
@desc このオプション項目の表示位置です。
@type select
@option 一番上
@value 0
@option BGM音量の上
@value 1
@option 一番下
@value 2
@default 0

*/

(() => {
    
    /////////////////プラグイン関係/////////////////
    
    const pluginName = "MK_OptionItemAdd";
    
    //----------プラグインパラメーター----------
    
    const parameters = PluginManager.parameters(pluginName);
    
    const p_option = function() {
        let option = JSON.parse(parameters["option"]);
        for(let r = 0; r < option.length; r++){
            option[r] = JSON.parse(option[r]);
            option[r].default = option[r].default == "true" ? true : false;
            option[r].position = Number(option[r].position);
        }
        return option;
    }();
    
    
    /////////////////元々オブジェクト/////////////////
    
    //----------コンフィグマネージャー----------
    
    ConfigManager.MK_OptionItemAdd_Symbol = function() {
        return "mk_optionItemAdd_";
    };
    
    const variableNames = function(){
        let name = "";
        const s = ConfigManager.MK_OptionItemAdd_Symbol();
        p_option.forEach(o => name = name + "ConfigManager." + s + o.variableName + " = " + o.default + ";");
        return name;
    }();
    
    eval(variableNames);
    
    const _ConfigManager_makeData = ConfigManager.makeData;
    ConfigManager.makeData = function() {
        const s = this.MK_OptionItemAdd_Symbol();
        const config = _ConfigManager_makeData.apply(this, arguments);
        p_option.forEach(o => config[s + o.variableName] = this[s + o.variableName]);
        return config;
    };

    const _ConfigManager_applyData = ConfigManager.applyData;
    ConfigManager.applyData = function(config) {
        const s = this.MK_OptionItemAdd_Symbol();
        _ConfigManager_applyData.apply(this, arguments);
        p_option.forEach(o => this[s + o.variableName] = this.readFlag(config, s + o.variableName, o.default));
    };
    
    ConfigManager.MK_OptionItemAdd = function(variableName) {
        return this[this.MK_OptionItemAdd_Symbol() + variableName];
    };
    
    
    //----------オプションウィンドウ----------
    
    const _Window_Options_addGeneralOptions = Window_Options.prototype.addGeneralOptions;
    Window_Options.prototype.addGeneralOptions = function() {
        const s = ConfigManager.MK_OptionItemAdd_Symbol();
        const option = p_option.filter(o => o.position == 0);
        option.forEach(o => this.addCommand(o.name, s + o.variableName));
        _Window_Options_addGeneralOptions.apply(this, arguments);
    };
    
    const _Window_Options_addVolumeOptions = Window_Options.prototype.addVolumeOptions;
    Window_Options.prototype.addVolumeOptions = function() {
        const s = ConfigManager.MK_OptionItemAdd_Symbol();
        const option1 = p_option.filter(o => o.position == 1);
        const option2 = p_option.filter(o => o.position == 2);
        option1.forEach(o => this.addCommand(o.name, s + o.variableName));
        _Window_Options_addVolumeOptions.apply(this, arguments);
        option2.forEach(o => this.addCommand(o.name, s + o.variableName));
    };
    
    const _Window_Options_isVolumeSymbol = Window_Options.prototype.isVolumeSymbol;
    Window_Options.prototype.isVolumeSymbol = function(symbol) {
        const s = ConfigManager.MK_OptionItemAdd_Symbol();
        return symbol.includes(s) ? false : _Window_Options_isVolumeSymbol.apply(this, arguments);
    };
    
    
})();
