
/*:

@target MZ
@plugindesc オプションの項目の一部を非表示にできます。
@author 紫鳥＠メロウ紙芝居
@url https://meroukamisibai.com/

@param display_alwaysDash
@text 「常時ダッシュ」の表示
@desc 「常時ダッシュ」を表示しますか？
@type boolean
@on 表示する
@off 表示しない
@default true

@param display_commandRemember
@text 「コマンド記憶」の表示
@desc 「コマンド記憶」を表示しますか？
@type boolean
@on 表示する
@off 表示しない
@default true

@param display_touchUI
@text 「タッチUI」の表示
@desc 「タッチUI」を表示しますか？
@type boolean
@on 表示する
@off 表示しない
@default true

@param display_bgmVolume
@text 「BGM 音量」の表示
@desc 「BGM 音量」を表示しますか？
@type boolean
@on 表示する
@off 表示しない
@default true

@param display_bgsVolume
@text 「BGS 音量」の表示
@desc 「BGS 音量」を表示しますか？
@type boolean
@on 表示する
@off 表示しない
@default true

@param display_meVolume
@text 「ME 音量」の表示
@desc 「ME 音量」を表示しますか？
@type boolean
@on 表示する
@off 表示しない
@default true

@param display_seVolume
@text 「SE 音量」の表示
@desc 「SE 音量」を表示しますか？
@type boolean
@on 表示する
@off 表示しない
@default true

@help MK_OptionItemHide.js

オプションの項目の一部を非表示にできます。

*/

(() => {
    
    /////////////////プラグイン関係/////////////////
    
    const pluginName = "MK_OptionItemHide";
    
    //----------プラグインパラメーター----------
    
    const parameters = PluginManager.parameters(pluginName);
    const p_display_alwaysDash = (parameters["display_alwaysDash"] == "true") ? true : false;
    const p_display_commandRemember = (parameters["display_commandRemember"] == "true") ? true : false;
    const p_display_touchUI = (parameters["display_touchUI"] == "true") ? true : false;
    const p_display_bgmVolume = (parameters["display_bgmVolume"] == "true") ? true : false;
    const p_display_bgsVolume = (parameters["display_bgsVolume"] == "true") ? true : false;
    const p_display_meVolume = (parameters["display_meVolume"] == "true") ? true : false;
    const p_display_seVolume = (parameters["display_seVolume"] == "true") ? true : false;
    
    
    /////////////////元々オブジェクト/////////////////
    
    //----------オプションウィンドウ----------
    
    const _Window_Options_makeCommandList = Window_Options.prototype.makeCommandList;
    Window_Options.prototype.makeCommandList = function() {
        _Window_Options_makeCommandList.apply(this, arguments);
        this.MK_OptionItemHide_Remove(p_display_alwaysDash, "alwaysDash");
        this.MK_OptionItemHide_Remove(p_display_commandRemember, "commandRemember");
        this.MK_OptionItemHide_Remove(p_display_touchUI, "touchUI");
        this.MK_OptionItemHide_Remove(p_display_bgmVolume, "bgmVolume");
        this.MK_OptionItemHide_Remove(p_display_bgsVolume, "bgsVolume");
        this.MK_OptionItemHide_Remove(p_display_meVolume, "meVolume");
        this.MK_OptionItemHide_Remove(p_display_seVolume, "seVolume");
    };
    
    //コマンド外す
    Window_Options.prototype.MK_OptionItemHide_Remove = function(display, symbol) {//表示するか, 外すコマンドのシンボル
        if(!display){
            const index = this._list.findIndex((command) => (command.symbol == symbol) ? true : false);
            if(index != -1){
                this._list.splice(index, 1);
                if(this._list.length < 7){
                    this.height -= this.itemHeight();
                    this.y += this.itemHeight() / 2;
                }
            }
        }
    };
    
})();
