
/*:

@target MZ
@plugindesc 回想機能を追加し、回想を作りやすくします
@author 紫鳥＠メロウ紙芝居
@url https://meroukamisibai.com/

@help MK_RecollectionFunction.js
ver1.1

回想機能を追加し、回想を作りやすくします。


条件分岐:

$gameTemp.MK_RecollectionFunction_Recollection() :
回想中か確認します。


@command start
@text 回想開始
@desc 回想を始めます。

@arg map
@text マップ
@desc 移動するマップのidです。
@type number
@min 1
@default 1

@arg x
@text x
@desc 移動するマップのxです。
@type number
@min 0
@default 0

@arg y
@text y
@desc 移動するマップのyです。
@type number
@min 0
@default 0

@arg direction
@text 向き
@desc 移動するマップの向きです。
@type select
@option そのまま
@value 0
@option 下
@value 2
@option 左
@value 4
@option 右
@value 6
@option 上
@value 8
@default 0

@command end
@text 回想終了
@desc 回想を終わります。

@command cgRecollection
@text CG回想
@desc CG回想を始めます。

@arg cg
@text CG
@desc 回想するCGです。
@type file[]
@dir img/pictures/
@default []

*/


(() => {
    
    /////////////////プラグイン関係/////////////////
    
    const pluginName = "MK_RecollectionFunction";
    
    //----------プラグインコマンド----------

    //回想開始
    PluginManager.registerCommand(pluginName, "start", args => {
    });
    
    //回想終了
    PluginManager.registerCommand(pluginName, "end", args => {
    });
    
    //CG回想
    PluginManager.registerCommand(pluginName, "cgRecollection", args => {
    });
    
    
    /////////////////元々オブジェクト/////////////////
    
    //----------ゲームテンポラリ----------
    
    const _Game_Temp_initialize = Game_Temp.prototype.initialize;
    Game_Temp.prototype.initialize = function() {
        _Game_Temp_initialize.apply(this, arguments);
        this.MK_RecollectionFunction_Initialize();
    };
    
    Game_Temp.prototype.MK_RecollectionFunction_Initialize = function() {
        this.mk_recollectionFunction = {
            recollection : false,
            move : [0, 0, 0, 0],
            cg : [],
            cg_showIndex : 0,
            cg_showDuring : false,
            cg_displayCgName : ""
        };
    };
        
    Game_Temp.prototype.MK_RecollectionFunction_Recollection = function() {
        return this.mk_recollectionFunction.recollection;
    };
    
    Game_Temp.prototype.MK_RecollectionFunction_Move = function() {
        return this.mk_recollectionFunction.move;
    };
    
    Game_Temp.prototype.MK_RecollectionFunction_Start = function() {
        this.mk_recollectionFunction.recollection = true;
        this.mk_recollectionFunction.move = [$gameMap.mapId(), $gamePlayer.x, $gamePlayer.y, $gamePlayer.direction()];
    };
    
    Game_Temp.prototype.MK_RecollectionFunction_End = function() {
        this.mk_recollectionFunction.recollection = false;
    };
    
    Game_Temp.prototype.MK_RecollectionFunction_CgRecollection = function(cg) {
        this.mk_recollectionFunction.cg = cg;
        this.mk_recollectionFunction.cg_showIndex = 0;
        this.mk_recollectionFunction.cg_showDuring = true;
        this.MK_RecollectionFunction_CgRecollectionUpdateDisplayCgName();
    };
    
    Game_Temp.prototype.MK_RecollectionFunction_CgRecollectionUpdate = function() {
        if(this.MK_RecollectionFunction_CgRecollectionDuring()){
            if(Input.isTriggered("ok") || Input.isTriggered("escape") || TouchInput.isTriggered()){
                const data = this.mk_recollectionFunction;
                if(data.cg.length - 1 != data.cg_showIndex){
                    data.cg_showIndex++;
                }else{
                    data.cg_showDuring = false;
                }
                this.MK_RecollectionFunction_CgRecollectionUpdateDisplayCgName();
            }
        }
    };
    
    Game_Temp.prototype.MK_RecollectionFunction_CgRecollectionUpdateDisplayCgName = function() {
        const data = this.mk_recollectionFunction;
        if(this.MK_RecollectionFunction_CgRecollectionDuring()){
            data.cg_displayCgName = data.cg[data.cg_showIndex];
        }else{
            data.cg_displayCgName = "";
        }
    };
    
    Game_Temp.prototype.MK_RecollectionFunction_CgRecollectionDuring = function() {
        return this.mk_recollectionFunction.cg_showDuring;
    };
    
    Game_Temp.prototype.MK_RecollectionFunction_DisplayCgName = function() {
        return this.mk_recollectionFunction.cg_displayCgName;
    };
    
    
    //----------ゲームインタープリター----------
    
    const _Game_Interpreter_loadImages = Game_Interpreter.prototype.loadImages;
    Game_Interpreter.prototype.loadImages = function() {
        _Game_Interpreter_loadImages.apply(this, arguments);
        const list = this._list.slice(0, 200);
        for(const command of list){
            if(command.code == 357 && command.parameters[0] == pluginName && command.parameters[1] =="cgRecollection"){
                const cg = JSON.parse(command.parameters[3].cg);
                cg.forEach(image => ImageManager.loadPicture(image));
            }
        }
    };
    
    const _Game_Interpreter_updateWaitMode = Game_Interpreter.prototype.updateWaitMode;
    Game_Interpreter.prototype.updateWaitMode = function() {
        let waiting = false;
        switch (this._waitMode) {
            case "mk_recollectionFunction_cg":
                waiting = $gameTemp.MK_RecollectionFunction_CgRecollectionDuring();
                break;
        }
        return waiting ? waiting : _Game_Interpreter_updateWaitMode.apply(this, arguments);
    };
    
    const _Game_Interpreter_command357 = Game_Interpreter.prototype.command357;
    Game_Interpreter.prototype.command357 = function(params) {
        const b = _Game_Interpreter_command357.apply(this, arguments);
        if(params[0] == pluginName){
            switch(params[1]){
                case "start":
                    if(!$gameTemp.MK_RecollectionFunction_Recollection()){
                        if(!$gameParty.inBattle() && !$gameMessage.isBusy()){
                            $gameTemp.MK_RecollectionFunction_Start();
                            const m = params[3];
                            $gamePlayer.reserveTransfer(Number(m.map), Number(m.x), Number(m.y), Number(m.direction), 0);
                            this.setWaitMode("transfer");
                        }
                    }
                    break;
                case "end":
                    if($gameTemp.MK_RecollectionFunction_Recollection()){
                        if(!$gameParty.inBattle() && !$gameMessage.isBusy()){
                            $gameTemp.MK_RecollectionFunction_End();
                            const m = $gameTemp.MK_RecollectionFunction_Move();
                            $gamePlayer.reserveTransfer(m[0], m[1], m[2], m[3], 0);
                            this.setWaitMode("transfer");
                            this.command113();
                        }
                    }
                    break;
                case "cgRecollection":
                    const cg = JSON.parse(params[3].cg);
                    $gameTemp.MK_RecollectionFunction_CgRecollection(cg);
                    this.setWaitMode("mk_recollectionFunction_cg");
                    break;
            }
        }
        return b;
    };
    
    
    //----------シーンマップ----------
    
    const _Scene_Map_update = Scene_Map.prototype.update;
    Scene_Map.prototype.update = function() {
        _Scene_Map_update.apply(this, arguments);
        if($gameTemp.MK_RecollectionFunction_CgRecollectionDuring()){
            $gameTemp.MK_RecollectionFunction_CgRecollectionUpdate();
        }
    };
    
    
    //----------スプライトベーススプライト----------
    
    const _Spriteset_Base_initialize = Spriteset_Base.prototype.initialize;
    Spriteset_Base.prototype.initialize = function() {
        _Spriteset_Base_initialize.apply(this, arguments);
        this.mk_recollectionFunction_displayName = "";
    };
    
    const _Spriteset_Base_createUpperLayer = Spriteset_Base.prototype.createUpperLayer;
    Spriteset_Base.prototype.createUpperLayer = function() {
        
        this.mk_recollectionFunction_cg = new Sprite();
        this.mk_recollectionFunction_cg.move(Graphics.width / 2, Graphics.height / 2);
        this.mk_recollectionFunction_cg.anchor.x = 0.5;
        this.mk_recollectionFunction_cg.anchor.y = 0.5;
        this.addChild(this.mk_recollectionFunction_cg);
        
        _Spriteset_Base_createUpperLayer.apply(this, arguments);
    };
    
    const _Spriteset_Base_update = Spriteset_Base.prototype.update;
    Spriteset_Base.prototype.update = function() {
        _Spriteset_Base_update.apply(this, arguments);
        const name = $gameTemp.MK_RecollectionFunction_DisplayCgName();
        if(this.mk_recollectionFunction_displayName != name){
            if(name != ""){
                this.mk_recollectionFunction_displayName = name;
                this.mk_recollectionFunction_cg.bitmap = ImageManager.loadPicture(name);
                const bitmap = this.mk_recollectionFunction_cg.bitmap;
                bitmap.addLoadListener(function() {
                    const width = bitmap.width;
                    const height = bitmap.height;
                    const maxWidth = Graphics.width;
                    const maxHeight = Graphics.height;
                    let scale = 100;
                    if(width > maxWidth || height > maxHeight){
                        while(true){
                            if(width * scale / 100 <= maxWidth && height * scale / 100 <= maxHeight){
                                break;
                            }
                            scale--;
                        }
                    }
                    scale = scale / 100;
                    this.mk_recollectionFunction_cg.scale.x = scale;
                    this.mk_recollectionFunction_cg.scale.y = scale;
                }.bind(this));
            }else{
                this.mk_recollectionFunction_displayName = "";
                this.mk_recollectionFunction_cg.bitmap = null;
            }
        }
    };
    
    
})();
