
/*:

@target MZ
@plugindesc 回想セレクト画面を簡単に呼べるプラグインです
@author 紫鳥＠メロウ紙芝居
@url https://meroukamisibai.com/
@base MK_StageSelect
@base MK_RecollectionFunction

@help MK_RecollectionSelect.js
ver1.1

このプラグインは「MK_StageSelect」と
「MK_RecollectionFunction」の二つの
プラグインが必要です。

回想セレクト画面を簡単に呼べるプラグインです。
回想の行先や選べるステージはjsファイルにある
データベースで設定します。


条件分岐:

$gameTemp.MK_RecollectionSelect_CancelButton() :
キャンセルボタンが押されてステージセレクトを閉じたか確認します。


@command recollection
@text 回想セレクト画面
@desc 回想セレクト画面を呼び出します。

@arg symbol
@text シンボル
@desc 呼び出すステージセレクトです。
@type string

*/

/////////////////グローバルデータ/////////////////

var $data_mk_recollectionSelect = null;


/////////////////回想データベース/////////////////

function MK_RecollectionSelect() {
    //回想
    this.recollections = [null];
    //ステージセレクトデータ
    this.stageSelects = [null];
    
    this.Database();
}

MK_RecollectionSelect.prototype.Database = function() {

    //回想
    //シンボル　名前　移動先[マップID,x,y,向き]
    
    /*サンプル
    this.Database_Recollection("story1", "ストーリー１", [2, 7, 2, 2]);
    this.Database_Recollection_Picture("pictures/Actor1_2");//画像
    this.Database_Recollection_AppearanceCondition(() => true);//出現条件
    this.Database_Recollection_ChooseCondition(() => true);//選択条件
    this.Database_Recollection_Cg(["Actor1_2", "Actor1_6", "Actor1_8"]);//回想CG
    this.Database_Recollection_Hint("ストーリーを進めよう");//回想ヒント
    */
    
    
    this.Database_Recollection("story1", "OP", [4, 1, 1, 2]);
    this.Database_Recollection_Picture("pictures/cg2_1");
    this.Database_Recollection_AppearanceCondition(() => true);
    this.Database_Recollection_FeasibleCondition(() => true);
    this.Database_Recollection_Cg(["cg2_1", "cg2_2", "cg2_3", "cg2_4", "cg2_5", "cg2_6"]);

    this.Database_Recollection("story2", "？？？", [13, 1, 1, 2]);
    this.Database_Recollection_Picture("pictures/");
    this.Database_Recollection_AppearanceCondition(() => true);
    this.Database_Recollection_FeasibleCondition(() => false);
    this.Database_Recollection_Hint("体験版では見れません");

    this.Database_Recollection("story3", "盗賊１", [14, 1, 1, 2]);
    this.Database_Recollection_Picture("pictures/ero1_1");
    this.Database_Recollection_AppearanceCondition(() => true);
    this.Database_Recollection_FeasibleCondition(() => true);
    this.Database_Recollection_Cg(["ero1_1", "ero1_2", "ero1_3", "ero1_4", "ero1_5"]);

    this.Database_Recollection("story4", "盗賊２", [15, 1, 1, 2]);
    this.Database_Recollection_Picture("pictures/ero2_1");
    this.Database_Recollection_AppearanceCondition(() => true);
    this.Database_Recollection_FeasibleCondition(() => true);
    this.Database_Recollection_Cg(["ero2_1", "ero2_2", "ero2_3", "ero2_4", "ero2_5", "ero2_6"]);

    this.Database_Recollection("story5", "盗賊３", [16, 1, 1, 2]);
    this.Database_Recollection_Picture("pictures/ero3_1");
    this.Database_Recollection_AppearanceCondition(() => true);
    this.Database_Recollection_FeasibleCondition(() => true);
    this.Database_Recollection_Cg(["ero3_1", "ero3_2", "ero3_3", "ero3_4", "ero3_5", "ero3_6", "ero3_7"]);

    this.Database_Recollection("story6", "ゴブリン", [17, 1, 1, 2]);
    this.Database_Recollection_Picture("pictures/ero4_1");
    this.Database_Recollection_AppearanceCondition(() => true);
    this.Database_Recollection_FeasibleCondition(() => true);
    this.Database_Recollection_Cg(["ero4_1", "ero4_2", "ero4_3", "ero4_4", "ero4_5", "ero4_6"]);

    this.Database_Recollection("story7", "スライム", [18, 1, 1, 2]);
    this.Database_Recollection_Picture("pictures/ero5_1");
    this.Database_Recollection_AppearanceCondition(() => true);
    this.Database_Recollection_FeasibleCondition(() => true);
    this.Database_Recollection_Cg(["ero5_1", "ero5_2", "ero5_3", "ero5_4", "ero5_5", "ero5_6"]);

    this.Database_Recollection("story8", "触手１", [19, 1, 1, 2]);
    this.Database_Recollection_Picture("pictures/ero6_1");
    this.Database_Recollection_AppearanceCondition(() => true);
    this.Database_Recollection_FeasibleCondition(() => true);
    this.Database_Recollection_Cg(["ero6_1", "ero6_2", "ero6_3", "ero6_4", "ero6_5", "ero6_6", "ero6_7"]);

    this.Database_Recollection("story9", "？？？", [20, 1, 1, 2]);
    this.Database_Recollection_Picture("pictures/");
    this.Database_Recollection_AppearanceCondition(() => true);
    this.Database_Recollection_FeasibleCondition(() => false);
    this.Database_Recollection_Hint("体験版では見れません");

    this.Database_Recollection("story10", "？？？", [21, 1, 1, 2]);
    this.Database_Recollection_Picture("pictures/");
    this.Database_Recollection_AppearanceCondition(() => true);
    this.Database_Recollection_FeasibleCondition(() => false);
    this.Database_Recollection_Hint("体験版では見れません");

    this.Database_Recollection("story11", "？？？", [22, 1, 1, 2]);
    this.Database_Recollection_Picture("pictures/");
    this.Database_Recollection_AppearanceCondition(() => true);
    this.Database_Recollection_FeasibleCondition(() => false);
    this.Database_Recollection_Hint("体験版では見れません");

    this.Database_Recollection("story12", "？？？", [23, 1, 1, 2]);
    this.Database_Recollection_Picture("pictures/");
    this.Database_Recollection_AppearanceCondition(() => true);
    this.Database_Recollection_FeasibleCondition(() => false);
    this.Database_Recollection_Hint("体験版では見れません");

    this.Database_Recollection("story13", "？？？", [24, 1, 1, 2]);
    this.Database_Recollection_Picture("pictures/");
    this.Database_Recollection_AppearanceCondition(() => true);
    this.Database_Recollection_FeasibleCondition(() => false);
    this.Database_Recollection_Hint("体験版では見れません");

    this.Database_Recollection("story14", "？？？", [25, 1, 1, 2]);
    this.Database_Recollection_Picture("pictures/");
    this.Database_Recollection_AppearanceCondition(() => true);
    this.Database_Recollection_FeasibleCondition(() => false);
    this.Database_Recollection_Hint("体験版では見れません");

    this.Database_Recollection("story15", "？？？", [26, 1, 1, 2]);
    this.Database_Recollection_Picture("pictures/");
    this.Database_Recollection_AppearanceCondition(() => true);
    this.Database_Recollection_FeasibleCondition(() => false);
    this.Database_Recollection_Hint("体験版では見れません");
    
    
    //---------------------------------------------------------------------------
    
    
    //ステージセレクト
    //シンボル　名前　選択するステージのシンボル達
    
    this.Database_StageSelect("select1", "エロシーン", [
        "story1",
        "story2",
        "story3",
        "story4",
        "story5",
        "story6",
        "story7",
        "story8",
        "story9",
        "story10",
        "story11",
        "story12",
        "story13",
        "story14",
        "story15"
    ]);
    
    
};

MK_RecollectionSelect.prototype.Database_Recollection = function(symbol, name, move) {
    this.recollections.push({
        symbol : symbol,
        name : name,
        move : move,
        picture : "",
        appearanceCondition : () => true,
        feasibleCondition : () => true,
        cg : [],
        hint : ""
    });
};

MK_RecollectionSelect.prototype.Database_Recollection_Picture = function(picture) {
    this.recollections[this.recollections.length - 1].picture = picture;
};

MK_RecollectionSelect.prototype.Database_Recollection_AppearanceCondition = function(appearanceCondition) {
    this.recollections[this.recollections.length - 1].appearanceCondition = appearanceCondition;
};

MK_RecollectionSelect.prototype.Database_Recollection_FeasibleCondition = function(chooseCondition) {
    this.recollections[this.recollections.length - 1].feasibleCondition = chooseCondition;
};

MK_RecollectionSelect.prototype.Database_Recollection_Cg = function(cg) {
    this.recollections[this.recollections.length - 1].cg = cg;
};

MK_RecollectionSelect.prototype.Database_Recollection_Hint = function(hint) {
    this.recollections[this.recollections.length - 1].hint = hint;
};

MK_RecollectionSelect.prototype.Database_StageSelect = function(symbol, name, stageSymbols) {
    this.stageSelects.push({
        symbol : symbol,
        name : name,
        stageSymbols : stageSymbols
    });
};

MK_RecollectionSelect.prototype.Recollection = function(symbol) {
    return this.recollections.find(recollection => recollection && recollection.symbol == symbol);
};

MK_RecollectionSelect.prototype.StageSelect = function(symbol) {
    return this.stageSelects.find(stageSelect => stageSelect && stageSelect.symbol == symbol);
};


(() => {
    
    /////////////////プラグイン関係/////////////////
    
    const pluginName = "MK_RecollectionSelect";
    
    //----------プラグインコマンド----------

    //回想セレクト画面
    PluginManager.registerCommand(pluginName, "recollection", args => {
    });
    
    
    /////////////////元々オブジェクト/////////////////
    
    //----------データマネージャー----------
    
    //ゲーム開始時作成データ
    const _DataManager_createGameObjects = DataManager.createGameObjects;
    DataManager.createGameObjects = function() {
        _DataManager_createGameObjects.apply(this, arguments);
        $data_mk_recollectionSelect = new MK_RecollectionSelect();
    };
    
    
    //----------ゲームテンポラリ----------
    
    const _Game_Temp_initialize = Game_Temp.prototype.initialize;
    Game_Temp.prototype.initialize = function() {
        _Game_Temp_initialize.apply(this, arguments);
        this.MK_RecollectionSelect_Initialize();
    };
    
    Game_Temp.prototype.MK_RecollectionSelect_Initialize = function() {
        this.mk_recollectionSelect = {
            recollectionSelectRunning : false,
            stageSelectChoice : false,
            waitModeChange : "",
            cancelButton : false
        };
    };
    
    Game_Temp.prototype.MK_RecollectionSelect_RecollectionSelectRunning = function() {
        return this.mk_recollectionSelect.recollectionSelectRunning;
    };
    
    Game_Temp.prototype.MK_RecollectionSelect_StageSelectChoice = function() {
        return this.mk_recollectionSelect.stageSelectChoice;
    };
    
    Game_Temp.prototype.MK_RecollectionSelect_StageSelectChoiceSet = function(choice) {
        this.mk_recollectionSelect.stageSelectChoice = choice;
    };
    
    Game_Temp.prototype.MK_RecollectionSelect_WaitModeChange = function() {
        return this.mk_recollectionSelect.waitModeChange;
    };
    
    Game_Temp.prototype.MK_RecollectionSelect_WaitModeChangeSet = function(waitMode) {
        this.mk_recollectionSelect.waitModeChange = waitMode;
    };
    
    Game_Temp.prototype.MK_RecollectionSelect_CancelButton = function() {
        return this.mk_recollectionSelect.cancelButton;
    };
    
    Game_Temp.prototype.MK_RecollectionSelect_CancelButtonSet = function(pushed) {
        this.mk_recollectionSelect.cancelButton = pushed;
    };
    
    Game_Temp.prototype.MK_RecollectionSelect_RecollectionSelect = function(symbol) {
        $gameSystem.MK_StageSelect_StageRemove();
        const select = $data_mk_recollectionSelect.StageSelect(symbol);
        $gameSystem.MK_StageSelect_TitleSet(select.name);
        select.stageSymbols.forEach(stageSymbol => {
            const stage = $data_mk_recollectionSelect.Recollection(stageSymbol);
            if(stage.appearanceCondition()){
                const feasible = stage.feasibleCondition();
                const name = feasible ? stage.name : "？？？？？？";
                const picture = feasible ? stage.picture : "";
                const options = [];
                const hint = stage.feasibleCondition() ? "" : stage.hint;
                if(feasible && stage.cg.length > 0){
                    options.push($gameSystem.MK_StageSelect_OptionCreate("recollection", "シナリオ", true, "", "", ""));
                    options.push($gameSystem.MK_StageSelect_OptionCreate("cg", "CG", true, "", "", ""));
                }
                $gameSystem.MK_StageSelect_StageAdd(stage.symbol, name, 0, feasible, hint, "", options, picture);
            }
        });
        $gameSystem.MK_StageSelect_StageSelect();
        this.mk_recollectionSelect.recollectionSelectRunning = true;
        this.MK_RecollectionSelect_StageSelectChoiceSet(false);
    };
    
    Game_Temp.prototype.MK_RecollectionSelect_RecollectionSelectUpdate = function(symbol) {
        if(this.MK_RecollectionSelect_StageSelectChoice()){
            if($gameSystem.MK_StageSelect_ChoiceSymbol() != ""){
                const r = $data_mk_recollectionSelect.Recollection($gameSystem.MK_StageSelect_ChoiceSymbol());
                if($gameSystem.MK_StageSelect_ChoiceSymbolOption() != "cg"){
                    $gameTemp.MK_RecollectionFunction_Start();
                    $gamePlayer.reserveTransfer(r.move[0], r.move[1], r.move[2], r.move[3], 0);
                    this.MK_RecollectionSelect_WaitModeChangeSet("transfer");
                }else{
                    $gameTemp.MK_RecollectionFunction_CgRecollection(r.cg);
                    this.MK_RecollectionSelect_WaitModeChangeSet("mk_recollectionFunction_cg");
                }
                this.MK_RecollectionSelect_CancelButtonSet(false);
            }else{
                this.MK_RecollectionSelect_CancelButtonSet(true);
            }
            this.mk_recollectionSelect.recollectionSelectRunning = false;
            this.MK_RecollectionSelect_StageSelectChoiceSet(false);
        }
    };
    
    
    //----------ゲームインタープリター----------
    
    const _Game_Interpreter_updateWaitMode = Game_Interpreter.prototype.updateWaitMode;
    Game_Interpreter.prototype.updateWaitMode = function() {
        let waiting = false;
        switch (this._waitMode) {
            case "mk_recollectionSelect_recollection":
                const wmc = $gameTemp.MK_RecollectionSelect_WaitModeChange();
                if(wmc == ""){
                    waiting = $gameTemp.MK_RecollectionSelect_RecollectionSelectRunning();
                }else{
                    this.setWaitMode(wmc);
                    $gameTemp.MK_RecollectionSelect_WaitModeChangeSet("");
                }
                break;
        }
        return waiting ? waiting : _Game_Interpreter_updateWaitMode.apply(this, arguments);
    };
    
    const _Game_Interpreter_command357 = Game_Interpreter.prototype.command357;
    Game_Interpreter.prototype.command357 = function(params) {
        const b = _Game_Interpreter_command357.apply(this, arguments);
        if(params[0] == pluginName){
            switch(params[1]){
                case "recollection":
                    $gameTemp.MK_RecollectionSelect_RecollectionSelect(params[3].symbol);
                    this.setWaitMode("mk_recollectionSelect_recollection");
                    break;
            }
        }
        return b;
    };
    
    
    //----------シーンマップ----------
    
    const _Scene_Map_update = Scene_Map.prototype.update;
    Scene_Map.prototype.update = function() {
        _Scene_Map_update.apply(this, arguments);
        if($gameTemp.MK_RecollectionSelect_RecollectionSelectRunning()){
            $gameTemp.MK_RecollectionSelect_RecollectionSelectUpdate();
        }
    };
    
    
    //----------MK_StageSelect----------
    
    const _MK_StageSelect_Scene_onOk = MK_StageSelect_Scene.prototype.onOk;
    MK_StageSelect_Scene.prototype.onOk = function() {
        $gameTemp.MK_RecollectionSelect_StageSelectChoiceSet(true);
        _MK_StageSelect_Scene_onOk.apply(this, arguments);
    };

    const _MK_StageSelect_Scene_onCancel = MK_StageSelect_Scene.prototype.onCancel;
    MK_StageSelect_Scene.prototype.onCancel = function() {
        $gameTemp.MK_RecollectionSelect_StageSelectChoiceSet(true);
        _MK_StageSelect_Scene_onCancel.apply(this, arguments);
    };
    
    
})();
