
/*:

@target MZ
@plugindesc 画面にテキストを表示できます
@author 紫鳥＠メロウ紙芝居
@url https://meroukamisibai.com/

@help MK_ScreenText.js

画面にテキストを表示できます。

プラグインコマンドでテキストを用意した後は、
直ぐに「ピクチャの表示」をしてください。
画像は特に何も指定しません。


@command textSet
@text テキストの用意
@desc テキストを用意した後に、「ピクチャの表示」で画面上にテキストを表示します。

@arg text
@text テキスト
@desc 表示するテキストです。
@type string

@arg textColor
@text テキストカラー
@desc 表示するテキストの色です。
@type struct<color>
@default {"r":"255","g":"255","b":"255"}

@arg outlineColor
@text アウトラインカラー
@desc 表示するテキストのアウトラインの色です。
@type struct<color>
@default {"r":"0","g":"0","b":"0"}

@arg fontSize
@text フォントサイズ
@desc テキストのフォントサイズです。
@type number
@min 0
@default 26

@arg outlineWidth
@text アウトライン幅
@desc テキストのアウトラインの幅です。
@type number
@min 0
@default 3

@arg fontBold
@text 太字
@desc テキストの太字です。
@on 太字にする
@off 太字にしない
@type boolean
@default false

@arg fontItalic
@text 斜体
@desc テキストの斜体です。
@on 斜体にする
@off 斜体にしない
@type boolean
@default false

*/

/*~struct~color:

@param r
@text 赤
@desc 色のR成分です。
@type number
@max 255
@min 0
@default 0

@param g
@text 緑
@desc 色のG成分です。
@type number
@max 255
@min 0
@default 0

@param b
@text 青
@desc 色のB成分です。
@type number
@max 255
@min 0
@default 0

*/

/////////////////スクリーンテキストデータ/////////////////

function MK_ScreenText(text, textColor, outlineColor, fontSize, outlineWidth, fontBold, fontItalic) {
    this.text = text || "";
    this.textColor = textColor || "rgba(255, 255, 255, 1)";
    this.outlineColor = outlineColor || "rgba(0, 0, 0, 1)";
    this.fontSize = fontSize || 16;
    this.outlineWidth = outlineWidth || 3;
    this.fontBold = fontBold || false;
    this.fontItalic = fontItalic || false;
    this.pictureName = "text_" + text + ":textColor_" + textColor + ":outlineColor_" + outlineColor + ":fontSize_" + fontSize + ":outlineWidth_" + outlineWidth + ":fontBold_" + fontBold + ":fontItalic_" + fontItalic;
}

MK_ScreenText.prototype.PictureName = function() {
    return this.pictureName;
};

(() => {
    
    /////////////////プラグイン関係/////////////////
    
    const pluginName = "MK_ScreenText";
    
    //----------プラグインコマンド----------

    //テキストの用意
    PluginManager.registerCommand(pluginName, "textSet", args => {
        let textColor = JSON.parse(args.textColor);
        textColor = "rgba(" + textColor.r + ", " + textColor.g + ", " + textColor.b + ", 1)";
        let outlineColor = JSON.parse(args.outlineColor);
        outlineColor = "rgba(" + outlineColor.r + ", " + outlineColor.g + ", " + outlineColor.b + ", 1)";
        $gameTemp.MK_ScreenText_TextDataCreate(args.text, textColor, outlineColor, Number(args.fontSize), Number(args.outlineWidth), args.fontBold == "true" ? true : false, args.fontItalic == "true" ? true : false);
    });
    
    
    /////////////////元々オブジェクト/////////////////
    
    //----------ゲームテンポラリ----------
    
    const _Game_Temp_initialize = Game_Temp.prototype.initialize;
    Game_Temp.prototype.initialize = function() {
        _Game_Temp_initialize.apply(this, arguments);
        this.MK_ScreenText_Initialize();
    };
    
    Game_Temp.prototype.MK_ScreenText_Initialize = function() {
        this.mk_screenText_text = false;
        this.mk_screenText_textData = null;
    };
    
    Game_Temp.prototype.MK_ScreenText_TextDisplay = function(display) {
        this.mk_screenText_text = display;
    };
    
    Game_Temp.prototype.MK_ScreenText_Text = function() {
        return this.mk_screenText_text;
    };
    
    Game_Temp.prototype.MK_ScreenText_TextDataCreate = function(text, textColor, outlineColor, fontSize, outlineWidth, fontBold, fontItalic) {
        this.mk_screenText_textData = new MK_ScreenText(text, textColor, outlineColor, fontSize, outlineWidth, fontBold, fontItalic);
        $gameTemp.MK_ScreenText_TextDisplay(true);
    };
    
    Game_Temp.prototype.MK_ScreenText_TextData = function() {
        return this.mk_screenText_textData;
    };
    
    
    //----------ゲームピクチャ----------
    
    const _Game_Picture_initialize = Game_Picture.prototype.initialize;
    Game_Picture.prototype.initialize = function() {
        this.mk_screenText = null;
        if($gameTemp.MK_ScreenText_Text()){
            this.mk_screenText = $gameTemp.MK_ScreenText_TextData();
            $gameTemp.MK_ScreenText_TextDisplay(false);
        }
        _Game_Picture_initialize.apply(this, arguments);
    };
    
    
    //----------スプライトピクチャ----------
    
    const _Sprite_Picture_initialize = Sprite_Picture.prototype.initialize;
    Sprite_Picture.prototype.initialize = function(pictureId) {
        this.mk_screenText_pictureName = "";
        _Sprite_Picture_initialize.apply(this, arguments);
    };
    
    const _Sprite_Picture_updateBitmap = Sprite_Picture.prototype.updateBitmap;
    Sprite_Picture.prototype.updateBitmap = function() {
        const picture = this.picture();
        if (!!picture && !!picture.mk_screenText) {
            const pictureName = picture.mk_screenText.PictureName();
            if(this.mk_screenText_pictureName != pictureName){
                this.mk_screenText_pictureName = pictureName;
                this.MK_ScreenText_LoadBitmap();
            }
            this.visible = true;
        }else{
            if(this.mk_screenText_pictureName){
                this.mk_screenText_pictureName = "";
            }
        }
        _Sprite_Picture_updateBitmap.apply(this, arguments);
    };
    
    Sprite_Picture.prototype.MK_ScreenText_LoadBitmap = function() {
        const picture = this.picture();
        if(!!picture.mk_screenText){
            if(!this.bitmap || this.mk_screenText_pictureName){
                this.bitmap = new Bitmap(1, 1);
            }

            const outlineWidth = picture.mk_screenText.outlineWidth;
            this.bitmap.clear();

            const context = this.bitmap.context;
            context.save();
            const italic = picture.mk_screenText.fontItalic ? "Italic " : "";
            const bold = picture.mk_screenText.fontBold ? "Bold " : "";
            context.font = italic + bold + picture.mk_screenText.fontSize + "px " + this.bitmap.fontFace;
            const w = context.measureText(picture.mk_screenText.text).width;
            context.restore();
            const width = Math.ceil(w);

            const sizeWidth = width + outlineWidth;
            const sizeHeight = picture.mk_screenText.fontSize + outlineWidth;
            this.bitmap.resize(sizeWidth, sizeHeight);
            this.bitmap.textColor = picture.mk_screenText.textColor;
            this.bitmap.outlineColor = picture.mk_screenText.outlineColor;
            this.bitmap.fontSize = picture.mk_screenText.fontSize;
            this.bitmap.outlineWidth = outlineWidth;
            this.bitmap.fontBold = picture.mk_screenText.fontBold;
            this.bitmap.fontItalic = picture.mk_screenText.fontItalic;
            this.bitmap.drawText(picture.mk_screenText.text, outlineWidth / 2, outlineWidth / 2, width, picture.mk_screenText.fontSize, "left");
            this.setFrame(0, 0, sizeWidth, sizeHeight);
            
        }
    };
    
    const _Sprite_Picture_loadBitmap = Sprite_Picture.prototype.loadBitmap;
    Sprite_Picture.prototype.loadBitmap = function() {
        const picture = this.picture();
        if(!picture.mk_screenText){
            _Sprite_Picture_loadBitmap.apply(this, arguments);
        }
    };
    
    
})();
