
/*:

@target MZ
@plugindesc 画面にウィンドウを表示できます
@author 紫鳥＠メロウ紙芝居
@url https://meroukamisibai.com/

@param windowBuilderUse
@text ウィンドウビルダー画像使用
@desc ウィンドウビルダーで作られる画像を使用しますか？
@type boolean
@on 使用する
@off 使用しない
@default false

@help MK_ScreenWindow.js
ver1.01
動作確認コアスクリプト: v1.7.0

画面にウィンドウを表示できます。

プラグインコマンドでウィンドウを用意した後は、
直ぐに「ピクチャの表示」をしてください。
画像は特に何も指定しません。


@command windowSet
@text ウィンドウの用意
@desc ウィンドウを用意した後に、「ピクチャの表示」で画面上にウィンドウを表示します。

@arg window
@text ウィンドウ
@desc 表示するウィンドウの画像です。
@type file
@dir img/system/
@default Window

@arg width
@text 幅
@desc ウィンドウの幅です。
@type number
@default 0

@arg height
@text 高さ
@desc ウィンドウの高さです。
@type number
@default 0

*/

/////////////////スクリーンウィンドウデータ/////////////////

function MK_ScreenWindow(windowFileName, width, height) {
    this.windowFileName = windowFileName || "";
    this.width = width || 0;
    this.height = height || 0;
    this.pictureName = "windowFileName_" + windowFileName + ":width_" + width + ":height_" + height;
}

MK_ScreenWindow.prototype.PictureName = function() {
    return this.pictureName;
};


/////////////////ウィンドウスプライト/////////////

function MK_ScreenWindow_Sprite(windowData) {
    this.initialize(...arguments);
}

MK_ScreenWindow_Sprite.prototype = Object.create(Sprite_Clickable.prototype);
MK_ScreenWindow_Sprite.prototype.constructor = MK_ScreenWindow_Sprite;

MK_ScreenWindow_Sprite.prototype.MK_ScreenWindow_UpdateOrigin = function(anchor_x, anchor_y) {
    this.anchor.x = anchor_x;
    this.anchor.y = anchor_y;
};

MK_ScreenWindow_Sprite.prototype.MK_ScreenWindow_UpdateBlendMode = function(blendMode) {
    this.blendMode = blendMode;
};


(() => {
    
    /////////////////プラグイン関係/////////////////
    
    const pluginName = "MK_ScreenWindow";
    
    //----------プラグインパラメーター----------
    
    const parameters = PluginManager.parameters(pluginName);
    const p_windowBuilderUse = (parameters["windowBuilderUse"] == "true") ? true : false;
    
    //----------プラグインコマンド----------

    //ウィンドウの用意
    PluginManager.registerCommand(pluginName, "windowSet", args => {
        $gameTemp.MK_ScreenWindow_WindowDataCreate(args.window, Number(args.width), Number(args.height));
    });
    
    
    /////////////////元々オブジェクト/////////////////
    
    //----------ゲームテンポラリ----------
    
    const _Game_Temp_initialize = Game_Temp.prototype.initialize;
    Game_Temp.prototype.initialize = function() {
        _Game_Temp_initialize.apply(this, arguments);
        this.MK_ScreenWindow_Initialize();
    };
    
    Game_Temp.prototype.MK_ScreenWindow_Initialize = function() {
        this.mk_screenWindow_window = false;
        this.mk_screenWindow_windowData = null;
    };
    
    Game_Temp.prototype.MK_ScreenWindow_WindowDisplay = function(display) {
        this.mk_screenWindow_window = display;
    };
    
    Game_Temp.prototype.MK_ScreenWindow_Window = function() {
        return this.mk_screenWindow_window;
    };
    
    Game_Temp.prototype.MK_ScreenWindow_WindowDataCreate = function(windowFileName, width, height) {
        this.mk_screenWindow_windowData = new MK_ScreenWindow(windowFileName, width, height);
        this.MK_ScreenWindow_WindowDisplay(true);
    };
    
    Game_Temp.prototype.MK_ScreenWindow_WindowData = function() {
        return this.mk_screenWindow_windowData;
    };
    
    
    //----------ゲームピクチャ----------
    
    const _Game_Picture_initialize = Game_Picture.prototype.initialize;
    Game_Picture.prototype.initialize = function() {
        this.mk_screenWindow = null;
        if($gameTemp.MK_ScreenWindow_Window()){
            this.mk_screenWindow = $gameTemp.MK_ScreenWindow_WindowData();
            $gameTemp.MK_ScreenWindow_WindowDisplay(false);
        }
        _Game_Picture_initialize.apply(this, arguments);
    };
    
    
    //----------ゲームインタープリター----------
    
    const _Game_Interpreter_loadImages = Game_Interpreter.prototype.loadImages;
    Game_Interpreter.prototype.loadImages = function() {
        _Game_Interpreter_loadImages.apply(this, arguments);
        const list = this._list.slice(0, 200);
        for(const command of list){
            if(command.code == 357 && command.parameters[0] == pluginName && command.parameters[1] =="windowSet"){
                ImageManager.loadSystem(command.parameters[3].window);
            }
        }
    };
    
    
    //----------スプライトピクチャ----------
    
    const _Sprite_Picture_initialize = Sprite_Picture.prototype.initialize;
    Sprite_Picture.prototype.initialize = function(pictureId) {
        this.mk_screenWindow_pictureName = "";
        _Sprite_Picture_initialize.apply(this, arguments);
    };
    
    const _Sprite_Picture_updateBitmap = Sprite_Picture.prototype.updateBitmap;
    Sprite_Picture.prototype.updateBitmap = function() {
        const picture = this.picture();
        if (!!picture && !!picture.mk_screenWindow) {
            const pictureName = picture.mk_screenWindow.PictureName();
            if(this.mk_screenWindow_pictureName != pictureName){
                this.mk_screenWindow_pictureName = pictureName;
                this.MK_ScreenWindow_WindowsDestroy();
                this.MK_ScreenWindow_WindowsRegister();
            }
            this.visible = true;
        }else{
            if(this.mk_screenWindow_pictureName){
                this.MK_ScreenWindow_WindowsDestroy();
                this.mk_screenWindow_pictureName = "";
            }
        }
        _Sprite_Picture_updateBitmap.apply(this, arguments);
    };
    
    Sprite_Picture.prototype.MK_ScreenWindow_WindowsDestroy = function() {
        for(let r = this.children.length - 1; r >= 0; --r){
            if(this.children[r].constructor.name == "MK_ScreenWindow_Sprite"){
                this.children[r].destroy();
            }
        }
    };
    
    Sprite_Picture.prototype.MK_ScreenWindow_WindowsRegister = function() {
        const window = this.picture().mk_screenWindow;
        const backSprite = new MK_ScreenWindow_Sprite(window);
        backSprite.addChild(new TilingSprite());
        this.addChild(backSprite);
        const frameSprite = new MK_ScreenWindow_Sprite(window);
        for (let i = 0; i < 8; i++) {
            frameSprite.addChild(new Sprite());
        }
        this.addChild(frameSprite);
        
        this.updateOrigin();
        if(!p_windowBuilderUse){
            this.MK_ScreenWindow_WindowsRefresh();
        }else{
            this.MK_ScreenWindow_WindowsWindowBuilderRefresh();
        }
    };
    
    Sprite_Picture.prototype.MK_ScreenWindow_WindowsRefresh = function() {
        const window = this.picture().mk_screenWindow;
        const sprites = this.children.filter(sprite => sprite.constructor.name == "MK_ScreenWindow_Sprite");
        const backSprite = sprites[0];
        const frameSprite = sprites[1];
        
        (() => {
            const m = 4;
            const w = Math.max(0, window.width - m * 2);
            const h = Math.max(0, window.height - m * 2);
            backSprite.addChild(new TilingSprite());
            const tilingSprite = backSprite.children[0];
            backSprite.bitmap = ImageManager.loadSystem(window.windowFileName);
            backSprite.setFrame(0, 0, 95, 95);
            backSprite.move(m, m);
            backSprite.scale.x = w / 95;
            backSprite.scale.y = h / 95;
            tilingSprite.bitmap = ImageManager.loadSystem(window.windowFileName);
            tilingSprite.anchor.x = this.anchor.x;
            tilingSprite.anchor.y = this.anchor.y;
            tilingSprite.setFrame(0, 96, 96, 96);
            tilingSprite.move(0, 0, w, h);
            tilingSprite.scale.x = 1 / backSprite.scale.x;
            tilingSprite.scale.y = 1 / backSprite.scale.y;
            backSprite.setColorTone([0, 0, 0, 0]);
        })();
        
        (() => {
            const drect = { x: 0, y: 0, width: window.width, height: window.height };
            const srect = { x: 96, y: 0, width: 96, height: 96 };
            const m = 24;
            const mx = 4 * 2 * this.anchor.x;
            const my = 4 * 2 * this.anchor.y;
            for (const child of frameSprite.children) {
                child.bitmap = ImageManager.loadSystem(window.windowFileName);
            }
            const sx = srect.x;
            const sy = srect.y;
            const sw = srect.width;
            const sh = srect.height;
            const dx = drect.x;
            const dy = drect.y;
            const dw = drect.width;
            const dh = drect.height;
            const smw = sw - m * 2;
            const smh = sh - m * 2;
            const dmw = dw - m * 2;
            const dmh = dh - m * 2;
            const children = frameSprite.children;
            frameSprite.setFrame(0, 0, dw, dh);
            frameSprite.move(dw * this.anchor.x * -1 + mx, dh * this.anchor.y * -1 + my);
            children[0].setFrame(sx, sy, m, m);
            children[1].setFrame(sx + sw - m, sy, m, m);
            children[2].setFrame(sx, sy + sw - m, m, m);
            children[3].setFrame(sx + sw - m, sy + sw - m, m, m);
            children[0].move(0, 0);
            children[1].move(dw - m, 0);
            children[2].move(0, dh - m);
            children[3].move(dw - m, dh - m);
            children[4].move(m, 0);
            children[5].move(m, dh - m);
            children[6].move(0, m);
            children[7].move(dw - m, m);
            children[4].setFrame(sx + m, sy, smw, m);
            children[5].setFrame(sx + m, sy + sw - m, smw, m);
            children[6].setFrame(sx, sy + m, m, smh);
            children[7].setFrame(sx + sw - m, sy + m, m, smh);
            children[4].scale.x = dmw / smw;
            children[5].scale.x = dmw / smw;
            children[6].scale.y = dmh / smh;
            children[7].scale.y = dmh / smh;
            if (children[8]) {
                children[8].setFrame(sx + m, sy + m, smw, smh);
                children[8].move(m, m);
                children[8].scale.x = dmw / smw;
                children[8].scale.y = dmh / smh;
            }
            for (const child of children) {
                child.visible = dw > 0 && dh > 0;
            }
        })();

    };
    
    Sprite_Picture.prototype.MK_ScreenWindow_WindowsWindowBuilderRefresh = function() {
        const window = this.picture().mk_screenWindow;
        const sprites = this.children.filter(sprite => sprite.constructor.name == "MK_ScreenWindow_Sprite");
        const backSprite = sprites[0];
        const frameSprite = sprites[1];
        
        (() => {
            const m = 4 + 6;
            const w = Math.max(0, window.width - m * 2);
            const h = Math.max(0, window.height - m * 2);
            const mx = m * 2 * this.anchor.x;
            const my = m * 2 * this.anchor.y;
            const bitmap = new Bitmap(w, h);
            
            backSprite.bitmap = null;
            backSprite.bitmap = bitmap;
            backSprite.setFrame(0, 0, w, h);
            backSprite.move(m - mx, m - my);
            backSprite.setColorTone([0, 0, 0, 0]);
            
            if (w > 0 && h > 0 && window.windowFileName) {
                const p = 192;
                for (let y = 0; y < h; y += p) {
                    for (let x = 0; x < w; x += p) {
                        bitmap.blt(ImageManager.loadSystem(window.windowFileName), 0, p, p, p, x, y, p, p);
                    }
                }
            }
            
        })();
        
        (() => {
            const w = window.width;
            const h = window.height;
            const m = 24;
            const bitmap = new Bitmap(w, h);

            frameSprite.bitmap = null;
            frameSprite.bitmap = bitmap;
            frameSprite.setFrame(0, 0, w, h);

            if (w > 0 && h > 0 && window.windowFileName) {
                const skin = ImageManager.loadSystem(window.windowFileName);

                const p = 96;
                const q = 96;
                bitmap.blt(skin, p+0,   0+0,   m,     m,     0,   0,   m,     m);
                bitmap.blt(skin, p+0,   0+q-m, m,     m,     0,   h-m, m,     m);
                bitmap.blt(skin, p+q-m, 0+0,   m,     m,     w-m, 0,   m,     m);
                bitmap.blt(skin, p+q-m, 0+q-m, m,     m,     w-m, h-m, m,     m);

                const frameHeight = 48;
                const heightCount = Math.floor((h-frameHeight) / frameHeight);
                let remainder = (h-frameHeight) % frameHeight;            
                for(let i = 0; i < heightCount; i++) {
                    bitmap.blt(skin, p+0,   0+m, m, p-m*2, 0,   m+frameHeight*i, m, frameHeight);
                    bitmap.blt(skin, p+q-m, 0+m, m, p-m*2, w-m, m+frameHeight*i, m, frameHeight);
                }
                if(remainder != 0) {
                    bitmap.blt(skin, p+0,   0+m, m, remainder, 0,   m+frameHeight*heightCount, m, remainder);
                    bitmap.blt(skin, p+q-m, 0+m, m, remainder, w-m, m+frameHeight*heightCount, m, remainder);
                }

                const frameWidth = 48;
                const widthCount = Math.floor((w-frameWidth) / frameWidth);
                remainder = (w-frameWidth) % frameWidth;
                for(let j = 0; j < widthCount; j++) {
                    bitmap.blt(skin, p+m,   0+0,   p-m*2, m, m+frameWidth*j, 0,   frameWidth, m);
                    bitmap.blt(skin, p+m,   0+q-m, p-m*2, m, m+frameWidth*j, h-m, frameWidth, m);
                }
                if(remainder != 0) {
                    bitmap.blt(skin, p+m,   0+0,   remainder, m, m+frameWidth*widthCount, 0,   remainder, m);
                    bitmap.blt(skin, p+m,   0+q-m, remainder, m, m+frameWidth*widthCount, h-m, remainder, m);
                }

                const r = 48;
                const s = 48;
                bitmap.blt(skin, 0,   0+q*4, r, s, 0,   0,   r, s);
                bitmap.blt(skin, r,   0+q*4, r, s, w-r, 0,   r, s);
                bitmap.blt(skin, r*2, 0+q*4, r, s, 0,   h-r, r, s);
                bitmap.blt(skin, r*3, 0+q*4, r, s, w-r, h-r, r, s);
            }
            
        })();
        
    };
    
    const _Sprite_Picture_updateOther = Sprite_Picture.prototype.updateOther;
    Sprite_Picture.prototype.updateOther = function() {
        _Sprite_Picture_updateOther.apply(this, arguments);
        if(this.mk_screenWindow_pictureName){
            const picture = this.picture();
            const sprites = this.children.filter(sprite => sprite.constructor.name == "MK_ScreenWindow_Sprite");
            sprites.forEach(sprite => {
                sprite.MK_ScreenWindow_UpdateOrigin(this.anchor.x, this.anchor.y);
                sprite.MK_ScreenWindow_UpdateBlendMode(this.blendMode);
            });
        }
    };
    
    
})();
