
/*:

@target MZ
@plugindesc セルフスイッチを一括で変更できます
@author 紫鳥＠メロウ紙芝居
@url https://meroukamisibai.com/

@help MK_SelfSwitches.js

セルフスイッチを一括で変更できます。


イベントのメモ:

<mk_selfSwitches:[種類]>:
イベントの種類を設定します。


@command nowMap
@text 今いるマップのセルフスイッチ変更
@desc 今いるマップのイベントのセルフスイッチを変更できます。

@arg switches
@text セルフスイッチ
@desc 操作するセルフスイッチです。
@type select
@option A
@option B
@option C
@option D
@default A

@arg operation
@text 操作
@desc 指定したセルフスイッチをONかOFFにします。
@type boolean
@default true

@command nowTypeMap
@text 今いるマップの特定のセルフスイッチ変更
@desc 今いるマップの指定した種類のイベントのセルフスイッチを変更できます。

@arg type
@text 種類
@desc 指定するイベントの種類の名です。
@type string

@arg switches
@text セルフスイッチ
@desc 操作するセルフスイッチです。
@type select
@option A
@option B
@option C
@option D
@default A

@arg operation
@text 操作
@desc 指定したセルフスイッチをONかOFFにします。
@type boolean
@default true

@command mapOff
@text 指定マップのセルフスイッチOFF
@desc 指定したマップのイベントのセルフスイッチをOFFにします。

@arg map
@text マップ
@desc 指定するマップのIDです。
@type number
@min 1
@default 1

@arg switches
@text セルフスイッチ
@desc OFFにするセルフスイッチです。
@type select
@option A
@option B
@option C
@option D
@default A

@command allMapOff
@text 全マップのセルフスイッチOFF
@desc 全マップのイベントのセルフスイッチをOFFにします。

@arg switches
@text セルフスイッチ
@desc OFFにするセルフスイッチです。
@type select
@option A
@option B
@option C
@option D
@default A

*/

(() => {
    
    /////////////////プラグイン関係/////////////////
    
    const pluginName = "MK_SelfSwitches";
    
    //----------プラグインコマンド----------

    //今いるマップのイベント
    PluginManager.registerCommand(pluginName, "nowMap", args => {
        $gameSelfSwitches.MK_SelfSwitches_NowMap(args.switches, (args.operation == "true") ? true : false);
    });
    
    ///今いるマップの特定のイベント
    PluginManager.registerCommand(pluginName, "nowTypeMap", args => {
        $gameSelfSwitches.MK_SelfSwitches_NowTypeMap(args.type, args.switches, (args.operation == "true") ? true : false);
    });
    
    //指定したマップのイベントのセルフスイッチ全てOFF
    PluginManager.registerCommand(pluginName, "mapOff", args => {
        $gameSelfSwitches.MK_SelfSwitches_MapOff(Number(args.map), args.switches);
    });
    
    //全マップのイベントのセルフスイッチ全てOFF
    PluginManager.registerCommand(pluginName, "allMapOff", args => {
        $gameSelfSwitches.MK_SelfSwitches_MapOff(Number(args.map), args.switches);
        $gameSelfSwitches.MK_SelfSwitches_AllMapOff(args.switches);
    });
    
    
    /////////////////元々オブジェクト/////////////////
    
    //----------セルフスイッチ関係----------
    
    //セルフスイッチ切替
    Game_SelfSwitches.prototype.MK_SelfSwitches_Switching = function(mapId, events, selfSwitches, value) {//マップid, イベントid配列, 対象セルフスイッチ, trueかfalse
        for(let r = 0; r < events.length; r++){
            this.setValue([mapId, events[r], selfSwitches], value);
        }
    };

    //今いるマップのイベント
    Game_SelfSwitches.prototype.MK_SelfSwitches_NowMap = function(selfSwitches, value) {//対象セルフスイッチ, trueかfalse
        const mapId = $gameMap.mapId();
        let events = [];
        const e = $dataMap.events.filter(function(event) {
            return (!!event) ? true : false;
        });
        for(let r = 0; r < e.length; r++){
            events.push(e[r].id);
        }
        this.MK_SelfSwitches_Switching(mapId, events, selfSwitches, value);
    };

    //今いるマップの特定のイベント
    Game_SelfSwitches.prototype.MK_SelfSwitches_NowTypeMap = function(type, selfSwitches, value) {//種類, 対象セルフスイッチ, trueかfalse
        const mapId = $gameMap.mapId();
        let events = [];
        const e = $dataMap.events.filter(event => (!!event && event.meta["mk_selfSwitches"] == type) ? true : false);
        for(let r = 0; r < e.length; r++){
            events.push(e[r].id);
        }
        this.MK_SelfSwitches_Switching(mapId, events, selfSwitches, value);
    };

    //指定したマップのイベントのセルフスイッチ全てOFF
    Game_SelfSwitches.prototype.MK_SelfSwitches_MapOff = function(mapId, selfSwitches) {//マップid, 対象セルフスイッチ
        const selfSwitchesData = Object.keys(this._data);
        let name = [];
        let deleteData = [];
        for(let r = 0; r < selfSwitchesData.length; r++){
            name = selfSwitchesData[r].split(",");
            if(name[0] == mapId && selfSwitches == name[2]){
                deleteData.push(selfSwitchesData[r]);
            }
        }
        for(let r = 0; r < deleteData.length; r++){
            delete this._data[deleteData[r]];
        }
        this.onChange();
    };

    //全マップのイベントのセルフスイッチ全てOFF
    Game_SelfSwitches.prototype.MK_SelfSwitches_AllMapOff = function(selfSwitches) {//対象セルフスイッチ
        const selfSwitchesData = Object.keys(this._data);
        let name = [];
        let deleteData = [];
        for(let r = 0; r < selfSwitchesData.length; r++){
            name = selfSwitchesData[r].split(",");
            if(selfSwitches == name[2]){
                deleteData.push(selfSwitchesData[r]);
            }
        }
        for(let r = 0; r < deleteData.length; r++){
            delete this._data[deleteData[r]];
        }
        this.onChange();
    };
    

})();
