
/*:

@target MZ
@plugindesc メニューを簡易化します
@author 紫鳥＠メロウ紙芝居
@url https://meroukamisibai.com/

@param command
@text メニューのコマンド
@desc 簡易メニューのコマンドの設定ができます。
@type struct<command>[]
@default ["{\"name\":\"再開\",\"action\":\"//メニューを閉じます。\\nSceneManager.pop();\",\"displayConditions\":\"return true;\",\"choicePossible\":\"return true;\"}","{\"name\":\"リトライ\",\"action\":\"//スイッチ2をONにしてメニューを閉じます。\\n$gameSwitches.setValue(2, true);\\nSceneManager.pop();\",\"displayConditions\":\"//スイッチ1がONの時に表示されます。\\nif($gameSwitches.value(1)){\\n return true;\\n}\\nreturn false;\",\"choicePossible\":\"return true;\"}","{\"name\":\"リタイア\",\"action\":\"//スイッチ3をONにしてメニューを閉じます。\\n$gameSwitches.setValue(3, true);\\nSceneManager.pop();\",\"displayConditions\":\"//スイッチ1がONの時に表示されます。\\nif($gameSwitches.value(1)){\\n return true;\\n}\\nreturn false;\\n\",\"choicePossible\":\"return true;\"}","{\"name\":\"オプション\",\"action\":\"//オプションに移動します。\\nSceneManager.push(Scene_Options);\",\"displayConditions\":\"return true;\",\"choicePossible\":\"return true;\"}","{\"name\":\"ゲーム終了\",\"action\":\"//ゲーム終了画面に行きます。\\nSceneManager.push(Scene_GameEnd);\",\"displayConditions\":\"//スイッチ1がOFFの時に表示されます。\\nif(!$gameSwitches.value(1)){\\n return true;\\n}\\nreturn false;\",\"choicePossible\":\"return true;\"}","{\"name\":\"ランダム\",\"action\":\"//ランダムで何かの画面に移動します。\\nswitch(Math.floor(Math.random() * 5)){\\n case 0 :\\n  //アイテム画面に移動します。\\n  SceneManager.push(Scene_Item);\\n  break;\\n case 1 :\\n  //スキル画面に移動します。\\n  SceneManager.push(Scene_Skill);\\n  break;\\n case 2 :\\n  //装備画面に移動します。\\n  SceneManager.push(Scene_Equip);\\n  break;\\n case 3 :\\n  //ステータス画面に移動します。\\n  SceneManager.push(Scene_Status);\\n  break;\\n case 4 :\\n  //セーブ画面に移動します。\\n  SceneManager.push(Scene_Save);\\n  break;\\n}\\n\",\"displayConditions\":\"return false;\",\"choicePossible\":\"return true;\"}"]

@help MK_SimpleMenu.js
ver1.01
動作確認コアスクリプト: v1.7.0

メニューを簡易化します。


@command simpleMenu
@text メニュー簡易化
@desc メニューを簡易化するか設定できます。

@arg simple
@text 簡易化
@desc メニューを簡易化するか設定できます。
@type boolean
@on 簡易化する
@off 簡易化しない
@default true

*/

/*~struct~command:

@param name
@text 名前
@desc コマンドの名前です。
@type string

@param action
@text 選択された時の処理
@desc 選択された時の処理です。スクリプトで入力してください。
@type multiline_string
@default SceneManager.pop();

@param displayConditions
@text 表示される条件
@desc コマンドがメニューに表示される条件です。スクリプトで入力してboolean型を返してください。
@type multiline_string
@default return true;

@param choicePossible
@text 選択可能か
@desc 選択できるコマンドか設定できます。スクリプトで入力してboolean型を返してください。
@type multiline_string
@default return true;

*/

(() => {
    
    /////////////////プラグイン関係/////////////////
    
    const pluginName = "MK_SimpleMenu";
    
    //----------プラグインパラメーター----------
    
    const parameters = PluginManager.parameters(pluginName);
    
    const p_command = function() {
        let command = JSON.parse(parameters["command"]);
        for(let r = 0; r < command.length; r++){
            command[r] = JSON.parse(command[r]);
        }
        return command;
    }();
    
    //----------プラグインコマンド----------

    PluginManager.registerCommand(pluginName, "simpleMenu", args => {
        $gameSystem.MK_SimpleMenu_SimpleMenu((args.simple == "true") ? true : false);
    });
    
    
    /////////////////元々オブジェクト/////////////////
    
    //----------セーブ関係----------
    
    //ロード
    const _DataManager_extractSaveContents = DataManager.extractSaveContents;
    DataManager.extractSaveContents = function(contents) {
        _DataManager_extractSaveContents.apply(this, arguments);
        if(typeof $gameSystem.mk_simpleMenu_simpleMenu === "undefined"){
            $gameSystem.MK_SimpleMenu_Initialize();
        }
    };
    
    //----------ゲームシステム関係----------
    
    const _Game_System_initialize = Game_System.prototype.initialize;
    Game_System.prototype.initialize = function() {
        _Game_System_initialize.apply(this, arguments);
        this.MK_SimpleMenu_Initialize();
    };
    
    Game_System.prototype.MK_SimpleMenu_Initialize = function() {
        this.mk_simpleMenu_simpleMenu = false;
        this.mk_simpleMenu_choiceNumber = 0;
    };
    
    //メニューを簡易化するか
    Game_System.prototype.MK_SimpleMenu_SimpleMenu = function(simple) {//簡易化するか
        this.mk_simpleMenu_simpleMenu = simple;
    };

    //選択肢の数
    Game_System.prototype.MK_SimpleMenu_ChoiceNumber = function(number) {//選択肢の数
        this.mk_simpleMenu_choiceNumber = number;
    };

    //スクリプトの条件判定結果返す
    Game_System.prototype.MK_SimpleMenu_Conditions = function(script) {//スクリプト
        let c = null;
        eval("c = function(){" + script + "}();");
        return c;
    };
    
    
    //----------メニューシーン----------
    
    const _Scene_Menu_createCommandWindow = Scene_Menu.prototype.createCommandWindow;
    Scene_Menu.prototype.createCommandWindow = function() {
        if($gameSystem.mk_simpleMenu_simpleMenu){
            const x = Graphics.boxWidth * 14 / 100;
            const y = Graphics.boxHeight * 68 / 100;
            const width = Graphics.boxWidth - x * 2;
            const rect = new Rectangle(x, y, width, this.calcWindowHeight(1, true));
            const commandWindow = new Window_MenuCommand(rect);
            let n = 0;
            for(let r = 0; r < p_command.length; r++){
                if($gameSystem.MK_SimpleMenu_Conditions(p_command[r].displayConditions)){
                    eval("commandWindow.setHandler('mk_simpleMenu_" + r + "', function(){" + p_command[r].action + "}.bind(this));");
                    n++;
                }
            }
            commandWindow.setHandler("cancel", this.popScene.bind(this));
            $gameSystem.MK_SimpleMenu_ChoiceNumber(n);
            commandWindow.refreshCursor();
            commandWindow.refresh();
            this.addWindow(commandWindow);
            this._commandWindow = commandWindow;
        }else{
            _Scene_Menu_createCommandWindow.apply(this, arguments);
        }
    };
    
    
    //----------ゴールドウィンドウ----------
    
    const _Window_Gold_initialize = Window_Gold.prototype.initialize;
    Window_Gold.prototype.initialize = function(rect) {
        _Window_Gold_initialize.apply(this, arguments);
        if($gameSystem.mk_simpleMenu_simpleMenu){
            this.hide();
        }
    };
    
    
    //----------メニューコマンドウィンドウ----------
    
    const _Window_MenuCommand_maxCols = Window_MenuCommand.prototype.maxCols;
    Window_MenuCommand.prototype.maxCols = function() {
        if($gameSystem.mk_simpleMenu_simpleMenu){
            return $gameSystem.mk_simpleMenu_choiceNumber;
        }else{
            return _Window_MenuCommand_maxCols.apply(this, arguments);
        }
    };
    
    const _Window_MenuCommand_makeCommandList = Window_MenuCommand.prototype.makeCommandList;
    Window_MenuCommand.prototype.makeCommandList = function() {
        if($gameSystem.mk_simpleMenu_simpleMenu){
            for(let r = 0; r < p_command.length; r++){
                if($gameSystem.MK_SimpleMenu_Conditions(p_command[r].displayConditions)){
                   eval("this.addCommand('" + p_command[r].name + "', 'mk_simpleMenu_" + r + "', " + $gameSystem.MK_SimpleMenu_Conditions(p_command[r].choicePossible) + ");");
                }
            }
        }else{
            _Window_MenuCommand_makeCommandList.apply(this, arguments);
        }
    };
    
    
    //----------メニューステータスウィンドウ----------
    
    const _Window_MenuStatus_initialize = Window_MenuStatus.prototype.initialize;
    Window_MenuStatus.prototype.initialize = function(rect) {
        _Window_MenuStatus_initialize.apply(this, arguments);
        if($gameSystem.mk_simpleMenu_simpleMenu){
            this.hide();
        }
    };
    
    
})();
