
/*:

@target MZ
@plugindesc 連続する「文章の表示」を一つに省略します
@author 紫鳥＠メロウ紙芝居
@url https://meroukamisibai.com/

@help MK_TestPlayOmitMessage.js
ver 1.0

連続する「文章の表示」を一つに省略します。　
テストプレイのイベントの動作チェックなどにどうぞ。

この機能をOFFにしたい場合は、
プラグインの状態をOFFにしてください。

*/

(() => {
    
    /////////////////元々オブジェクト/////////////////
    
    Game_Interpreter.prototype.command101 = function(params) {
        if ($gameMessage.isBusy()) {
            return false;
        }
        $gameMessage.setFaceImage("", 0);
        $gameMessage.setBackground(0);
        $gameMessage.setPositionType(2);
        $gameMessage.setSpeakerName("");

        let lastMessage = "";
        while (this.nextEventCode() === 101 || this.nextEventCode() === 401) {
            this._index++;
            switch(this.currentCommand().code){
                case 101 :
                    lastMessage = "";
                    break;
                case 401 :
                    if(!lastMessage){
                        lastMessage = this.currentCommand().parameters[0];
                    }
                    break;
            }
        }
        lastMessage = "\\>" + lastMessage;

        let nextCommand = "";
        switch(this.nextEventCode()){
            case 0 :
                nextCommand = "空行";
                break;
            case 101 :
                nextCommand = "文章の表示";
                break;
            case 102 :
                nextCommand = "選択肢の表示";
                break;
            case 103 :
                nextCommand = "数値入力の処理";
                break;
            case 104 :
                nextCommand = "アイテム選択の処理";
                break;
            case 105 :
                nextCommand = "文章のスクロール表示";
                break;
            case 108 :
                nextCommand = "注釈";
                break;
            case 111 :
                nextCommand = "条件分岐";
                break;
            case 112 :
                nextCommand = "ループ";
                break;
            case 112 :
                nextCommand = "ループの中断";
                break;
            case 115 :
                nextCommand = "イベントの処理の中断";
                break;
            case 117 :
                nextCommand = "コモンイベント";
                break;
            case 118 :
                nextCommand = "ラベル";
                break;
            case 119 :
                nextCommand = "ラベルジャンプ";
                break;
            case 121 :
                nextCommand = "スイッチの操作";
                break;
            case 122 :
                nextCommand = "変数の操作";
                break;
            case 123 :
                nextCommand = "セルフスイッチの操作";
                break;
            case 124 :
                nextCommand = "タイマーの処理";
                break;
            case 115 :
                nextCommand = "所持金の増滅";
                break;
            case 126 :
                nextCommand = "アイテムの増滅";
                break;
            case 127 :
                nextCommand = "武器の増滅";
                break;
            case 128 :
                nextCommand = "防具の増滅";
                break;
            case 129 :
                nextCommand = "メンバーの入れ替え";
                break;
            case 132 :
                nextCommand = "戦闘BGMの変更";
                break;
            case 133 :
                nextCommand = "勝利MEの変更";
                break;
            case 134 :
                nextCommand = "セーブ禁止の変更";
                break;
            case 135 :
                nextCommand = "メニュー禁止の変更";
                break;
            case 136 :
                nextCommand = "エンカウント禁止の変更";
                break;
            case 137 :
                nextCommand = "並び替え禁止の変更";
                break;
            case 138 :
                nextCommand = "ウィンドウカラーの変更";
                break;
            case 139 :
                nextCommand = "敗北MEの変更";
                break;
            case 140 :
                nextCommand = "乗り物BGMの変更";
                break;
            case 201 :
                nextCommand = "場所移動";
                break;
            case 202 :
                nextCommand = "乗り物位置の設定";
                break;
            case 203 :
                nextCommand = "イベントの位置の設定";
                break;
            case 204 :
                nextCommand = "マップのスクロール";
                break;
            case 205 :
                nextCommand = "移動ルートの設定";
                break;
            case 206 :
                nextCommand = "乗り物の乗降";
                break;
            case 211 :
                nextCommand = "透明状態の変更";
                break;
            case 212 :
                nextCommand = "アニメーションの表示";
                break;
            case 213 :
                nextCommand = "フキダシアイコンの表示";
                break;
            case 214 :
                nextCommand = "イベントの一時消去";
                break;
            case 216 :
                nextCommand = "隊列歩行の変更";
                break;
            case 217 :
                nextCommand = "隊列メンバーの集合";
                break;
            case 221 :
                nextCommand = "画面のフェードアウト";
                break;
            case 222 :
                nextCommand = "画面のフェードイン";
                break;
            case 223 :
                nextCommand = "画面の色調変更";
                break;
            case 224 :
                nextCommand = "画面のフラッシュ";
                break;
            case 225 :
                nextCommand = "画面のシェイク";
                break;
            case 230 :
                nextCommand = "ウェイト";
                break;
            case 231 :
                nextCommand = "ピクチャの表示";
                break;
            case 232 :
                nextCommand = "ピクチャの移動";
                break;
            case 233 :
                nextCommand = "ピクチャの回転";
                break;
            case 234 :
                nextCommand = "ピクチャの色調変更";
                break;
            case 235 :
                nextCommand = "ピクチャの消去";
                break;
            case 236 :
                nextCommand = "天候の設定";
                break;
            case 241 :
                nextCommand = "BGMの設定";
                break;
            case 242 :
                nextCommand = "BGMのフェードアウト";
                break;
            case 243 :
                nextCommand = "BGMの保存";
                break;
            case 244 :
                nextCommand = "BGMの再開";
                break;
            case 245 :
                nextCommand = "BGSの演奏";
                break;
            case 246 :
                nextCommand = "BGSのフェードアウト";
                break;
            case 249 :
                nextCommand = "MEの演奏";
                break;
            case 250 :
                nextCommand = "SEの演奏";
                break;
            case 251 :
                nextCommand = "SEの停止";
                break;
            case 261 :
                nextCommand = "ムービーの再生";
                break;
            case 281 :
                nextCommand = "マップ名表示の変更";
                break;
            case 282 :
                nextCommand = "タイルセットの変更";
                break;
            case 283 :
                nextCommand = "戦闘背景の変更";
                break;
            case 284 :
                nextCommand = "遠景の変更";
                break;
            case 285 :
                nextCommand = "指定位置の情報取得";
                break;
            case 301 :
                nextCommand = "戦闘の処理";
                break;
            case 302 :
                nextCommand = "ショップの処理";
                break;
            case 303 :
                nextCommand = "名前入力の処理";
                break;
            case 311 :
                nextCommand = "HPの増滅";
                break;
            case 312 :
                nextCommand = "MPの増滅";
                break;
            case 326 :
                nextCommand = "TPの増滅";
                break;
            case 313 :
                nextCommand = "ステートの変更";
                break;
            case 314 :
                nextCommand = "全回復";
                break;
            case 315 :
                nextCommand = "経験値の増滅";
                break;
            case 316 :
                nextCommand = "レベルの増滅";
                break;
            case 317 :
                nextCommand = "能力値の増滅";
                break;
            case 318 :
                nextCommand = "スキルの増滅";
                break;
            case 319 :
                nextCommand = "装備の変更";
                break;
            case 320 :
                nextCommand = "名前の変更";
                break;
            case 321 :
                nextCommand = "職業の変更";
                break;
            case 322 :
                nextCommand = "アクター画像の変更";
                break;
            case 323 :
                nextCommand = "乗り物画像の変更";
                break;
            case 324 :
                nextCommand = "二つ名の変更";
                break;
            case 325 :
                nextCommand = "プロフィールの変更";
                break;
            case 331 :
                nextCommand = "敵キャラのHP増滅";
                break;
            case 332 :
                nextCommand = "敵キャラのMP増滅";
                break;
            case 342 :
                nextCommand = "敵キャラのTP増滅";
                break;
            case 333 :
                nextCommand = "敵キャラのステート変更";
                break;
            case 334 :
                nextCommand = "敵キャラの全回復";
                break;
            case 335 :
                nextCommand = "敵キャラの出現";
                break;
            case 336 :
                nextCommand = "敵キャラの変身";
                break;
            case 337 :
                nextCommand = "戦闘アニメーションの表示";
                break;
            case 339 :
                nextCommand = "戦闘行動の強制";
                break;
            case 340 :
                nextCommand = "バトルの中断";
                break;
            case 351 :
                nextCommand = "メニュー画面を開く";
                break;
            case 352 :
                nextCommand = "セーブ画面を開く";
                break;
            case 353 :
                nextCommand = "ゲームオーバー";
                break;
            case 354 :
                nextCommand = "タイトル画面に戻す";
                break;
            case 355 :
                nextCommand = "スクリプト";
                break;
            case 655 :
                nextCommand = "プラグインコマンド（MV）";
                break;
            case 357 :
                nextCommand = "プラグインコマンド";
                break;
            default :
                nextCommand = "？？？？？？";
                break;
        }
        nextCommand = "\\>" + nextCommand;

        $gameMessage.add("\\>-----最後の文章の表示一行----------");
        $gameMessage.add(lastMessage);
        $gameMessage.add("\\>-----次のイベントコマンド----------");
        $gameMessage.add(nextCommand);

        switch (this.nextEventCode()) {
            case 102: // Show Choices
                this._index++;
                this.setupChoices(this.currentCommand().parameters);
                break;
            case 103: // Input Number
                this._index++;
                this.setupNumInput(this.currentCommand().parameters);
                break;
            case 104: // Select Item
                this._index++;
                this.setupItemChoice(this.currentCommand().parameters);
                break;
        }
        this.setWaitMode("message");
        return true;
    };
    
})();
