
/*:

@target MZ
@plugindesc タイトルから指定した場所に移動するコマンドを追加します
@author 紫鳥＠メロウ紙芝居
@url https://meroukamisibai.com/

@param commands
@text コマンド
@desc コマンドの設定です。
@type struct<command>[]
@default ["{\"name\":\"アナザー\",\"move\":\"{\\\"map\\\":\\\"1\\\",\\\"x\\\":\\\"0\\\",\\\"y\\\":\\\"0\\\",\\\"direction\\\":\\\"2\\\"}\",\"position\":\"{\\\"name\\\":\\\"continue\\\",\\\"position\\\":\\\"down\\\"}\",\"displayConditions\":\"return true;\",\"choicePossible\":\"return true;\",\"cursor\":\"true\"}"]

@param addHeight
@text 高さ追加
@desc 表示されるコマンドが増える場合、コマンドウィンドウの高さも増やすか
@type boolean
@on 増やす
@off 増やさない
@default true

@help MK_TitleMove.js
ver1.1

タイトルから指定した場所に移動するコマンドを追加します。


*/

/*~struct~command:

@param name
@text 名前
@desc コマンドの名前です。
@type string

@param move
@text 移動先
@desc 選択された時の移動先です。
@type struct<move>

@param position
@text コマンド位置
@desc コマンドの位置です。
@type struct<position>

@param displayConditions
@text 表示される条件
@desc コマンドが表示される条件です。スクリプトで入力してboolean型を返してください。
@type multiline_string
@default return true;

@param choicePossible
@text 選択可能か
@desc 選択できるコマンドか設定できます。スクリプトで入力してboolean型を返してください。
@type multiline_string
@default return true;

@param cursor
@text カーソル初期位置
@desc このコマンドが最後に選択された状態でタイトル画面に戻った時、カーソル初期位置をこのコマンドにするか設定できます。
@type boolean
@on カーソル初期位置にする
@off カーソル初期位置にしない
@default true

*/

/*~struct~move:

@param map
@text マップ
@desc 移動するマップのidです。
@type number
@min 1
@default 1

@param x
@text x
@desc 移動するマップのxです。
@type number
@min 0
@default 0

@param y
@text y
@desc 移動するマップのyです。
@type number
@min 0
@default 0

@param direction
@text 向き
@desc 移動するマップの向きです。
@type select
@option 下
@value 2
@option 左
@value 4
@option 右
@value 6
@option 上
@value 8
@default 2

*/

/*~struct~position:

@param name
@text 近いコマンド
@desc コマンドを追加したい所の近くにあるコマンドを指定してください。
@type select
@option ニューゲーム
@value newGame
@option コンティニュー
@value continue
@option オプション
@value options
@default continue

@param position
@text 位置
@desc 指定した近いコマンドのどこに置くか
@type select
@option 近いコマンドの上
@value up
@option 近いコマンドの下
@value down
@default up

*/

(() => {
    
    /////////////////自作関係/////////////////
    
    const mk_titleMove = new MK_TitleMove();
    
    function MK_TitleMove() {
        this.commands = [];
        this.choiceId = 0;
        this.cursorLast = false;
        this.selectSymbol = "";
    }
    
    MK_TitleMove.prototype.Symbol = function() {
        return "mk_titleMove_";
    };
    
    MK_TitleMove.prototype.CommandsMake = function() {
        let id = 1;
        p_commands.forEach(p => {
            this.commands.push({id : id, pluginParameter : p});
            id++;
        });
    };
    
    MK_TitleMove.prototype.Commands = function() {
        return this.commands;
    };
    
    MK_TitleMove.prototype.Command = function(id) {
        return this.commands.find(c => c.id == id);
    };
    
    MK_TitleMove.prototype.ChoiceId = function() {
        return this.choiceId;
    };
    
    MK_TitleMove.prototype.ChoiceIdSet = function(id) {
        this.choiceId = id;
    };
    
    MK_TitleMove.prototype.CursorLast = function() {
        return this.cursorLast;
    };
    
    MK_TitleMove.prototype.CursorLastSet = function(cursorLast) {
        this.cursorLast = cursorLast;
    };
    
    MK_TitleMove.prototype.SelectSymbol = function() {
        return this.selectSymbol;
    };
    
    MK_TitleMove.prototype.SelectSymbolSet = function(symbol) {
        this.selectSymbol = symbol;
    };
    
    
    /////////////////プラグイン関係/////////////////
    
    const pluginName = "MK_TitleMove";
    
    //----------プラグインパラメーター----------
    
    const parameters = PluginManager.parameters(pluginName);
    
    const p_commands = function() {
        let commands = JSON.parse(parameters["commands"]);
        for(let r = 0; r < commands.length; r++){
            commands[r] = JSON.parse(commands[r]);
            
            commands[r].move = JSON.parse(commands[r].move);
            commands[r].move.map = Number(commands[r].move.map);
            commands[r].move.x = Number(commands[r].move.x);
            commands[r].move.y = Number(commands[r].move.y);
            commands[r].move.direction = Number(commands[r].move.direction);
            
            commands[r].position = JSON.parse(commands[r].position);
            commands[r].cursor = commands[r].cursor == "true" ? true : false;
        }
        return commands;
    }();
    const p_addHeight = parameters["addHeight"] == "true" ? true : false;
    
    mk_titleMove.CommandsMake();
    
    
    /////////////////元々オブジェクト/////////////////
    
    //----------プレイヤーデータ----------
    
    const _Game_Player_setupForNewGame = Game_Player.prototype.setupForNewGame;
    Game_Player.prototype.setupForNewGame = function() {
        const id = mk_titleMove.ChoiceId();
        if(id > 0){
            const move = mk_titleMove.Command(id).pluginParameter.move;
            const mapId = move.map;
            const x = move.x;
            const y = move.y;
            const direction = move.direction;
            this.reserveTransfer(mapId, x, y, direction, 0);
            mk_titleMove.ChoiceIdSet(0);
        }else{
            _Game_Player_setupForNewGame.apply(this, arguments);
        }
    };
    
    
    //----------タイトルシーン----------
    
    const _Scene_Title_calcWindowHeight = Scene_Title.prototype.calcWindowHeight;
    Scene_Title.prototype.calcWindowHeight = function(numLines, selectable) {
        if(p_addHeight){
            mk_titleMove.Commands().forEach(c => {
                const p = c.pluginParameter;
                if(eval("(() => {" + p.displayConditions + "})();")){
                    numLines++;
                }
            });
        }
        return _Scene_Title_calcWindowHeight.apply(this, arguments);
    };
    
    const _Scene_Title_createCommandWindow = Scene_Title.prototype.createCommandWindow;
    Scene_Title.prototype.createCommandWindow = function() {
        _Scene_Title_createCommandWindow.apply(this, arguments);
        mk_titleMove.Commands().forEach(c => {
            const p = c.pluginParameter;
            this._commandWindow.setHandler(mk_titleMove.Symbol() + c.id, this.MK_TitleMove_Command.bind(this, c));
        });
    };
    
    Scene_Title.prototype.MK_TitleMove_Command = function(c) {
        mk_titleMove.ChoiceIdSet(c.id);
        mk_titleMove.CursorLastSet(c.pluginParameter.cursor);
        mk_titleMove.SelectSymbolSet(mk_titleMove.Symbol() + c.id);
        this.commandNewGame();
    };
    
    
    //----------タイトルウィンドウ----------
    
    const _Window_TitleCommand_makeCommandList = Window_TitleCommand.prototype.makeCommandList;
    Window_TitleCommand.prototype.makeCommandList = function() {
        _Window_TitleCommand_makeCommandList.apply(this, arguments);
        let downCorrection_newGame = 0;
        let downCorrection_continue = 0;
        let downCorrection_options = 0;
        const symbol = mk_titleMove.Symbol();
        mk_titleMove.Commands().forEach(c => {
            const p = c.pluginParameter;
            if(eval("(() => {" + p.displayConditions + "})();")){
                this.addCommand(p.name, symbol + c.id, eval("(() => {" + p.choicePossible + "})();"));
                const addCommand = this._list.pop();
                let nameIndex = 0;
                switch(p.position.name){
                    case "newGame":
                        nameIndex = this._list.findIndex(c2 => c2.symbol == "newGame");
                        if(p.position.position == "up"){
                            this._list.splice(nameIndex, 0, addCommand);
                        }else{
                            this._list.splice(nameIndex + 1 + downCorrection_newGame, 0, addCommand);
                            downCorrection_newGame++;
                        }
                        break;
                    case "continue":
                        nameIndex = this._list.findIndex(c2 => c2.symbol == "continue");
                        if(p.position.position == "up"){
                            this._list.splice(nameIndex, 0, addCommand);
                        }else{
                            this._list.splice(nameIndex + 1 + downCorrection_continue, 0, addCommand);
                            downCorrection_continue++;
                        }
                        break;
                    case "options":
                        nameIndex = this._list.findIndex(c2 => c2.symbol == "options");
                        if(p.position.position == "up"){
                            this._list.splice(nameIndex, 0, addCommand);
                        }else{
                            this._list.splice(nameIndex + 1 + downCorrection_options, 0, addCommand);
                            downCorrection_options++;
                        }
                        break;
                }
            }
        });
    };
    
    const _Window_TitleCommand_selectLast = Window_TitleCommand.prototype.selectLast;
    Window_TitleCommand.prototype.selectLast = function() {
        if(mk_titleMove.CursorLast()){
            this.selectSymbol(mk_titleMove.SelectSymbol());
            mk_titleMove.CursorLastSet(false);
        }else{
            _Window_TitleCommand_selectLast.apply(this);
        }
    };

})();
