//=============================================================================
// RPG Maker MZ - VideoController
//=============================================================================

/*:
 *
 * @plugindesc ビデオコントローラー
 * @target MZ
 * @author sun_dandy
 * @url https://star-write-dream.com/
 * @base MoviePicture
 * @orderAfter MoviePicture
 *
 * @help VideoController.js(ver1.0.1)
 *
 * MoviePicture.jsを前提としたビデオコントローラー
 *
 * --------------------------
 * ■利用規約
 * Copyright (c) 2025 sund_dandy
 * https://star-write-dream.com/
 *
 * 以下に定める条件に従い、本プラグインファイル（以下「ソフトウェア」）の
 * 制作依頼者に対し、ソフトウェアを変更し、
 * 制作依頼者の制作する作品（以下、制作物）に組み込むことを許可します。
 * 制作物の内容および公開形式に制約はありません。
 *
 * ソフトウェア単体で掲載、頒布、共有することはできません。
 * 上記の著作権表示および本許諾表示は変更できず、削除もできません。
 * 別途、制作物の重要な箇所にソフトウェアの著作権表示をする必要はありません。
 *
 * ソフトウェアは「現状のまま」で、明示であるか暗黙であるかを問わず、
 * 何らの保証もなく提供されます。ここでいう保証とは、商品性、
 * 特定の目的への適合性、および権利非侵害についての保証も含みますが、
 * それに限定されるものではありません。作者または著作権者は、契約行為、
 * 不法行為、またはそれ以外であろうと、ソフトウェアに起因または関連し、
 * あるいはソフトウェアの使用またはその他の扱いによって生じる一切の請求、
 * 損害、その他の義務について何らの責任も負わないものとします。
 * --------------------------
 * 
 * @param playImage
 * @text 再生ボタン画像
 * @desc 再生ボタン画像を指定します。
 * @type file
 * @dir img/system
 * @default 
 * 
 * @param pauseImage
 * @text 一時停止ボタン画像
 * @desc 一時停止ボタン画像を指定します。
 * @type file
 * @dir img/system
 * @default 
 * 
 * @param endImage
 * @text 終了ボタン画像
 * @desc 終了ボタン画像を指定します。
 * @type file
 * @dir img/system
 * @default 
 * 
 * @param sliderBackColor
 * @text シークバー背面色
 * @desc シークバー背面の色を指定します。
 * @type struct<SliderData>
 * @default {"color1":"#696969","color2":"#808080","isVertical":"true"}
 * 
 * @param sliderToggleColor
 * @text トグル色
 * @desc トグル色を指定します。
 * @type struct<SliderData>
 * @default {"color1":"#D3D3D3","color2":"#C0C0C0","isVertical":"true"}
 * 
 * @param layout
 * @text 初期レイアウト
 * @desc レイアウトを指定します。プラグインコマンドで変更できます。
 * @type struct<LayoutData>
 * @default {"sliderPosition":"200,500","sliderSize":"400,20","toggleSize":"20,26","buttonPosition":"620,500","endButtonPosition":"680,500"}
 *
 * @command open
 * @text コントローラを表示する
 * @desc コントローラを表示します。
 * 
 * @command setLayout
 * @text レイアウト変更
 * @desc レイアウトを変更します。
 * 
 * @arg layout
 * @text 新規設定
 * @type struct<LayoutData>
 * @desc レイアウトを変更します。
 * @default {"sliderPosition":"200,500","sliderSize":"400,20","toggleSize":"20,26","buttonPosition":"620,500","endButtonPosition":"680,500"}
 * 
 * @arg setDefault
 * @text デフォルトに戻す
 * @type boolean
 * @desc ON:レイアウトをパラメータの初期値に戻します。「新規設定」は無視されます。
 * @default false
 * 
 */
/*~struct~SliderData:
 *
 * @param color1
 * @type string
 * @text 色1
 * @desc グラデーション色1を指定します。
 * @default #ffffff
 *
 * @param color2
 * @type string
 * @text 色2
 * @desc グラデーション色2を指定します。
 * @default #000000
 *
 * @param isVertical
 * @type boolean
 * @text 縦にグラデーション
 * @desc ON:縦グラデーション。OFF:横グラデーション。
 * @default false
 *
 *
*/
/*~struct~LayoutData:
 *
 * @param sliderPosition
 * @text シークバー位置
 * @desc シークバーの位置を指定します。（x,y）
 * @type string
 * @default 100,300
 * 
 * @param sliderSize
 * @text スクロールバーサイズ
 * @desc スクロールバーのサイズを指定します。（幅,高さ）
 * @type string
 * @default 400,80
 * 
 * @param toggleSize
 * @text トグルサイズ
 * @desc トグルのサイズを指定します。（幅,高さ）
 * @type string
 * @default 40,100
 *
 * @param buttonPosition
 * @text 再生・一時停止ボタン画像の位置
 * @desc 再生・一時停止ボタンの位置を指定します。（x,y）
 * @type string
 * @default 400,400
 * 
 * @param endButtonPosition
 * @text 終了ボタン画像の位置
 * @desc 終了ボタンの位置をx,yで指定します。
 * @type string
 * @default 500,400
 *
*/

/*
    ■更新履歴
    v1.0.1 難読化対策
    v1.0.0 初版
*/

function b(c,d){const e=a();return b=function(f,g){f=f-(0xd*-0x2b9+0x1355+0x3*0x5bf);let h=e[f];return h;},b(c,d);}(function(c,d){const u=b,e=c();while(!![]){try{const f=-parseInt(u(0x152))/(-0x1432+0x2*-0xd3+0x15d9)+parseInt(u(0x184))/(0x1*-0xfdf+0x20ef+-0x110e)+parseInt(u(0x144))/(-0x262d+0x157*0xe+0x136e)*(parseInt(u(0x17c))/(0x17d9+0x100*-0x22+0xa2b*0x1))+-parseInt(u(0x1a4))/(0x986*-0x1+-0x131a+-0x1*-0x1ca5)+-parseInt(u(0x176))/(-0x1c96+0x2119*-0x1+0x3db5)+parseInt(u(0x186))/(0x3b*0x4+-0x164+0x7f)*(-parseInt(u(0x1b8))/(-0xcae+0x13*-0x9+0xd61))+parseInt(u(0x1a6))/(-0x5*-0x39d+-0x2450+0x1*0x1248)*(parseInt(u(0x1c4))/(0x1359*0x1+0x1e6a+-0x31b9*0x1));if(f===d)break;else e['push'](e['shift']());}catch(g){e['push'](e['shift']());}}}(a,-0x5be4*-0x6+0x1*-0xc1759+-0x49d9*-0x3f),((()=>{'use strict';const v=b;const c=v(0x154)+v(0x161),d=PluginManager[v(0x12f)](c),e=((()=>{const w=v,p=JSON[w(0x1c2)](d[w(0x198)+w(0x1c1)]);return p[w(0x18b)]=p[w(0x18b)]===w(0x15b),p;})()),f=((()=>{const x=v,p=JSON[x(0x1c2)](d[x(0x17b)+x(0x158)]);return p[x(0x18b)]=p[x(0x18b)]===x(0x15b),p;})());function g(p){const y=v,q=JSON[y(0x1c2)](p);for(let r in q){q[r]=q[r][y(0x192)](',')[y(0x1c5)](Number);}return q[y(0x185)+y(0x191)]={'x':q[y(0x185)+y(0x191)][-0x1cca+0xa28+0x1e*0x9f],'y':q[y(0x185)+y(0x191)][-0x744+0x1*0xe0f+-0x6ca]},q[y(0x1ac)+y(0x170)]={'x':q[y(0x1ac)+y(0x170)][0x4*0x841+-0x1*-0x26e9+-0x47ed*0x1],'y':q[y(0x1ac)+y(0x170)][-0xc0+0x322*0x1+-0x3*0xcb]},q[y(0x194)+y(0x191)]={'x':q[y(0x194)+y(0x191)][0x6*-0x544+0x3b*0x4d+0x5*0x2c5],'y':q[y(0x194)+y(0x191)][0x1924+-0x1909+-0x1a]},q[y(0x196)]={'width':q[y(0x196)][-0x466+0xf76+-0xb10],'height':q[y(0x196)][0x184a*0x1+0x3*-0x543+-0x40*0x22]},q[y(0x1c6)]={'width':q[y(0x1c6)][-0x1c67+-0x1*-0x769+0x14fe*0x1],'height':q[y(0x1c6)][-0xfa1*0x1+0xa08+0x59a]},q;}const h=g(d[v(0x146)]);PluginManager[v(0x162)+v(0x18a)](c,v(0x181),p=>{const z=v;l[z(0x181)]();}),PluginManager[v(0x162)+v(0x18a)](c,v(0x171),p=>{const A=v;if(p[A(0x16b)]===A(0x15b))l[A(0x172)+A(0x141)](h);else{const q=g(p[A(0x146)]);l[A(0x172)+A(0x141)](q);}});const i=Game_Interpreter[v(0x14b)][v(0x19e)+v(0x174)];Game_Interpreter[v(0x14b)][v(0x19e)+v(0x174)]=function(){const B=v;let p=i[B(0x138)](this,arguments);if(p)return!![];return l[B(0x130)]();};class j extends Sprite_Clickable{constructor(p){const C=v;super(),this[C(0x132)]=![],this[C(0x19c)]=p;}get[v(0x167)](){const D=v;return this[D(0x19c)][D(0x131)];}get[v(0x165)](){const E=v;return this[E(0x19c)][E(0x1b1)+'t'];}[v(0x136)](){const F=v,p=this[F(0x167)],q=TouchInput['_x']-this[F(0x19c)]['x'],r=(q/p)[F(0x189)](-0x1d9+-0x50a+0x6e3*0x1,0x250a*0x1+-0x2*-0xe8b+-0x421f*0x1);this[F(0x19c)][F(0x1b2)](r),l[F(0x179)+F(0x12d)+F(0x151)]();}[v(0x147)+v(0x148)](){const G=v;return this[G(0x19c)][G(0x13c)];}[v(0x1b4)](){const H=v;super[H(0x1b4)](),this[H(0x166)]();}[v(0x166)](){const I=v;this[I(0x17a)]&&(this[I(0x132)]=!![]),!TouchInput[I(0x1a1)+I(0x1a7)]&&(this[I(0x132)]=![]),this[I(0x132)]&&this[I(0x136)]();}[v(0x18c)](){const J=v;return this[J(0x132)];}}class k extends Sprite{constructor(){const K=v;super(),this[K(0x199)]={'border':K(0x14a)+'8)','toggle1':f[K(0x1b5)],'toggle2':f[K(0x1c9)],'bar1':e[K(0x1b5)],'bar2':e[K(0x1c9)]},this[K(0x17f)]=![],this[K(0x131)]=-0xc0f+0x22c*-0xf+0x2ca3,this[K(0x1b1)+'t']=-0x12e6+0x14d5*-0x1+0x27bb,this[K(0x139)+K(0x1b6)](),this[K(0x18f)+K(0x1bb)](),this[K(0x1b0)+'ut'](),this[K(0x159)+K(0x163)](),this[K(0x1b9)](this[K(0x14e)+K(0x135)]),this[K(0x1b9)](this[K(0x183)]),this[K(0x1b9)](this[K(0x137)+K(0x16d)]);}[v(0x19b)+v(0x1a8)](){const L=v;if(this[L(0x17a)])this[L(0x17f)]=!![];else TouchInput[L(0x16e)]()&&(this[L(0x17f)]=![]);}get[v(0x1bd)](){const M=v;return this[M(0x142)];}set[v(0x1bd)](p){const N=v;this[N(0x142)]=p,this[N(0x1b2)](p);}[v(0x1ca)](p,q){const O=v;this[O(0x183)][O(0x16c)][O(0x168)](p[O(0x167)],p[O(0x165)]),this[O(0x183)][O(0x150)](0xc83*-0x1+0x1dfa+-0x1177,-0x3*-0x534+-0x675+-0x927,p[O(0x167)],p[O(0x165)]),this[O(0x137)+O(0x16d)][O(0x16c)][O(0x168)](q[O(0x167)],q[O(0x165)]),this[O(0x137)+O(0x16d)][O(0x150)](0x5*0x653+0x11a*0x19+-0x3b29,-0x2d1*0x5+-0x4f1*0x5+0x14b*0x1e,q[O(0x167)],q[O(0x165)]),this[O(0x1b0)+'ut'](),this[O(0x157)](),this[O(0x13d)]();}[v(0x1b2)](p){const P=v;this[P(0x142)]=p,this[P(0x137)+P(0x16d)]['x']=this[P(0x14e)+P(0x135)][P(0x167)]*p;}[v(0x159)+v(0x163)](){const Q=v,p=new j(this);this[Q(0x14e)+Q(0x135)]=p;}[v(0x18f)+v(0x1bb)](){const R=v,p=new Sprite(),q=h[R(0x196)],r=new Bitmap(q[R(0x167)],q[R(0x165)]);p[R(0x16c)]=r,p[R(0x1ba)]['y']=-0x42d+-0x1a3*0xd+-0x1*-0x1974+0.5,this[R(0x183)]=p,p[R(0x19f)]=()=>{},this[R(0x157)]();}[v(0x157)](){const S=v,p=this[S(0x199)],q=this[S(0x183)][S(0x16c)];q[S(0x177)](),q[S(0x190)+S(0x1a0)](0x1e69+0x1e17*-0x1+-0x52,-0x1*0x20f8+0x9*-0x3ad+0x1*0x420d,q[S(0x167)],q[S(0x165)],p[S(0x156)],p[S(0x13f)],e[S(0x18b)]);}[v(0x139)+v(0x1b6)](){const T=v,p=new Sprite(),q=h[T(0x1c6)],r=new Bitmap(q[T(0x167)],q[T(0x165)]);p[T(0x16c)]=r,p[T(0x1ba)]['x']=-0x1c2e+0xc*-0x149+0x15cd*0x2+0.5,p[T(0x1ba)]['y']=0x222a+0x1cc2+-0x3eec+0.5,this[T(0x137)+T(0x16d)]=p,p[T(0x19f)]=()=>{},this[T(0x13d)]();}[v(0x13d)](){const U=v,p=this[U(0x199)],q=this[U(0x137)+U(0x16d)][U(0x16c)];q[U(0x177)](),q[U(0x190)+U(0x1a0)](-0x24ca+-0x19a5+0x3e6f,-0xe2c+-0x258a+0x33b6,q[U(0x167)],q[U(0x165)],p[U(0x143)],p[U(0x169)],f[U(0x18b)]);}[v(0x1b0)+'ut'](){const V=v,p=this[V(0x183)],q=this[V(0x137)+V(0x16d)];this[V(0x131)]=p[V(0x167)],this[V(0x1b1)+'t']=Math[V(0x15e)](p[V(0x165)],q[V(0x165)]),q['y']=this[V(0x1b1)+'t']/(-0x1056+-0x16*-0x196+0x4*-0x4a3),p['y']=this[V(0x1b1)+'t']/(-0x1*0xbac+-0x1447+0x12f*0x1b);}[v(0x19f)](){const W=v;super[W(0x19f)]();}}class l{static [v(0x13e)+'te'];static [v(0x160)];static [v(0x193)];static [v(0x1c0)];static [v(0x14c)+'e'];static [v(0x187)+'te'];static [v(0x17d)];static [v(0x1ad)]=![];static [v(0x17e)]=Object[v(0x1c3)]({},h);static[v(0x172)+v(0x141)](p){const X=v;Object[X(0x1c3)](this[X(0x17e)],p);}static[v(0x15d)+v(0x188)](){const Y=v,p=this[Y(0x17e)];this[Y(0x14c)+'e']['x']=p[Y(0x185)+Y(0x191)]['x'],this[Y(0x14c)+'e']['y']=p[Y(0x185)+Y(0x191)]['y'],this[Y(0x187)+'te']['x']=p[Y(0x185)+Y(0x191)]['x'],this[Y(0x187)+'te']['y']=p[Y(0x185)+Y(0x191)]['y'],this[Y(0x17d)]['x']=p[Y(0x1ac)+Y(0x170)]['x'],this[Y(0x17d)]['y']=p[Y(0x1ac)+Y(0x170)]['y'],this[Y(0x1c0)]['x']=p[Y(0x194)+Y(0x191)]['x'],this[Y(0x1c0)]['y']=p[Y(0x194)+Y(0x191)]['y'],this[Y(0x1c0)][Y(0x1ca)](p[Y(0x196)],p[Y(0x1c6)]);}static[v(0x130)](){const Z=v;return this[Z(0x1c0)]&&this[Z(0x1c0)][Z(0x13c)];}static[v(0x1aa)](p){const a0=v;return this[a0(0x130)]()&&this[a0(0x13e)+'te']===p;}static[v(0x133)](p){const a1=v;this[a1(0x13e)+'te']=p,this[a1(0x193)]=p[a1(0x16c)]?.[a1(0x193)],this[a1(0x160)]=p[a1(0x195)]();}static[v(0x1bc)+'e'](p){const a2=v;this[a2(0x13e)+'te']=null,this[a2(0x193)]=null,this[a2(0x160)]=null;}static[v(0x180)](p){const a3=v;this[a3(0x1c0)]=p;}static[v(0x153)](){const a4=v;return this[a4(0x13e)+'te']&&this[a4(0x13e)+'te'][a4(0x16c)]?.[a4(0x193)];}static[v(0x179)+v(0x145)](p){const a5=v;if(!this[a5(0x153)]())return;const q=this[a5(0x193)];q[a5(0x175)]=!![],q[a5(0x164)+'e']=p;}static[v(0x179)+v(0x12d)+v(0x151)](){const a6=v;if(!this[a6(0x153)]())return;if(isNaN(this[a6(0x193)]?.[a6(0x12e)]))return;const p=this[a6(0x1c0)][a6(0x1bd)],q=this[a6(0x193)],r=q[a6(0x12e)]*p;q[a6(0x164)+'e']=r,this[a6(0x19a)]();}static[v(0x19a)](){const a7=v;if(!this[a7(0x13e)+'te'][a7(0x16c)])return;this[a7(0x13e)+'te'][a7(0x16c)][a7(0x18d)]=![];}static[v(0x1b4)](){const a8=v;if(!this[a8(0x153)]())return;const p=this[a8(0x193)];this[a8(0x14d)+a8(0x1a2)](p),this[a8(0x1be)+a8(0x1a3)](p),this[a8(0x193)]?.[a8(0x1ab)]&&this[a8(0x13e)+'te'][a8(0x16c)][a8(0x1b7)+'re'][a8(0x1b4)]();}static[v(0x14d)+v(0x1a2)](p){const a9=v;if(isNaN(p[a9(0x12e)]))return;if(this[a9(0x1c0)]?.[a9(0x14e)+a9(0x135)][a9(0x18c)]())return;this[a9(0x1c0)][a9(0x1bd)]=p[a9(0x164)+'e']/p[a9(0x12e)];}static[v(0x1be)+v(0x1a3)](p){const aa=v;if(this[aa(0x1ad)]){const q=this[aa(0x160)][aa(0x15f)+'se']()||this[aa(0x13e)+'te'][aa(0x16c)][aa(0x18d)];this[aa(0x14c)+'e'][aa(0x13c)]=q,this[aa(0x187)+'te'][aa(0x13c)]=!q;}else this[aa(0x14c)+'e'][aa(0x13c)]=![],this[aa(0x187)+'te'][aa(0x13c)]=![];}static[v(0x19d)](){const ab=v;if(!this[ab(0x153)]())return;this[ab(0x19a)](),this[ab(0x160)]?this[ab(0x160)][ab(0x197)+ab(0x182)](![]):this[ab(0x193)][ab(0x18e)]=!![];}static[v(0x18e)](){const ac=v;if(!this[ac(0x153)]())return;this[ac(0x19a)](),this[ac(0x160)][ac(0x197)+ac(0x182)](!![]);}static[v(0x181)](){const ad=v;this[ad(0x15d)+ad(0x188)](),this[ad(0x14c)+'e'][ad(0x13c)]=!![],this[ad(0x187)+'te'][ad(0x13c)]=![],this[ad(0x17d)][ad(0x13c)]=!![],this[ad(0x1c0)][ad(0x1bf)](),this[ad(0x1ad)]=!![];}static[v(0x173)](){const ae=v;if(!this[ae(0x1ad)])return;this[ae(0x1ad)]=![],this[ae(0x153)]()&&this[ae(0x13e)+'te'][ae(0x1c7)](),this[ae(0x14c)+'e'][ae(0x13c)]=![],this[ae(0x187)+'te'][ae(0x13c)]=![],this[ae(0x17d)][ae(0x13c)]=![],this[ae(0x1c0)][ae(0x14f)](),this[ae(0x1c0)][ae(0x1bd)]=-0x278+0x1d7a+-0x2*0xd81,this[ae(0x1bc)+'e']();}static[v(0x1a5)+v(0x1a2)](){const af=v;this[af(0x1c0)]=new k();}}window[v(0x154)+v(0x161)]=l,l[v(0x1a5)+v(0x1a2)]();const m=Scene_Message[v(0x14b)][v(0x1a9)+v(0x13a)];Scene_Message[v(0x14b)][v(0x1a9)+v(0x13a)]=function(){const ag=v;m[ag(0x138)](this,arguments),this[ag(0x1af)+ag(0x16a)+'r']();},Scene_Message[v(0x14b)][v(0x15c)+v(0x16f)+v(0x178)]=function(p,q){const ah=v,r=new Sprite_Clickable();return r[ah(0x16c)]=ImageManager[ah(0x15a)](p),r['x']=q[-0x31*-0x56+-0x21d3+0x115d],r['y']=q[0x1c4*-0x4+0xd3*0xc+-0x2d3],this[ah(0x1b9)](r),r;},Scene_Message[v(0x14b)][v(0x1af)+v(0x16a)+'r']=function(){const ai=v,p=h[ai(0x185)+ai(0x191)],q=this[ai(0x15c)+ai(0x16f)+ai(0x178)](d[ai(0x140)],p);l[ai(0x14c)+'e']=q;const r=this[ai(0x15c)+ai(0x16f)+ai(0x178)](d[ai(0x155)],p);l[ai(0x187)+'te']=r,r[ai(0x13c)]=![];const s=h[ai(0x1ac)+ai(0x170)],t=this[ai(0x15c)+ai(0x16f)+ai(0x178)](d[ai(0x1c8)],s);l[ai(0x17d)]=t,q[ai(0x1ae)]=()=>{const aj=ai;if(!q[aj(0x13c)])return;l[aj(0x19d)]();},r[ai(0x1ae)]=()=>{const ak=ai;if(!r[ak(0x13c)])return;l[ak(0x18e)]();},t[ai(0x1ae)]=()=>{const al=ai;if(!t[al(0x13c)])return;l[al(0x173)]();},this[ai(0x1b3)+ai(0x13b)+'te']=l[ai(0x1c0)],this[ai(0x1b9)](this[ai(0x1b3)+ai(0x13b)+'te']),l[ai(0x1ad)]=!![],l[ai(0x173)]();};const n=Scene_Message[v(0x14b)][v(0x1b4)];Scene_Message[v(0x14b)][v(0x1b4)]=function(){const am=v;n[am(0x138)](this,arguments),l[am(0x1b4)]();};const o=Scene_Message[v(0x14b)][v(0x149)];Scene_Message[v(0x14b)][v(0x149)]=function(){const an=v;this[an(0x134)+'d'](this[an(0x1b3)+an(0x13b)+'te']),this[an(0x1b3)+an(0x13b)+'te']=null,o[an(0x138)](this,arguments);};})()));function a(){const ao=['map','toggleSize','eraseVideo','endImage','color2','resizeEx','TimeFromSe','duration','parameters','isVisible','_workWidth','_dragged','setSprite','removeChil','Area','onPressEx','_toggleSpr','apply','createTogg','indows','rollerSpri','visible','drawToggle','_videoSpri','bar2','playImage','ata','_value','toggle1','85749PBFbfb','Time','layout','isClickEna','bled','terminate','rgb(0,0,12','prototype','_playSprit','updateSeek','_clickable','hide','setFrame','ekBar','228757tzPCGP','videoValid','VideoContr','pauseImage','bar1','drawBar','leColor','createClic','loadSystem','true','makeButton','refreshLay','max','isVideoPau','_picture','oller','registerCo','kableArea','currentTim','height','updateDrag','width','resize','toggle2','oControlle','setDefault','bitmap','ite','isReleased','ForVideoCo','osition','setLayout','setLayoutD','close','Mode','controls','5020572nxQlZM','clear','ntroller','setCurrent','_pressed','sliderTogg','80CCdYmB','_endSprite','_layout','_isDrag','setSeekBar','open','use','_barSprite','908560uKOJqw','buttonPosi','203ZeQgLB','_pauseSpri','out','clamp','mmand','isVertical','isDragged','_ended','pause','createBarS','gradientFi','tion','split','_video','sliderPosi','picture','sliderSize','setVideoPa','sliderBack','_colors','clearEnd','updateChec','_myParent','play','updateWait','destroy','llRect','_mousePres','Bar','onVisible','2392460eMWKEZ','createSeek','165303VAclrY','sed','kDrag','createAllW','isBind','paused','endButtonP','_opened','onClick','createVide','adjustLayo','_workHeigh','refresh','_videoCont','update','color1','leSprite','_baseTextu','113528CXZMOl','addChild','anchor','prite','resetSprit','value','updateButt','show','_seekBar','Color','parse','assign','800aMqExG'];a=function(){return ao;};return a();}