/*:
 * @plugindesc タイトル画面にテキストを追加します
 * @author hara
 *
 * @param 表示テキスト
 * @desc タイトル画面に追加表示するテキストを入力します。
 * @default タイトルプラステキスト てすと
 * @type string
 *
 * @param フォントサイズ
 * @desc フォントサイズを指定します。(0～60)
 * @default 21
 * @type number
 * @max 60
 * @min 0
 *
 * @param 横の位置
 * @desc 「left」「center」「right」のいずれかを指定します。
 * @default right
 * @type string
 *
 * @help
 * タイトル画面の下の方にテキストを追加します。
 * バージョン情報など、変更の度に画像で用意するには面倒な内容に使うと
 * 丁度いいかもしれません。
 *
 * ・利用規約
 * 禁止事項はありません。
 */

(function() {
'use strict';

var pluginName = 'hr_TitlePlusText';
var parameters = PluginManager.parameters(pluginName);

var plusText    = String(parameters['表示テキスト']);
var fSize       = Number(parameters['フォントサイズ']);
var pos         = String(parameters['横の位置']);

var _Scene_Title_createForeground = Scene_Title.prototype.createForeground;
Scene_Title.prototype.createForeground = function() {
    _Scene_Title_createForeground.call(this);
    this.drawTitlePlusText();
};

Scene_Title.prototype.drawTitlePlusText = function() {
    var m = 6;                              // margin
    var width = Graphics.boxWidth - m*4;
    var height = 60;
    this._plusTextSprite = new Sprite(new Bitmap(width, height));
    this.addChild(this._plusTextSprite);
    this._plusTextSprite.x = m*2;
    this._plusTextSprite.y = Graphics.height - height - m;
    var x = 0;
    if (pos == 'left') x = m;               // 左右寄せ時、アウトラインの見切れ対策
    if (pos == 'right') x = -m;
    this._plusTextSprite.bitmap.fontSize = fSize;
    this._plusTextSprite.bitmap.drawText(plusText, x, 0, width, height, pos);
};

})();