/*:
 * @target MZ
 * @plugindesc オプションに「もどる」コマンドを追加
 * @author hara
 * @url https://note.com/haranta/n/n635cc684d731
 *
 * @param backText
 * @text 「もどる」の表示名
 * @desc オプションの選択肢に表示されます。(初期設定：もどる)
 * @default もどる
 * @type string
 * 
 * @help
 * オプションに「もどる」コマンドを追加します。
 * 「もどる」コマンドを実行した時の動きは、オプション画面で
 * キャンセルを押した時のデフォルトの動きと同じです。
 * (表示中の設定が保存されます。)
 * 
 * 更新履歴
 * 2023/11/16   ver 1.1
 *              他プラグインとの競合対策。
 *              もどる選択肢の表示名をパラメータから変更できるよう変更。
 * 2021/08/28   ver 1.0
 *              MZ版作成。
 *
 * ・利用規約
 * 禁止事項はありません。
 */


(function() {
'use strict';

    const pluginName = "hr_optionBack_mz";

    const _Window_Options_makeCommandList = Window_Options.prototype.makeCommandList;
    Window_Options.prototype.makeCommandList = function() {
        _Window_Options_makeCommandList.call(this);
        this.addBackOptions();
    };

    Window_Options.prototype.addBackOptions = function() {
        const text = PluginManager.parameters(pluginName).backText;
        this.addCommand(text, 'back');
    };

    Window_Options.prototype.isBackSymbol = function(symbol) {
        return symbol == 'back';
    };

    Window_Options.prototype.getCurrentSymbol = function() {
        const index = this.index();
        return this.commandSymbol(index);
    };

    const _Window_Options_processOk = Window_Options.prototype.processOk;
    Window_Options.prototype.processOk = function() {
        const symbol = this.getCurrentSymbol();
        if (this.isBackSymbol(symbol)) {
            this.processCancel();
            return;
        }
        _Window_Options_processOk.call(this);
    };

    const _Window_Options_cursorRight = Window_Options.prototype.cursorRight;
    Window_Options.prototype.cursorRight = function() {
        const symbol = this.getCurrentSymbol();
        if (this.isBackSymbol(symbol)) return;
        _Window_Options_cursorRight.call(this);
    };

    const _Window_Options_cursorLeft = Window_Options.prototype.cursorLeft;
    Window_Options.prototype.cursorLeft = function() {
        const symbol = this.getCurrentSymbol();
        if (this.isBackSymbol(symbol)) return;
        _Window_Options_cursorLeft.call(this);
    };

    const _Window_Options_drawItem = Window_Options.prototype.drawItem;
    Window_Options.prototype.drawItem = function(index) {
        const symbol = this.commandSymbol(index);
        if (this.isBackSymbol(symbol)) {
            const rect = this.itemLineRect(index);
            this.resetTextColor();
            this.drawText(this.commandName(index), rect.x, rect.y, rect.width, 'center');
        } else {
            _Window_Options_drawItem.call(this, index);
        }
    };

    const _Scene_Options_maxCommands = Scene_Options.prototype.maxCommands;
    Scene_Options.prototype.maxCommands = function() {
        return _Scene_Options_maxCommands.call(this) + 1;
    };

})();