*:
 * @target MZ
*/

(() => {
    'use strict'

    Window_TitleCommand.prototype.makeCommandList = function() {
        const continueEnabled = this.isContinueEnabled();
        this.addCommand(TextManager.newGame, "newGame");
        this.addCommand(TextManager.continue_, "continue", continueEnabled);
        this.addCommand("ゲーム終了", "exit");
    };

    Scene_Title.prototype.createCommandWindow = function() {
        const background = $dataSystem.titleCommandWindow.background;
        const rect = this.commandWindowRect();
        this._commandWindow = new Window_TitleCommand(rect);
        this._commandWindow.setBackgroundType(background);
        this._commandWindow.setHandler("newGame", this.commandNewGame.bind(this));
        this._commandWindow.setHandler("continue", this.commandContinue.bind(this));
        this._commandWindow.setHandler("exit", () => {
            this._commandWindow.close();
            SceneManager.exit();
        });
        this.addWindow(this._commandWindow);
    };
})();