/*:
 * @target MZ
 * @plugindesc 選択肢ウィンドウとその項目の背景もすべて非表示にします（完全に文字のみ表示）。選択肢ハイライトも消えます。
 * @author ChatGPT
 *
 * @help ChoiceWindowTransparent.js
 *
 * このプラグインは、RPGツクールMZの選択肢ウィンドウを完全に透明化します。
 * ウィンドウの背景・枠線だけでなく、選択肢項目のハイライト背景も表示されません。
 * よって「文字だけが表示される選択肢」になります。
 *
 * ◆使用方法：
 * プラグインを導入し、有効化するだけで全選択肢に適用されます。
 *
 * ◆ライセンス：
 * 商用・非商用問わず使用可能。クレジットは任意です。
 */

(() => {
  const _Window_ChoiceList_initialize = Window_ChoiceList.prototype.initialize;
  Window_ChoiceList.prototype.initialize = function(messageWindow) {
    _Window_ChoiceList_initialize.call(this, messageWindow);
    this.opacity = 0;
    this.backOpacity = 0;
  };

  // ウィンドウ背景の描画を無効化
  Window_ChoiceList.prototype.drawBackground = function() {
    // 何も描画しない
  };

  // 選択肢の背景（ハイライト）も無効化
  Window_ChoiceList.prototype.drawItemBackground = function(index) {
    // 何も描画しない（ハイライトなし）
  };
})();
