/*:
 * @target MZ
 * @plugindesc 数値入力処理でEscキーによるキャンセルを可能にします
 * @author ChatGPT
 *
 * @help
 * このプラグインを導入すると、数値入力中にEscキー（Bボタン）などで
 * キャンセル操作が可能になります。
 * キャンセル時、変数には -1 が代入されます。
 */

(() => {
    const _Scene_NumberInput_create = Scene_NumberInput.prototype.create;
    Scene_NumberInput.prototype.create = function() {
        _Scene_NumberInput_create.call(this);
        this._numberWindow.setHandler("cancel", this.popScene.bind(this));
    };

    const _Scene_NumberInput_terminate = Scene_NumberInput.prototype.terminate;
    Scene_NumberInput.prototype.terminate = function() {
        const variableId = $gameMessage.numInputVariableId();
        if (this._numberWindow.isCancelTriggered()) {
            $gameVariables.setValue(variableId, -1); // キャンセル時に -1 を代入
        }
        _Scene_NumberInput_terminate.call(this);
    };

    Window_NumberInput.prototype.isCancelTriggered = function() {
        return this._cancelTriggered;
    };

    const _Window_NumberInput_processCancel = Window_NumberInput.prototype.processCancel;
    Window_NumberInput.prototype.processCancel = function() {
        this._cancelTriggered = true;
        _Window_NumberInput_processCancel.call(this);
    };
})();
