/*:
 * @target MZ
 * @plugindesc 数値入力中にEsc/Bキーでキャンセル可能にします。キャンセル時は変数に -1 を上書きします（完全版） 
 * @author ChatGPT
 * 
 * @help
 * このプラグインを導入すると、「数値入力の処理」においてEsc/Bキーで
 * キャンセルできるようになります。
 *
 * キャンセル時、入力された値は無視され、変数に -1 が代入されます。
 */

(() => {
    let _cancelNumberInput = false;
    let _targetVariableId = 0;

    // 1. Escキーでキャンセルフラグを立てて processOk を実行
    const _Window_NumberInput_update = Window_NumberInput.prototype.update;
    Window_NumberInput.prototype.update = function() {
        _Window_NumberInput_update.call(this);
        if (this.active && Input.isTriggered("cancel")) {
            SoundManager.playCancel();
            _cancelNumberInput = true;
            _targetVariableId = $gameMessage.numInputVariableId();
            this.processOk();
        }
    };

    // 2. onInputNumber後にキャンセルフラグが立っていたら、変数を -1 に上書き
    const _Game_Message_onInputNumber = Game_Message.prototype.onInputNumber;
    Game_Message.prototype.onInputNumber = function(inputNumber) {
        _Game_Message_onInputNumber.call(this, inputNumber);

        if (_cancelNumberInput && _targetVariableId > 0) {
            $gameVariables.setValue(_targetVariableId, -1);
        }

        _cancelNumberInput = false;
        _targetVariableId = 0;
    };
})();
