/*:
 * @target MZ
 * @plugindesc 変数に上限・下限を設定できるプラグイン（Ver.1.0）
 * @author ChatGPT
 * 
 * @help
 * ◆使い方：
 * このプラグインを導入すると、指定した変数に対して
 * 最大値・最小値の制限を自動的にかけることができます。
 * 
 * イベントコマンドやスクリプトで変数を操作する際、
 * 指定した上限・下限を超えないように自動で調整されます。
 * 
 * ◆制限の設定：
 * 下の MAX_VALUES と MIN_VALUES のオブジェクトに
 * 「変数ID: 上限（または下限）」の形式で設定してください。
 * 
 * 例）変数11の最大値を100、最小値を0にしたい場合：
 * 
 * const MAX_VALUES = {
 *   11: 100,
 * };
 * 
 * const MIN_VALUES = {
 *   11: 0,
 * };
 * 
 * ◆注意：
 * 上限・下限の両方を設定しなくても動作します。
 * 片方のみでもOKです。
 * 
 * このプラグインに設定した変数以外は制限されません。
 */

(() => {
    const MAX_VALUES = {
        11: 100, // 変数11の最大値は100
        12: 50   // 変数12の最大値は50
    };

    const MIN_VALUES = {
        11: 0,   // 変数11の最小値は0
        12: 10   // 変数12の最小値は10
    };

    const _Game_Variables_setValue = Game_Variables.prototype.setValue;
    Game_Variables.prototype.setValue = function(variableId, value) {
        if (MAX_VALUES[variableId] !== undefined) {
            value = Math.min(value, MAX_VALUES[variableId]);
        }
        if (MIN_VALUES[variableId] !== undefined) {
            value = Math.max(value, MIN_VALUES[variableId]);
        }
        _Game_Variables_setValue.call(this, variableId, value);
    };
})();
